/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.bind;

import com.bmc.thirdparty.org.springframework.validation.BindException;
import com.bmc.thirdparty.org.springframework.validation.ValidationUtils;
import com.bmc.thirdparty.org.springframework.validation.Validator;
import com.bmc.thirdparty.org.springframework.web.bind.BindInitializer;
import com.bmc.thirdparty.org.springframework.web.bind.ServletRequestDataBinder;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;

public abstract class BindUtils {
    public static BindException bind(ServletRequest request, Object object, String objectName) {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(object, objectName);
        binder.bind(request);
        return binder.getErrors();
    }

    public static BindException bind(ServletRequest request, Object object, String objectName, BindInitializer initializer) throws ServletException {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(object, objectName);
        if (initializer != null) {
            initializer.initBinder(request, binder);
        }
        binder.bind(request);
        return binder.getErrors();
    }

    public static BindException bindAndValidate(ServletRequest request, Object object, String objectName, Validator validator) {
        BindException binder = BindUtils.bind(request, object, objectName);
        if (validator != null) {
            ValidationUtils.invokeValidator(validator, object, binder);
        }
        return binder;
    }

    public static BindException bindAndValidate(ServletRequest request, Object object, String objectName, Validator validator, BindInitializer initializer) throws ServletException {
        BindException binder = BindUtils.bind(request, object, objectName, initializer);
        if (validator != null) {
            ValidationUtils.invokeValidator(validator, object, binder);
        }
        return binder;
    }
}

