/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParserPlugin
extends ARFilterAPIPlugin {
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.QUERYPARSER", this);
    private String serverName = "localhost";
    private ARServerUser serverUser = null;

    @Override
    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        int n;
        String[] stringArray = aRPluginContext.getCmdLineArgs();
        String string = "initialize method was invoked with args = ";
        if (stringArray.length >= 0) {
            for (n = 0; n < stringArray.length; ++n) {
                string = string + " " + stringArray[n];
            }
        }
        aRPluginContext.logMessage(this.pluginInfo, 0, string);
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-x")) continue;
            this.serverName = stringArray[n + 1];
            n = stringArray.length;
        }
        aRPluginContext.logMessage(this.pluginInfo, 0, "Server name = " + this.serverName);
        this.initServerUser(aRPluginContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> filterAPICall(ARPluginContext aRPluginContext, List<Value> list) throws ARException {
        if (list.size() == 0 || list.size() < 4) {
            return null;
        }
        this.initServerUser(aRPluginContext);
        String string = (String)list.get(0).getValue();
        String string2 = (String)list.get(1).getValue();
        String string3 = (String)list.get(2).getValue();
        String string4 = (String)list.get(3).getValue();
        if (string4 == null || string4.length() == 0) {
            string4 = "parse";
        }
        if (string == null || string.length() == 0) {
            throw new ARException(2, -1, "Input string is null");
        }
        if (string2 == null || string2.length() == 0) {
            throw new ARException(2, -1, "Form is null");
        }
        if (string3 == null) {
            string3 = "";
        }
        String string5 = this.serverUser.getLocale();
        this.serverUser.setLocale(string3);
        try {
            Object object;
            ArrayList<Value> arrayList = new ArrayList<Value>();
            if (string4.equalsIgnoreCase("format")) {
                object = this.serverUser.decodeQualification(string);
                if (object != null) {
                    arrayList.add(new Value(this.serverUser.formatQualification(object, null, null, 0, false)));
                }
            } else {
                object = Utilities.parseQualification(this.serverUser, string, string2, string3);
                if (object != null) {
                    arrayList.add(new Value(this.serverUser.encodeQualification(object)));
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            this.serverUser.setLocale(string5);
        }
    }

    private void initServerUser(ARPluginContext aRPluginContext) throws ARException {
        aRPluginContext.logMessage(0, "initServerUser()");
        if (this.serverUser == null) {
            this.serverUser = new ARServerUser((ARNativeAuthenticationInfo)aRPluginContext, "", this.serverName);
            int n = Utilities.getIntegerValue(aRPluginContext.getARConfigEntry("TCD-Specific-Port"));
            this.serverUser.setPort(n);
            int n2 = Utilities.getIntegerValue(aRPluginContext.getARConfigEntry("Plugin-Loopback-RPC-Socket"));
            if (n2 > 0) {
                this.serverUser.usePrivateRpcQueue(n2);
            }
            this.serverUser.setVUIType(1);
        }
        this.serverUser.setUserContext((ARNativeAuthenticationInfo)aRPluginContext);
    }
}

