/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting.birt;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ChartType;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.IARReportEngine;
import com.bmc.arsys.arreporting.ILogListener;
import com.bmc.arsys.arreporting.OutputFormat;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportParameters;
import com.bmc.arsys.arreporting.ReportStyle;
import com.bmc.arsys.arreporting.ReportType;
import com.bmc.arsys.utils.LocaleUtil;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.JavaDateFormatSpecifierImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDataSet;
import org.eclipse.birt.report.engine.api.script.element.IDataSource;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.IDesignEngine;
import org.eclipse.birt.report.model.api.IDesignEngineFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;

public class BIRTReportEngine
implements IARReportEngine {
    private static final String TIME_OF_DAY_ON_PREPARE = "this.getStyle().dateTimeFormat = params[\"customTimeFormat\"]";
    private static final String DATE_ON_PREPARE = "this.getStyle().dateTimeFormat = params[\"customDateFormat\"]";
    private static final String TIME_ON_PREPARE = "this.getStyle().dateTimeFormat = params[\"customDateFormat\"] + \" \" + params[\"customTimeFormat\"]";
    private static final String TABLE_DETAIL_ROW_STYLE = "TableDetailRow";
    private static final String TABLE_HEADER_STYLE = "TableHeader";
    private static final String INTERNAL_NON_DISPLAY_ARRAY_LIST = "internalNonDisplayArrayList";
    private static final String AR_BIRT_NULL_PASSWORD = "AR_BIRT_NULL_PASSWORD";
    private static final int MAX_AR_COND_OP_CODE = 5;
    private static final int MIN_AR_COND_OP_CODE = 0;
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String HTML_RENDER_FORMAT = "html";
    private static final String PDF_RENDER_FORMAT = "pdf";
    private static final String DOC_RENDER_FORMAT = "doc";
    private static final String EXCEL_RENDER_FORMAT = "xls";
    private static final String PPT_RENDER_FORMAT = "ppt";
    private static final String QUALIFICATION = "qualification";
    private static final String RESULTLIST = "resultList";
    private static final String FORM = "form";
    private static final String FIELDS = "fields";
    private static final String SORTINFO = "sortInfo";
    private static final String HIDE_ENTRY_ID = "hideEntryId";
    private static final String NON_DISPLAY_FIELDS = "nonDisplayFields";
    private EngineConfig reportConfig = null;
    private DesignConfig designConfig = null;
    private IReportEngine reportEngine = null;
    private IDesignEngine designEngine = null;
    private String engineHome = null;
    private boolean initialized = false;
    private Properties properties = null;
    private final ILogListener logListener;
    private final Map<Integer, String> groupStyles = new HashMap<Integer, String>();

    public BIRTReportEngine(Properties properties, ILogListener iLogListener) {
        this.properties = properties;
        this.logListener = iLogListener;
        if (properties.getProperty("birt.engine") == null) {
            properties.setProperty("birt.engine", System.getenv("BIRT_ENGINE"));
        }
        if (properties.getProperty("birt.template.dir") == null) {
            properties.setProperty("birt.template.dir", System.getenv("BIRT_TEMPLATES"));
        }
        if (properties.getProperty("birt.log.dir") == null) {
            properties.setProperty("birt.log.dir", System.getenv("BIRT_LOGDIR"));
        }
        this.setupGroupStyles();
    }

    private void setupGroupStyles() {
        this.groupStyles.put(4, "GroupHeader");
        this.groupStyles.put(3, "GroupHeader1");
        this.groupStyles.put(2, "GroupHeader2");
        this.groupStyles.put(1, "GroupHeader3");
        this.groupStyles.put(0, "GroupHeader4");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void shutdown() {
        if (this.reportEngine != null) {
            this.reportEngine.destroy();
        }
        Platform.shutdown();
        this.reportConfig = null;
        this.designConfig = null;
        this.reportEngine = null;
        this.designEngine = null;
        this.initialized = false;
    }

    public void startup() throws ARException {
        try {
            String string;
            if (this.engineHome == null) {
                this.engineHome = this.properties.getProperty("birt.engine");
            }
            if (this.engineHome == null) {
                this.engineHome = System.getenv("BIRT_ENGINE");
            }
            if (this.engineHome == null) {
                throw new ARException(2, -1, "No value supplied for BIRT_ENGINE");
            }
            this.reportConfig = new EngineConfig();
            this.reportConfig.setEngineHome(this.engineHome);
            String string2 = this.properties.getProperty("birt.reports.dir");
            if (string2 != null) {
                this.reportConfig.setResourcePath(string2);
            }
            if ((string = this.properties.getProperty("birt.log.dir")) != null) {
                this.reportConfig.setLogConfig(string, Level.FINE);
            }
            this.logMessage(0, "Starting BIRT Reporting Engine");
            Platform.startup((PlatformConfig)this.reportConfig);
            IReportEngineFactory iReportEngineFactory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
            this.reportEngine = iReportEngineFactory.createReportEngine(this.reportConfig);
            this.reportEngine.changeLogLevel(Level.WARNING);
            this.designConfig = new DesignConfig();
            this.designConfig.setBIRTHome(this.engineHome);
            IDesignEngineFactory iDesignEngineFactory = (IDesignEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.model.DesignEngineFactory");
            this.designEngine = iDesignEngineFactory.createDesignEngine(this.designConfig);
            this.initialized = true;
            this.logMessage(0, "BIRT Reporting Engine successfully initialized");
        }
        catch (BirtException birtException) {
            this.logMessage(2, birtException.getMessage());
            throw new ARException(2, -1, birtException.getMessage());
        }
    }

    public void setEngineHome(String string) {
        this.engineHome = string;
    }

    public OutputStream runReport(ARServerUser aRServerUser, ReportParameters reportParameters, OutputFormat outputFormat) throws SemanticException, URISyntaxException, IOException, EngineException, ARException, ScriptException, DesignFileException {
        File file = File.createTempFile("temp", ".rptdesign");
        String string = file.getAbsolutePath();
        this.createReport(aRServerUser, reportParameters, string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.runReport(aRServerUser, reportParameters, string, (OutputStream)byteArrayOutputStream);
        file.delete();
        return byteArrayOutputStream;
    }

    public void createReport(ARServerUser aRServerUser, ReportParameters reportParameters, String string) throws SemanticException, URISyntaxException, IOException, DesignFileException, ARException {
        ReportStyle reportStyle = reportParameters.getStyle();
        if (reportStyle == null) {
            reportStyle = ReportStyle.LIST;
        }
        switch (reportStyle) {
            case LIST: {
                this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "list.rptdesign");
                break;
            }
            case CHART: 
            case CHART_AND_LIST: {
                ChartType chartType = reportParameters.getChartType();
                if (chartType == null) {
                    throw new ARException(2, -1, "Unsuported chart type");
                }
                switch (chartType) {
                    case METER: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "meterchart.rptdesign");
                        break;
                    }
                    case PIE: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "piechart.rptdesign");
                        break;
                    }
                    case AREA: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "areachart.rptdesign");
                        break;
                    }
                    case BAR: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "barchart.rptdesign");
                        break;
                    }
                    case BUBBLE: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "bubblechart.rptdesign");
                        break;
                    }
                    case CONE: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "conechart.rptdesign");
                        break;
                    }
                    case DIFFERENCE: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "diffchart.rptdesign");
                        break;
                    }
                    case LINE: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "linechart.rptdesign");
                        break;
                    }
                    case PYRAMID: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "pyramidchart.rptdesign");
                        break;
                    }
                    case SCATTER: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "scatterchart.rptdesign");
                        break;
                    }
                    case STOCK: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "stockchart.rptdesign");
                        break;
                    }
                    case TUBE: {
                        this.createReportFromTemplate(aRServerUser, reportParameters, string, this.properties.getProperty("birt.template.dir") + SEPARATOR + "tubechart.rptdesign");
                    }
                }
                break;
            }
            default: {
                throw new ARException(2, -1, "Unsuported report style");
            }
        }
    }

    private void addTableContent(ReportParameters reportParameters, ElementFactory elementFactory, TableHandle tableHandle, boolean bl, boolean bl2) throws SemanticException, ContentException, NameException {
        CharSequence charSequence;
        TableGroupHandle tableGroupHandle;
        int n;
        RowHandle rowHandle = (RowHandle)tableHandle.getHeader().get(0);
        if (!bl) {
            rowHandle.setProperty("backgroundColor", (Object)"#AAAAAA");
        }
        RowHandle rowHandle2 = (RowHandle)tableHandle.getDetail().get(0);
        rowHandle2.setStyleName(TABLE_DETAIL_ROW_STYLE);
        int n2 = rowHandle.getCells().getCount();
        rowHandle.setStyleName(TABLE_HEADER_STYLE);
        List<FieldInfo> list = reportParameters.getFields();
        for (int i = 0; i < n2; ++i) {
            CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(i);
            if (i >= list.size()) continue;
            LabelHandle labelHandle = elementFactory.newLabel(reportParameters.getFieldName(list.get(i).getFieldId()));
            labelHandle.setText(list.get(i).getLabel());
            labelHandle.setStyleName(TABLE_HEADER_STYLE);
            if (!bl) {
                this.addCellBorders(cellHandle);
            } else {
                cellHandle.setStyleName(TABLE_HEADER_STYLE);
            }
            cellHandle.getContent().add((DesignElementHandle)labelHandle);
        }
        List<FieldInfo> list2 = reportParameters.getGroups();
        if (list2 != null && !list2.isEmpty()) {
            n = 0;
            for (FieldInfo fieldInfo : list2) {
                if (fieldInfo.getGroup() == 0) continue;
                tableGroupHandle = elementFactory.newTableGroup();
                charSequence = reportParameters.getFieldName(fieldInfo.getFieldId());
                tableGroupHandle.setName((String)charSequence + "_group");
                tableGroupHandle.setKeyExpr("row[\"" + (String)charSequence + "\"]");
                tableGroupHandle.setInterval("none");
                tableGroupHandle.setSortDirection(fieldInfo.getSortDir() == 1 ? "asc" : "desc");
                tableHandle.getGroups().add((DesignElementHandle)tableGroupHandle);
                RowHandle rowHandle3 = elementFactory.newTableRow(n2);
                CellHandle cellHandle = (CellHandle)rowHandle3.getCells().get(0);
                String string = fieldInfo.getLabel();
                if (string == null || string.length() == 0) {
                    string = charSequence;
                }
                TextDataHandle textDataHandle = elementFactory.newTextData((String)charSequence + "_textLabel");
                textDataHandle.setValueExpr("\"" + string + ": \" + " + "row[\"" + (String)charSequence + "\"]");
                textDataHandle.setProperty("marginLeft", (Object)(n * 10 + "pt"));
                textDataHandle.setProperty("textAlign", (Object)"left");
                cellHandle.getContent().add((DesignElementHandle)textDataHandle);
                rowHandle3.setStyleName(this.groupStyles.get(n));
                tableGroupHandle.getHeader().add((DesignElementHandle)rowHandle3);
                if (++n < this.groupStyles.size()) continue;
                n = 0;
            }
        }
        n = 1;
        if (list != null && !list.isEmpty()) {
            n = list.get(0).getFieldId();
        }
        for (FieldInfo fieldInfo : list) {
            if (n != 1 && fieldInfo.getFieldId() == 8) {
                n = fieldInfo.getFieldId();
            }
            if (fieldInfo.getFieldId() != 1) continue;
            n = fieldInfo.getFieldId();
            break;
        }
        block11: for (int i = 0; i < n2; ++i) {
            FieldInfo fieldInfo;
            CellHandle cellHandle = (CellHandle)rowHandle2.getCells().get(i);
            if (i >= list.size()) continue;
            fieldInfo = list.get(i);
            DataItemHandle dataItemHandle = elementFactory.newDataItem(reportParameters.getFieldName(fieldInfo.getFieldId()) + "_data");
            if (DataType.CURRENCY.equals((Object)fieldInfo.getDataType())) {
                dataItemHandle.setResultSetColumn(reportParameters.getFieldName(fieldInfo.getFieldId()));
            } else {
                dataItemHandle.setResultSetColumn(reportParameters.getFieldName(fieldInfo.getFieldId()));
            }
            if (bl2 && n == fieldInfo.getFieldId()) {
                if (dataItemHandle.getActionHandle() == null) {
                    tableGroupHandle = StructureFactory.createAction();
                    dataItemHandle.setAction((org.eclipse.birt.report.model.api.elements.structures.Action)tableGroupHandle);
                }
                dataItemHandle.getActionHandle().setURI("params[\"midTierURL\"].value + row[\"" + reportParameters.getFieldName(1) + "\"]");
                dataItemHandle.getActionHandle().setLinkType("hyperlink");
                tableGroupHandle = dataItemHandle.getActionHandle().getExpressionProperty("uri");
                tableGroupHandle.setType("javascript");
            }
            if (!bl) {
                this.addCellBorders(cellHandle);
            } else {
                cellHandle.setStyleName(TABLE_DETAIL_ROW_STYLE);
            }
            cellHandle.getContent().add((DesignElementHandle)dataItemHandle);
            tableGroupHandle = fieldInfo.getDataType();
            switch (tableGroupHandle.toInt()) {
                case 7: {
                    dataItemHandle.setOnPrepare(TIME_ON_PREPARE);
                    continue block11;
                }
                case 13: {
                    dataItemHandle.setOnPrepare(DATE_ON_PREPARE);
                    continue block11;
                }
                case 14: {
                    dataItemHandle.setOnPrepare(TIME_OF_DAY_ON_PREPARE);
                    continue block11;
                }
                case 2: {
                    dataItemHandle.getPrivateStyle().setNumberFormatCategory("Fixed");
                    dataItemHandle.getPrivateStyle().setNumberFormat("###0");
                    continue block11;
                }
                case 10: 
                case 12: {
                    int n3;
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("#,##0.");
                    for (n3 = 0; n3 < fieldInfo.getPrecision(); ++n3) {
                        ((StringBuffer)charSequence).append("0");
                    }
                    dataItemHandle.getPrivateStyle().setNumberFormatCategory("Fixed");
                    dataItemHandle.getPrivateStyle().setNumberFormat(((StringBuffer)charSequence).toString());
                    continue block11;
                }
                case 3: {
                    int n3;
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("###0.");
                    for (n3 = 0; n3 < fieldInfo.getPrecision(); ++n3) {
                        ((StringBuffer)charSequence).append("0");
                    }
                    dataItemHandle.getPrivateStyle().setNumberFormatCategory("Fixed");
                    dataItemHandle.getPrivateStyle().setNumberFormat(((StringBuffer)charSequence).toString());
                    continue block11;
                }
            }
        }
    }

    private void setDetailCellFormatting(CellHandle cellHandle, DataType dataType) throws SemanticException {
        int n = dataType.toInt();
        switch (n) {
            case 12: {
                cellHandle.getStyle().setNumberFormatCategory("Currency");
                cellHandle.getStyle().setNumberFormat("###0.00");
                Locale locale = LocaleUtil.getLocale();
                break;
            }
            case 10: {
                cellHandle.getStyle().setNumberFormatCategory("Fixed");
                cellHandle.getStyle().setNumberFormat("###0.00");
                break;
            }
            case 13: {
                cellHandle.getStyle().setDateFormatCategory("General Date");
                break;
            }
            case 5: {
                cellHandle.getStyle().setStringFormatCategory("Unformatted");
                break;
            }
            case 4: {
                cellHandle.getStyle().setStringFormatCategory("Unformatted");
                break;
            }
            case 6: {
                cellHandle.getStyle().setStringFormatCategory("Unformatted");
                break;
            }
            case 2: {
                cellHandle.getStyle().setNumberFormatCategory("Unformatted");
                break;
            }
            case 3: {
                cellHandle.getStyle().setNumberFormatCategory("Fixed");
                cellHandle.getStyle().setNumberFormat("###0.00");
                break;
            }
            case 7: {
                cellHandle.getStyle().setDateTimeFormatCategory("Long Date");
                break;
            }
            case 14: {
                break;
            }
            case 40: {
                cellHandle.getStyle().setNumberFormatCategory("Unformatted");
                break;
            }
        }
    }

    private void addTableColumnBindings(ReportParameters reportParameters, OdaDataSetHandle odaDataSetHandle, TableHandle tableHandle) throws SemanticException {
        Object object;
        Object object22;
        List list = odaDataSetHandle.getListProperty("resultSet");
        PropertyHandle propertyHandle = tableHandle.getColumnBindings();
        for (Object object22 : list) {
            object = StructureFactory.createComputedColumn();
            object.setName(object22.getColumnName());
            object.setDisplayName(object22.getColumnName());
            object.setExpression("dataSetRow[\"" + object22.getColumnName() + "\"]");
            object.setDataType(object22.getDataType());
            propertyHandle.addItem((IStructure)object);
        }
        List<FieldInfo> list2 = reportParameters.getFields();
        object22 = list2.iterator();
        while (object22.hasNext()) {
            object = (FieldInfo)object22.next();
            if (!DataType.CURRENCY.equals((Object)((FieldInfo)object).getDataType())) continue;
            ComputedColumn computedColumn = StructureFactory.createComputedColumn();
            String string = reportParameters.getFieldName(((FieldInfo)object).getFieldId());
            computedColumn.setName(reportParameters.getFieldName(((FieldInfo)object).getFieldId()));
            computedColumn.setDisplayName(string);
            computedColumn.setExpression("if (dataSetRow[\"" + string + ".VALUE\"] == null) {\"\"" + " } else { var nf =  java.text.NumberFormat.getInstance(reportContext.getLocale()); nf.setMinimumFractionDigits(2); nf.format(dataSetRow[\"" + string + ".VALUE\"]) + \" \" + dataSetRow[\"" + string + ".TYPE\"]}");
            computedColumn.setDataType("string");
            propertyHandle.addItem((IStructure)computedColumn);
        }
    }

    private void addChartColumnBindings(OdaDataSetHandle odaDataSetHandle, ExtendedItemHandle extendedItemHandle, int n, int n2) throws SemanticException {
        List list = odaDataSetHandle.getListProperty("resultSet");
        PropertyHandle propertyHandle = extendedItemHandle.getColumnBindings();
        propertyHandle.clearValue();
        for (ResultSetColumn resultSetColumn : list) {
            ComputedColumn computedColumn = StructureFactory.createComputedColumn();
            computedColumn.setName(resultSetColumn.getColumnName());
            computedColumn.setDisplayName(resultSetColumn.getColumnName());
            computedColumn.setExpression("dataSetRow[\"" + resultSetColumn.getColumnName() + "\"]");
            computedColumn.setDataType(resultSetColumn.getDataType());
            propertyHandle.addItem((IStructure)computedColumn);
        }
    }

    private OdaDataSetHandle createDataSet(ReportParameters reportParameters, ReportDesignHandle reportDesignHandle, ElementFactory elementFactory) throws SemanticException, IOException, ContentException, NameException {
        int n;
        OdaDataSetHandle odaDataSetHandle = elementFactory.newOdaDataSet("adhoc_dataset", "com.bmc.arsys.oda.runtime.dataSet");
        odaDataSetHandle.setQueryText(this.createQueryPropertyString(reportParameters).toString());
        odaDataSetHandle.setDataSource("adhoc_datasource");
        odaDataSetHandle.setRowFetchLimit(reportParameters.getMaxRecords());
        reportDesignHandle.getDataSets().add((DesignElementHandle)odaDataSetHandle);
        PropertyHandle propertyHandle = odaDataSetHandle.getPropertyHandle("resultSet");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        List<FieldInfo> list = reportParameters.getFields();
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            FieldInfo fieldInfo = list.get(i);
            arrayList.add(fieldInfo.getFieldId());
            n2 = !DataType.CURRENCY.equals((Object)fieldInfo.getDataType()) ? this.addFieldToResultSet(propertyHandle, reportParameters, fieldInfo.getFieldId(), n2) : this.addCurrencyFieldToResultset(propertyHandle, reportParameters, fieldInfo.getFieldId(), n2);
        }
        arrayList2.addAll(arrayList);
        List<FieldInfo> list2 = reportParameters.getGroups();
        for (n = 0; n < list2.size(); ++n) {
            FieldInfo fieldInfo = list2.get(n);
            if (!arrayList2.contains(fieldInfo.getFieldId())) {
                arrayList3.add(fieldInfo.getFieldId());
            }
            if (arrayList.contains(fieldInfo.getFieldId())) continue;
            arrayList.add(fieldInfo.getFieldId());
            n2 = !DataType.CURRENCY.equals((Object)fieldInfo.getDataType()) ? this.addFieldToResultSet(propertyHandle, reportParameters, fieldInfo.getFieldId(), n2) : this.addCurrencyFieldToResultset(propertyHandle, reportParameters, fieldInfo.getFieldId(), n2);
        }
        if (reportParameters.isIncludeChart()) {
            int n3;
            n = reportParameters.getCategoryField();
            if (n > 0 && !arrayList.contains(n)) {
                arrayList.add(n);
                if (!arrayList2.contains(n)) {
                    arrayList3.add(n);
                }
                n2 = 12 != reportParameters.getFieldDataType(n) ? this.addFieldToResultSet(propertyHandle, reportParameters, n, n2) : this.addCurrencyFieldToResultset(propertyHandle, reportParameters, n, n2);
            }
            if ((n3 = reportParameters.getSeriesField()) > 0 && !arrayList.contains(n3)) {
                arrayList.add(n3);
                if (!arrayList2.contains(n3)) {
                    arrayList3.add(n3);
                }
                n2 = 12 != reportParameters.getFieldDataType(n3) ? this.addFieldToResultSet(propertyHandle, reportParameters, n3, n2) : this.addCurrencyFieldToResultset(propertyHandle, reportParameters, n3, n2);
            }
        }
        if (!arrayList.contains(1)) {
            arrayList3.add(1);
            OdaResultSetColumn odaResultSetColumn = StructureFactory.createOdaResultSetColumn();
            odaResultSetColumn.setPosition(Integer.valueOf(n2 + 1));
            ++n2;
            odaResultSetColumn.setColumnName(reportParameters.getFieldName(1));
            odaResultSetColumn.setDataType("string");
            propertyHandle.addItem((IStructure)odaResultSetColumn);
        }
        reportParameters.getProperties().put(INTERNAL_NON_DISPLAY_ARRAY_LIST, arrayList3);
        return odaDataSetHandle;
    }

    private int addFieldToResultSet(PropertyHandle propertyHandle, ReportParameters reportParameters, int n, int n2) throws SemanticException {
        OdaResultSetColumn odaResultSetColumn = StructureFactory.createOdaResultSetColumn();
        odaResultSetColumn.setPosition(Integer.valueOf(n2 + 1));
        odaResultSetColumn.setColumnName(reportParameters.getFieldName(n));
        odaResultSetColumn.setDataType(this.getDataType(reportParameters.getFieldDataType(n)));
        propertyHandle.addItem((IStructure)odaResultSetColumn);
        return ++n2;
    }

    private int addCurrencyFieldToResultset(PropertyHandle propertyHandle, ReportParameters reportParameters, int n, int n2) throws SemanticException {
        OdaResultSetColumn odaResultSetColumn = StructureFactory.createOdaResultSetColumn();
        odaResultSetColumn.setPosition(Integer.valueOf(n2 + 1));
        ++n2;
        odaResultSetColumn.setColumnName(reportParameters.getFieldName(n) + ".VALUE");
        odaResultSetColumn.setDataType("decimal");
        propertyHandle.addItem((IStructure)odaResultSetColumn);
        OdaResultSetColumn odaResultSetColumn2 = StructureFactory.createOdaResultSetColumn();
        odaResultSetColumn2.setPosition(Integer.valueOf(n2 + 1));
        ++n2;
        odaResultSetColumn2.setColumnName(reportParameters.getFieldName(n) + ".TYPE");
        odaResultSetColumn2.setDataType("string");
        propertyHandle.addItem((IStructure)odaResultSetColumn2);
        OdaResultSetColumn odaResultSetColumn3 = StructureFactory.createOdaResultSetColumn();
        odaResultSetColumn3.setPosition(Integer.valueOf(n2 + 1));
        odaResultSetColumn3.setColumnName(reportParameters.getFieldName(n) + ".OBJECT");
        odaResultSetColumn3.setNativeDataType(Integer.valueOf(1000));
        propertyHandle.addItem((IStructure)odaResultSetColumn3);
        return ++n2;
    }

    private String getDataType(DataType dataType) {
        if (dataType == null) {
            return "string";
        }
        return this.getDataType(dataType.toInt());
    }

    private String getDataType(int n) {
        switch (n) {
            case 4: {
                return "string";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "float";
            }
            case 10: {
                return "decimal";
            }
            case 6: {
                return "string";
            }
            case 7: {
                return "date-time";
            }
            case 13: {
                return "date";
            }
            case 14: {
                return "time";
            }
        }
        return "string";
    }

    private DataType getARDataType(String string) {
        if (string.equals("string")) {
            return DataType.CHAR;
        }
        if (string.equals("integer")) {
            return DataType.INTEGER;
        }
        if (string.equals("float")) {
            return DataType.REAL;
        }
        if (string.equals("decimal")) {
            return DataType.DECIMAL;
        }
        if (string.equals("date-time")) {
            return DataType.TIME;
        }
        if (string.equals("date")) {
            return DataType.DATE;
        }
        if (string.equals("time")) {
            return DataType.TIME_OF_DAY;
        }
        return DataType.CHAR;
    }

    private void createReportFromTemplate(ARServerUser aRServerUser, ReportParameters reportParameters, String string, String string2) throws SemanticException, URISyntaxException, IOException, DesignFileException {
        Object object;
        Object object2;
        Map.Entry<Object, Object> entry2;
        Object object32;
        Object object42;
        Value value;
        Form form;
        boolean bl = true;
        boolean bl2 = true;
        FormCriteria formCriteria = new FormCriteria();
        formCriteria.setPropertiesToRetrieve(60062);
        try {
            form = aRServerUser.getForm(reportParameters.getForm(), formCriteria);
            value = (Value)form.getProperties().get((Object)60062);
            if (value != null && value.getIntValue() == 0) {
                bl = false;
            }
        }
        catch (ARException aRException) {
            // empty catch block
        }
        form = this.designEngine.newSessionHandle(ULocale.forLocale((Locale)LocaleUtil.parseLocale((String)aRServerUser.getLocale())));
        value = form.openDesign(string2);
        ElementFactory elementFactory = value.getElementFactory();
        if (ReportStyle.LIST.equals((Object)reportParameters.getStyle())) {
            reportParameters.setChartType(null);
            reportParameters.setAggregation(null);
            reportParameters.setCategoryField(0);
            reportParameters.setSeriesField(0);
        }
        if (ReportStyle.CHART.equals((Object)reportParameters.getStyle())) {
            reportParameters.clearFields();
            reportParameters.clearGroups();
        }
        TextItemHandle textItemHandle = (TextItemHandle)value.findElement("adhoc_header_text");
        if (reportParameters.getTitle() != null) {
            textItemHandle.setContent(reportParameters.getTitle());
        } else if (textItemHandle.canDrop()) {
            textItemHandle.dropAndClear();
        }
        Object object5 = null;
        for (Object object42 : value.getDataSources()) {
            if (!"com.bmc.arsys.oda.runtime".equals(object42.getExtensionID())) continue;
            object5 = object42;
            break;
        }
        Iterator iterator = null;
        for (Object object32 : value.getDataSets()) {
            if (!"com.bmc.arsys.oda.runtime.dataSet".equals(object32.getExtensionID())) continue;
            iterator = object32;
            break;
        }
        object42 = iterator.getBeforeOpen();
        value.getDataSets().drop((DesignElementHandle)iterator);
        object32 = reportParameters.getProperties();
        this.clearChartProperties(reportParameters);
        this.clearListProperties(reportParameters);
        if (object32 != null && !((Properties)object32).isEmpty()) {
            for (Map.Entry<Object, Object> entry2 : ((Properties)object32).entrySet()) {
                object2 = (String)entry2.getKey();
                if (((String)object2).equals("arFieldObjects") || ((String)object2).equals(INTERNAL_NON_DISPLAY_ARRAY_LIST)) continue;
                object5.setPrivateDriverProperty((String)object2, (String)entry2.getValue());
            }
        }
        object5.setPrivateDriverProperty("reportDesigner", "AR_DESIGNER");
        iterator = this.createDataSet(reportParameters, (ReportDesignHandle)value, elementFactory);
        List list = (List)((Properties)object32).get(INTERNAL_NON_DISPLAY_ARRAY_LIST);
        if (list != null && !list.isEmpty()) {
            entry2 = "";
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (Integer)object2.next();
                if (object == null) continue;
                entry2 = (String)((Object)entry2) + object + ",";
            }
            object5.setPrivateDriverProperty(NON_DISPLAY_FIELDS, (String)((Object)entry2));
            ((Properties)object32).setProperty(NON_DISPLAY_FIELDS, (String)((Object)entry2));
        } else {
            object5.setPrivateDriverProperty(NON_DISPLAY_FIELDS, "");
            ((Properties)object32).setProperty(NON_DISPLAY_FIELDS, "");
        }
        iterator.setBeforeOpen((String)object42);
        entry2 = iterator.getPropertyHandle("resultSet");
        object2 = (TableHandle)value.findElement("adhoc_list_table");
        value.setLayoutPreference("auto layout");
        if (object2 != null && !reportParameters.isIncludeList() && object2.canDrop()) {
            object2.dropAndClear();
            object2 = null;
        }
        object = reportParameters.getFields();
        if (object2 != null) {
            Object object6;
            int n;
            object2.setDataSet((DataSetHandle)iterator);
            int n2 = object2.getColumnCount();
            boolean bl3 = false;
            for (n = n2; n < object.size(); ++n) {
                object6 = elementFactory.newTableColumn();
                object6.setProperty("width", (Object)"20%");
                object2.getColumns().add((DesignElementHandle)object6);
                ((RowHandle)object2.getHeader().get(0)).getCells().add((DesignElementHandle)elementFactory.newCell());
                ((RowHandle)object2.getDetail().get(0)).getCells().add((DesignElementHandle)elementFactory.newCell());
                ((RowHandle)object2.getFooter().get(0)).getCells().add((DesignElementHandle)elementFactory.newCell());
            }
            n2 = object2.getColumnCount();
            n = 100 / n2;
            for (Object object7 : object2.getColumns()) {
                object7.setProperty("width", (Object)(n + "%"));
            }
            object6 = object.iterator();
            while (object6.hasNext()) {
                Object object7;
                object7 = (FieldInfo)object6.next();
                if (((FieldInfo)object7).getFieldId() != 1) continue;
                bl3 = true;
            }
            object2.setWidth("100%");
            object2.getColumnBindings().clearValue();
            this.addTableColumnBindings(reportParameters, (OdaDataSetHandle)iterator, (TableHandle)object2);
            this.addTableContent(reportParameters, elementFactory, (TableHandle)object2, true, bl);
        }
        this.configureChart(aRServerUser, (ReportDesignHandle)value, (OdaDataSetHandle)iterator, reportParameters, bl, bl2);
        value.saveAs(string);
        value.close();
    }

    public Series getValueSeries(Chart chart) {
        Axis axis = (Axis)((ChartWithAxes)chart).getAxes().get(0);
        Axis axis2 = (Axis)axis.getAssociatedAxes().get(0);
        SeriesDefinition seriesDefinition = (SeriesDefinition)axis2.getSeriesDefinitions().get(0);
        return (Series)seriesDefinition.getSeries().get(0);
    }

    public void setTimeFormat(Chart chart, String string) {
        if (chart instanceof ChartWithAxes) {
            ChartWithAxes chartWithAxes = (ChartWithAxes)chart;
            ((Axis)chartWithAxes.getAxes().get(0)).setFormatSpecifier((FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)string));
        } else if (chart instanceof ChartWithoutAxes) {
            SeriesDefinition seriesDefinition = (SeriesDefinition)((ChartWithoutAxes)chart).getSeriesDefinitions().get(0);
            seriesDefinition.setFormatSpecifier((FormatSpecifier)JavaDateFormatSpecifierImpl.create((String)string));
        }
    }

    private void configureChart(ARServerUser aRServerUser, ReportDesignHandle reportDesignHandle, OdaDataSetHandle odaDataSetHandle, ReportParameters reportParameters, boolean bl, boolean bl2) throws SemanticException, ExtendedElementException {
        ExtendedItemHandle extendedItemHandle = (ExtendedItemHandle)reportDesignHandle.findElement("adhoc_chart");
        if (extendedItemHandle != null && !reportParameters.isIncludeChart() && extendedItemHandle.canDrop()) {
            extendedItemHandle.dropAndClear();
            extendedItemHandle = null;
        }
        if (extendedItemHandle != null) {
            int n = reportParameters.getSeriesField();
            int n2 = reportParameters.getCategoryField();
            this.addChartColumnBindings(odaDataSetHandle, extendedItemHandle, n2, n);
            Chart chart = (Chart)extendedItemHandle.getReportItem().getProperty("chart.instance");
            String string = reportParameters.getSeriesLabel();
            String string2 = reportParameters.getCategoryLabel();
            chart.getTitle().setVisible(false);
            String string3 = reportParameters.getFieldName(reportParameters.getCategoryField());
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            try {
                Field field = aRServerUser.getField(reportParameters.getForm(), reportParameters.getCategoryField());
                if (field.getDataType() == 2 || field.getDataType() == 3 || field.getDataType() == 10) {
                    bl3 = true;
                } else if (field.getDataType() == 7) {
                    bl4 = true;
                } else if (field.getDataType() == 13) {
                    bl5 = true;
                } else if (field.getDataType() == 14) {
                    bl6 = true;
                }
            }
            catch (ARException aRException) {
                // empty catch block
            }
            Trigger trigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)0, (String)("row[\"" + string3 + "\"] + \" (\" +  valueData + \")\" "))));
            String string4 = "";
            string4 = bl3 ? "params[\"chartURL\"].value + encodeURIComponent(\"'" + reportParameters.getCategoryField() + "'=\" + row[\"" + string3 + "\"])" : (bl4 ? "params[\"chartURL\"].value + encodeURIComponent(\"'" + reportParameters.getCategoryField() + "'=\\\"\"" + " + Date.parse(row[\"" + string3 + "\"]) + \"\\\"\")" : (bl5 ? "params[\"chartURL\"].value + encodeURIComponent(\"'" + reportParameters.getCategoryField() + "'=\\\"\"" + " + convertDate(row[\"" + string3 + "\"]) + \"\\\"\")" : "params[\"chartURL\"].value + encodeURIComponent(\"'" + reportParameters.getCategoryField() + "'=\\\"\"" + " + row[\"" + string3 + "\"] + \"\\\"\")"));
            if (bl6) {
                this.setTimeFormat(chart, "HH:mm:ss");
            }
            String string5 = "<structure name=\"action\"><property name=\"linkType\">hyperlink</property><expression name=\"uri\" type=\"javascript\">" + string4 + "</expression> <property name=\"targetWindow\">_blank</property>" + "</structure>";
            Trigger trigger2 = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)URLValueImpl.create((String)string5, null, (String)"", (String)"", (String)"")));
            if (chart instanceof ChartWithAxes) {
                ChartWithAxes chartWithAxes = (ChartWithAxes)chart;
                Axis axis = chartWithAxes.getPrimaryBaseAxes()[0];
                String string6 = "row[\"" + string3 + "\"]";
                if (12 == reportParameters.getFieldDataType(reportParameters.getCategoryField())) {
                    string6 = "row[\"" + string3 + ".VALUE\"] + \" \" + row[\"" + string3 + ".TYPE\"]";
                }
                axis.getTitle().getCaption().setValue(string2);
                axis.getTitle().getCaption().getFont().setBold(false);
                axis.getTitle().setVisible(true);
                ((Query)((Series)((SeriesDefinition)axis.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setDefinition(string6);
                switch (reportParameters.getChartType()) {
                    case BAR: 
                    case CONE: 
                    case PYRAMID: 
                    case TUBE: {
                        chartWithAxes.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
                        break;
                    }
                }
                Axis axis2 = chartWithAxes.getPrimaryOrthogonalAxis(axis);
                axis2.getTitle().getCaption().setValue(string);
                axis2.getTitle().getCaption().getFont().setBold(false);
                axis2.getTitle().setVisible(true);
                extendedItemHandle.setDataSet((DataSetHandle)odaDataSetHandle);
                String string7 = reportParameters.getFieldName(reportParameters.getSeriesField());
                String string8 = "row[\"" + string7 + "\"]";
                if (12 == reportParameters.getFieldDataType(reportParameters.getSeriesField())) {
                    string8 = "row[\"" + string7 + ".VALUE\"]";
                }
                ((Query)((Series)((SeriesDefinition)axis2.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setDefinition(string8);
                if (reportParameters.getAggregation() != null) {
                    SeriesGrouping seriesGrouping = DataFactory.eINSTANCE.createSeriesGrouping();
                    seriesGrouping.setEnabled(true);
                    seriesGrouping.setAggregateExpression(reportParameters.getAggregation().getBIRTType());
                    seriesGrouping.setGroupType(org.eclipse.birt.chart.model.attribute.DataType.TEXT_LITERAL);
                    ((Query)((Series)((SeriesDefinition)axis2.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setGrouping(seriesGrouping);
                }
                this.getValueSeries(chart).getTriggers().add((Object)trigger);
                if (bl && bl2) {
                    this.getValueSeries(chart).getTriggers().add((Object)trigger2);
                }
            } else if (chart instanceof ChartWithoutAxes) {
                Object object;
                ChartWithoutAxes chartWithoutAxes = (ChartWithoutAxes)chart;
                String string9 = reportParameters.getFieldName(reportParameters.getSeriesField());
                String string10 = "row[\"" + string9 + "\"]";
                if (12 == reportParameters.getFieldDataType(reportParameters.getSeriesField())) {
                    string10 = "row[\"" + string9 + ".VALUE\"]";
                }
                Series series = (Series)((SeriesDefinition)((SeriesDefinition)chartWithoutAxes.getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0)).getSeries().get(0);
                ((Query)series.getDataDefinition().get(0)).setDefinition(string10);
                series.getLabel().getCaption().setValue(string);
                series.getLabel().getCaption().getFont().setBold(false);
                series.setSeriesIdentifier((Object)string);
                series.getTriggers().add((Object)trigger);
                if (bl && bl2) {
                    series.getTriggers().add((Object)trigger2);
                }
                if (reportParameters.getAggregation() != null) {
                    object = DataFactory.eINSTANCE.createSeriesGrouping();
                    object.setEnabled(true);
                    object.setAggregateExpression(reportParameters.getAggregation().getBIRTType());
                    object.setGroupType(org.eclipse.birt.chart.model.attribute.DataType.TEXT_LITERAL);
                    ((Query)series.getDataDefinition().get(0)).setGrouping(object);
                }
                object = "row[\"" + string3 + "\"]";
                if (12 == reportParameters.getFieldDataType(reportParameters.getCategoryField())) {
                    object = "row[\"" + string3 + ".VALUE\"] + \" \" + row[\"" + string3 + ".TYPE\"]";
                }
                ((Query)((Series)((SeriesDefinition)chartWithoutAxes.getSeriesDefinitions().get(0)).getSeries().get(0)).getDataDefinition().get(0)).setDefinition((String)object);
            }
        }
    }

    private void addCellBorders(CellHandle cellHandle) throws SemanticException {
        cellHandle.setProperty("borderBottomWidth", (Object)"thin");
        cellHandle.setProperty("borderBottomStyle", (Object)"solid");
        cellHandle.setProperty("borderBottomColor", (Object)"black");
        cellHandle.setProperty("borderLeftWidth", (Object)"thin");
        cellHandle.setProperty("borderLeftStyle", (Object)"solid");
        cellHandle.setProperty("borderLeftColor", (Object)"black");
        cellHandle.setProperty("borderTopWidth", (Object)"thin");
        cellHandle.setProperty("borderTopStyle", (Object)"solid");
        cellHandle.setProperty("borderTopColor", (Object)"black");
        cellHandle.setProperty("borderRightWidth", (Object)"thin");
        cellHandle.setProperty("borderRightStyle", (Object)"solid");
        cellHandle.setProperty("borderRightColor", (Object)"black");
    }

    private String createQueryPropertyString(ReportParameters reportParameters) throws IOException {
        Object object;
        Object object2;
        Properties properties = new Properties();
        properties.setProperty(FORM, reportParameters.getForm());
        if (reportParameters.getQualification() != null) {
            properties.setProperty(QUALIFICATION, reportParameters.getQualification());
        } else {
            reportParameters.setQualification("1 = 1");
        }
        if (reportParameters.getResultList() != null) {
            properties.setProperty(RESULTLIST, reportParameters.getResultList());
            properties.remove(QUALIFICATION);
        }
        properties.setProperty(HIDE_ENTRY_ID, "true");
        List<FieldInfo> list = reportParameters.getFields();
        for (FieldInfo object32 : list) {
            if (object32.getFieldId() != 1) continue;
            properties.setProperty(HIDE_ENTRY_ID, "false");
            break;
        }
        this.addFieldProperties(reportParameters, properties);
        StringBuffer stringBuffer = new StringBuffer();
        List<FieldInfo> list2 = reportParameters.getGroups();
        if (list2 != null) {
            object2 = list2;
            object = object2.iterator();
            while (object.hasNext()) {
                FieldInfo fieldInfo = object.next();
                if (fieldInfo.getSortDir() == -1) continue;
                stringBuffer.append(fieldInfo.getFieldId()).append(",").append(fieldInfo.getSortDir() == 0 ? 2 : 1).append(",").append(fieldInfo.getGroup()).append(";");
            }
        }
        if (stringBuffer.length() > 0) {
            properties.setProperty(SORTINFO, stringBuffer.toString());
        }
        object2 = new ByteArrayOutputStream();
        properties.store((OutputStream)object2, null);
        object = new String(((ByteArrayOutputStream)object2).toByteArray());
        ((ByteArrayOutputStream)object2).close();
        return ((String)object).toString();
    }

    private void addFieldProperties(ReportParameters reportParameters, Properties properties) {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<FieldInfo> list = reportParameters.getFields();
        for (int i = 0; i < list.size(); ++i) {
            FieldInfo fieldInfo = list.get(i);
            arrayList.add(fieldInfo.getFieldId());
        }
        List<FieldInfo> list2 = reportParameters.getGroups();
        for (n = 0; n < list2.size(); ++n) {
            object = list2.get(n);
            if (arrayList.contains(((FieldInfo)object).getFieldId())) continue;
            arrayList.add(list2.get(n).getFieldId());
        }
        if (reportParameters.getCategoryField() > 0 && !arrayList.contains(reportParameters.getCategoryField())) {
            arrayList.add(reportParameters.getCategoryField());
        }
        if (reportParameters.getSeriesField() > 0 && !arrayList.contains(reportParameters.getSeriesField())) {
            arrayList.add(reportParameters.getSeriesField());
        }
        if (!arrayList.contains(1)) {
            arrayList.add(1);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            object = (Integer)arrayList.get(n);
            stringBuffer.append(object);
            properties.setProperty("Field-" + object, reportParameters.getFieldDataType((Integer)object) + "::" + reportParameters.getFieldName((Integer)object));
        }
        properties.setProperty(FIELDS, stringBuffer.toString());
    }

    private String getTableFieldString(ReportParameters reportParameters) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<FieldInfo> list = reportParameters.getFields();
        for (n = 0; n < list.size(); ++n) {
            arrayList.add(list.get(n).getFieldId());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(arrayList.get(n));
        }
        return stringBuffer.toString();
    }

    public ReportParameters getParameters(String string) throws ARException {
        ReportParameters reportParameters = new ReportParameters();
        try {
            IReportRunnable iReportRunnable = this.reportEngine.openReportDesign(string);
            this.populateParameters(iReportRunnable, reportParameters);
        }
        catch (IOException iOException) {
            throw new ARException();
        }
        catch (EngineException engineException) {
            throw new ARException();
        }
        return reportParameters;
    }

    private void populatePrivateDriverProperties(ReportParameters reportParameters, IDataSource iDataSource) {
        for (ReportConstants reportConstants : ReportConstants.values()) {
            if (iDataSource.getPrivateDriverProperty(Integer.toString(reportConstants.toInt())) == null) continue;
            reportParameters.getProperties().setProperty(Integer.toString(reportConstants.toInt()), iDataSource.getPrivateDriverProperty(Integer.toString(reportConstants.toInt())));
        }
        if (iDataSource.getPrivateDriverProperty("reportDesigner") != null) {
            reportParameters.getProperties().setProperty("reportDesigner", iDataSource.getPrivateDriverProperty("reportDesigner"));
        }
        if (iDataSource.getPrivateDriverProperty(NON_DISPLAY_FIELDS) != null) {
            reportParameters.getProperties().setProperty(NON_DISPLAY_FIELDS, iDataSource.getPrivateDriverProperty(NON_DISPLAY_FIELDS));
        }
        this.clearChartProperties(reportParameters);
        this.clearListProperties(reportParameters);
    }

    private void clearListProperties(ReportParameters reportParameters) {
        if (ReportStyle.CHART.equals((Object)reportParameters.getStyle())) {
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_REPORT_FIELDS_ID);
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_SORTINFO_ID);
        }
    }

    private void clearChartProperties(ReportParameters reportParameters) {
        if (ReportStyle.LIST.equals((Object)reportParameters.getStyle())) {
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_REPORT_CHART_ID);
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_CHART_AGGREGATE_BY);
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_CHART_CATEGORY_ID);
            reportParameters.getProperties().remove((Object)ReportConstants.DESIGNER_CHART_SERIES_ID);
        }
    }

    public ReportParameters getParameters(byte[] byArray) throws ARException {
        ReportParameters reportParameters = new ReportParameters();
        reportParameters.setType(ReportType.BIRT);
        try {
            IReportRunnable iReportRunnable = this.reportEngine.openReportDesign((InputStream)new ByteArrayInputStream(byArray));
            this.populateParameters(iReportRunnable, reportParameters);
            return reportParameters;
        }
        catch (IOException iOException) {
            throw new ARException();
        }
        catch (EngineException engineException) {
            throw new ARException();
        }
    }

    private void populateParameters(IReportRunnable iReportRunnable, ReportParameters reportParameters) throws ARException, IOException {
        Object object;
        String string;
        IDataSource iDataSource = this.getDataSource(iReportRunnable);
        String string2 = iDataSource.getPrivateDriverProperty("reportDesigner");
        IDataSet iDataSet = this.getDataSet(iReportRunnable);
        if (iDataSet != null) {
            this.populateParametersFromQueryText(reportParameters, iDataSet.getQueryText());
        }
        if ("AR_DESIGNER".equals(string2)) {
            reportParameters.getProperties().setProperty("reportDesigner", "AR_DESIGNER");
            this.populatePrivateDriverProperties(reportParameters, iDataSource);
            string = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_TEMPLATE_ID.toInt()));
            if (string != null && string.length() > 0) {
                int n = Integer.parseInt(string);
                reportParameters.setStyle(ReportStyle.fromInt(n));
            }
            if ((object = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_CHART_ID.toInt()))) != null && ((String)object).length() > 0) {
                int n = Integer.parseInt((String)object);
                reportParameters.setChartType(ChartType.fromInt(n));
            } else {
                reportParameters.setChartType(null);
            }
            if (!ReportStyle.CHART.equals((Object)reportParameters.getStyle())) {
                ReportDesignHandle reportDesignHandle = (ReportDesignHandle)iReportRunnable.getDesignHandle().getModuleHandle();
                TableHandle tableHandle = (TableHandle)reportDesignHandle.findElement("adhoc_list_table");
                if (tableHandle != null) {
                    RowHandle rowHandle = (RowHandle)tableHandle.getHeader().get(0);
                    int n = rowHandle.getCells().getCount();
                    for (int i = 0; i < n; ++i) {
                        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(i);
                        LabelHandle labelHandle = (LabelHandle)cellHandle.getContent().get(0);
                        if (labelHandle == null) continue;
                        reportParameters.getFields().get(i).setLabel(labelHandle.getText());
                    }
                }
            } else {
                reportParameters.clearFields();
                reportParameters.clearGroups();
            }
        } else {
            reportParameters.getProperties().setProperty("reportDesigner", "BIRT_DESIGNER");
        }
        string = reportParameters.getProperties().getProperty(NON_DISPLAY_FIELDS);
        if (string != null && string.length() > 0 && (object = string.split(",")) != null && ((String[])object).length > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Object object2 : object) {
                if (object2 == null || ((String)object2).length() <= 0) continue;
                arrayList.add(Integer.parseInt((String)object2));
            }
            for (Integer n : arrayList) {
                reportParameters.removeField(n);
            }
        }
        this.clearChartProperties(reportParameters);
        this.clearListProperties(reportParameters);
    }

    private IDataSource getDataSource(IReportRunnable iReportRunnable) throws ARException {
        IDataSource iDataSource = null;
        SlotHandle slotHandle = iReportRunnable.getDesignHandle().getModuleHandle().getDataSources();
        for (OdaDataSourceHandle odaDataSourceHandle : slotHandle) {
            DesignElement designElement = odaDataSourceHandle.getElement();
            if (!(designElement instanceof OdaDataSource)) continue;
            iDataSource = iReportRunnable.getDesignInstance().getDataSource(((OdaDataSource)designElement).getName());
            break;
        }
        if (iDataSource == null) {
            iDataSource = iReportRunnable.getDesignInstance().getDataSource("adhoc_datasource");
        }
        if (iDataSource == null) {
            this.logMessage(2, "Unable to find data source");
            throw new ARException(2, 3356, "Unable to find data source");
        }
        return iDataSource;
    }

    private IDataSet getDataSet(IReportRunnable iReportRunnable) throws ARException {
        IDataSet iDataSet = null;
        SlotHandle slotHandle = iReportRunnable.getDesignHandle().getModuleHandle().getDataSets();
        for (OdaDataSetHandle odaDataSetHandle : slotHandle) {
            DesignElement designElement = odaDataSetHandle.getElement();
            if (!(designElement instanceof OdaDataSet)) continue;
            iDataSet = iReportRunnable.getDesignInstance().getDataSet(((OdaDataSet)designElement).getName());
            break;
        }
        if (iDataSet == null) {
            iDataSet = iReportRunnable.getDesignInstance().getDataSet("adhoc_dataset");
        }
        if (iDataSet == null) {
            this.logMessage(2, "Unable to find data set");
            throw new ARException(2, 3356, "Unable to find data set");
        }
        return iDataSet;
    }

    private void populateParametersFromQueryText(ReportParameters reportParameters, String string) throws IOException {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(string.getBytes()));
        reportParameters.setQualification(properties.getProperty(QUALIFICATION));
        String string2 = properties.getProperty(FIELDS);
        String string3 = properties.getProperty(SORTINFO);
        String string4 = properties.getProperty(HIDE_ENTRY_ID);
        reportParameters.clearFields();
        String[] stringArray = null;
        if (stringArray == null) {
            stringArray = string2.split(",");
        }
        for (String string5 : stringArray) {
            reportParameters.addField(new FieldInfo(Integer.parseInt(string5), null, null));
        }
        if ("true".equals(string4)) {
            reportParameters.removeField(1);
        }
        if (string3 != null && string3.length() > 0) {
            String[] stringArray2 = string3.split(";");
            reportParameters.clearGroups();
            for (String string6 : stringArray2) {
                String[] stringArray3 = string6.split(",");
                if (stringArray3.length < 2) continue;
                FieldInfo fieldInfo = new FieldInfo(Integer.parseInt(stringArray3[0]), null, Integer.parseInt(stringArray3[1]), 0);
                if (stringArray3.length >= 3) {
                    fieldInfo.setGroup(Integer.parseInt(stringArray3[2]));
                }
                reportParameters.addGroup(fieldInfo);
            }
        }
    }

    public void runReport(ARServerUser aRServerUser, byte[] byArray, OutputFormat outputFormat, OutputStream outputStream) throws ARException {
        try {
            IReportRunnable iReportRunnable = this.reportEngine.openReportDesign((InputStream)new ByteArrayInputStream(byArray));
            ReportParameters reportParameters = new ReportParameters();
            reportParameters.setOutputFormat(outputFormat);
            this.runReport(aRServerUser, iReportRunnable, reportParameters, outputStream);
        }
        catch (EngineException engineException) {
            throw new ARException(2, -1, engineException.getMessage());
        }
        catch (SemanticException semanticException) {
            throw new ARException(2, -1, semanticException.getMessage());
        }
        catch (ScriptException scriptException) {
            throw new ARException(2, -1, scriptException.getMessage());
        }
    }

    private void runReport(ARServerUser aRServerUser, IReportRunnable iReportRunnable, ReportParameters reportParameters, OutputStream outputStream) throws EngineException, ARException, ScriptException, SemanticException {
        Object object;
        Object object2;
        Object object3;
        String string;
        IDataSet iDataSet;
        IDataSource iDataSource = this.getDataSource(iReportRunnable);
        if (iDataSource != null) {
            iDataSource.setPrivateDriverProperty("user", aRServerUser.getUser());
            iDataSource.setPrivateDriverProperty("server", aRServerUser.getServer());
            if (aRServerUser.getPassword() == null || aRServerUser.getPassword() != null && aRServerUser.getPassword().length() == 0) {
                iDataSource.setPrivateDriverProperty("password", AR_BIRT_NULL_PASSWORD);
            } else {
                iDataSource.setPrivateDriverProperty("password", aRServerUser.getPassword());
            }
            iDataSource.setPrivateDriverProperty("port", Integer.toString(aRServerUser.getPort()));
            iDataSource.setPrivateDriverProperty("authentication", aRServerUser.getAuthentication());
            if (aRServerUser.getLocale() != null) {
                iDataSource.setPrivateDriverProperty("locale", aRServerUser.getLocale());
            } else {
                iDataSource.getPrivateDriverProperty("");
            }
            if (aRServerUser.getTimeZone() != null) {
                iDataSource.setPrivateDriverProperty("timezone", aRServerUser.getTimeZone());
            } else {
                iDataSource.setPrivateDriverProperty("timezone", "");
            }
        }
        if (reportParameters.getQualification() == null || reportParameters.getQualification().length() == 0) {
            reportParameters.setQualification("1 = 1");
        }
        if (reportParameters.getQualification() != null && reportParameters.getQualification().length() > 0 || reportParameters.getResultList() != null && reportParameters.getResultList().length() > 0) {
            iDataSet = this.getDataSet(iReportRunnable);
            string = iDataSet.getQueryText();
            object3 = new Properties();
            try {
                ((Properties)object3).load(new ByteArrayInputStream(string.getBytes()));
                if (reportParameters.getQualification() != null && reportParameters.getQualification().length() > 0) {
                    object2 = ((Properties)object3).getProperty(QUALIFICATION);
                    if (reportParameters.isOverrideQualification()) {
                        ((Properties)object3).setProperty(QUALIFICATION, reportParameters.getQualification());
                    } else if (object2 != null && ((String)object2).length() > 0) {
                        ((Properties)object3).setProperty(QUALIFICATION, (String)object2 + " AND " + reportParameters.getQualification());
                    } else {
                        ((Properties)object3).setProperty(QUALIFICATION, reportParameters.getQualification());
                    }
                }
                ((Properties)object3).remove(RESULTLIST);
                if (reportParameters.getResultList() != null && reportParameters.getResultList().length() > 0) {
                    ((Properties)object3).setProperty(RESULTLIST, reportParameters.getResultList());
                    ((Properties)object3).remove(QUALIFICATION);
                }
                object2 = new ByteArrayOutputStream();
                ((Properties)object3).store((OutputStream)object2, null);
                object = new String(((ByteArrayOutputStream)object2).toByteArray());
                iDataSet.setQueryText(((String)object).toString());
                ((ByteArrayOutputStream)object2).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (reportParameters.getQualification() != null && reportParameters.getQualification().length() > 0) {
            iDataSet = this.getDataSet(iReportRunnable);
            string = iDataSet.getQueryText();
            object3 = new Properties();
            try {
                ((Properties)object3).load(new ByteArrayInputStream(string.getBytes()));
                object2 = ((Properties)object3).getProperty(QUALIFICATION);
                if (reportParameters.isOverrideQualification()) {
                    ((Properties)object3).setProperty(QUALIFICATION, reportParameters.getQualification());
                } else if (object2 != null && ((String)object2).length() > 0) {
                    ((Properties)object3).setProperty(QUALIFICATION, (String)object2 + " AND " + reportParameters.getQualification());
                } else {
                    ((Properties)object3).setProperty(QUALIFICATION, reportParameters.getQualification());
                }
                object = new ByteArrayOutputStream();
                ((Properties)object3).store((OutputStream)object, null);
                String string2 = new String(((ByteArrayOutputStream)object).toByteArray());
                iDataSet.setQueryText(string2.toString());
                ((ByteArrayOutputStream)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        iDataSet = this.reportEngine.createRunAndRenderTask(iReportRunnable);
        iDataSet.setLocale(LocaleUtil.parseLocale((String)aRServerUser.getLocale()));
        iDataSet.setParameterValue("midTierURL", (Object)reportParameters.getMidtierUrl());
        if (aRServerUser.getTimeZone() != null) {
            string = TimeZone.getTimeZone((String)aRServerUser.getTimeZone());
            iDataSet.setTimeZone((TimeZone)string);
        }
        string = null;
        object3 = reportParameters.getOutputFormat();
        object2 = null;
        switch (1.$SwitchMap$com$bmc$arsys$arreporting$OutputFormat[((Enum)object3).ordinal()]) {
            case 1: {
                string = new HTMLRenderOption();
                string.setOutputFormat(HTML_RENDER_FORMAT);
                object = new HTMLServerImageHandler();
                string.setImageHandler((IHTMLImageHandler)object);
                object2 = (HTMLRenderOption)string;
                object2.setBaseImageURL(this.properties.getProperty("birt.base.image.url"));
                object2.setImageDirectory(this.properties.getProperty("birt.image.dir"));
                if (reportParameters.isForcePNG()) {
                    object2.setSupportedImageFormats("PNG");
                }
                object2.setEmbeddable(false);
                break;
            }
            case 2: {
                string = new HTMLRenderOption();
                string.setOutputFormat(HTML_RENDER_FORMAT);
                object = new HTMLServerImageHandler();
                string.setImageHandler((IHTMLImageHandler)object);
                object2 = (HTMLRenderOption)string;
                object2.setEmbeddable(true);
                object2.setBaseImageURL(this.properties.getProperty("birt.base.image.url"));
                object2.setImageDirectory(this.properties.getProperty("birt.image.dir"));
                if (!reportParameters.isForcePNG()) break;
                object2.setSupportedImageFormats("PNG");
                break;
            }
            case 3: {
                string = new RenderOption();
                string.setOutputFormat(PDF_RENDER_FORMAT);
                break;
            }
            case 4: {
                string = new RenderOption();
                string.setOutputFormat(EXCEL_RENDER_FORMAT);
                break;
            }
            case 5: {
                string = new RenderOption();
                string.setOutputFormat(DOC_RENDER_FORMAT);
                break;
            }
            case 6: {
                string = new RenderOption();
                string.setOutputFormat(PPT_RENDER_FORMAT);
            }
        }
        string.setOutputStream(outputStream);
        iDataSet.setRenderOption((IRenderOption)string);
        iDataSet.run();
        iDataSet.close();
    }

    public void runReport(ARServerUser aRServerUser, ReportParameters reportParameters, String string, OutputStream outputStream) throws ARException {
        try {
            IReportRunnable iReportRunnable = this.reportEngine.openReportDesign(string);
            this.runReport(aRServerUser, iReportRunnable, reportParameters, outputStream);
        }
        catch (EngineException engineException) {
            throw new ARException(2, -1, engineException.getMessage());
        }
        catch (SemanticException semanticException) {
            throw new ARException(2, -1, semanticException.getMessage());
        }
        catch (ScriptException scriptException) {
            throw new ARException(2, -1, scriptException.getMessage());
        }
    }

    public void setTemp() {
    }

    public EngineConfig getReportConfig() {
        return this.reportConfig;
    }

    public void setReportConfig(EngineConfig engineConfig) {
        this.reportConfig = engineConfig;
    }

    public DesignConfig getDesignConfig() {
        return this.designConfig;
    }

    public void setDesignConfig(DesignConfig designConfig) {
        this.designConfig = designConfig;
    }

    public IReportEngine getReportEngine() {
        return this.reportEngine;
    }

    public void setReportEngine(IReportEngine iReportEngine) {
        this.reportEngine = iReportEngine;
    }

    public IDesignEngine getDesignEngine() {
        return this.designEngine;
    }

    public void setDesignEngine(IDesignEngine iDesignEngine) {
        this.designEngine = iDesignEngine;
    }

    public String getEngineHome() {
        return this.engineHome;
    }

    private void logMessage(int n, String string) {
        if (this.logListener != null) {
            this.logListener.logMessage(n, string);
        }
    }

    public void runReport(ARServerUser aRServerUser, ReportParameters reportParameters, byte[] byArray, ByteArrayOutputStream byteArrayOutputStream) throws ARException {
        this.runReport(aRServerUser, byArray, reportParameters.getOutputFormat(), (OutputStream)byteArrayOutputStream);
    }

    public Properties getEngineProperties() {
        return this.properties;
    }

    private String combineQualifications(ARServerUser aRServerUser, String string, String string2) throws ARException {
        QualifierInfo qualifierInfo = this.getAllQualifier();
        QualifierInfo qualifierInfo2 = this.getAllQualifier();
        if (string != null && !this.isEncodedQualification(string)) {
            throw new ARException(2, -1, "Primary qualification is in an unsupported format");
        }
        if (string2 != null && !this.isEncodedQualification(string2)) {
            throw new ARException(2, -1, "Secondary qualification is in an unsupported format");
        }
        return null;
    }

    private QualifierInfo getAllQualifier() {
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(new Value(1));
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2 = new ArithmeticOrRelationalOperand(new Value(1));
        QualifierInfo qualifierInfo = new QualifierInfo(new RelationalOperationInfo(1, arithmeticOrRelationalOperand, arithmeticOrRelationalOperand2));
        return qualifierInfo;
    }

    private boolean isEncodedQualification(String string) {
        int n;
        return string != null && string.length() > 2 && (n = string.charAt(0) - 48) <= 5 && n >= 0 && string.charAt(1) == '\\';
    }
}

