/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.PerfThreadControlBlock;
import com.bmc.arsys.demo.javadriver.PerfThreadControlLocalStorage;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfJavaDriver
extends JavaDriver {
    static long OUT_MODE_PERF_LOG = 2L;
    static long OUT_MODE_PERF_LOG_MEM = 4L;
    static long OUT_MODE_ANY = 7L;
    private static long outputSetting;
    static int fileCount;
    static long driverStartTime;

    public static void main(String[] stringArray) {
        try {
            ProxyManager.setUseConnectionPooling(false);
            PerfJavaDriver perfJavaDriver = new PerfJavaDriver();
            perfJavaDriver.setCommandLineArgs(stringArray);
            perfJavaDriver.setPrimaryThread(true);
            javaDriverOnly = false;
            perfJavaDriver.start();
        }
        catch (Exception exception) {
            outputWriter.printString("Error in executing the command\n");
        }
    }

    @Override
    protected ThreadControlBlock initThreadControlBlockPtr() {
        localStorage = new PerfThreadControlLocalStorage();
        return (ThreadControlBlock)localStorage.get();
    }

    @Override
    public void initCommandProcessing() {
        super.initCommandProcessing();
        if ((PerfJavaDriver.getOutputSetting() & (OUT_MODE_PERF_LOG | OUT_MODE_PERF_LOG_MEM)) != 0L) {
            driverStartTime = System.currentTimeMillis();
            if (PerfJavaDriver.isForOutputFile()) {
                PerfJavaDriver.setFileCount(this.getOutputCount());
            }
        }
    }

    protected static boolean isForOutputFile() {
        boolean bl = false;
        if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_PERF_LOG) != 0L && (PerfJavaDriver.getOutputSetting() & OUT_MODE_PERF_LOG_MEM) == 0L) {
            bl = true;
        }
        return bl;
    }

    static synchronized void setFileCount(int n) {
        fileCount = n;
    }

    static synchronized int getAndIncrementTheFileCount() {
        return fileCount++;
    }

    @Override
    protected void logResult(List<StatusInfo> list, long l) throws IOException {
        super.logResult(list, l);
        if ((PerfJavaDriver.getOutputSetting() & (OUT_MODE_PERF_LOG | OUT_MODE_PERF_LOG_MEM)) != 0L) {
            long l2 = 0L;
            if (list != null && list.size() != 0 && list.get(0).getMessageType() == 2) {
                l2 = list.get(0).getMessageNum();
            }
            this.logPerfResults(l2, l);
        }
    }

    protected void logPerfResults(long l, long l2) throws IOException {
        PerfThreadControlBlock perfThreadControlBlock = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        if (!perfThreadControlBlock.isResultFileOpened()) {
            perfThreadControlBlock.initLogMethod();
        }
        long l3 = l2 - driverStartTime;
        String string = PerfJavaDriver.getStatString(l3, perfThreadControlBlock.getCurrentCommand(), l, perfThreadControlBlock.getAuxCount());
        perfThreadControlBlock.writeInResultFile(string);
    }

    static String getStatString(long l, String string, long l2, long l3) {
        String string2 = "" + l;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (n = string2.length(); n < 8; ++n) {
            stringBuilder.append("0");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(stringBuilder.toString()).append(string2).append(" ").append(string);
        for (n = string.length(); n < 6; ++n) {
            stringBuilder2.append(" ");
        }
        stringBuilder2.append(" ");
        String string3 = "" + l2;
        StringBuilder stringBuilder3 = new StringBuilder();
        for (n = string3.length(); n < 10; ++n) {
            stringBuilder3.append(" ");
        }
        stringBuilder2.append(stringBuilder3.toString()).append(string3).append(" ");
        String string4 = "" + l3 * 1000L;
        StringBuilder stringBuilder4 = new StringBuilder();
        for (n = string4.length(); n < 10; ++n) {
            stringBuilder4.append(" ");
        }
        stringBuilder2.append(stringBuilder4.toString()).append(string4);
        return stringBuilder2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyThreadControlBlockPtr(boolean bl) throws IOException {
        try {
            super.destroyThreadControlBlockPtr(bl);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.processResultFile();
            throw throwable;
        }
        this.processResultFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResultFile() throws IOException {
        PerfThreadControlBlock perfThreadControlBlock = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        try {
            String string;
            Object object;
            Stack<String> stack = new Stack<String>();
            if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_PERF_LOG_MEM) != 0L && (object = perfThreadControlBlock.getResultStack()) != null && !((Stack)object).empty()) {
                while (!((Stack)object).empty()) {
                    string = (String)((Stack)object).pop();
                    stack.push(string);
                }
            }
            if (PerfJavaDriver.isForOutputFile()) {
                object = perfThreadControlBlock.getResultFile();
                if (perfThreadControlBlock.getOutputFileName() != null && object != null) {
                    ((PrintWriter)object).println();
                    ((PrintWriter)object).println("Corresponding Output File: " + perfThreadControlBlock.getOutputFileName());
                    ((PrintWriter)object).flush();
                }
                while (!stack.empty()) {
                    string = (String)stack.pop();
                    ((PrintWriter)object).println(string);
                }
            }
            Object var6_5 = null;
            perfThreadControlBlock.closeResultFile();
            perfThreadControlBlock.closeResultStack();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            perfThreadControlBlock.closeResultFile();
            perfThreadControlBlock.closeResultStack();
            throw throwable;
        }
    }

    @Override
    protected void setOutputCount(String string) {
        PerfThreadControlBlock perfThreadControlBlock = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        perfThreadControlBlock.setResultFileCount(new Integer(string));
    }

    protected int getOutputCount() {
        PerfThreadControlBlock perfThreadControlBlock = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        return perfThreadControlBlock.getResultFileCount();
    }

    @Override
    void printAuxillaryStatus() {
        PerfThreadControlBlock perfThreadControlBlock = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
        outputWriter.printResult("Elapsed micro seconds: " + perfThreadControlBlock.getAuxCount() * 1000L + "\n");
    }

    @Override
    protected JavaDriver instantiateJavaDriver() {
        return new PerfJavaDriver();
    }

    @Override
    public void beginAPICall() {
        if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_ANY) != 0L) {
            PerfThreadControlBlock perfThreadControlBlock = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
            perfThreadControlBlock.setAuxCount(System.currentTimeMillis());
        }
    }

    @Override
    public void endAPICall(List<StatusInfo> list) {
        try {
            if ((PerfJavaDriver.getOutputSetting() & OUT_MODE_ANY) != 0L) {
                PerfThreadControlBlock perfThreadControlBlock = (PerfThreadControlBlock)PerfJavaDriver.getThreadControlBlockPtr();
                long l = perfThreadControlBlock.getAuxCount();
                perfThreadControlBlock.setAuxCount(System.currentTimeMillis() - l);
                this.logResult(list, l);
            }
        }
        catch (Exception exception) {
            System.out.println("Problem in end API Call...");
        }
    }

    protected static long getOutputSetting() {
        return outputSetting;
    }

    @Override
    protected void setOutputSetting(String string) {
        super.setOutputSetting(string);
        outputSetting = new Long(string);
    }

    static {
        fileCount = 0;
    }
}

