/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jpa.vendor;

import com.bmc.thirdparty.org.springframework.orm.jpa.JpaDialect;
import com.bmc.thirdparty.org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import com.bmc.thirdparty.org.springframework.orm.jpa.vendor.Database;
import com.bmc.thirdparty.org.springframework.orm.jpa.vendor.TopLinkJpaDialect;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.persistence.spi.PersistenceProvider;
import oracle.toplink.essentials.ejb.cmp3.EntityManager;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;

public class TopLinkJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final PersistenceProvider persistenceProvider = new EntityManagerFactoryProvider();
    private final JpaDialect jpaDialect = new TopLinkJpaDialect();

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public Map getJpaPropertyMap() {
        String targetDatabase;
        Properties jpaProperties = new Properties();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.setProperty("toplink.target-database", this.getDatabasePlatform());
        } else if (this.getDatabase() != null && (targetDatabase = this.determineTargetDatabaseName(this.getDatabase())) != null) {
            jpaProperties.setProperty("toplink.target-database", targetDatabase);
        }
        if (this.isGenerateDdl()) {
            jpaProperties.setProperty("toplink.ddl-generation", "create-tables");
            jpaProperties.setProperty("toplink.ddl-generation.output-mode", "database");
        }
        if (this.isShowSql()) {
            jpaProperties.setProperty("toplink.logging.level", Level.FINE.toString());
        }
        return jpaProperties;
    }

    protected String determineTargetDatabaseName(Database database) {
        switch (database) {
            case DB2: {
                return "DB2";
            }
            case HSQL: {
                return "HSQL";
            }
            case INFORMIX: {
                return "Informix";
            }
            case MYSQL: {
                return "MySQL4";
            }
            case ORACLE: {
                return "Oracle";
            }
            case POSTGRESQL: {
                return "PostgreSQL";
            }
            case SQL_SERVER: {
                return "SQLServer";
            }
            case SYBASE: {
                return "Sybase";
            }
        }
        return null;
    }

    public Class getEntityManagerInterface() {
        return EntityManager.class;
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }
}

