/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.connection;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARTimeUnit;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.connection.ApiProxyManagerI;
import com.bmc.arsys.apitransport.connection.ApiProxyManagerTask;
import com.bmc.arsys.apitransport.connection.ApiProxyPoolI;
import com.bmc.arsys.apitransport.connection.a;
import com.bmc.arsys.apitransport.connection.b;
import com.bmc.arsys.utils.ProcessUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class c
implements ApiProxyManagerI {
    private static final String if = "cmdbproxy";
    private static final String do = "_CMDB";
    protected static ApiProxyManagerI currentManager = null;
    private b for = new b();
    private static Logger char = Logger.getLogger(c.class);
    protected static boolean useConnectionPooling = Config.getInstance().isProxyPoolingOn();
    protected ConcurrentHashMap<String, ApiProxyPoolI> serverProxyPools;
    private static List<ApiUserContextI> new = Collections.synchronizedList(new ArrayList());
    ApiProxyManagerTask proxyCleanUpTask = null;
    private volatile long case;
    static final long cleanUpDelayMS = 100L;
    protected static volatile long connectionTimeout = Config.getInstance().getTimeUnit().toMillis(Config.getInstance().getConnectionTimeout());
    protected static volatile int idleConnectionsPerServer = Config.getInstance().getIdleConnectionsPerServer();
    protected static volatile int maxProxiesPerServer = Config.getInstance().getMaxProxiesPerServer();
    protected static long connectionLifespan = Config.getInstance().getTimeUnit().toMillis(Config.getInstance().getConnectionLifespan());
    private final ReentrantLock try = new ReentrantLock();
    private static long byte = 0L;
    private static final ReentrantLock a = new ReentrantLock();
    private static final ReentrantLock int = new ReentrantLock();

    public c() {
        this(useConnectionPooling);
    }

    public c(boolean bl) {
        char.trace("create new ProxyManager instance for proxyPoolingFlag : " + bl);
        useConnectionPooling = bl;
        this.serverProxyPools = new ConcurrentHashMap();
        this.case = System.currentTimeMillis();
        this.a();
    }

    public c(int n2, int n3, long l2, long l3, ARTimeUnit aRTimeUnit) {
        connectionTimeout = aRTimeUnit == null ? connectionTimeout : aRTimeUnit.toMillis(l2);
        connectionLifespan = aRTimeUnit == null ? l3 : aRTimeUnit.toMillis(l3);
        idleConnectionsPerServer = n3;
        maxProxiesPerServer = n2;
        this.serverProxyPools = new ConcurrentHashMap();
        this.case = System.currentTimeMillis();
        this.a();
    }

    @Override
    public ApiProxyI getProxy(ApiUserContextI apiUserContextI) throws ARException {
        if (apiUserContextI instanceof ApiUserContextBase && !((ApiUserContextBase)apiUserContextI).isProxyInMultiThreadTransaction()) {
            ((ApiUserContextBase)apiUserContextI).proxyILock.lock();
        }
        ApiProxyI apiProxyI = null;
        if (apiUserContextI.isProxyInContext() && !this.isCMDBCall(apiUserContextI)) {
            apiProxyI = apiUserContextI.getProxyI();
        } else if (this.isCMDBCall(apiUserContextI) && apiUserContextI.isCMDBProxyInContext()) {
            apiProxyI = apiUserContextI.getCMDBProxyI();
        } else {
            ApiProxyPoolI apiProxyPoolI = this.getServerPool(apiUserContextI);
            apiProxyI = apiProxyPoolI.get(apiUserContextI);
        }
        apiProxyI.setProxyProperties(apiUserContextI);
        return apiProxyI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void releaseProxy(ApiProxyI apiProxyI, ApiUserContextI apiUserContextI) {
        try {
            block17: {
                try {
                    if (apiProxyI == null) break block17;
                    boolean bl = c.isCMDBProxyName(apiProxyI.getClass().getName());
                    boolean bl2 = apiUserContextI.isCMDBProxyInContext();
                    boolean bl3 = apiUserContextI.isProxyInContext();
                    long l2 = c.getConnectionLifespanMilliSec();
                    long l3 = apiProxyI.getEstablishTime();
                    long l4 = System.currentTimeMillis();
                    long l5 = l4 - l3;
                    String string = null;
                    String string2 = null;
                    String string3 = "";
                    ApiProxyPoolI apiProxyPoolI = null;
                    if (c.isUseConnectionPooling()) {
                        apiProxyPoolI = this.getServerPool(apiUserContextI, apiProxyI);
                        apiProxyPoolI.setLastUsed(l4);
                        string3 = apiProxyPoolI.getPoolName();
                    }
                    if (char.isDebugEnabled()) {
                        string2 = apiProxyI.toString();
                        string = " for load balance after established for " + l5 + " (" + ProcessUtil.getElapsedTimeToFormatedString(l5) + ")";
                    }
                    if (c.isUseConnectionPooling() && (!bl3 && !bl || bl && !bl2)) {
                        apiProxyI.setLastUsed(l4);
                        if (l2 > 0L) {
                            apiProxyI = this.checkAndTerminateProxyIfNeededForLoadBalance(apiProxyPoolI, apiProxyI, apiUserContextI, l2);
                        }
                        if (apiProxyI != null && apiProxyPoolI != null) {
                            apiProxyPoolI.put(apiProxyI);
                            if (char.isTraceEnabled() && l2 > 0L) {
                                char.trace("checked " + string2 + " in pool " + string3);
                            }
                            break block17;
                        }
                        if (char.isDebugEnabled()) {
                            char.debug("terminated connection " + string2 + " for " + string3 + string);
                        }
                        break block17;
                    }
                    if (c.isUseConnectionPooling() || apiProxyI == null || !(apiProxyI instanceof a) || l2 <= 0L) break block17;
                    if (char.isInfoEnabled()) {
                        string3 = " for " + apiUserContextI.getContextInfoStr();
                    }
                    if (char.isInfoEnabled()) {
                        string2 = apiProxyI.toString();
                    }
                    if ((apiProxyI = this.checkAndTerminateProxyIfNeededForLoadBalance(null, apiProxyI, apiUserContextI, l2)) == null) {
                        if (bl3) {
                            apiUserContextI.setProxyI(apiProxyI);
                            if (char.isDebugEnabled()) {
                                char.debug("terminated an AR connection " + string2 + string3 + string);
                            }
                            break block17;
                        }
                        if (!bl) break block17;
                        apiUserContextI.setCMDBProxyI(apiProxyI);
                        if (char.isDebugEnabled()) {
                            char.debug("terminated an CMDB connection " + string2 + string3 + string);
                        }
                        break block17;
                    }
                    if (!char.isTraceEnabled()) break block17;
                    char.trace("kept " + string2 + string3);
                }
                catch (ARException aRException) {
                    char.debug("should not come here.");
                    Object var19_16 = null;
                    if (!(apiUserContextI instanceof ApiUserContextBase)) return;
                    int n4 = ((ApiUserContextBase)apiUserContextI).proxyILock.getHoldCount();
                    if (n4 <= 0) return;
                    ((ApiUserContextBase)apiUserContextI).proxyILock.unlock();
                    return;
                }
            }
            Object var19_15 = null;
            if (!(apiUserContextI instanceof ApiUserContextBase)) return;
            int n2 = ((ApiUserContextBase)apiUserContextI).proxyILock.getHoldCount();
            if (n2 <= 0) return;
            ((ApiUserContextBase)apiUserContextI).proxyILock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            if (!(apiUserContextI instanceof ApiUserContextBase)) throw throwable;
            int n3 = ((ApiUserContextBase)apiUserContextI).proxyILock.getHoldCount();
            if (n3 <= 0) throw throwable;
            ((ApiUserContextBase)apiUserContextI).proxyILock.unlock();
            throw throwable;
        }
    }

    protected void terminateProxy(ApiProxyI apiProxyI, ApiUserContextI apiUserContextI) {
        if (apiProxyI != null) {
            try {
                apiProxyI.ARTermination(null);
            }
            catch (ARException aRException) {
                char.debug(aRException.getLocalizedMessage());
            }
        }
    }

    public String getKeyForServer(ApiUserContextI apiUserContextI) {
        String string = apiUserContextI.getServer();
        int n2 = apiUserContextI.getPort();
        if (n2 != 0) {
            string = string + ":" + n2;
        }
        if (this.isCMDBCall(apiUserContextI)) {
            string = string + do;
        }
        return string;
    }

    protected boolean isCMDBCall(ApiUserContextI apiUserContextI) {
        String string = apiUserContextI.getProxyJrpcClazzName();
        return c.isCMDBProxyName(string);
    }

    public static boolean isCMDBProxyName(String string) {
        boolean bl = false;
        if (string != null && string.toLowerCase().contains(if)) {
            bl = true;
        }
        return bl;
    }

    protected String getKeyForServerNoPort(ApiUserContextI apiUserContextI) {
        return apiUserContextI.getServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void ageOutIdlePools() {
        block20: {
            if (!c.isUseConnectionPooling() || connectionTimeout <= 0L) {
                return;
            }
            ReentrantLock reentrantLock = this.try;
            if (!reentrantLock.tryLock()) break block20;
            HashSet<String> hashSet = new HashSet<String>();
            String string = null;
            String string2 = null;
            for (String string3 : this.serverProxyPools.keySet()) {
                ApiProxyPoolI apiProxyPoolI = this.serverProxyPools.get(string3);
                String string4 = apiProxyPoolI.getPoolName();
                long l2 = this.a(string4, apiProxyPoolI);
                long l3 = System.currentTimeMillis();
                long l4 = l3 - l2;
                if (char.isDebugEnabled()) {
                    string2 = " been idle " + l4 + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(l4) + ")";
                }
                if (idleConnectionsPerServer == 0 && connectionTimeout > 0L && l4 > connectionTimeout) {
                    hashSet.add(string3);
                    if (char.isDebugEnabled()) {
                        string = " time out after " + string2;
                        char.debug("Pool " + string3 + string);
                    }
                    if (apiProxyPoolI instanceof a) {
                        ((a)apiProxyPoolI).interruptIdleWorkers();
                        continue;
                    }
                    apiProxyPoolI.clear();
                    continue;
                }
                if (connectionTimeout <= 0L) continue;
                ((a)apiProxyPoolI).ageOutIdleProxy();
            }
            Object var16_12 = null;
            try {
                block17: {
                    try {
                        if (hashSet.size() <= 0) break block17;
                        int n2 = this.serverProxyPools.size();
                        for (String string5 : hashSet) {
                            this.serverProxyPools.remove(string5);
                            char.debug("removed inactive pool " + string5);
                        }
                        if (!char.isTraceEnabled()) break block17;
                        String string6 = "internal Ps count reduced from " + n2 + " to " + this.serverProxyPools.size() + "(It is normal if this internal number is bigger than Midtier displays, such as double the ones with port.)";
                        char.trace(string6);
                    }
                    catch (Throwable throwable) {
                        char.trace(throwable.getLocalizedMessage());
                        Object var21_23 = null;
                        reentrantLock.unlock();
                    }
                }
                Object var21_22 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var21_24 = null;
                reentrantLock.unlock();
                throw throwable;
            }
            catch (Throwable throwable) {
                Object var16_13 = null;
                try {
                    block18: {
                        try {
                            if (hashSet.size() <= 0) break block18;
                            int n3 = this.serverProxyPools.size();
                            for (String string7 : hashSet) {
                                this.serverProxyPools.remove(string7);
                                char.debug("removed inactive pool " + string7);
                            }
                            if (!char.isTraceEnabled()) break block18;
                            String string8 = "internal Ps count reduced from " + n3 + " to " + this.serverProxyPools.size() + "(It is normal if this internal number is bigger than Midtier displays, such as double the ones with port.)";
                            char.trace(string8);
                        }
                        catch (Throwable throwable2) {
                            char.trace(throwable2.getLocalizedMessage());
                            Object var21_26 = null;
                            reentrantLock.unlock();
                        }
                    }
                    Object var21_25 = null;
                    reentrantLock.unlock();
                }
                catch (Throwable throwable3) {
                    Object var21_27 = null;
                    reentrantLock.unlock();
                    throw throwable3;
                }
                throw throwable;
            }
        }
        if (char.isTraceEnabled()) {
            char.trace("Skip. all pools are busy this time");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycleConnectionForInactiveARServerUser() {
        if (c.isUseConnectionPooling() || connectionLifespan <= 0L) {
            return;
        }
        if (connectionLifespan > 0L) {
            int n2 = new.size();
            if (char.isTraceEnabled()) {
                char.trace("InactiveARServerUser none pooling connection recycle evaluating among " + n2 + " ARServerUser instances.");
            }
            int.lock();
            try {
                for (ApiUserContextI apiUserContextI : new) {
                    int n3;
                    Object var11_8;
                    if (!(apiUserContextI instanceof ApiUserContextBase) || ((ApiUserContextBase)apiUserContextI).isProxyInMultiThreadTransaction() || !((ApiUserContextBase)apiUserContextI).proxyILock.tryLock()) continue;
                    try {
                        long l2;
                        ApiProxyI apiProxyI;
                        String string = null;
                        if (char.isDebugEnabled()) {
                            string = apiUserContextI.getContextInfoStr();
                        }
                        long l3 = System.currentTimeMillis();
                        if (apiUserContextI.isProxyInContext()) {
                            apiProxyI = apiUserContextI.getProxyI();
                            l2 = l3 - apiProxyI.getEstablishTime();
                            if (this.a(apiProxyI) && this.isProxyNeedToRebalanced(apiProxyI, connectionLifespan)) {
                                if (char.isDebugEnabled()) {
                                    char.debug("recycle an AR connection " + apiProxyI + " for " + string + " after established for " + l2 + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(l2) + ")");
                                }
                                this.terminateProxy(apiProxyI, apiUserContextI);
                                apiUserContextI.setProxyI(null);
                            }
                        }
                        if (apiUserContextI.isCMDBProxyInContext()) {
                            apiProxyI = apiUserContextI.getCMDBProxyI();
                            l2 = l3 - apiProxyI.getEstablishTime();
                            if (this.a(apiProxyI) && this.isProxyNeedToRebalanced(apiProxyI, connectionLifespan)) {
                                if (char.isDebugEnabled()) {
                                    char.debug("recycle an CMDB connection " + apiProxyI + " for " + string + " after established for " + l2 + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(l2) + ")");
                                }
                                this.terminateProxy(apiProxyI, apiUserContextI);
                                apiUserContextI.setCMDBProxyI(null);
                            }
                        }
                        var11_8 = null;
                        n3 = ((ApiUserContextBase)apiUserContextI).proxyILock.getHoldCount();
                        if (n3 <= 0) continue;
                        ((ApiUserContextBase)apiUserContextI).proxyILock.unlock();
                    }
                    catch (Throwable throwable) {
                        var11_8 = null;
                        n3 = ((ApiUserContextBase)apiUserContextI).proxyILock.getHoldCount();
                        if (n3 > 0) {
                            ((ApiUserContextBase)apiUserContextI).proxyILock.unlock();
                        }
                        throw throwable;
                    }
                }
                Object var14_11 = null;
                if (int.getHoldCount() > 0) {
                    int.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (int.getHoldCount() > 0) {
                    int.unlock();
                }
                throw throwable;
            }
        }
    }

    private boolean a(ApiProxyI apiProxyI) {
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        if (!c.isUseConnectionPooling() && connectionLifespan > 0L && l2 - apiProxyI.getLastUsed() > connectionLifespan) {
            bl = true;
        }
        return bl;
    }

    protected ApiProxyI checkAndTerminateProxyIfNeededForLoadBalance(ApiProxyPoolI apiProxyPoolI, ApiProxyI apiProxyI, ApiUserContextI apiUserContextI, long l2) {
        if (l2 <= 0L || apiUserContextI instanceof ApiUserContextBase && ((ApiUserContextBase)apiUserContextI).isProxyInMultiThreadTransaction()) {
            return apiProxyI;
        }
        if (this.isProxyNeedToRebalanced(apiProxyI, l2)) {
            if (char.isDebugEnabled()) {
                long l3 = System.currentTimeMillis();
                char.debug("an connection " + apiProxyI + " for " + apiUserContextI.getContextInfoStr() + " will be terminated for load_balance after established for " + (l3 - apiProxyI.getEstablishTime()) + " ms (" + ProcessUtil.getElapsedTimeToFormatedString(l3 - apiProxyI.getEstablishTime()) + ")");
            }
            if (apiProxyPoolI != null) {
                this.deRecodeProxy(apiProxyPoolI, apiProxyI);
            }
            this.terminateProxy(apiProxyI, apiUserContextI);
            apiProxyI = null;
        }
        return apiProxyI;
    }

    public void deRecodeProxy(ApiProxyPoolI apiProxyPoolI, ApiProxyI apiProxyI) {
        if (char.isDebugEnabled()) {
            char.debug("will deRecodeProxy " + apiProxyI + " in pool " + apiProxyPoolI.getPoolName());
        }
        ((a)apiProxyPoolI).deRecodeProxy(apiProxyI);
        if (char.isDebugEnabled()) {
            char.debug("done deRecodeProxy " + apiProxyI + " from pool " + apiProxyPoolI.getPoolName() + ". Will terminate the proxy ");
        }
    }

    protected boolean isProxyNeedToRebalanced(ApiProxyI apiProxyI, long l2) {
        boolean bl = false;
        if (apiProxyI != null) {
            long l3 = System.currentTimeMillis();
            long l4 = l3 - apiProxyI.getEstablishTime();
            if (l2 > 0L && l4 > l2) {
                if (char.isTraceEnabled()) {
                    char.trace(apiProxyI + " established= " + l4 + " millisec; connectionLifespan= " + l2 + " millisec");
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long a(String string, ApiProxyPoolI apiProxyPoolI) {
        ReentrantLock reentrantLock;
        long l2 = apiProxyPoolI.getLastUsed();
        if (string.contains(":") && (reentrantLock = this.try).tryLock()) {
            try {
                for (ApiProxyPoolI apiProxyPoolI2 : this.serverProxyPools.values()) {
                    if (!string.equals(apiProxyPoolI2.getPoolName()) || apiProxyPoolI2.getLastUsed() <= l2) continue;
                    char.trace("updating last used for pool " + string);
                    l2 = apiProxyPoolI2.getLastUsed();
                    apiProxyPoolI.setLastUsed(l2);
                }
                Object var9_7 = null;
                reentrantLock.unlock();
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                reentrantLock.unlock();
                throw throwable;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.try.lock();
        try {
            for (ApiProxyPoolI apiProxyPoolI : this.serverProxyPools.values()) {
                apiProxyPoolI.clear();
            }
            this.serverProxyPools.clear();
            Object var4_3 = null;
            this.try.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.try.unlock();
            throw throwable;
        }
    }

    protected ConcurrentHashMap<String, ApiProxyPoolI> getServerProxyPools() {
        return this.serverProxyPools;
    }

    protected void setServerProxyPools(ConcurrentHashMap<String, ApiProxyPoolI> concurrentHashMap) {
        this.serverProxyPools = concurrentHashMap;
    }

    private String a(ApiUserContextI apiUserContextI, ApiProxyI apiProxyI) {
        String string = this.getKeyForServer(apiUserContextI);
        if (apiProxyI != null) {
            boolean bl = string.contains(do);
            boolean bl2 = apiProxyI.getClass().getName().toLowerCase().contains(if);
            if (!bl && bl2) {
                string = string + do;
                if (char.isTraceEnabled()) {
                    char.trace(apiProxyI + " will be enforced to released to " + string);
                }
            } else if (bl && !bl2) {
                int n2 = string.indexOf(do);
                string = string.substring(0, n2);
                if (char.isTraceEnabled()) {
                    char.trace(apiProxyI + " will be enforced to released to " + string);
                }
            }
        }
        return string;
    }

    protected ApiProxyPoolI getServerPool(ApiUserContextI apiUserContextI) throws ARException {
        return this.getServerPool(apiUserContextI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApiProxyPoolI getServerPool(ApiUserContextI apiUserContextI, ApiProxyI apiProxyI) throws ARException {
        if (apiUserContextI.getServer() == null || apiUserContextI.getServer().length() == 0) {
            throw new ARException(2, 150);
        }
        String string = this.a(apiUserContextI, apiProxyI);
        ApiProxyPoolI apiProxyPoolI = this.serverProxyPools.get(string);
        try {
            if (apiProxyPoolI == null) {
                this.try.lock();
                try {
                    apiProxyPoolI = this.createNewPool(string, c.getMaxProxiesPerServer());
                    this.serverProxyPools.put(string, apiProxyPoolI);
                    string = this.getKeyForServerNoPort(apiUserContextI);
                    this.getServerProxyPools().put(string, apiProxyPoolI);
                    Object var6_5 = null;
                    this.try.unlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.try.unlock();
                    throw throwable;
                }
            }
            Object var8_8 = null;
            apiProxyPoolI.setLastUsed(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            apiProxyPoolI.setLastUsed(System.currentTimeMillis());
            throw throwable;
        }
        return apiProxyPoolI;
    }

    protected abstract ApiProxyPoolI createNewPool(String var1, int var2);

    @Override
    public abstract ApiProxyI createProxy(ApiUserContextI var1) throws ARException;

    protected static long getConnectionTimeout(ARTimeUnit aRTimeUnit) {
        return aRTimeUnit == null ? connectionTimeout : aRTimeUnit.convert(connectionTimeout, ARTimeUnit.MILLISECONDS);
    }

    public static int getMaxProxiesPerServer() {
        return maxProxiesPerServer;
    }

    public static int getIdleConnectionsPerServer() {
        return idleConnectionsPerServer;
    }

    public static long getConnectionTimeoutMilliSec() {
        return connectionTimeout;
    }

    public static long getConnectionLifespanMilliSec() {
        return connectionLifespan;
    }

    public static void setConnectionLifespan(long l2, ARTimeUnit aRTimeUnit) {
        connectionLifespan = aRTimeUnit == null ? l2 : aRTimeUnit.toMillis(l2);
        char.trace("set new connectionLifespan = " + connectionLifespan);
        if (currentManager != null) {
            ((c)currentManager).a();
        }
    }

    protected static boolean isUseConnectionPooling() {
        return useConnectionPooling;
    }

    protected long getLastCleaned() {
        return this.case;
    }

    protected void setLastCleaned(long l2) {
        char.trace("Pools cleaning ");
        this.case = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustProxyPoolVariables(int n2, int n3, long l2, ARTimeUnit aRTimeUnit) {
        this.try.lock();
        try {
            maxProxiesPerServer = n2;
            idleConnectionsPerServer = n3;
            connectionTimeout = aRTimeUnit == null ? l2 : aRTimeUnit.toMillis(l2);
            for (a a2 : this.serverProxyPools.values()) {
                a2.adjustPoolParameters(n2, n3);
            }
            Object var9_7 = null;
            this.try.unlock();
            this.a();
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.try.unlock();
            this.a();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        long l2 = ApiProxyManagerTask.caculateTimePeriod();
        if (char.isTraceEnabled()) {
            char.trace("evaluating cleanUp timer newPeriod = " + l2 + " milliSec; prevPeriod = " + byte + " milliSec");
        }
        if (l2 != byte) {
            a.lock();
            if (l2 != byte) {
                try {
                    if (this.proxyCleanUpTask != null) {
                        if (this.proxyCleanUpTask.cleanUpTimer != null) {
                            this.proxyCleanUpTask.cleanUpTimer.cancel();
                            this.proxyCleanUpTask.cleanUpTimer = null;
                        }
                        this.proxyCleanUpTask.cancel();
                        this.proxyCleanUpTask = null;
                        char.info("cleanUp timer canceled previous task for connection pooling: " + c.isUseConnectionPooling());
                    }
                    if (l2 > 0L) {
                        long l3 = 0L;
                        this.proxyCleanUpTask = new ApiProxyManagerTask();
                        char.info("set timer period " + l2 + " milliSec (" + ProcessUtil.getElapsedTimeToFormatedString(l2) + ")");
                        this.proxyCleanUpTask.cleanUpTimer.scheduleAtFixedRate((TimerTask)this.proxyCleanUpTask, l3, l2);
                    }
                    byte = l2;
                    Object var6_3 = null;
                    if (a.getHoldCount() > 0) {
                        a.unlock();
                    }
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    if (a.getHoldCount() > 0) {
                        a.unlock();
                    }
                    throw throwable;
                }
            }
        }
    }

    protected b getProxyFactory() {
        return this.for;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerARServerUserCheck(ApiUserContextI apiUserContextI) {
        if (!new.contains(apiUserContextI)) {
            int.lock();
            try {
                if (!new.contains(apiUserContextI)) {
                    new.add(apiUserContextI);
                    if (char.isTraceEnabled()) {
                        char.trace(apiUserContextI.getContextInfoStr() + " is registered. total registered: " + new.size());
                    }
                }
                Object var2_1 = null;
                if (int.getHoldCount() > 0) {
                    int.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (int.getHoldCount() > 0) {
                    int.unlock();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deRegisterARServerUser(ApiUserContextI apiUserContextI) {
        if (new.contains(apiUserContextI)) {
            int.lock();
            try {
                if (new.contains(apiUserContextI)) {
                    new.remove(apiUserContextI);
                    if (char.isTraceEnabled()) {
                        char.trace(apiUserContextI.getContextInfoStr() + " is deregistered. total registered: " + new.size());
                    }
                }
                Object var2_1 = null;
                if (int.getHoldCount() > 0) {
                    int.unlock();
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (int.getHoldCount() > 0) {
                    int.unlock();
                }
                throw throwable;
            }
        }
    }

    public static long getConnectionLifespan(ARTimeUnit aRTimeUnit) {
        return aRTimeUnit == null ? connectionLifespan : aRTimeUnit.convert(connectionLifespan, ARTimeUnit.MILLISECONDS);
    }

    void loadBalanceForInactiveProxyInPool() {
        if (!c.isUseConnectionPooling() || connectionLifespan <= 0L) {
            return;
        }
        for (String string : this.serverProxyPools.keySet()) {
            ApiProxyPoolI apiProxyPoolI = this.serverProxyPools.get(string);
            if (!(apiProxyPoolI instanceof a)) continue;
            ((a)apiProxyPoolI).terminateProxyForLoadBalancer();
        }
    }

    public void deRecodeProxy(ApiUserContextI apiUserContextI, ApiProxyI apiProxyI) {
        if (ProxyManager.isUseConnectionPooling()) {
            try {
                ApiProxyPoolI apiProxyPoolI = this.getServerPool(apiUserContextI);
                if (apiProxyPoolI != null && apiProxyPoolI instanceof a) {
                    ((a)apiProxyPoolI).deRecodeProxy(apiProxyI);
                }
            }
            catch (Exception exception) {
                char.trace("not able to de-recode proxy " + apiProxyI + " " + exception.getLocalizedMessage());
            }
        }
    }
}

