/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronization;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import java.util.Iterator;
import java.util.List;

public abstract class TransactionSynchronizationUtils {
    private static final Log logger = LogFactory.getLog(class$org$springframework$transaction$support$TransactionSynchronizationUtils == null ? (class$org$springframework$transaction$support$TransactionSynchronizationUtils = TransactionSynchronizationUtils.class$("com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationUtils")) : class$org$springframework$transaction$support$TransactionSynchronizationUtils);
    static /* synthetic */ Class class$org$springframework$transaction$support$TransactionSynchronizationUtils;

    public static void triggerBeforeCommit(boolean readOnly) {
        Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
        while (it.hasNext()) {
            TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
            synchronization.beforeCommit(readOnly);
        }
    }

    public static void triggerBeforeCompletion() {
        Iterator it = TransactionSynchronizationManager.getSynchronizations().iterator();
        while (it.hasNext()) {
            TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
            try {
                synchronization.beforeCompletion();
            }
            catch (Throwable tsex) {
                logger.error("TransactionSynchronization.beforeCompletion threw exception", tsex);
            }
        }
    }

    public static void triggerAfterCommit() {
        List synchronizations = TransactionSynchronizationManager.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCommit(synchronizations);
    }

    public static void invokeAfterCommit(List synchronizations) {
        if (synchronizations != null) {
            Iterator it = synchronizations.iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                try {
                    synchronization.afterCommit();
                }
                catch (AbstractMethodError tserr) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Spring 2.0's TransactionSynchronization.afterCommit method not implemented in synchronization class [" + synchronization.getClass().getName() + "]", tserr);
                }
            }
        }
    }

    public static void triggerAfterCompletion(int completionStatus) {
        List synchronizations = TransactionSynchronizationManager.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCompletion(synchronizations, completionStatus);
    }

    public static void invokeAfterCompletion(List synchronizations, int completionStatus) {
        if (synchronizations != null) {
            Iterator it = synchronizations.iterator();
            while (it.hasNext()) {
                TransactionSynchronization synchronization = (TransactionSynchronization)it.next();
                try {
                    synchronization.afterCompletion(completionStatus);
                }
                catch (Throwable tsex) {
                    logger.error("TransactionSynchronization.afterCompletion threw exception", tsex);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

