/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.mail.javamail;

import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.core.io.ClassPathResource;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import java.io.File;
import java.io.IOException;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;

public class ConfigurableMimeFileTypeMap
extends FileTypeMap
implements InitializingBean {
    private Resource mappingLocation = new ClassPathResource("mime.types", this.getClass());
    private String[] mappings;
    private FileTypeMap fileTypeMap;

    public void setMappingLocation(Resource mappingLocation) {
        this.mappingLocation = mappingLocation;
    }

    public void setMappings(String[] mappings) {
        this.mappings = mappings;
    }

    public void afterPropertiesSet() {
        this.getFileTypeMap();
    }

    protected final FileTypeMap getFileTypeMap() {
        if (this.fileTypeMap == null) {
            try {
                this.fileTypeMap = this.createFileTypeMap(this.mappingLocation, this.mappings);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not load specified MIME type mapping file: " + this.mappingLocation);
            }
        }
        return this.fileTypeMap;
    }

    protected FileTypeMap createFileTypeMap(Resource mappingLocation, String[] mappings) throws IOException {
        MimetypesFileTypeMap fileTypeMap;
        MimetypesFileTypeMap mimetypesFileTypeMap = fileTypeMap = mappingLocation != null ? new MimetypesFileTypeMap(mappingLocation.getInputStream()) : new MimetypesFileTypeMap();
        if (mappings != null) {
            for (int i2 = 0; i2 < mappings.length; ++i2) {
                fileTypeMap.addMimeTypes(mappings[i2]);
            }
        }
        return fileTypeMap;
    }

    public String getContentType(File file) {
        return this.getFileTypeMap().getContentType(file);
    }

    public String getContentType(String fileName) {
        return this.getFileTypeMap().getContentType(fileName);
    }
}

