/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DefaultProxyManager;
import com.bmc.arsys.api.PoolingProxyManager;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiProxyJRpcBase;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.session.ARServerContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ProxyManager {
    private static int maxProxiesPerServer = Config.getInstance().getMaxProxiesPerServer();
    private static boolean int = true;
    private static ProxyManager for = null;
    protected static final ReentrantLock lock = new ReentrantLock();
    private static Map<String, ARServerContext> a = new Hashtable<String, ARServerContext>();
    private static Map<String, Class<? extends ApiProxyI>> if = new Hashtable<String, Class<? extends ApiProxyI>>();
    private static Logger do = Logger.getLogger(ProxyManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyManager getProxyManager() {
        if (for == null) {
            lock.lock();
            try {
                if (for == null) {
                    for = ProxyManager.isUseConnectionPooling() ? new PoolingProxyManager(maxProxiesPerServer) : new DefaultProxyManager();
                }
                Object var1 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var1_1 = null;
                lock.unlock();
                throw throwable;
            }
        }
        return for;
    }

    public static void setConnectionLimits(int n2) {
        maxProxiesPerServer = n2;
        do.info("Client sets connection limits per server to :" + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUseConnectionPooling(boolean bl) {
        do.info("Client sets useConnectionPooling to : " + bl);
        if (int == bl) {
            return;
        }
        if (for != null) {
            do.debug("ProxyManager before lock for setUseConnectionPooling usePooling = " + bl + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            lock.lock();
            do.debug("ProxyManager setUseConnectionPooling usePooling = " + bl + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            try {
                int = bl;
                for.clear();
                for = null;
                for = ProxyManager.getProxyManager();
                Object var2_1 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                lock.unlock();
                throw throwable;
            }
        } else {
            do.debug("ProxyManager directly setUseConnectionPooling usePooling = " + bl + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
            int = bl;
        }
    }

    public static boolean isUseConnectionPooling() {
        return int;
    }

    public static PoolInfo[] getPoolInformation() {
        return for.getInfo();
    }

    synchronized PoolInfo[] getInfo() {
        return new PoolInfo[0];
    }

    public abstract ApiProxyI getProxy(ApiUserContextI var1) throws ARException;

    public abstract void releaseProxy(ApiProxyI var1, ApiUserContextI var2);

    synchronized void clear() {
    }

    protected ApiProxyI createProxy(ApiUserContextI apiUserContextI) throws ARException {
        List<StatusInfo> list;
        ARException aRException;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connects to ARServer ").append(apiUserContextI.getServer()).append(" through ");
        ApiProxyI apiProxyI = null;
        if (!this.a(apiUserContextI.getPort())) {
            throw new ARException(2, 8202, " server : " + apiUserContextI.getServer() + "; port : " + apiUserContextI.getPort());
        }
        try {
            if (apiUserContextI.getApiConfig().getJrpcMode()) {
                apiProxyI = this.a(apiUserContextI.getProxyJrpcClazzName(), apiUserContextI);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof ARException) {
                aRException = (ARException)invocationTargetException.getCause();
                stringBuilder.append("Java Rpc failed with: ").append(aRException);
                do.error(stringBuilder.toString());
                list = aRException.getLastStatus();
                if (list.size() > 0 && list.get(0).getMessageNum() == 8203L) {
                    do.error("Will retry Jni");
                }
                apiUserContextI.setLastStatus(list);
                throw aRException;
            }
            throw new RuntimeException(invocationTargetException);
        }
        try {
            if (null == apiProxyI) {
                apiProxyI = this.a(apiUserContextI.getProxyClazzName(), apiUserContextI);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof ARException) {
                aRException = (ARException)invocationTargetException.getCause();
                stringBuilder.append("Java Rpc failed with: ").append(aRException);
                do.error(stringBuilder.toString());
                list = aRException.getLastStatus();
                apiUserContextI.setLastStatus(list);
                throw aRException;
            }
            throw new RuntimeException(invocationTargetException);
        }
        return apiProxyI;
    }

    private boolean a(int n2) {
        return n2 == 0 || n2 >= 1 && n2 <= 65535;
    }

    public static Map<String, ARServerContext> getServerContextMap() {
        return a;
    }

    public static ARServerContext getARServerContext(String string, int n2) {
        String string2 = string + ":" + n2;
        return a.get(string2);
    }

    private ApiProxyI a(String string, ApiUserContextI apiUserContextI) throws InvocationTargetException, ARException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Connects to ARServer ").append(apiUserContextI.getServer()).append(" through ");
        ApiProxyI apiProxyI = null;
        if (null == string) {
            stringBuilder.append("Proxy/ProxyJRpc class name should be provided.");
            do.error(stringBuilder);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        try {
            Class<Object> clazz = null;
            if (if.containsKey(string)) {
                clazz = if.get(string);
            } else {
                clazz = Class.forName(string);
                if.put(string, clazz);
            }
            if (ApiProxyJRpcBase.class.isAssignableFrom(clazz)) {
                Constructor<Object> constructor = clazz.getDeclaredConstructor(ApiUserContextI.class);
                apiProxyI = (ApiProxyI)constructor.newInstance(apiUserContextI);
            } else if (ApiProxyI.class.isAssignableFrom(clazz)) {
                Constructor<Object> constructor = clazz.getDeclaredConstructor(Boolean.TYPE);
                apiProxyI = (ApiProxyI)constructor.newInstance(true);
            } else {
                stringBuilder.append(string).append(" is not valid Proxy/ProxyJRpc class.");
                do.error(stringBuilder);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            stringBuilder.append(apiProxyI);
            do.info(stringBuilder.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            stringBuilder.append("RPC call failed. Cause : Class '").append(string).append("' not found.");
            do.error(stringBuilder.toString());
            throw new RuntimeException(stringBuilder.toString());
        }
        catch (SecurityException securityException) {
            stringBuilder.append("RPC call failed. Cause : '").append(securityException);
            do.error(stringBuilder.toString());
            throw new RuntimeException(stringBuilder.toString());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            stringBuilder.append("RPC call failed. Cause : '").append(string).append("' is not a valid ApiProxyI class.");
            do.error(stringBuilder.toString());
            throw new RuntimeException(stringBuilder.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuilder.append("RPC call failed. Cause : '").append(string).append("' is not a valid ApiProxyI class.");
            do.error(stringBuilder.toString());
            throw new RuntimeException(stringBuilder.toString());
        }
        catch (InstantiationException instantiationException) {
            stringBuilder.append("RPC call failed. Cause : '").append(string).append("' is not a valid ApiProxyI class.");
            do.error(stringBuilder.toString());
            throw new RuntimeException(stringBuilder.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            stringBuilder.append("RPC call failed. Cause : '").append(illegalAccessException);
            do.error(stringBuilder.toString());
            throw new RuntimeException(stringBuilder.toString());
        }
        return apiProxyI;
    }

    public static class PoolInfo {
        protected String mServerKey;
        protected int mFree;
        protected int mInUse;
        protected int mNotCreated;

        PoolInfo(String string, int n2, int n3, int n4) {
            this.mServerKey = string;
            this.mInUse = n2;
            this.mFree = n3;
            this.mNotCreated = n4;
        }

        public String getServerName() {
            return this.mServerKey;
        }

        public int getInUse() {
            return this.mInUse;
        }

        public int getFree() {
            return this.mFree;
        }

        public int getNotCreated() {
            return this.mNotCreated;
        }
    }
}

