/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.encrypt;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.arxdrenc.ArXdrEncryptRPCSvrToCnt;
import com.bmc.arsys.apitransport.arxdrenc.ArXdrUnXdrBufferStream;
import com.bmc.arsys.arencrypt.ARDataKey;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.arencrypt.ARPublicPrivateKeyPair;
import com.bmc.arsys.arencrypt.KeyExchangeEncryption;
import com.bmc.arsys.arencrypt.NetWorkDataKeyInfo;
import com.bmc.arsys.arencrypt.NetworkDataEncryption;
import com.bmc.arsys.arencrypt.PasswordEncryption;
import com.bmc.arsys.arrpc.ArEncryptRPCCntToSvr;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARPluginSvrRemoteHostInfo;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.encrypt.AREncryptAPISessionNode;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrBufferDecodingStream;
import org.acplt.oncrpc.XdrDecodingStream;
import org.apache.log4j.Logger;

public class ARPluginServerEncryptionInfo
extends ARPluginSvrRemoteHostInfo {
    private static Logger log = Logger.getLogger(ARPluginServerEncryptionInfo.class);
    private int mDataEncryptionKeyExpiry;
    private int mPublicKeyExpiry;
    private int mEncryptionSecurityPolicy;
    private int mDataEncryptionAlgorithm;
    private int mPublicKeyAlgorithm;
    private int mNumEncSessionHashentries;
    private transient ARPublicPrivateKeyPair mKeypair;
    private Map<Integer, AREncryptAPISessionNode> mMapSessionNodes;
    private static ARPluginServerEncryptionInfo theInstance;
    private static final transient String PLUGIN_USER = "Plug-in Server";
    private static final transient String ARPLUGIN_A = "Plug-in";
    private static final transient String ARPLUGIN_B = "Alert";
    private static final transient String ARPLUGIN_C = "$";
    private static final transient String ARPLUGIN_D = "Msg";
    private static final int PASSWORD_CHAR_SIZE = 30;
    public static final transient int PASSWORD_CHAR_ENCRYPTED_SIZE = 120;

    private ARPluginServerEncryptionInfo() throws ARException {
        log.debug((Object)"Constructor ARPluginServerEncryptionInfo");
        this.mDataEncryptionKeyExpiry = ARPluginServerConfiguration.getInstance().getDataEncryptionKeyExpiry();
        this.mPublicKeyExpiry = ARPluginServerConfiguration.getInstance().getPublicKeyExpiry();
        this.mEncryptionSecurityPolicy = ARPluginServerConfiguration.getInstance().getEncryptionSecurityPolicy();
        this.mDataEncryptionAlgorithm = ARPluginServerConfiguration.getInstance().getDataEncryptionAlgorithm();
        this.mPublicKeyAlgorithm = ARPluginServerConfiguration.getInstance().getPublicKeyAlgorithm();
        this.mMapSessionNodes = new ConcurrentHashMap<Integer, AREncryptAPISessionNode>();
        try {
            this.mKeypair = new ARPublicPrivateKeyPair(this.mPublicKeyAlgorithm, this.mPublicKeyExpiry);
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(8786), (Throwable)exception);
            throw new ARException(2, 8786);
        }
    }

    public static synchronized void initialize() throws ARException {
        if (theInstance == null) {
            theInstance = new ARPluginServerEncryptionInfo();
        }
    }

    public static ARPluginServerEncryptionInfo getInstance() throws ARException {
        return theInstance;
    }

    public int getDataEncryptionKeyExpiry() {
        return this.mDataEncryptionKeyExpiry;
    }

    public int getPublicKeyExpiry() {
        return this.mPublicKeyExpiry;
    }

    public int getEncryptionSecurityPolicy() {
        return this.mEncryptionSecurityPolicy;
    }

    public boolean disableAllEncryption() {
        boolean bl = false;
        String string = System.getProperty("os.arch");
        if (string != null && string.equals("sparc") && this.mEncryptionSecurityPolicy == 2) {
            bl = true;
        }
        return bl;
    }

    public int getDataEncryptionAlgorithm() {
        return this.mDataEncryptionAlgorithm;
    }

    public int getPublicKeyAlgorithm() {
        return this.mPublicKeyAlgorithm;
    }

    public int getNumEncSessionHashentries() {
        return this.mNumEncSessionHashentries;
    }

    public PrivateKey getPrivateKey() throws ARException {
        log.info((Object)"getPrivateKey");
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            try {
                return this.mKeypair.getPrivateKey();
            }
            catch (AREncryptionException aREncryptionException) {
                log.error((Object)CatalogReader.getInstance().getMessage(8787), (Throwable)aREncryptionException);
                throw new ARException(2, 8787, aREncryptionException.getLocalizedMessage());
            }
        }
    }

    public PublicKey getPublicKey() throws ARException {
        log.info((Object)"getPublicKey");
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            try {
                return this.mKeypair.getPublicKey();
            }
            catch (AREncryptionException aREncryptionException) {
                log.error((Object)CatalogReader.getInstance().getMessage(8788), (Throwable)aREncryptionException);
                throw new ARException(2, 8788);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastCreateTime() {
        Date date;
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            date = this.mKeypair.getLastCreateTime();
        }
        return date;
    }

    public byte[] getPublicKeyBytes() throws ARException {
        log.info((Object)"getPublicKeyBytes");
        ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
        synchronized (aRPublicPrivateKeyPair) {
            try {
                return this.mKeypair.getPublicKeyBytes();
            }
            catch (AREncryptionException aREncryptionException) {
                log.error((Object)CatalogReader.getInstance().getMessage(8788), (Throwable)aREncryptionException);
                throw new ARException(2, 8788);
            }
        }
    }

    public static byte[] generateRandomBytes() {
        return StringByteUtil.generateRandomBytes((int)20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createAndInsertSessionNode(byte[] byArray, byte[] byArray2) {
        log.info((Object)"createAndInsertSessionNode");
        AREncryptAPISessionNode aREncryptAPISessionNode = new AREncryptAPISessionNode(this.mDataEncryptionAlgorithm, byArray, byArray2);
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            this.mMapSessionNodes.put(aREncryptAPISessionNode.getSessionId(), aREncryptAPISessionNode);
        }
        return aREncryptAPISessionNode.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unxdrAndDecryptPreMasterkey(int n, byte[] byArray) throws ARException {
        log.info((Object)"unxdrAndDecryptPreMasterkey");
        byte[] byArray2 = null;
        try {
            byte[] byArray3;
            AREncryptAPISessionNode aREncryptAPISessionNode = this.getSessionNode(n);
            log.debug((Object)("KeyExchange Create new encryption session node for sessionId: " + n));
            if (aREncryptAPISessionNode != null) {
                ARPublicPrivateKeyPair aRPublicPrivateKeyPair = this.mKeypair;
                synchronized (aRPublicPrivateKeyPair) {
                    KeyExchangeEncryption keyExchangeEncryption = new KeyExchangeEncryption((ARPPKey)this.mKeypair);
                    byArray3 = keyExchangeEncryption.decrypt(byArray, (Key)this.mKeypair.getPrivateKey());
                }
            } else {
                throw new ARException(2, 9002);
            }
            byArray2 = ArXdrUnXdrBufferStream.unXdrBytes((byte[])byArray3);
            aREncryptAPISessionNode.setPreMasterKey(byArray2);
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)exception);
            throw new ARException(2, 9002);
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AREncryptAPISessionNode getSessionNode(int n) {
        AREncryptAPISessionNode aREncryptAPISessionNode;
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            aREncryptAPISessionNode = this.mMapSessionNodes.get(n);
        }
        return aREncryptAPISessionNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionNode(int n) {
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            this.mMapSessionNodes.remove(n);
        }
    }

    public void generateServerAndClientDataKey(int n, byte[] byArray) throws ARException {
        log.info((Object)"generateServerAndClientDataKey");
        try {
            AREncryptAPISessionNode aREncryptAPISessionNode = this.getSessionNode(n);
            if (aREncryptAPISessionNode == null) {
                log.error((Object)CatalogReader.getInstance().getMessage(9002));
                throw new ARException(2, 9002);
            }
            NetWorkDataKeyInfo netWorkDataKeyInfo = new NetWorkDataKeyInfo();
            netWorkDataKeyInfo.setEncAlgorithmParam(this.mDataEncryptionAlgorithm);
            netWorkDataKeyInfo.genDataEncKeys(aREncryptAPISessionNode.getEncTransferObject());
            aREncryptAPISessionNode.setServerClientDataKey(netWorkDataKeyInfo);
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)exception);
            throw new ARException(2, 9002);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CleanUpTimedoutSessions() {
        log.info((Object)"CleanUpTimedoutSessions");
        Map<Integer, AREncryptAPISessionNode> map = this.mMapSessionNodes;
        synchronized (map) {
            Set<Integer> set = this.mMapSessionNodes.keySet();
            if (set.size() > 0) {
                for (Integer n : set) {
                    AREncryptAPISessionNode aREncryptAPISessionNode = this.mMapSessionNodes.get(n);
                    if (aREncryptAPISessionNode == null || System.currentTimeMillis() <= aREncryptAPISessionNode.getCreateTime() + (long)this.mDataEncryptionKeyExpiry && aREncryptAPISessionNode.getEncryptionAlgorithm() == this.mDataEncryptionAlgorithm) continue;
                    this.mMapSessionNodes.remove(n);
                }
            }
        }
    }

    public byte[] XdrAndEncryptSessionId(int n) throws ARException {
        byte[] byArray;
        block4: {
            log.info((Object)("XdrAndEncryptSessionId: " + n));
            byArray = null;
            try {
                AREncryptAPISessionNode aREncryptAPISessionNode = this.getSessionNode(n);
                if (aREncryptAPISessionNode != null) {
                    byte[] byArray2 = ArXdrUnXdrBufferStream.xdrInt((int)n);
                    ARDataKey aRDataKey = aREncryptAPISessionNode.getServerDataKey();
                    if (aRDataKey != null) {
                        NetworkDataEncryption networkDataEncryption = new NetworkDataEncryption(false, false);
                        byArray = networkDataEncryption.encryptData(aRDataKey, byArray2);
                    }
                    break block4;
                }
                log.error((Object)CatalogReader.getInstance().getMessage(9002));
                throw new ARException(2, 9002);
            }
            catch (Exception exception) {
                log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)exception);
                throw new ARException(2, 9002);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XdrAble encryptAndXdrData(int n, byte[] byArray) throws OncRpcException {
        log.debug((Object)"encryptAndXdrData");
        NetworkDataEncryption networkDataEncryption = new NetworkDataEncryption(false, false);
        try {
            AREncryptAPISessionNode aREncryptAPISessionNode = this.getSessionNode(n);
            if (aREncryptAPISessionNode != null) {
                byte[] byArray2;
                int n2 = 0;
                AREncryptAPISessionNode aREncryptAPISessionNode2 = aREncryptAPISessionNode;
                synchronized (aREncryptAPISessionNode2) {
                    ARDataKey aRDataKey = aREncryptAPISessionNode.getServerDataKey();
                    byArray2 = networkDataEncryption.encryptData(aRDataKey, byArray);
                }
                aREncryptAPISessionNode2 = new ArXdrEncryptRPCSvrToCnt(new byte[0], 0);
                aREncryptAPISessionNode2.setOut(byArray2);
                aREncryptAPISessionNode2.setErrorCode(n2);
                return aREncryptAPISessionNode2;
            }
            log.error((Object)"Encryption info not found for the API session. Key Exchange required.");
            throw new OncRpcAuthenticationException(2);
        }
        catch (OncRpcAuthenticationException oncRpcAuthenticationException) {
            throw oncRpcAuthenticationException;
        }
        catch (Throwable throwable) {
            log.error((Object)CatalogReader.getInstance().getMessage(8784), throwable);
            throw new OncRpcException(1, throwable, throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unXdrAndDecryptData(byte[] byArray, ArEncryptionContext arEncryptionContext) throws OncRpcException {
        log.debug((Object)"unXdrAndDecryptData");
        ArEncryptRPCCntToSvr arEncryptRPCCntToSvr = null;
        XdrBufferDecodingStream xdrBufferDecodingStream = null;
        try {
            arEncryptRPCCntToSvr = new ArEncryptRPCCntToSvr();
            xdrBufferDecodingStream = new XdrBufferDecodingStream(byArray, byArray.length + 4);
            xdrBufferDecodingStream.beginDecoding();
            arEncryptRPCCntToSvr.xdrDecode((XdrDecodingStream)xdrBufferDecodingStream);
            byte[] byArray2 = arEncryptRPCCntToSvr.getIn();
            int n = arEncryptRPCCntToSvr.getSessionId();
            arEncryptionContext.setCurrentSessionId(n);
            AREncryptAPISessionNode aREncryptAPISessionNode = this.getSessionNode(n);
            if (aREncryptAPISessionNode != null) {
                byte[] byArray3;
                Object object = aREncryptAPISessionNode;
                synchronized (object) {
                    NetworkDataEncryption networkDataEncryption = new NetworkDataEncryption(false, false);
                    byArray3 = networkDataEncryption.decryptData(aREncryptAPISessionNode.getClientDataKey(), byArray2);
                }
                object = byArray3;
                return object;
            }
            try {
                log.debug((Object)("Encryption info not found for the API session. Key Exchange required for sessionId: " + n));
                throw new OncRpcAuthenticationException(2);
            }
            catch (OncRpcAuthenticationException oncRpcAuthenticationException) {
                throw oncRpcAuthenticationException;
            }
            catch (Throwable throwable) {
                log.error((Object)CatalogReader.getInstance().getMessage(8785), throwable);
                throw new OncRpcException(2, throwable, throwable.getMessage());
            }
        }
        finally {
            try {
                xdrBufferDecodingStream.endDecoding();
                xdrBufferDecodingStream.close();
                xdrBufferDecodingStream = null;
            }
            catch (Exception exception) {
                log.debug((Object)("DecodingStream can not be closes." + exception.getLocalizedMessage()));
            }
        }
    }

    public String toPswdString(String string) throws ARException {
        return this.toPswdString(string, ARPluginSvrThreadLocalStorageBlock.getTLB().getRemoteHostCharSet());
    }

    public String toPswdString(String string, String string2) throws ARException {
        String string3 = "";
        byte[] byArray = string.getBytes();
        if (byArray.length == 120) {
            PasswordEncryption passwordEncryption = new PasswordEncryption(0, false);
            try {
                byte[] byArray2 = passwordEncryption.decryptPasswordEx(string.getBytes());
                try {
                    string3 = new String(byArray2, string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string3 = new String(byArray2);
                    log.warn((Object)unsupportedEncodingException.getLocalizedMessage());
                }
            }
            catch (AREncryptionException aREncryptionException) {
                throw new ARException(2, aREncryptionException.getErrorNum(), aREncryptionException.getLocalizedMessage());
            }
        }
        return string3;
    }

    public String doMagic(String string) {
        String string2 = "";
        char[] cArray = new char[30];
        char[] cArray2 = new char[30];
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append(ARPLUGIN_A);
        stringBuilder.append(ARPLUGIN_D);
        stringBuilder.append(ARPLUGIN_C);
        stringBuilder.append(ARPLUGIN_B);
        stringBuilder.append(ARPLUGIN_C);
        string2 = stringBuilder.toString();
        int n = string2.length();
        if (string != null && !string.equals("")) {
            StringBuilder stringBuilder2 = new StringBuilder(string).reverse();
            String string3 = stringBuilder2.toString();
            if (string3.length() < 30 - n) {
                stringBuilder.append(string3);
                return stringBuilder.toString();
            }
            char[] cArray3 = string3.toCharArray();
            char[] cArray4 = stringBuilder.toString().toCharArray();
            System.arraycopy(cArray3, 0, cArray, 30 - cArray3.length, cArray3.length);
            for (int i = 0; i < 30; ++i) {
                cArray2[i] = (char)(cArray4[i] ^ cArray[i]);
                if (cArray2[i] != '\u0000' && cArray2[i] != '\n' && cArray2[i] != '\r') continue;
                cArray2[i] = cArray[i];
            }
            return new String(cArray2);
        }
        return string2;
    }

    static {
        log.debug((Object)("os.name: " + System.getProperty("os.name")));
        log.debug((Object)("os.arch: " + System.getProperty("os.arch")));
        log.debug((Object)("java.vendor: " + System.getProperty("java.vendor")));
    }
}

