/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.pluginsvr.ARPluginRPCCallQueueProcessor;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARPluginServerManager;
import com.bmc.arsys.pluginsvr.ISignalMasking;
import com.bmc.arsys.pluginsvr.binding.ARPluginSvrExecutorFactory;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ARPluginServerMain {
    private static ARPluginRPCCallQueueProcessor rpcDispatcher = null;
    private static Logger log = Logger.getLogger(ARPluginServerMain.class);

    public static void main(String[] stringArray) {
        try {
            Object obj;
            System.out.println("AR System Plugin Server Version 7.6.04 build002 Build 002 201101141059");
            ARPluginServerManager aRPluginServerManager = ARPluginServerManager.getInstance();
            ARPluginServerConfiguration aRPluginServerConfiguration = aRPluginServerManager.loadConfiguration(stringArray);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String string = aRPluginServerConfiguration.getMaskingImplementation();
            if (string != null && string.length() > 0 && (obj = classLoader.loadClass(string).newInstance()) instanceof ISignalMasking) {
                ((ISignalMasking)obj).useMasking();
            }
            aRPluginServerManager.initRpcDispatcher();
            aRPluginServerManager.initTransport();
            if (ARPluginServerConfiguration.isNativePluginHostSupported()) {
                try {
                    log.debug((Object)"initialize native plugin proxy");
                    PluginProxy.initializePluginProxy(aRPluginServerConfiguration.getNativePlugins(), stringArray);
                }
                catch (Exception exception) {
                    log.error((Object)CatalogReader.getInstance().getMessage(8792), (Throwable)exception);
                    System.out.println(CatalogReader.getInstance().getMessage(8792) + exception.getLocalizedMessage());
                }
            }
            ARPluginLoaderRouter.initializeJavaPlugins();
            ARPluginSvrExecutorFactory.getRPCCallExecutor();
            log.info((Object)"AR System Plugin Server Version 7.6.04 build002 Build 002 201101141059");
            ARPluginServerMain.startReloadThread(stringArray);
            ARPluginServerManager.getTransport().run();
        }
        catch (OncRpcException oncRpcException) {
            log.error((Object)(CatalogReader.getInstance().getMessage(8793) + " " + oncRpcException.getMessage()), (Throwable)oncRpcException);
            System.out.println(CatalogReader.getInstance().getMessage(8793) + oncRpcException.getLocalizedMessage());
            ARPluginServerMain.stopServer(1);
        }
        catch (IOException iOException) {
            System.out.println(CatalogReader.getInstance().getMessage(8793) + " " + iOException.getLocalizedMessage());
            log.error((Object)CatalogReader.getInstance().getMessage(8793), (Throwable)iOException);
            ARPluginServerMain.stopServer(2);
        }
        catch (ARException aRException) {
            log.error((Object)CatalogReader.getInstance().getMessage(8793), (Throwable)aRException);
            System.out.println(CatalogReader.getInstance().getMessage(8793) + " " + aRException.getLocalizedMessage());
            ARPluginServerMain.stopServer(3);
        }
        catch (Throwable throwable) {
            log.error((Object)CatalogReader.getInstance().getMessage(8793), throwable);
            System.out.println(CatalogReader.getInstance().getMessage(8793) + throwable.getLocalizedMessage());
            ARPluginServerMain.stopServer(10);
        }
        log.info((Object)"AR Plugin Server going down.");
        System.out.println("AR Plugin Server going down.");
        ARPluginServerMain.stopServer(20);
    }

    public static void stopServer(int n) {
        String string = "Shutting down the AR Plugin server " + n;
        log.info((Object)string);
        System.out.println(string);
        ARPluginSvrExecutorFactory.terminateAllPlugins();
        if (rpcDispatcher != null) {
            rpcDispatcher.close(ARPluginServerMain.rpcDispatcher.transports);
            rpcDispatcher.stopRpcProcessing();
        }
        System.exit(n);
    }

    private static void startReloadThread(final String[] stringArray) {
        new Thread(){

            public void run() {
                ARPluginServerConfiguration aRPluginServerConfiguration = ARPluginServerConfiguration.getInstance();
                while (true) {
                    aRPluginServerConfiguration.updateConfig(stringArray);
                    try {
                        Thread.sleep(ARPluginServerConfiguration.getInstance().getReloadDelay());
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        log.error((Object)"Reloading Thread Interrupted!!", (Throwable)interruptedException);
                        log.info((Object)"Restarting The Reload-Thread...");
                        ARPluginServerMain.startReloadThread(stringArray);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }
}

