/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arreporting;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.GroupInfo;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.ARDataStructure;
import com.bmc.arsys.arreporting.Aggregation;
import com.bmc.arsys.arreporting.FieldInfo;
import com.bmc.arsys.arreporting.ILogListener;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.ReportParameters;
import com.bmc.arsys.arreporting.ReportType;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.arreporting.birt.BIRTReportEngine;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.activity.SemanticException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDelegator {
    private static final int MAX_AR_COND_OP_CODE = 5;
    private static final int MIN_AR_COND_OP_CODE = 0;
    private static final QualifierInfo reportTypeQualInfo = new QualifierInfo(new RelationalOperationInfo(1, new ArithmeticOrRelationalOperand(2000011), new ArithmeticOrRelationalOperand(new Value("Web"))));
    public static final String ENV_BIRT_TEMP = "BIRT_TEMP";
    private static final int REPORT_SET = 2000017;
    private static final int DESCRIPTION = 8;
    private static final int SERVER = 2000018;
    private static final int REPORT_DEFINITION = 2000012;
    private static final int REPORT_PERMISSION = 112;
    private static final int FORM_NAME = 2000010;
    private static final int REPORT_TYPE = 2000011;
    private static final int REPORT_NAME = 2010005;
    private static final int REPORT_ADHOC = 2010008;
    private static final int REPORT_LOCALE = 160;
    private static final int REPORT_QUERY_OVERRIDE = 2000040;
    private static final int REPORT_VISIBLE_IN_CONSOLE = 2010010;
    private String reportForm = null;
    private BIRTReportEngine birtEngine = null;
    private Properties properties = null;
    private final ILogListener logListener;
    private String tempDir = null;

    public ReportDelegator(Properties properties, ILogListener iLogListener) {
        this.properties = properties;
        this.logListener = iLogListener;
        this.tempDir = properties.getProperty("birt.reports.dir");
        if (this.tempDir == null || this.tempDir.length() <= 0) {
            this.tempDir = System.getenv(ENV_BIRT_TEMP);
        }
        if (this.tempDir == null || this.tempDir.length() <= 0) {
            this.tempDir = System.getProperty("java.io.tmpdir");
        }
        if (!this.tempDir.endsWith(System.getProperty("file.separator"))) {
            this.tempDir = this.tempDir + System.getProperty("file.separator");
        }
    }

    public void initializeEngines() throws ARException {
        this.initializeBIRTEngine();
    }

    private void initializeBIRTEngine() throws ARException {
        if (this.birtEngine == null || !this.birtEngine.isInitialized()) {
            this.birtEngine = new BIRTReportEngine(this.properties, this.logListener);
            this.birtEngine.startup();
        }
    }

    public void shutDown() {
        if (this.birtEngine != null) {
            this.birtEngine.shutdown();
        }
    }

    public Properties getEngineProperties(ReportType reportType) {
        if (ReportType.BIRT.equals((Object)reportType) && this.birtEngine != null) {
            return this.birtEngine.getEngineProperties();
        }
        return null;
    }

    public String createReport(ARServerUser aRServerUser, ReportType reportType, ReportParameters reportParameters, String string, boolean bl) throws ARException {
        Object object;
        String string2 = null;
        this.validateContext(aRServerUser);
        if (ReportType.BIRT.equals((Object)reportType)) {
            this.validateBIRTEngine();
            try {
                Object object2;
                String string3;
                Object object3;
                object = this.getFieldObjects(aRServerUser, reportParameters);
                this.validateParameters(reportParameters, (List<Field>)object);
                String string4 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()));
                String string5 = reportParameters.getEncodedPrimaryQual();
                String string6 = reportParameters.getEncodedSecondaryQual();
                String string7 = "";
                if (string5 != null && !string5.equals("1=1")) {
                    string7 = string5;
                    reportParameters.getProperties().setProperty("parseEncodedQualToStringPrimary", string7);
                }
                if (string6 != null && string6.length() > 0) {
                    object3 = this.parseEncodedQualToStringUsingDS(aRServerUser, reportParameters.getForm(), string6, string4);
                    reportParameters.getProperties().setProperty("parseEncodedQualToStringSecondary", (String)object3);
                    if (object3 != null && ((String)object3).length() > 0) {
                        if (string7 != null && string7.length() > 0) {
                            string7 = string7 + " AND ";
                        }
                        string7 = string7 + (String)object3;
                    }
                }
                if (string7.length() > 0) {
                    object3 = Utilities.parseQualification(aRServerUser, string7, reportParameters.getForm(), string4);
                    string3 = null;
                    if (object3 != null) {
                        string3 = aRServerUser.encodeQualification((QualifierInfo)object3);
                        reportParameters.getProperties().setProperty("Application-Parse-Qual-L", string3);
                        string7 = string3;
                        object2 = new OutputInteger(0);
                        aRServerUser.getListEntry(reportParameters.getForm(), (QualifierInfo)object3, 0, 1, new ArrayList(), new ArrayList(), false, (OutputInteger)object2);
                    }
                }
                if (string7 == null || string7.length() == 0) {
                    string7 = "1=1";
                }
                reportParameters.setQualification(string7);
                object3 = object.iterator();
                block11: while (object3.hasNext()) {
                    string3 = (Field)object3.next();
                    switch (string3.getDataType()) {
                        case 12: {
                            if (string3.getFieldLimit() == null || !(string3.getFieldLimit() instanceof CurrencyFieldLimit)) break;
                            object2 = reportParameters.getField(string3.getFieldID());
                            if (object2 == null) continue block11;
                            ((FieldInfo)object2).setPrecision(((CurrencyFieldLimit)string3.getFieldLimit()).getPrecision());
                            break;
                        }
                        case 3: {
                            if (string3.getFieldLimit() == null || !(string3.getFieldLimit() instanceof RealFieldLimit)) break;
                            object2 = reportParameters.getField(string3.getFieldID());
                            if (object2 == null) continue block11;
                            ((FieldInfo)object2).setPrecision(((RealFieldLimit)string3.getFieldLimit()).getPrecision());
                            break;
                        }
                        case 10: {
                            if (string3.getFieldLimit() == null || !(string3.getFieldLimit() instanceof DecimalFieldLimit)) break;
                            object2 = reportParameters.getField(string3.getFieldID());
                            if (object2 == null) continue block11;
                            ((FieldInfo)object2).setPrecision(((DecimalFieldLimit)string3.getFieldLimit()).getPrecision());
                            break;
                        }
                    }
                }
                this.birtEngine.createReport(aRServerUser, reportParameters, string);
            }
            catch (SemanticException semanticException) {
                throw new ARException(2, -1, semanticException.getMessage());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ARException(2, -1, uRISyntaxException.getMessage());
            }
            catch (IOException iOException) {
                throw new ARException(2, -1, iOException.getMessage());
            }
            catch (DesignFileException designFileException) {
                throw new ARException(2, -1, designFileException.getMessage());
            }
            catch (ParseException parseException) {
                throw new ARException(2, -1, parseException.getMessage());
            }
        }
        if (bl) {
            string2 = this.persistReport(aRServerUser, reportType, reportParameters, string);
            object = new File(string);
            if (((File)object).exists()) {
                ((File)object).delete();
            }
        }
        return string2;
    }

    private void validateParameters(ReportParameters reportParameters, List<Field> list) throws ARException {
        int n = reportParameters.getSeriesField();
        block3: for (Field field : list) {
            if (field.getFieldID() != n) continue;
            switch (field.getDataType()) {
                case 2: 
                case 3: 
                case 10: 
                case 12: 
                case 40: {
                    continue block3;
                }
            }
            if (Aggregation.COUNT.equals((Object)reportParameters.getAggregation())) continue;
            throw new ARException(2, -1, "The supplied series field is of an invalid datatype for the selected aggregation");
        }
    }

    private void addPermissionsToReportEntry(ARServerUser aRServerUser, ReportParameters reportParameters, Entry entry) {
        int n;
        String string = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_PRIVACY_ID.toInt()));
        String string2 = "";
        if (string != null && (n = Integer.parseInt(string)) == 1) {
            string2 = "0;";
            try {
                List list = aRServerUser.getListGroup(aRServerUser.getUser(), null);
                boolean bl = true;
                for (GroupInfo groupInfo : list) {
                    if (groupInfo == null) continue;
                    if (bl) {
                        string2 = groupInfo.getId() + ";";
                        bl = false;
                        continue;
                    }
                    string2 = string2 + groupInfo.getId() + ";";
                }
            }
            catch (ARException aRException) {
                // empty catch block
            }
        }
        if (string2 != null && string2.length() > 0) {
            entry.put(Integer.valueOf(112), new Value(string2));
        }
    }

    private String persistReport(ARServerUser aRServerUser, ReportType reportType, ReportParameters reportParameters, String string) throws ARException {
        String string2;
        File file = new File(string);
        if (!file.exists()) {
            throw new ARException(2, 3351, "Unable to locate report file");
        }
        Entry entry = new Entry();
        entry.put(Integer.valueOf(2010005), new Value(reportParameters.getName()));
        entry.put(Integer.valueOf(2000011), new Value(reportParameters.getType().getName()));
        entry.put(Integer.valueOf(2000010), new Value(reportParameters.getForm()));
        entry.put(Integer.valueOf(2000018), new Value(Keyword.AR_KEYWORD_SERVER));
        String string3 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_LOCALE_ID.toInt()));
        if (string3 == null) {
            string3 = "";
        }
        if (string3.length() > 0 && !string3.startsWith("en")) {
            if (!string3.startsWith("zh") && !string3.equals("pt_BR")) {
                string3 = string3.substring(0, 2);
            }
            entry.put(Integer.valueOf(160), string3 != null && string3.length() > 0 ? new Value(string3) : new Value(Keyword.AR_KEYWORD_LOCALE));
        }
        if ((string2 = reportParameters.getProperties().getProperty(Integer.toString(ReportConstants.DESIGNER_VISIBLE_IN_CONSOLE.toInt()))) != null) {
            entry.put(Integer.valueOf(2010010), new Value(string2));
        }
        if (reportParameters.getDescription() == null || reportParameters.getDescription().length() == 0) {
            entry.put(Integer.valueOf(8), new Value("Web Report"));
        } else {
            entry.put(Integer.valueOf(8), new Value(reportParameters.getDescription()));
        }
        if (reportParameters.getReportSet() == null || reportParameters.getReportSet().length() == 0) {
            entry.put(Integer.valueOf(2000017), new Value("BIRT Ad-Hoc"));
        } else {
            entry.put(Integer.valueOf(2000017), new Value(reportParameters.getReportSet()));
        }
        entry.put(Integer.valueOf(7), new Value((Object)2, DataType.ENUM));
        entry.put(Integer.valueOf(2), new Value(aRServerUser.getUser()));
        entry.put(Integer.valueOf(2000040), new Value((Object)0, DataType.ENUM));
        AttachmentValue attachmentValue = new AttachmentValue();
        if (reportParameters.getName() == null || reportParameters.getName().length() == 0) {
            attachmentValue.setName("Report.rptdesign");
        } else {
            attachmentValue.setName(this.makeValidFileName(reportParameters.getName()) + ".rptdesign");
        }
        attachmentValue.setLocationType(1);
        attachmentValue.setFilePath(file.getAbsolutePath());
        try {
            attachmentValue.setValue(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new ARException(2, 3351, iOException.getMessage());
        }
        entry.put(Integer.valueOf(2000012), new Value(attachmentValue));
        entry.put(Integer.valueOf(2010008), new Value("1"));
        this.addPermissionsToReportEntry(aRServerUser, reportParameters, entry);
        return aRServerUser.createEntry(this.getReportFormName(aRServerUser), entry);
    }

    private void validateBIRTEngine() throws ARException {
        if (this.birtEngine == null || !this.birtEngine.isInitialized()) {
            this.initializeBIRTEngine();
        }
    }

    private void validateContext(ARServerUser aRServerUser) throws ARException {
        if (aRServerUser == null) {
            throw new ARException(2, 149);
        }
        if (aRServerUser.getUser() == null || aRServerUser.getUser().length() == 0) {
            throw new ARException(2, 149);
        }
        if (aRServerUser.getServer() == null || aRServerUser.getServer().length() == 0) {
            throw new ARException(2, 150);
        }
    }

    public void deleteReport(ARServerUser aRServerUser, String string) throws ARException {
        this.validateContext(aRServerUser);
        List list = aRServerUser.getListEntry(this.getReportFormName(aRServerUser), this.getReportNameQualification(string), 0, 0, null, null, false, null);
        if (list != null && !list.isEmpty()) {
            aRServerUser.deleteEntry(this.getReportFormName(aRServerUser), ((EntryListInfo)list.get(0)).getEntryID(), 0);
        }
    }

    private String getReportFormName(ARServerUser aRServerUser) throws ARException {
        this.validateContext(aRServerUser);
        if (this.reportForm == null) {
            FormCriteria formCriteria = new FormCriteria();
            formCriteria.setPropertiesToRetrieve(FormCriteria.NAME);
            int n = 1025;
            List list = aRServerUser.getListFormObjects(0L, n, null, new int[]{2010005, 2000011, 2000010}, formCriteria);
            if (list.size() > 0) {
                this.reportForm = ((Form)list.get(0)).getName();
            }
        } else {
            this.reportForm = "Report";
        }
        return this.reportForm;
    }

    private QualifierInfo getReportNameQualification(String string) {
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand(2010005);
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2 = new ArithmeticOrRelationalOperand(new Value(string));
        return new QualifierInfo(1, new QualifierInfo(new RelationalOperationInfo(1, arithmeticOrRelationalOperand, arithmeticOrRelationalOperand2)), reportTypeQualInfo);
    }

    public Entry getReportEntry(ARServerUser aRServerUser, String string) throws ARException {
        this.validateContext(aRServerUser);
        List list = aRServerUser.getListEntryObjects(this.getReportFormName(aRServerUser), this.getReportNameQualification(string), 0, 0, new ArrayList(), new int[]{2010005, 2000011, 2000012, 2}, false, null);
        if (list != null && !list.isEmpty()) {
            return (Entry)list.get(0);
        }
        return null;
    }

    public Entry getReportEntryByEntryID(ARServerUser aRServerUser, String string) throws ARException {
        this.validateContext(aRServerUser);
        return aRServerUser.getEntry(this.getReportFormName(aRServerUser), string, new int[]{2010005, 2000011, 2000012, 2});
    }

    public String getReportType(Entry entry) {
        Value value = (Value)entry.get((Object)2000011);
        if (value != null) {
            return value.getValue().toString();
        }
        return null;
    }

    public String getReportName(Entry entry) {
        Value value = (Value)entry.get((Object)2010005);
        if (value != null) {
            return value.getValue().toString();
        }
        return null;
    }

    public String getSubmitter(Entry entry) {
        Value value = (Value)entry.get((Object)2);
        if (value != null) {
            return value.getValue().toString();
        }
        return "";
    }

    public byte[] getReportData(ARServerUser aRServerUser, Entry entry) throws ARException {
        this.validateContext(aRServerUser);
        Value value = (Value)entry.get((Object)2000012);
        byte[] byArray = null;
        if (value != null && value.getValue() != null && DataType.ATTACHMENT.equals((Object)value.getDataType())) {
            AttachmentValue attachmentValue = (AttachmentValue)value.getValue();
            if (attachmentValue != null && ((byArray = attachmentValue.getValue()) == null || byArray.length == 0)) {
                attachmentValue.setValue(new byte[0]);
                byArray = aRServerUser.getEntryBlob(this.getReportFormName(aRServerUser), entry.getEntryId(), 2000012);
            }
            return byArray;
        }
        return byArray;
    }

    private ReportParameters getParameters(ARServerUser aRServerUser, Entry entry) throws ARException {
        String string = this.getReportType(entry);
        if (ReportType.fromName(string).equals((Object)ReportType.BIRT)) {
            byte[] byArray = this.getReportData(aRServerUser, entry);
            if (byArray == null) {
                throw new ARException(2, 3356);
            }
            ReportParameters reportParameters = this.birtEngine.getParameters(byArray);
            reportParameters.getProperties().setProperty(Integer.toString(2), this.getSubmitter(entry));
            return reportParameters;
        }
        return null;
    }

    public ReportParameters getParametersByEntryID(ARServerUser aRServerUser, String string) throws ARException {
        Entry entry = this.getReportEntryByEntryID(aRServerUser, string);
        if (entry != null) {
            return this.getParameters(aRServerUser, entry);
        }
        return null;
    }

    public ReportParameters getParameters(String string) throws ARException {
        try {
            int n;
            File file = new File(string);
            if (!file.exists()) {
                throw new ARException(2, -1, "File name is not valid");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                return null;
            }
            byte[] byArray = new byte[(int)l];
            int n2 = 0;
            for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
            }
            if (n < byArray.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)fileInputStream).close();
            return this.birtEngine.getParameters(byArray);
        }
        catch (IOException iOException) {
            throw new ARException(2, -1, iOException.getMessage());
        }
    }

    public ReportParameters getParameters(ARServerUser aRServerUser, String string) throws ARException {
        this.validateContext(aRServerUser);
        Entry entry = this.getReportEntry(aRServerUser, string);
        if (entry != null) {
            return this.getParameters(aRServerUser, entry);
        }
        return null;
    }

    public byte[] getReport(ARServerUser aRServerUser, String string) throws ARException {
        AttachmentValue attachmentValue;
        Value value;
        this.validateContext(aRServerUser);
        Entry entry = this.getReportEntry(aRServerUser, string);
        if (entry != null && (value = (Value)entry.get((Object)2000012)) != null && value.getValue() != null && DataType.ATTACHMENT.equals((Object)value.getDataType()) && (attachmentValue = (AttachmentValue)value.getValue()) != null) {
            attachmentValue.setValue(new byte[0]);
            return aRServerUser.getEntryBlob(this.getReportFormName(aRServerUser), entry.getEntryId(), 2000012);
        }
        return null;
    }

    public byte[] getReportByEntryID(ARServerUser aRServerUser, String string) throws ARException {
        AttachmentValue attachmentValue;
        Value value;
        this.validateContext(aRServerUser);
        Entry entry = aRServerUser.getEntry(this.getReportFormName(aRServerUser), string, new int[]{2010005, 2000011, 2000012});
        if (entry != null && (value = (Value)entry.get((Object)2000012)) != null && value.getValue() != null && DataType.ATTACHMENT.equals((Object)value.getDataType()) && (attachmentValue = (AttachmentValue)value.getValue()) != null) {
            attachmentValue.setValue(new byte[0]);
            return aRServerUser.getEntryBlob(this.getReportFormName(aRServerUser), entry.getEntryId(), 2000012);
        }
        return null;
    }

    public ByteArrayOutputStream runFileReport(ARServerUser aRServerUser, ReportParameters reportParameters) throws ARException {
        this.validateContext(aRServerUser);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        reportParameters.setQualification(this.convertEncodedQualStr(aRServerUser, reportParameters.getForm(), reportParameters.getQualification()));
        this.birtEngine.runReport(aRServerUser, reportParameters, reportParameters.getReportFile(), (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream runEntryReport(ARServerUser aRServerUser, ReportParameters reportParameters) throws ARException {
        this.validateContext(aRServerUser);
        byte[] byArray = null;
        if (reportParameters.getEntryId() != null && reportParameters.getEntryId().length() > 0) {
            byArray = this.getReportByEntryID(aRServerUser, reportParameters.getEntryId());
        }
        if (byArray == null && reportParameters.getName() != null && reportParameters.getName().length() > 0) {
            byArray = this.getReport(aRServerUser, reportParameters.getName());
        }
        if (byArray != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            reportParameters.setQualification(this.convertEncodedQualStr(aRServerUser, reportParameters.getForm(), reportParameters.getQualification()));
            this.birtEngine.runReport(aRServerUser, reportParameters, byArray, byteArrayOutputStream);
            return byteArrayOutputStream;
        }
        this.logMessage(2, "No report identifier was supplied for runEntryReport");
        throw new ARException(2, 3356, "A report name or entry id must be provided");
    }

    public ByteArrayOutputStream runNewReport(ARServerUser aRServerUser, ReportParameters reportParameters) throws ARException {
        if (ReportType.BIRT.equals((Object)reportParameters.getType())) {
            this.validateContext(aRServerUser);
            try {
                File file = File.createTempFile(aRServerUser.getUser(), ".rptdesign");
                file.deleteOnExit();
                String string = file.getAbsolutePath();
                this.birtEngine.createReport(aRServerUser, reportParameters, string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                reportParameters.setQualification(this.convertEncodedQualStr(aRServerUser, reportParameters.getForm(), reportParameters.getQualification()));
                this.birtEngine.runReport(aRServerUser, reportParameters, string, (OutputStream)byteArrayOutputStream);
                return byteArrayOutputStream;
            }
            catch (IOException iOException) {
                this.logMessage(2, iOException.getMessage());
                throw new ARException(2, -1, iOException.getMessage());
            }
            catch (SemanticException semanticException) {
                this.logMessage(2, semanticException.getMessage());
                throw new ARException(2, -1, semanticException.getMessage());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.logMessage(2, uRISyntaxException.getMessage());
                throw new ARException(2, -1, uRISyntaxException.getMessage());
            }
            catch (DesignFileException designFileException) {
                this.logMessage(2, designFileException.getMessage());
                throw new ARException(2, -1, designFileException.getMessage());
            }
        }
        return null;
    }

    public void updateReport(ARServerUser aRServerUser, String string, ReportParameters reportParameters) throws ARException {
        this.validateContext(aRServerUser);
        Entry entry = this.getReportEntry(aRServerUser, string);
        if (entry != null) {
            Value value;
            if (reportParameters.getName() == null) {
                reportParameters.getProperties().setProperty(Integer.toString(ReportConstants.DESIGNER_REPORT_NAME_ID.toInt()), string);
            }
            if ((value = (Value)entry.get((Object)2000011)) != null && value.getDataType().equals((Object)DataType.CHAR) && ReportType.fromName((String)value.getValue()).equals((Object)ReportType.BIRT)) {
                Object object;
                Object object2;
                String string2 = this.makeValidFileName(string);
                String string3 = this.tempDir + string2 + ".rptdesign";
                File file = new File(string3);
                if (file.exists()) {
                    file.delete();
                }
                List<FieldInfo> list = reportParameters.getFields();
                boolean bl = false;
                for (FieldInfo object32 : list) {
                    if (object32.getDataType() != null) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    object2 = this.getFieldObjects(aRServerUser, reportParameters);
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (Field)iterator.next();
                        FieldInfo fieldInfo = reportParameters.getField(object.getFieldID());
                        if (fieldInfo == null) continue;
                        fieldInfo.setDataType(DataType.toDataType((int)object.getDataType()));
                    }
                }
                this.createReport(aRServerUser, ReportType.BIRT, reportParameters, string3, false);
                object2 = new Entry();
                file = new File(string3);
                AttachmentValue attachmentValue = new AttachmentValue();
                if (reportParameters.getName() == null || reportParameters.getName().length() == 0) {
                    attachmentValue.setName("Report.rptdesign");
                } else {
                    attachmentValue.setName(reportParameters.getName() + ".rptdesign");
                }
                attachmentValue.setLocationType(1);
                attachmentValue.setFilePath(file.getAbsolutePath());
                try {
                    attachmentValue.setValue(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    throw new ARException(2, 3351, iOException.getMessage());
                }
                object2.put(Integer.valueOf(2000012), new Value(attachmentValue));
                object = reportParameters.getDescription();
                if (object != null && ((String)object).length() > 0) {
                    object2.put(Integer.valueOf(8), new Value((String)object));
                }
                this.addPermissionsToReportEntry(aRServerUser, reportParameters, (Entry)object2);
                aRServerUser.setEntry(this.getReportFormName(aRServerUser), entry.getEntryId(), (Entry)object2, new Timestamp(), 0);
            } else {
                throw new ARException(2, 3356);
            }
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String parseEncodedQualToStringUsingDS(ARServerUser aRServerUser, String string, String string2, String string3) throws ARException, ParseException {
        if (string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = ARDataStructure.processAsList(string2);
        for (int i = 0; i < arrayList2.size(); ++i) {
            StringBuffer stringBuffer;
            String string4 = (String)arrayList2.get(i);
            HashMap<String, String> object = ARDataStructure.processAsMap(string4);
            if (object == null || object.size() <= 0) continue;
            String string5 = (String)object.get("id");
            String string6 = (String)object.get("relop");
            int n = Integer.parseInt((String)object.get("dt"));
            String string7 = (String)object.get("value");
            if (string7 != null && string7.indexOf("$\\") != -1) {
                n = 1;
            }
            switch (n) {
                case 4: 
                case 6: 
                case 7: 
                case 11: 
                case 13: 
                case 14: {
                    if (string7 == null) break;
                    string7 = "\"" + string7.trim().replaceAll("\"", "\"\"") + "\"";
                    break;
                }
                case 12: {
                    if (string7 == null || string7.length() == 0) {
                        string7 = "$\\NULL$";
                        break;
                    }
                    if ((string7 = string7.replace("\"\"", "\"")).startsWith("\"") && string7.endsWith("\"")) {
                        string7 = string7.substring(1, string7.length() - 1);
                    }
                    if ((stringBuffer = new CurrencyValue(string7 = string7.trim())).getCurrencyCode() == null || stringBuffer.getCurrencyCode().length() <= 0) break;
                    string7 = "\"" + string7 + "\"";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 10: {
                    if (string7 == null) break;
                    string7 = string7.replace("\"\"", "\"");
                    if (!(string7 = string7.trim()).startsWith("\"") || !string7.endsWith("\"")) break;
                    string7 = string7.substring(1, string7.length() - 1);
                }
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append(" '").append(string5).append("' ").append(string6);
            if (string7 != null) {
                stringBuffer.append(" ").append(string7);
            }
            if (i < arrayList2.size() - 1) {
                stringBuffer.append(" AND ");
            }
            arrayList.add(stringBuffer.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string8 : arrayList) {
            if (string8 == null || string8.length() <= 0) continue;
            stringBuffer.append(string8);
        }
        return stringBuffer.toString();
    }

    private void logMessage(int n, String string) {
        if (this.logListener != null) {
            this.logListener.logMessage(n, string);
        }
    }

    private String convertEncodedQualStr(ARServerUser aRServerUser, String string, String string2) throws ARException {
        if (this.isEncodedQual(string2)) {
            string2 = aRServerUser.formatQualification(string, (Object)string2);
            return string2;
        }
        return string2;
    }

    private boolean isEncodedQual(String string) {
        int n;
        return string != null && string.length() > 2 && (n = string.charAt(0) - 48) <= 5 && n >= 0 && string.charAt(1) == '\\';
    }

    private List<Field> getFieldObjects(ARServerUser aRServerUser, ReportParameters reportParameters) throws ARException {
        Object object = reportParameters.getProperties().get("arFieldObjects");
        if (object == null || !(object instanceof List) || ((List)object).isEmpty()) {
            List list = aRServerUser.getListFieldObjects(reportParameters.getForm(), 1);
            reportParameters.getProperties().put("arFieldObjects", list);
            return list;
        }
        return (List)object;
    }

    public String makeValidFileName(String string) {
        if (string == null) {
            return "";
        }
        return string.replaceAll("(\\[|#|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\]|\\s)+", "_");
    }

    class SnippetInfo {
        QualifierInfo qualification = null;
        int operation = 0;

        SnippetInfo() {
        }

        public QualifierInfo getQualification() {
            return this.qualification;
        }

        public void setQualification(QualifierInfo qualifierInfo) {
            this.qualification = qualifierInfo;
        }

        public int getOperation() {
            return this.operation;
        }

        public void setOperation(int n) {
            this.operation = n;
        }
    }
}

