/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugin.sample;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DateOnlyFieldLimit;
import com.bmc.arsys.api.DateTimeFieldLimit;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.TimeOnlyFieldLimit;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARDBCSample
extends ARDBCPlugin {
    private Connection con;
    private ARPluginInfo pluginInfo = new ARPluginInfo("SAMPLE_JDBC_PLUGIN", (ARPluggable)this);
    private static final String NAME = "SAMPLE_JDBC_PLUGIN";
    private static final String DBNAME = "SamplePlugin";

    synchronized ArrayList<VendorForm> getTables() throws SQLException {
        Statement stmt = this.con.createStatement();
        ArrayList<VendorForm> list = new ArrayList<VendorForm>();
        ResultSet rsTables = null;
        DatabaseMetaData dbmd = this.con.getMetaData();
        rsTables = dbmd.getTables(null, null, null, null);
        while (rsTables.next()) {
            String tableName = rsTables.getString("TABLE_NAME");
            if (!tableName.startsWith("ar")) continue;
            VendorForm form = new VendorForm(NAME, tableName);
            list.add(form);
        }
        rsTables.close();
        stmt.close();
        return list;
    }

    synchronized ArrayList<ARVendorField> getColumns(String tableName) throws SQLException {
        Statement stmt = this.con.createStatement();
        ArrayList<ARVendorField> list = new ArrayList<ARVendorField>();
        String query = "Select TOP 1 * from " + tableName;
        ResultSet set = stmt.executeQuery(query);
        ResultSetMetaData metadata = set.getMetaData();
        int numCols = metadata.getColumnCount();
        block12: for (int i = 1; i <= numCols; ++i) {
            String name = metadata.getColumnName(i);
            int type = metadata.getColumnType(i);
            DateOnlyFieldLimit limit = null;
            switch (type) {
                case 1: {
                    type = 4;
                    limit = new CharacterFieldLimit(1, 0, 0, null, null, 0);
                    break;
                }
                case 3: {
                    type = 10;
                    limit = new DecimalFieldLimit("-99999999999999999999999999.99", "99999999999999999999999999.99", 3);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    type = 3;
                    limit = new RealFieldLimit(-1.845E19, 1.845E19, 6);
                    break;
                }
                case 4: {
                    type = 2;
                    new IntegerFieldLimit(-2147483647, Integer.MAX_VALUE);
                    break;
                }
                case 2004: {
                    type = 11;
                    limit = new AttachmentFieldLimit(200000, 0, 0);
                    break;
                }
                case -1: {
                    type = 4;
                    limit = new CharacterFieldLimit(0, 0, 0, null, null, 0);
                    break;
                }
                case 12: {
                    type = 4;
                    limit = new CharacterFieldLimit(255, 0, 0, null, null, 0);
                    break;
                }
                case 91: {
                    type = 13;
                    limit = new DateOnlyFieldLimit();
                    break;
                }
                case 92: {
                    type = 14;
                    limit = new TimeOnlyFieldLimit();
                    break;
                }
                case 93: {
                    type = 7;
                    limit = new DateTimeFieldLimit();
                    break;
                }
                default: {
                    continue block12;
                }
            }
            ARVendorField field = new ARVendorField(name, 0, type, (FieldLimit)limit);
            list.add(field);
        }
        set.close();
        stmt.close();
        return list;
    }

    Entry getRecord(String tableName, List<ARVendorField> fields, String entryId) throws SQLException {
        Statement stmt = this.con.createStatement();
        Entry entry = null;
        String query = "Select * from " + tableName;
        ResultSet set = stmt.executeQuery(query);
        HashMap<Integer, Value> values = null;
        int rowNum = 1;
        if (set != null && fields != null) {
            while (set.next()) {
                String id = "";
                values = new HashMap<Integer, Value>();
                for (int i = 0; i < fields.size(); ++i) {
                    Value val;
                    String value;
                    ARVendorField field = fields.get(i);
                    if (field.getFieldId() == 1) {
                        id = value = Integer.toString(rowNum++);
                        val = new Value(value, DataType.toDataType((int)field.getDataType()));
                        values.put(new Integer(field.getFieldId()), val);
                        continue;
                    }
                    value = set.getString(field.getName());
                    val = new Value(value, DataType.toDataType((int)field.getDataType()));
                    values.put(new Integer(field.getFieldId()), val);
                }
                if (!id.equals(entryId)) continue;
                break;
            }
            entry = new Entry(values);
            set.close();
        }
        stmt.close();
        return entry;
    }

    List<Entry> getRecords(String tableName, List<ARVendorField> fields, QualifierInfo qual) throws SQLException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Statement stmt = this.con.createStatement();
        String query = "Select * from " + tableName;
        ResultSet set = stmt.executeQuery(query);
        int rowNum = 1;
        if (set != null && fields != null) {
            while (set.next()) {
                HashMap<Integer, Value> values = new HashMap<Integer, Value>();
                for (int i = 0; i < fields.size(); ++i) {
                    Value val;
                    String value;
                    ARVendorField field = fields.get(i);
                    if (field.getFieldId() == 1) {
                        value = Integer.toString(rowNum++);
                        val = new Value(value, DataType.toDataType((int)field.getDataType()));
                        values.put(new Integer(field.getFieldId()), val);
                        continue;
                    }
                    value = set.getString(field.getName());
                    val = new Value(value, DataType.toDataType((int)field.getDataType()));
                    values.put(new Integer(field.getFieldId()), val);
                }
                Entry entry = new Entry(values);
                entries.add(entry);
            }
            set.close();
        }
        stmt.close();
        return entries;
    }

    String createRecord(ARPluginContext context, String tableName, List<ARVendorField> fields, Entry entry) throws SQLException {
        String key = null;
        Statement stmt = this.con.createStatement();
        if (tableName != null && fields != null && entry != null) {
            String query = "Insert into " + tableName + " (";
            for (int j = 0; j < fields.size(); ++j) {
                ARVendorField field1 = fields.get(j);
                if (field1.getFieldId() == 1) continue;
                query = query + field1.getName();
                if (j + 1 >= fields.size()) continue;
                query = query + ",";
            }
            query = query + ") Values (";
            block11: for (int i = 0; i < fields.size(); ++i) {
                ARVendorField field = fields.get(i);
                Value value = (Value)entry.get((Object)field.getFieldId());
                if (field.getFieldId() == 1) continue;
                switch (field.getDataType()) {
                    case 4: {
                        query = query + " '" + (String)value.getValue() + "' ";
                        break;
                    }
                    case 10: {
                        query = query + " " + ((BigDecimal)value.getValue()).doubleValue() + "  ";
                        break;
                    }
                    case 3: {
                        query = query + " " + (Double)value.getValue() + "  ";
                        break;
                    }
                    case 2: {
                        query = query + " " + (Integer)value.getValue() + " ";
                        break;
                    }
                    case 11: {
                        query = query + " " + value.getValue() + " ";
                        break;
                    }
                    case 13: {
                        query = query + " " + ((DateInfo)value.getValue()).getValue() + " ";
                        break;
                    }
                    case 7: {
                        query = query + " " + ((Timestamp)value.getValue()).getValue() + " ";
                        break;
                    }
                    case 14: {
                        query = query + " " + ((Time)value.getValue()).getValue() + " ";
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                if (i + 1 >= fields.size()) continue;
                query = query + ",";
            }
            int row = stmt.executeUpdate(query = query + ")");
            if (row > 0) {
                key = Integer.toString(row);
            }
        }
        stmt.close();
        return key;
    }

    public void cancel(ARPluginContext context, long transid) throws ARException {
        context.logMessage(this.pluginInfo, 0, "cancel()");
        super.cancel(context, transid);
    }

    public void commit(ARPluginContext context, long transid) throws ARException {
        context.logMessage(this.pluginInfo, 0, "commit()");
        super.commit(context, transid);
    }

    public String createEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, Entry newEntry) throws ARException {
        context.logMessage(this.pluginInfo, 0, "createEntry()");
        String entry = null;
        try {
            entry = this.createRecord(context, tableName, fields, newEntry);
        }
        catch (SQLException e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1007L, "Error creating entry for table " + tableName, e.getMessage())));
        }
        return entry;
    }

    public void deleteEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId) throws ARException {
        context.logMessage(this.pluginInfo, 0, "deleteEntry()");
    }

    public AttachmentValue getBLOB(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId, int fieldId) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getBlob()");
        return super.getBLOB(context, tableName, fields, transid, entryId, fieldId);
    }

    public Entry getEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId, int[] fieldIds) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getEntry()");
        Entry entry = null;
        try {
            entry = this.getRecord(tableName, fields, entryId);
        }
        catch (SQLException e) {
            StatusInfo info = new StatusInfo(2, 1004L, "Error fetching entry " + entryId + " from table " + tableName, e.getMessage());
            ArrayList<StatusInfo> status = new ArrayList<StatusInfo>();
            status.add(info);
            throw new ARException(status);
        }
        if (entry == null) {
            new ARException(Arrays.asList(new StatusInfo(2, 1006L, "No such entry " + entryId + " for table " + tableName, "")));
        }
        return entry;
    }

    public List<StatisticsResultInfo> getEntryStatistics(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, QualifierInfo qual, ArithmeticOrRelationalOperand arithOp, int statistic, int[] groupBy) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getEntryStatistics()");
        return super.getEntryStatistics(context, tableName, fields, transid, qual, arithOp, statistic, groupBy);
    }

    public List<Entry> getListEntryWithFields(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, QualifierInfo qual, List<SortInfo> sortList, List<EntryListFieldInfo> fieldList, int startAt, int maxReturn, OutputInteger numMatches) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getListEntryWithFields()");
        List<Object> entries = new ArrayList();
        try {
            entries = this.getRecords(tableName, fields, qual);
        }
        catch (SQLException e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching entries for given qualification from table " + tableName, e.getMessage())));
        }
        if (entries == null || entries.size() == 0) {
            new ARException(Arrays.asList(new StatusInfo(2, 1005L, "No entries for table " + tableName, "")));
        }
        return entries;
    }

    public List<VendorForm> getListForms(ARPluginContext context) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getListForms()");
        ArrayList<VendorForm> list = null;
        try {
            list = this.getTables();
        }
        catch (SQLException e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching table names from the datasource", e.getMessage())));
        }
        return list;
    }

    public List<ARVendorField> getMultipleFields(ARPluginContext context, VendorForm form) throws ARException {
        context.logMessage(this.pluginInfo, 0, "getMultipleFields()");
        ArrayList<ARVendorField> list = null;
        try {
            list = this.getColumns(form.getTableName());
        }
        catch (SQLException e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + form.getTableName(), e.getMessage())));
        }
        return list;
    }

    public void rollback(ARPluginContext context, long transid) throws ARException {
        context.logMessage(this.pluginInfo, 0, "rollBack()");
    }

    public void setBLOB(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId, int fieldId, AttachmentValue blob) throws ARException {
        context.logMessage(this.pluginInfo, 0, "setBlob()");
    }

    public void setEntry(ARPluginContext context, String tableName, List<ARVendorField> fields, long transid, String entryId, Entry entry, Timestamp lastModified) throws ARException {
        context.logMessage(this.pluginInfo, 0, "setEntry()");
    }

    public void initialize(ARPluginContext context) throws ARException {
        context.logMessage(this.pluginInfo, 0, "initialize()");
        String url = "jdbc:odbc:SamplePlugin";
        String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
        String user = "sa";
        String password = "";
        try {
            String item = context.getConfigItem(this.pluginInfo, "dburl");
            if (item != null && !item.equals("")) {
                url = item;
            }
            if ((item = context.getConfigItem(this.pluginInfo, "driver")) != null && !item.equals("")) {
                driver = item;
            }
            if ((item = context.getConfigItem(this.pluginInfo, "user")) != null && !item.equals("")) {
                user = item;
            }
            if ((item = context.getConfigItem(this.pluginInfo, "password")) != null) {
                password = item;
            }
            Class.forName(driver);
            this.con = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1000L, "Error establishing jdbc connection to the datasource " + url, e.getMessage())));
        }
    }

    public void onEvent(ARPluginContext contexxt, int eventId) throws ARException {
        contexxt.logMessage(this.pluginInfo, 0, "onEvent()");
        super.onEvent(contexxt, eventId);
    }

    public void terminate(ARPluginContext context) throws ARException {
        try {
            context.logMessage(this.pluginInfo, 0, "terminate()");
            this.con.close();
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1001L, "Error closing jdbc connection to the datasource", DBNAME)));
        }
    }
}

