/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSOperation;
import com.bmc.arsys.ws.mapping.ARSPort;
import com.bmc.arsys.ws.mapping.ARSWebService;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.WsdlOperation;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlPortBindingOperation {
    protected String portName = null;
    protected Service service = null;
    protected Port port = null;
    protected Binding binding = null;
    protected SOAPBinding soapBinding = null;
    protected String bindingStyle = null;
    protected Map<String, WsdlOperation> operations = null;
    protected List<WsdlOperation> operationsList = null;

    public WsdlPortBindingOperation() {
    }

    public WsdlPortBindingOperation(Service s, Port p, Binding b, SOAPBinding sb) {
        this.setPort(p);
        this.service = s;
        this.binding = b;
        this.soapBinding = sb;
        this.operationsList = new LinkedList<WsdlOperation>();
        this.operations = new HashMap<String, WsdlOperation>();
    }

    public Service getParentService() {
        return this.service;
    }

    public void setParentService(Service s) {
        this.service = s;
    }

    public Port getPort() {
        return this.port;
    }

    public void setPort(Port p) {
        this.port = p;
        this.portName = p.getName();
    }

    public String getPortName() {
        return this.portName;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding bind) {
        this.binding = bind;
    }

    public SOAPBinding getSoapBinding() {
        return this.soapBinding;
    }

    public void setSoapBinding(SOAPBinding sb) {
        this.soapBinding = sb;
    }

    public String getBindingStyle() {
        return this.bindingStyle;
    }

    public void setBindingStyle(String style) {
        this.bindingStyle = style;
    }

    public WsdlOperation getOperation(String opName) {
        return this.operations.get(opName);
    }

    public List getOperationList() {
        return this.operationsList;
    }

    public Map getOperationMap() {
        return this.operations;
    }

    public void addOperation(WsdlOperation op) {
        if (this.operationsList == null) {
            this.operationsList = new LinkedList<WsdlOperation>();
        }
        if (this.operations == null) {
            this.operations = new HashMap<String, WsdlOperation>();
        }
        this.operations.put(op.getName(), op);
        this.operationsList.add(op);
    }

    public void setOperationList(Map<String, WsdlOperation> ops, List<WsdlOperation> list) {
        this.operations = ops;
        this.operationsList = list;
    }

    protected void parseOperations() {
        String bindingStyle = this.soapBinding.getStyle();
        WsdlUtil.trace(" SoapBindingStyle: " + bindingStyle);
        if (bindingStyle == null || bindingStyle.equals("")) {
            bindingStyle = "document";
        }
        List bindingOperations = this.binding.getBindingOperations();
        Iterator i = bindingOperations.iterator();
        while (i.hasNext()) {
            WsdlOperation op = new WsdlOperation((BindingOperation)i.next(), bindingStyle);
            this.addOperation(op);
        }
        if (this.operationsList.size() == 0) {
            throw new ARWSException("INVALID_WSDL", "Not a single document/literal operation");
        }
        this.setBindingStyle(bindingStyle);
    }

    public void createMappingDoc(ARSWebService ws, Document mappingDom, XMLSchemaParser schemaParser, Definition def, StringBuffer warnings) {
        String locationURI = null;
        List extensibilityList = this.port.getExtensibilityElements();
        for (Object obj : extensibilityList) {
            if (!(obj instanceof SOAPAddress)) continue;
            locationURI = ((SOAPAddress)obj).getLocationURI();
        }
        String useStyle = "";
        Iterator<WsdlOperation> i = this.operationsList.iterator();
        if (this.operationsList.size() > 0) {
            useStyle = this.operationsList.get((int)0).useStyle;
        }
        ARSPort arsPort = new ARSPort(this.portName, locationURI, ws.getTargetNamespace(), this.bindingStyle, useStyle);
        while (i.hasNext()) {
            WsdlOperation op = i.next();
            try {
                this.createOperationDoc(op, mappingDom, schemaParser, def, arsPort);
            }
            catch (ARWSException e) {
                warnings.append("WARNING: Ignored method: " + op.getName() + e + System.getProperty("line.separator"));
            }
        }
        ws.addPort(arsPort);
    }

    protected void createOperationDoc(WsdlOperation op, Document mappingDom, XMLSchemaParser schemaParser, Definition def, ARSPort arsport) {
        List inputHeaderList;
        String inputTopElement = "";
        String outputTopElement = "";
        ARSMapping inputMapping = null;
        ARSMapping outputMapping = null;
        if (op.getBindingStyle().equals("rpc")) {
            String namespace;
            if (op.getInputMessage() != null) {
                inputTopElement = op.getName();
                namespace = op.getUseStyle().equals("encoded") ? op.getInputBody().getNamespaceURI() : arsport.getTargetNamespace();
                inputMapping = new ARSMapping(schemaParser, op.getInputMessage(), namespace, mappingDom, op.getUseStyle());
            }
            if (op.getOutputMessage() != null) {
                outputTopElement = op.getName() + "Response";
                namespace = op.getUseStyle().equals("encoded") ? op.getOutputBody().getNamespaceURI() : arsport.getTargetNamespace();
                outputMapping = new ARSMapping(schemaParser, op.getOutputMessage(), namespace, mappingDom, op.getUseStyle());
            }
        } else if (op.getBindingStyle().equals("document")) {
            if (op.getFirstInputPart() != null) {
                inputTopElement = op.getFirstInputPart().getElementName() == null ? "" : op.getFirstInputPart().getElementName().getLocalPart();
                inputMapping = new ARSMapping(schemaParser, op.getFirstInputPart(), mappingDom, op.getUseStyle(), true);
            }
            if (op.getFirstOutputPart() != null) {
                outputTopElement = op.getFirstOutputPart().getElementName() == null ? "" : op.getFirstOutputPart().getElementName().getLocalPart();
                outputMapping = new ARSMapping(schemaParser, op.getFirstOutputPart(), mappingDom, op.getUseStyle(), true);
            }
        }
        if ((inputHeaderList = op.getInputHeaderList()) != null && inputHeaderList.size() > 0) {
            inputMapping.addSoapHeaderList(schemaParser, inputHeaderList, def);
        }
        if (inputMapping != null) {
            arsport.addMapping(inputMapping);
        }
        if (outputMapping != null) {
            arsport.addMapping(outputMapping);
        }
        ARSOperation arsOp = new ARSOperation(op.getName(), op.getSoapActionURI(), inputMapping != null ? inputMapping.getName() : "", inputTopElement, outputMapping != null ? outputMapping.getName() : "", outputTopElement, op.getBindingStyle(), op.getUseStyle(), inputMapping.getTargetNamespace(), outputMapping.getTargetNamespace());
        arsport.addOperation(arsOp);
    }
}

