/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.util;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.mapping.ARSWebService;
import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.BasicHTTPAuthenticator;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.CustomXmlSchemaParser;
import com.bmc.arsys.ws.wsdl.WsdlParser;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import com.bmc.arsys.ws.wsdlgen.WsdlGenerator;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.axis.utils.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WsdlAdminInterface {
    protected String tempDir = "C:\\temp";
    protected int rc = 0;
    protected String errorString = "";
    protected Document outputDocument = null;
    protected boolean outputDocumentIsUTF8 = false;
    protected StringBuffer warnings = new StringBuffer();

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public int getErrorCode() {
        return this.rc;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public String getOutputAsXMLString() {
        StringWriter sw = new StringWriter();
        this.getOutputInWriter(sw);
        return sw.toString();
    }

    protected void exceptionToErrorCode(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String targetMessage = "";
        if (e instanceof ARWSException && ((ARWSException)e).getTargetException() != null) {
            targetMessage = ((ARWSException)e).getTargetException().getMessage() + System.getProperty("line.separator");
        }
        this.errorString = "ERROR: " + e.getMessage() + System.getProperty("line.separator") + System.getProperty("line.separator") + "Additional Details:" + System.getProperty("line.separator") + targetMessage + sw.getBuffer().toString();
        WsdlUtil.trace(this.errorString);
        this.rc = -1;
    }

    public void getOutputAsXMLFile(String outputFile) {
        this.errorString = "";
        this.rc = 0;
        try {
            FileOutputStream fstream = new FileOutputStream(outputFile);
            if (this.outputDocumentIsUTF8) {
                this.getOutputInWriter(new OutputStreamWriter((OutputStream)fstream, "utf-8"));
            } else {
                this.getOutputInWriter(new OutputStreamWriter(fstream));
            }
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
    }

    public void getOutputInWriter(Writer writer) {
        this.errorString = "";
        this.rc = 0;
        if (this.outputDocument == null) {
            this.rc = -1;
            return;
        }
        try {
            if (this.outputDocumentIsUTF8) {
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            } else {
                writer.write("<?xml version=\"1.0\" encoding=\"" + WsdlUtil.getAdminToolEncoding() + "\"?>");
            }
            writer.write(System.getProperty("line.separator"));
            DOM2Writer.serializeAsXML((Node)this.outputDocument.getDocumentElement(), (Writer)writer, (boolean)true, (boolean)true);
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
    }

    public void generateWsdlFromMappingString(String inputMappingString) {
        this.generateWsdlFromMappingString(inputMappingString, null);
    }

    public void generateWsdlFromMappings(String inputMappingString, String schemaInfo) {
        this.generateWsdlFromMappingString(inputMappingString, schemaInfo);
    }

    public void generateWsdlFromMappingString(String inputMappingString, String schemaInfo) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            InputSource is = new InputSource(new StringReader(inputMappingString));
            this.outputDocument = this.generateWsdl(WsdlUtil.newDocument(is), schemaInfo);
            this.outputDocumentIsUTF8 = true;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void generateWsdlFromMappingUri(String uri) {
        this.generateWsdlFromMappingUri(uri, null);
    }

    public void generateWsdlFromMappingUri(String uri, String schemaInfo) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.generateWsdl(WsdlUtil.newDocument(uri, false), schemaInfo);
            this.outputDocumentIsUTF8 = true;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseWSDLIntoMappingString(String uri) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseWsdl(uri);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseWSDLIntoMappingString(String uri, String authUser, String authPass) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseWsdl(uri, authUser, authPass);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseWSDLIntoMappingString(String uri, Authenticator authenticator) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseWsdl(uri, authenticator);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void getTopLevelElementsFromSchemaInfo(String schemaInfo) {
        this.getSchemaTopLevelElementsAsXmlString(schemaInfo);
    }

    public void getSchemaTopLevelElementsAsXmlString(String schemaInfo) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.getSchemaTopLevelElements(schemaInfo);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseXMLSchemaIntoMappingString(String uri) {
        this.parseXMLSchemaIntoMappingString(uri, null, null);
    }

    public void parseXMLSchemaIntoMappingString(String uri, String namespace, String name) {
        this.parseXMLSchemaIntoMappingString(uri, namespace, name, "element");
    }

    public void parseXMLSchemaIntoMappingString(String uri, String namespace, String name, String type) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            this.outputDocument = this.parseXMLSchema(uri, namespace, name, type);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseSchemaInfoIntoMappingString(String schemaInfo, String namespace, String name, String type) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            CustomXmlSchemaParser cSchemaParser = new CustomXmlSchemaParser(this.warnings);
            cSchemaParser.parseSchema(null, schemaInfo);
            String uri = null;
            uri = cSchemaParser.getIsLinked() ? schemaInfo : cSchemaParser.writeSchemasToTempDir(this.tempDir, null, null);
            this.outputDocument = this.parseXMLSchema(uri, namespace, name, type);
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseXSDIntoSchemaInfo(String xsdURI, String oldSchemaInfo) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            CustomXmlSchemaParser cSchemaParser = new CustomXmlSchemaParser(this.warnings);
            cSchemaParser.parseSchema(null, oldSchemaInfo);
            cSchemaParser.parseSchema(null, xsdURI);
            this.outputDocument = cSchemaParser.getSchemaInfo();
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public void parseXSDNResolveMappings(String uri, String currentMappingString) {
        this.errorString = "";
        this.rc = 0;
        this.warnings = new StringBuffer();
        try {
            NodeList list;
            Element webservices;
            InputSource is = new InputSource(new StringReader(currentMappingString));
            Document inputDoc = WsdlUtil.newDocument(is);
            if (inputDoc != null && (webservices = inputDoc.getDocumentElement()) != null && (list = webservices.getElementsByTagName("webservice")) != null) {
                this.outputDocument = WsdlUtil.newDocument();
                Element rootElement = this.outputDocument.createElementNS(null, "webservices");
                this.outputDocument.appendChild(rootElement);
                for (int i = 0; i < list.getLength(); ++i) {
                    Element webservice = (Element)list.item(i);
                    if (webservice == null) continue;
                    ARSWebService ws = new ARSWebService(webservice);
                    ARSWebService ws2 = new ARSWebService(ws, uri, this.warnings);
                    this.outputDocument.getDocumentElement().appendChild(this.outputDocument.importNode(ws2.getElement(), true));
                }
            }
            this.outputDocumentIsUTF8 = false;
        }
        catch (Exception e) {
            this.exceptionToErrorCode(e);
        }
        this.errorString = this.errorString + this.warnings.toString();
    }

    public Document generateWsdl(Document inputMapping, String schemaInfo) {
        NodeList list;
        Element webservices;
        ArrayList<ARSWebService> listServices = new ArrayList<ARSWebService>();
        if (inputMapping != null && (webservices = inputMapping.getDocumentElement()) != null && (list = webservices.getElementsByTagName("webservice")) != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element webservice = (Element)list.item(i);
                if (webservice == null) continue;
                ARSWebService ws = new ARSWebService(webservice);
                listServices.add(ws);
            }
        }
        WsdlGenerator wsdlGenerator = new WsdlGenerator(listServices, schemaInfo, this.warnings);
        return wsdlGenerator.generateWsdl();
    }

    public Document parseWsdl(String uri) {
        WsdlParser wparser = new WsdlParser(uri, this.tempDir, this.warnings);
        return wparser.parseWsdl();
    }

    public Document parseWsdl(String uri, String authUser, String authPass) {
        return this.parseWsdl(uri, new BasicHTTPAuthenticator(authUser, authPass));
    }

    public Document parseWsdl(String uri, Authenticator authenticator) {
        Authenticator.setDefault(authenticator);
        WsdlParser wparser = new WsdlParser(uri, this.tempDir, this.warnings);
        return wparser.parseWsdl();
    }

    public Document parseXMLSchema(String uri, String namespace, String name, String type) {
        QName qName;
        XMLSchemaParser schemaParser = new XMLSchemaParser(uri, this.warnings);
        Document mappingDom = WsdlUtil.newDocument();
        if (name != null && !name.equals("")) {
            qName = new QName(namespace, name);
        } else {
            CustomXmlSchemaParser cSchemaParser = new CustomXmlSchemaParser(this.warnings);
            cSchemaParser.parseSchema(null, uri);
            qName = cSchemaParser.getFirstGlobalElement();
        }
        if (type == null || !type.equals("complexType")) {
            type = "element";
        }
        ARSMapping mapping = new ARSMapping(schemaParser, qName, type, mappingDom);
        mappingDom.appendChild(mapping.getMappingElement());
        return mappingDom;
    }

    public Document getSchemaTopLevelElements(String schemaInfo) {
        CustomXmlSchemaParser schemaParser = new CustomXmlSchemaParser(this.warnings);
        schemaParser.parseSchema(null, schemaInfo);
        if (schemaParser.getFirstGlobalElement() == null && schemaParser.getFirstGlobalComplexType() == null) {
            throw new ARWSException("INVALID_WSDL", "ERROR: no top level elements/complexTypes in this file");
        }
        return schemaParser.getGlobalElementsAndComplexTypes();
    }

    public static void printUsage() {
        System.out.println("Usage");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface generateWSDL <mappingUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface generateWSDLSchemaInfo <mappingUri> <schemaInfoUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface generateWSDLSchemaURI <mappingUri> <schemaUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface parseWsdl <wsdlUri> [<authUser> <authPass>]");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface getGlobals <xsdUri>");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface parseXMLSchema <xsdUri> [<namespace> <name> [<type>]]");
        System.out.println("  java com.bmc.arsys.ws.util.WsdlAdminInterface resolveMappings <schemaUri> <mappingUri>");
    }

    public static String readFile(String fileName) throws FileNotFoundException, IOException {
        FileReader fr = new FileReader(fileName);
        StringBuffer buf = new StringBuffer();
        int c = fr.read();
        while (c != -1) {
            buf.append((char)c);
            c = fr.read();
        }
        return buf.toString();
    }

    public static void main(String[] argv) throws FileNotFoundException, IOException {
        if (argv.length == 0) {
            WsdlAdminInterface.printUsage();
            return;
        }
        WsdlAdminInterface ws = new WsdlAdminInterface();
        ws.setTempDir("C:\\temp");
        if (argv[0].equals("generateWSDL") && argv.length == 2) {
            ws.generateWsdlFromMappingUri(argv[1]);
        } else if (argv[0].equals("generateWSDLSchemaURI") && argv.length == 3) {
            ws.generateWsdlFromMappingUri(argv[1], argv[2]);
        } else if (argv[0].equals("generateWSDLSchemaInfo") && argv.length == 3) {
            ws.generateWsdlFromMappingUri(argv[1], WsdlAdminInterface.readFile(argv[2]));
        } else if (argv[0].equals("parseWsdl") && argv.length == 2) {
            ws.parseWSDLIntoMappingString(argv[1]);
        } else if (argv[0].equals("parseWsdl") && argv.length == 4) {
            ws.parseWSDLIntoMappingString(argv[1], argv[2], argv[3]);
        } else if (argv[0].equals("getGlobals") && argv.length == 2) {
            ws.getSchemaTopLevelElementsAsXmlString(argv[1]);
        } else if (argv[0].equals("parseXMLSchema") && argv.length == 2) {
            ws.parseXMLSchemaIntoMappingString(argv[1]);
        } else if (argv[0].equals("parseXMLSchema") && argv.length == 4) {
            ws.parseXMLSchemaIntoMappingString(argv[1], argv[2], argv[3]);
        } else if (argv[0].equals("parseXMLSchema") && argv.length == 5) {
            ws.parseXMLSchemaIntoMappingString(argv[1], argv[2], argv[3], argv[4]);
        } else if (argv[0].equals("resolveMappings") && argv.length == 3) {
            ws.parseXSDNResolveMappings(argv[1], WsdlAdminInterface.readFile(argv[2]));
        } else {
            WsdlAdminInterface.printUsage();
            return;
        }
        if (ws.getErrorCode() != 0) {
            System.out.println("ERROR: " + ws.getErrorCode() + " " + ws.getErrorString());
        } else {
            if (!ws.getErrorString().equals("")) {
                System.out.println("WARNINGS :" + ws.getErrorString());
            }
            System.out.println(ws.getOutputAsXMLString());
            ws.getOutputAsXMLFile("C:\\temp\\" + argv[0] + ".xml");
        }
    }
}

