/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.client;

import com.bmc.arsys.ws.client.PolicyDetails;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis.MessageContext;
import org.apache.ws.axis.security.WSDoAllReceiver;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;

public class WsPluginReceiver
extends WSDoAllReceiver {
    private static final long serialVersionUID = -8905511215599153916L;
    private PolicyDetails pd = null;

    WsPluginReceiver(PolicyDetails pd) {
        this.pd = pd;
    }

    private Crypto loadCrypto(PolicyDetails pd, Properties prop) throws WSSecurityException {
        String providerVal = prop.getProperty("org.apache.ws.security.crypto.provider");
        if (providerVal == null) {
            throw new WSSecurityException("WSHandler: loadKeyStore: no crypto provider in properties file");
        }
        Crypto crypto = CryptoFactory.getInstance((Properties)prop);
        if (crypto == null) {
            throw new WSSecurityException("WSHandler: Signature: CryptoFactory could not create a crypto");
        }
        try {
            KeyStore ks = crypto.getKeyStore();
            String keyStoreType = null;
            if (ks != null) {
                keyStoreType = ks.getType();
            }
            ks = keyStoreType == null ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance(keyStoreType);
            ByteArrayInputStream bais = new ByteArrayInputStream(pd.getKsBytes());
            String keyStorePass = null;
            Enumeration<Object> e = prop.keys();
            while (e.hasMoreElements()) {
                String o = (String)e.nextElement();
                if (o.indexOf(".keystore.password") <= 0) continue;
                keyStorePass = prop.getProperty(o);
            }
            if (keyStorePass == null) {
                ks.load(bais, null);
            } else {
                ks.load(bais, keyStorePass.toCharArray());
            }
            ((CryptoBase)crypto).setKeyStore(ks);
        }
        catch (KeyStoreException kse) {
            throw new WSSecurityException("unable to create keystore", (Throwable)kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new WSSecurityException("no such algorithm", (Throwable)nsae);
        }
        catch (CertificateException ce) {
            throw new WSSecurityException("certificate exception", (Throwable)ce);
        }
        catch (IOException ioe) {
            throw new WSSecurityException("io exception", (Throwable)ioe);
        }
        return crypto;
    }

    public Crypto loadSignatureCrypto(RequestData reqData) throws WSSecurityException {
        this.setPasswordCallBack(reqData);
        Crypto crypto = null;
        String sigPropFile = this.getString("signaturePropFile", reqData.getMsgContext());
        if (sigPropFile != null) {
            crypto = (Crypto)cryptos.get(sigPropFile);
            if (crypto == null) {
                try {
                    crypto = CryptoFactory.getInstance((String)sigPropFile, (ClassLoader)this.getURlClassLoader(reqData));
                }
                catch (MalformedURLException e) {
                    throw new WSSecurityException("Error loading Crypto instance", (Throwable)e);
                }
                cryptos.put(sigPropFile, crypto);
            }
        } else {
            Properties sigProp = (Properties)this.getOption("SignaturePropRefId");
            if (sigProp != null) {
                crypto = (Crypto)cryptos.get(this.pd.getPolicyId());
                if (crypto == null) {
                    crypto = this.loadCrypto(this.pd, sigProp);
                    cryptos.put(this.pd.getPolicyId(), crypto);
                }
            } else {
                throw new WSSecurityException("WSHandler: Signature: no crypto properties");
            }
        }
        return crypto;
    }

    protected URLClassLoader getURlClassLoader(RequestData reqData) throws MalformedURLException {
        File f = new File(this.pd.getKeystoreFilePath());
        URL url = f.toURI().toURL();
        return new URLClassLoader(new URL[]{url}, this.getClassLoader(reqData.getMsgContext()));
    }

    public Crypto loadEncryptionCrypto(RequestData reqData) throws WSSecurityException {
        this.setPasswordCallBack(reqData);
        Crypto crypto = null;
        String encPropFile = this.getString("encryptionPropFile", reqData.getMsgContext());
        if (encPropFile != null) {
            crypto = (Crypto)cryptos.get(encPropFile);
            if (crypto == null) {
                try {
                    crypto = CryptoFactory.getInstance((String)encPropFile, (ClassLoader)this.getURlClassLoader(reqData));
                }
                catch (MalformedURLException e) {
                    throw new WSSecurityException("Error loading Crypto instance", (Throwable)e);
                }
                cryptos.put(encPropFile, crypto);
            }
        } else {
            Properties encProp = (Properties)this.getOption("encryptionPropRefId");
            if (encProp != null) {
                crypto = (Crypto)cryptos.get(this.pd.getPolicyId());
                if (crypto == null) {
                    crypto = this.loadCrypto(this.pd, encProp);
                    cryptos.put(this.pd.getPolicyId(), crypto);
                }
            } else {
                throw new WSSecurityException("WSHandler: Encryption: no crypto properties");
            }
        }
        return crypto;
    }

    public Crypto loadDecryptionCrypto(RequestData reqData) throws WSSecurityException {
        this.setPasswordCallBack(reqData);
        Crypto crypto = null;
        String encPropFile = this.getString("decryptionPropFile", reqData.getMsgContext());
        if (encPropFile != null) {
            crypto = (Crypto)cryptos.get(encPropFile);
            if (crypto == null) {
                try {
                    crypto = CryptoFactory.getInstance((String)encPropFile, (ClassLoader)this.getURlClassLoader(reqData));
                }
                catch (MalformedURLException e) {
                    throw new WSSecurityException("Error loading Crypto instance", (Throwable)e);
                }
                cryptos.put(encPropFile, crypto);
            }
        } else {
            Properties decProp = (Properties)this.getOption("decryptionPropRefId");
            if (decProp != null) {
                crypto = (Crypto)cryptos.get(this.pd.getPolicyId());
                if (crypto == null) {
                    crypto = this.loadCrypto(this.pd, decProp);
                    cryptos.put(this.pd.getPolicyId(), crypto);
                }
            } else {
                throw new WSSecurityException("WSHandler: Decryption: no crypto properties");
            }
        }
        return crypto;
    }

    protected void setPasswordCallBack(RequestData reqData) {
        Object pwCb = this.getOption("passwordCallbackRef");
        if (pwCb != null && pwCb instanceof CallbackHandler) {
            ((MessageContext)reqData.getMsgContext()).setProperty("passwordCallbackRef", pwCb);
        }
    }
}

