/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.alert;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.ws.client.WebServiceSoapClient;
import java.net.URI;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARAlertPlugin
extends ARFilterAPIPlugin {
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ALRT.WEBSERVICE", this);
    private static final int AR_ALRT_MAX_PARAMS = 5;

    public static void init(ARPluginContext context) {
        System.out.println("Static initialize method invoked");
        System.out.println("UserDefined value for alert web services ");
    }

    @Override
    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException {
        if (pInValues.size() != 5) {
            this.ThrowException("Invalid number of parameters for Web Service call");
        }
        try {
            String[] arguments = new String[19];
            String fragment = null;
            URI endpointURI = null;
            String protocol = null;
            int indx = -1;
            String endpoint = pInValues.get(3).toString();
            if (endpoint.startsWith("http://")) {
                indx = 5;
                protocol = new String("http");
            } else if (endpoint.startsWith("https://")) {
                indx = 6;
                protocol = new String("https");
            }
            if (indx >= 0) {
                if ((indx = (endpoint = endpoint.substring(indx)).indexOf("#")) >= 0) {
                    fragment = endpoint.substring(indx + 1);
                    endpoint = endpoint.substring(0, indx);
                }
                if (endpoint != null) {
                    endpointURI = new URI(protocol, endpoint, fragment);
                }
            } else {
                endpointURI = new URI(endpoint);
            }
            context.logMessage(this.pluginInfo, 0, "endpoint " + endpoint);
            context.logMessage(this.pluginInfo, 0, "rempart " + fragment);
            arguments[0] = new String("c4245525-eeff-460b-a51a-79820047329f");
            arguments[1] = new String("WebServiceSoapClient");
            arguments[2] = new String("call");
            arguments[3] = new String("([Ljava/lang/String;)Ljava/lang/String;");
            arguments[4] = new String("");
            arguments[5] = new String("ARAlertNotification");
            arguments[6] = new String("<operation bindingStyle=\"document\" name=\"Notify\" soapActionURI=\"urn:Alert Notification/Notify\" type=\"create\" useStyle=\"literal\"><inputMapping name=\"Create\" namespace=\"urn:Alert Notification\" topLevelElement=\"Notify\"/><outputMapping name=\"CreateResponse\" namespace=\"urn:Alert Notification\" topLevelElement=\"NotifyResponse\"/></operation>");
            arguments[7] = endpointURI.toString();
            arguments[8] = new String("urn:Alert Notification");
            arguments[9] = null;
            arguments[10] = null;
            arguments[11] = new String("<ns0:ROOT xmlns:ns0=\"urn:urn:Alert Notification\" xmlns:ns1=\"urn:Alert Notification\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><ns1:Registered_user>" + pInValues.get(0) + "</ns1:Registered_user>" + "<ns1:Alert_Text>" + pInValues.get(2) + "</ns1:Alert_Text>" + "<ns1:Alert_ID>" + pInValues.get(1) + "</ns1:Alert_ID>" + "</ns0:ROOT>");
            context.logMessage(this.pluginInfo, 0, "before calling WebService method");
            String returnString = WebServiceSoapClient.call(context, this.pluginInfo, arguments);
            Vector<Value> list = new Vector<Value>();
            Value value = new Value(returnString);
            list.add(value);
            return list;
        }
        catch (Exception e) {
            this.ThrowException(e.getMessage());
            return null;
        }
    }

    private void ThrowException(String appendedText) throws ARException {
        throw new ARException(2, 9130, appendedText);
    }

    @Override
    public void initialize(ARPluginContext context) throws ARException {
    }

    @Override
    public void onEvent(ARPluginContext context, int pEventID) throws ARException {
    }

    @Override
    public void terminate(ARPluginContext context) throws ARException {
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 2 && argv[0].equals("testAlert")) {
            ARAlertPlugin.testAlert(argv[1]);
        } else {
            System.out.println("Usage:");
            System.out.println("   java WebServiceSoapClient testAlert Hello");
        }
    }

    public static String testAlert(String isbn) throws Exception {
        String[] inputValues = new String[]{"c4245525-eeff-460b-a51a-79820047329f", "WebServiceSoapClient", "call", "([Ljava/lang/String;)Ljava/lang/String;", "", "ARAlertNotification", "<operation name=\"getPrice\" type=\"create\" useStyle=\"encoded\" bindingStyle=\"rpc\"><inputMapping name=\"getPriceRequest\" topLevelElement=\"getPrice\"/><outputMapping name=\"getPriceResponse\" topLevelElement=\"getPriceResponse\"/></operation>", "http://services.xmethods.net:80/soap/servlet/rpcrouter", "urn:xmethods-BNPriceCheck", "dummy-inputMap", "dummy-outputMap", "<ROOT xmlns=\"urn:BNQuoteService\" xmlns:ns1=\"urn:xmethods-BNPriceCheck\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  ><ns1:isbn xsi:type=\"xsd:string\">" + isbn + "</ns1:isbn>" + "</ROOT>"};
        return WebServiceSoapClient.call(null, null, inputValues);
    }
}

