/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Action;
import com.bmc.arsys.api.ActiveLinkAction;
import com.bmc.arsys.api.ActiveLinkGuide;
import com.bmc.arsys.api.AlertMessageCriteria;
import com.bmc.arsys.api.ApplicationContainer;
import com.bmc.arsys.api.ArchiveInfo;
import com.bmc.arsys.api.ArithOpAssignInfo;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AssignFieldInfo;
import com.bmc.arsys.api.AssignFilterApiInfo;
import com.bmc.arsys.api.AssignInfo;
import com.bmc.arsys.api.AssignSQLInfo;
import com.bmc.arsys.api.AttachmentField;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.AuditInfo;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.COMMethodInfo;
import com.bmc.arsys.api.COMMethodParmInfo;
import com.bmc.arsys.api.COMValueInfo;
import com.bmc.arsys.api.CallGuideAction;
import com.bmc.arsys.api.ChangeFieldAction;
import com.bmc.arsys.api.CharacterField;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.CloseWindowAction;
import com.bmc.arsys.api.ColumnField;
import com.bmc.arsys.api.ColumnFieldLimit;
import com.bmc.arsys.api.CommitChangesAction;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.ContainerType;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CurrencyDetail;
import com.bmc.arsys.api.CurrencyField;
import com.bmc.arsys.api.CurrencyFieldLimit;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DDEAction;
import com.bmc.arsys.api.DataDictionaryMenu;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DateOnlyField;
import com.bmc.arsys.api.DateTimeField;
import com.bmc.arsys.api.DayInfo;
import com.bmc.arsys.api.DecimalField;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.DiaryField;
import com.bmc.arsys.api.DiaryFieldLimit;
import com.bmc.arsys.api.DiaryItem;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.DirectSqlAction;
import com.bmc.arsys.api.DisplayField;
import com.bmc.arsys.api.DisplayFieldLimit;
import com.bmc.arsys.api.DisplayInstanceMap;
import com.bmc.arsys.api.DisplayOnlyForm;
import com.bmc.arsys.api.DisplayPropertyMap;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryKey;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EnumItem;
import com.bmc.arsys.api.EscalationInterval;
import com.bmc.arsys.api.EscalationTime;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.ExitGuideAction;
import com.bmc.arsys.api.ExternalReference;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldAssignInfo;
import com.bmc.arsys.api.FieldDataDictionaryMenu;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.FieldMapping;
import com.bmc.arsys.api.FileMenu;
import com.bmc.arsys.api.FilterAction;
import com.bmc.arsys.api.FilterGuide;
import com.bmc.arsys.api.FilterMessageAction;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormDataDictionaryMenu;
import com.bmc.arsys.api.FormType;
import com.bmc.arsys.api.FunctionAssignInfo;
import com.bmc.arsys.api.GotoAction;
import com.bmc.arsys.api.GotoGuideLabelAction;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.ImageData;
import com.bmc.arsys.api.IndexInfo;
import com.bmc.arsys.api.IntegerField;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.JoinFieldMapping;
import com.bmc.arsys.api.JoinForm;
import com.bmc.arsys.api.Keyword;
import com.bmc.arsys.api.ListMenu;
import com.bmc.arsys.api.LocalizedRequestInfo;
import com.bmc.arsys.api.LocalizedValueCriteria;
import com.bmc.arsys.api.LogAction;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuItem;
import com.bmc.arsys.api.MessageAction;
import com.bmc.arsys.api.NotifyAction;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OleAutomationAction;
import com.bmc.arsys.api.OpenWindowAction;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.PackingList;
import com.bmc.arsys.api.PermissionInfo;
import com.bmc.arsys.api.PropInfo;
import com.bmc.arsys.api.PushFieldsAction;
import com.bmc.arsys.api.PushFieldsInfo;
import com.bmc.arsys.api.QualifierFromFieldInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.QueryMenu;
import com.bmc.arsys.api.QuerySourceForm;
import com.bmc.arsys.api.RealField;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.RecursiveQuery;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.RegularFieldMapping;
import com.bmc.arsys.api.RegularForm;
import com.bmc.arsys.api.RegularQuery;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.RunMacroAction;
import com.bmc.arsys.api.RunProcessAction;
import com.bmc.arsys.api.SelectionField;
import com.bmc.arsys.api.SelectionFieldLimit;
import com.bmc.arsys.api.ServerInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SetFieldsAction;
import com.bmc.arsys.api.SetFieldsFromFilterAPI;
import com.bmc.arsys.api.SetFieldsFromSQL;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.SqlMenu;
import com.bmc.arsys.api.StatusHistoryItem;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.TableField;
import com.bmc.arsys.api.TableFieldLimit;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.TimeOnlyField;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ValueSetQuery;
import com.bmc.arsys.api.VendorFieldMapping;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.ViewDisplayPropertyMap;
import com.bmc.arsys.api.ViewField;
import com.bmc.arsys.api.ViewFieldLimit;
import com.bmc.arsys.api.ViewFieldMapping;
import com.bmc.arsys.api.ViewForm;
import com.bmc.arsys.api.ViewKey;
import com.bmc.arsys.api.WaitAction;
import com.bmc.arsys.api.WebService;
import com.bmc.arsys.api.WfdBreakpoint;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.LocaleCharSet;
import com.bmc.arsys.demo.javadriver.OutputWriter;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputReader {
    static Stack<Object> inputSources = new Stack();
    static BufferedReader currentInputSource = new BufferedReader(new InputStreamReader(System.in));
    static boolean nullPromptOption = false;

    public static void setNullPromptOption(boolean value) {
        nullPromptOption = value;
    }

    public static boolean getNullPromptOption() {
        return nullPromptOption;
    }

    public static void getInputLine() throws IOException {
        String inputLine = null;
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        BufferedReader currentInputFile = threadControlBlockPtr.getCurrentInputFile();
        inputLine = currentInputFile.readLine();
        if (inputLine == null) {
            if (threadControlBlockPtr.isCurrentInputSourceStdInput()) {
                JavaDriver.outputWriter.driverPrintError("\n*** EOF on input file; exiting ***\n");
                System.exit(1);
            }
            threadControlBlockPtr.closeCurrentInputFile();
            InputReader.getInputLine();
            return;
        }
        threadControlBlockPtr.addToCurrentInputFilePosition(inputLine.length());
        PrintWriter fp = threadControlBlockPtr.getRecordFile();
        if (fp != null && !inputLine.equals("srec")) {
            fp.write(inputLine);
            fp.write("\n");
        }
        int index = 0;
        for (index = inputLine.length() - 1; index >= 0 && inputLine.charAt(index) == ' ' && inputLine.charAt(index) == '\t' && inputLine.charAt(index) == '\n'; --index) {
        }
        threadControlBlockPtr.setBuffer(inputLine.substring(0, index + 1));
        if (inputLine.length() >= 1 && inputLine.charAt(0) == '#' && threadControlBlockPtr.processCommentLine(inputLine) && !threadControlBlockPtr.getIsStdOut()) {
            JavaDriver.outputWriter.printResult(inputLine + "\n");
        }
    }

    public static boolean getBoolean(String prompt, boolean defaultVal) throws IOException {
        if (!InputReader.getNullPromptOption()) {
            return defaultVal;
        }
        return InputReader.getBooleanForChangingInfo(prompt, defaultVal);
    }

    public static boolean getBooleanForChangingInfo(String prompt, boolean defaultVal) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(prompt);
        boolean val = defaultVal;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        String input = threadControlBlockPtr.getBuffer();
        if (input.length() != 0) {
            val = input.equals("t") || input.equals("true") || input.equals("T");
        }
        return val;
    }

    public static int getInt(int defaultVal) throws IOException {
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        String input = threadControlBlockPtr.getBuffer();
        int value = defaultVal;
        if (input.length() != 0) {
            try {
                Integer val = new Integer(input);
                value = val;
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        return value;
    }

    public static int getInt(String prompt, int defaultVal) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(prompt);
        return InputReader.getInt(defaultVal);
    }

    public static long getLong(String prompt, long defaultVal) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(prompt);
        long value = defaultVal;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        String input = threadControlBlockPtr.getBuffer();
        if (input.length() != 0) {
            try {
                Long val = new Long(input);
                value = val;
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        return value;
    }

    public static double getDouble(String prompt, double defaultVal) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(prompt);
        double value = defaultVal;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        String input = threadControlBlockPtr.getBuffer();
        if (input.length() != 0) {
            try {
                Double val = new Double(input);
                value = val;
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        return value;
    }

    public static char getChar(String prompt, char defaultVal) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(prompt);
        char value = defaultVal;
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        String input = threadControlBlockPtr.getBuffer();
        if (input.length() != 0) {
            value = input.charAt(0);
        }
        return value;
    }

    public static String getString(String prompt, String defaultVal) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(prompt);
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        String value = threadControlBlockPtr.getBuffer();
        if (value == null || value.length() == 0) {
            return defaultVal;
        }
        ARServerUser tmpContext = threadControlBlockPtr.getContext();
        if (tmpContext != null) {
            if (value.equals("$USER$") && tmpContext.getUser() != null) {
                threadControlBlockPtr.setBuffer(tmpContext.getUser());
            }
            if (value.equals("$SERVER$")) {
                threadControlBlockPtr.setBuffer(tmpContext.getServer());
            }
            if (value.equals("$FIRST_LIST_ID$")) {
                threadControlBlockPtr.setBuffer(threadControlBlockPtr.getFirstListId());
            }
            if (value.equals("$SECOND_LIST_ID$")) {
                threadControlBlockPtr.setBuffer(threadControlBlockPtr.getSecondListId());
            }
            if (value.equals("$LAST_LIST_ID$")) {
                threadControlBlockPtr.setBuffer(threadControlBlockPtr.getLastListId());
            }
        }
        if ((value = threadControlBlockPtr.getBuffer()) == null || value.length() == 0) {
            return defaultVal;
        }
        return value;
    }

    public static Time getTimeOfDay(String prompt, Time defaultTime) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt(prompt + "(" + defaultTime.getValue() + "): ");
        Time timeOfDay = new Time(defaultTime.getValue());
        InputReader.getInputLine();
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        String s = threadControlBlockPtr.getBuffer();
        if (s.length() != 0) {
            Long val = new Long(s);
            timeOfDay.setValue(val);
        }
        return timeOfDay;
    }

    public static Timestamp getTimestamp(String prompt, Timestamp defaultTime) throws IOException {
        if (InputReader.getBoolean("Null Timestamp (F): ", false)) {
            return null;
        }
        String input = InputReader.getString(prompt, "");
        Timestamp time = new Timestamp(defaultTime.getValue());
        if (input.length() != 0) {
            Long val = new Long(input);
            time.setValue(val);
        }
        return time;
    }

    public static Timestamp[] getTimestampArray() throws IOException {
        Timestamp[] timestampList = null;
        int numItems = InputReader.getInt("Number of Timestamps (0): ", 0);
        if (numItems != 0) {
            timestampList = new Timestamp[numItems];
            for (int i = 0; i < numItems; ++i) {
                timestampList[i] = InputReader.getTimestamp("   Timestamp: (0)", new Timestamp(0L));
            }
        }
        return timestampList;
    }

    public static List<Timestamp> getTimestampList() throws IOException {
        Timestamp[] array = InputReader.getTimestampArray();
        return new ArrayList<Timestamp>(Arrays.asList(array));
    }

    public static int[] getInternalIDList() throws IOException {
        int[] idList = null;
        int numItems = InputReader.getInt("  Number of ids( 0 ): ", 0);
        if (numItems != 0) {
            idList = new int[numItems];
            for (int i = 0; i < numItems; ++i) {
                idList[i] = InputReader.getInt("    Id  " + i + " ( 1 ): ", 1);
            }
        }
        return idList;
    }

    public static List<Integer> getInternalIDArrayList() throws IOException {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        int numItems = InputReader.getInt("  Number of ids( 0 ): ", 0);
        if (numItems != 0) {
            for (int i = 0; i < numItems; ++i) {
                idList.add(InputReader.getInt("    Id  " + i + " ( 1 ): ", 1));
            }
        }
        return idList;
    }

    public static List<Integer> getIntegerList() throws IOException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int numItems = InputReader.getInt("  Number of ids( 0 ): ", 0);
        if (numItems != 0) {
            for (int i = 0; i < numItems; ++i) {
                list.add(new Integer(InputReader.getInt("    Id  " + i + " ( 1 ): ", 1)));
            }
        }
        return list;
    }

    public static FormType[] getFormTypeList() throws IOException {
        FormType[] formTypeList = null;
        int numItems = InputReader.getInt("  Number of  Values( 0 ): ", 0);
        if (numItems != 0) {
            formTypeList = new FormType[numItems];
            for (int i = 0; i < numItems; ++i) {
                formTypeList[i] = InputReader.getFormType();
            }
        }
        return formTypeList;
    }

    public static String[] getStringArray(String indent, String header) throws IOException {
        int numItems;
        String[] nameList = null;
        if (header == null || header.length() == 0) {
            header = "item";
        }
        if ((numItems = InputReader.getInt(indent + "Number of " + header + "s (0): ", 0)) != 0) {
            nameList = new String[numItems];
            for (int i = 0; i < numItems; ++i) {
                nameList[i] = InputReader.getString(indent + header + "(" + i + "): ", "");
            }
        }
        return nameList;
    }

    public static List<String> getStringList(String indent, String header) throws IOException {
        String[] array = InputReader.getStringArray(indent, header);
        if (array != null) {
            return new ArrayList<String>(Arrays.asList(array));
        }
        return null;
    }

    public static String[] getApplicationKeyList(String indent) throws IOException {
        String[] nameList = null;
        int numItems = InputReader.getInt(indent + "Number of application keys (0): ", 0);
        if (numItems != 0) {
            nameList = new String[numItems];
            for (int i = 0; i < numItems; ++i) {
                nameList[i] = InputReader.getString(indent + "Name " + "(" + i + "): ", "");
            }
        }
        return nameList;
    }

    public static void getARServerUser() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Control record:\n");
        ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
        ARServerUser serverUser = threadControlBlockPtr.getContext();
        String authentication = null;
        authentication = serverUser.getAuthentication() != null ? InputReader.getString("   Authentication String (" + serverUser.getAuthentication() + "): ", serverUser.getAuthentication()) : InputReader.getString("   Authentication String (): ", "");
        serverUser.setAuthentication(authentication);
        String name = null;
        name = serverUser.getUser() != null && serverUser.getUser() != null ? InputReader.getString("   User name (" + serverUser.getUser() + "): ", serverUser.getUser()) : InputReader.getString("   User name (): ", "");
        serverUser.setUser(name);
        String password = null;
        password = serverUser.getPassword() != null && serverUser.getPassword() != null ? InputReader.getString("   Password (" + serverUser.getPassword() + "): ", serverUser.getPassword()) : InputReader.getString("   Password(): ", "");
        serverUser.setPassword(password);
        String localeStr = null;
        LocaleCharSet localeCharSet = new LocaleCharSet();
        if (serverUser.getLocale() != null) {
            localeCharSet.setLocale(serverUser.getLocale());
            String dispStr = localeCharSet.toString();
            localeStr = InputReader.getString("   Locale (" + dispStr + "): ", dispStr);
        } else {
            localeStr = InputReader.getString("   Locale : ", "");
        }
        localeCharSet.parseLocaleAndCharSet(localeStr);
        serverUser.setLocale(localeCharSet.getLocale());
        String timeZone = null;
        timeZone = serverUser.getTimeZone() != null ? InputReader.getString("   TimeZone (" + serverUser.getTimeZone() + "): ", serverUser.getTimeZone()) : InputReader.getString("   TimeZone () : ", "");
        serverUser.setTimeZone(timeZone);
        String server = null;
        server = serverUser.getServer() != null ? InputReader.getString("   Server (" + serverUser.getServer() + "): ", serverUser.getServer()) : InputReader.getString("   Server () : ", "");
        serverUser.setServer(server);
    }

    public static FilterMessageAction getFilterStatusInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Status Info:\n");
        if (InputReader.getBoolean("Null Filter Status Info (F): ", false)) {
            return null;
        }
        int messageType = InputReader.getInt("   Note, Warning, or Error (0, 1, 2) (2) : ", 2);
        int messageNumber = InputReader.getInt("   Message number (0): ", 0);
        String messageText = InputReader.getString("   Message Text():  ", "");
        return new FilterMessageAction(messageType, messageNumber, messageText);
    }

    public static MessageAction getMessageInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Message Info:\n");
        if (InputReader.getBoolean("Null Message Info (F): ", false)) {
            return null;
        }
        int messageType = InputReader.getInt("   Note, Warning, Error, Prompt, Accessible hint or Tooltip (0, 1, 2, 5, 6, 7)(2) : ", 2);
        int messageNumber = InputReader.getInt("   Message number (10000): ", 10000);
        String messageText = InputReader.getString("   Message Text():  ", "");
        boolean usePane = InputReader.getBooleanForChangingInfo("   Use Prompting Pane? (T): ", true);
        return new MessageAction(messageType, messageNumber, messageText, usePane);
    }

    public static List<CoordinateInfo> getCoordinateInfoList() throws IOException {
        ArrayList<CoordinateInfo> coordinates = null;
        int numberOfItems = InputReader.getInt("Number of Items in the List (0): ", 0);
        if (numberOfItems != 0) {
            coordinates = new ArrayList<CoordinateInfo>(numberOfItems);
            for (int i = 0; i < numberOfItems; ++i) {
                int x = InputReader.getInt("x (" + i + "): ", 0);
                int y = InputReader.getInt("y (" + i + "): ", 0);
                coordinates.add(new CoordinateInfo(x, y));
            }
        }
        return coordinates;
    }

    public static ByteListValue getByteListInfo() throws IOException {
        if (InputReader.getBoolean("Null ByteListInfo (F): ", false)) {
            return null;
        }
        byte[] byteArray = null;
        int type = InputReader.getInt("Byte List Type (0): ", 0);
        int numberOfBytes = InputReader.getInt("Number of Items in the List (0): ", 0);
        if (numberOfBytes != 0) {
            byteArray = new byte[numberOfBytes];
            for (int i = 0; i < numberOfBytes; ++i) {
                byteArray[i] = (byte)InputReader.getChar("Byte (" + i + "): ", '0');
            }
        }
        return new ByteListValue(type, byteArray);
    }

    public static AttachmentValue getAttachmentInfo() throws IOException {
        if (InputReader.getBoolean("Null AttachmentInfo (F): ", false)) {
            return null;
        }
        String name = InputReader.getString("Attachment Name(): ", "");
        int choice = InputReader.getInt("Choose:\n   1 - prompt for filename,\n   2 - prompt for string\n   default (1): ", 1);
        if (choice < 1 || choice > 2) {
            JavaDriver.outputWriter.driverPrintWarning("   ERROR: choice outside range 1-4; defaulting to prompt for filename(1)");
            choice = 1;
        }
        if (choice == 1) {
            File fp;
            String cname = null;
            if (!InputReader.getBoolean("Null FileName? (F):", false)) {
                cname = InputReader.getString("File Name ():", "");
            }
            if ((fp = new File(cname)).exists() && fp.canRead()) {
                return new AttachmentValue(name, cname);
            }
            JavaDriver.outputWriter.driverPrintError("  ERROR: failed to open file\n");
            return null;
        }
        String content = InputReader.getString("Enter String(): ", "");
        return new AttachmentValue(name, content.getBytes());
    }

    public static Value getValue() throws IOException, ARException {
        return InputReader.getValue("");
    }

    public static Value getValue(String indent) throws IOException, ARException {
        if (InputReader.getBoolean(indent + "Null Value (F): ", false)) {
            return null;
        }
        int dataType = indent == "" ? InputReader.getInt("Datatype Null/Key/Int/Real/Char/DiaryList/Enum/Time/Bitmask/Byte\n    Decimal/attach/currency/date/timeofday/join/trim/control/Table/Column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (0): ", 0) : InputReader.getInt(indent + "Datatype Null/Key/Int/Real/Char/DiaryList/Enum/Time/Bitmask/Byte/Decimal/attach/currency/date/timeofday/join/trim/control/Table/Column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (0): ", 0);
        Value val = InputReader.getValue(dataType, indent);
        return val;
    }

    public static Value getValue(int dataType) throws IOException, ARException {
        return InputReader.getValue(dataType, "");
    }

    public static Value getValue(int dataType, String indent) throws IOException, ARException {
        Value val = null;
        switch (dataType) {
            case 0: {
                val = new Value();
                break;
            }
            case 1: {
                int keycode = InputReader.getInt(indent + "Keyword Code (0): ", 0);
                val = new Value(Keyword.toKeyword(keycode));
                break;
            }
            case 2: {
                int intVal = InputReader.getInt(indent + "Integer Value (0): ", 0);
                val = new Value(intVal);
                break;
            }
            case 3: {
                double doubleVal = InputReader.getDouble(indent + "Real Value (0.0): ", 0.0);
                val = new Value(doubleVal);
                break;
            }
            case 4: {
                String name = InputReader.getString(indent + "Char Value (): ", "");
                val = new Value(name);
                break;
            }
            case 5: {
                String dairyValue = InputReader.getString(indent + "DiaryList Value (): ", "");
                DiaryListValue diaryList = new DiaryListValue();
                diaryList.setAppendedText(dairyValue);
                val = new Value(diaryList);
                break;
            }
            case 6: {
                int enumVal = InputReader.getInt(indent + "Enum Value( 0 ): ", 0);
                val = new Value((Object)enumVal, DataType.ENUM);
                break;
            }
            case 7: {
                Timestamp timeStamp = InputReader.getTimestamp(indent + "Time Value (0):", new Timestamp(0L));
                val = new Value(timeStamp);
                break;
            }
            case 14: {
                Time timeOfDay = InputReader.getTimeOfDay(indent + "Time Of Day Value(0):", new Time(0L));
                val = new Value(timeOfDay);
                break;
            }
            case 8: {
                long maskVal = InputReader.getLong("indent + Bitmask Value (0): ", 0L);
                val = new Value(maskVal, DataType.BITMASK);
                break;
            }
            case 9: {
                ByteListValue byteList = InputReader.getByteListInfo();
                val = new Value(byteList);
                break;
            }
            case 30: {
                val = new Value(null, DataType.JOIN);
                break;
            }
            case 31: {
                val = new Value(null, DataType.TRIM);
                break;
            }
            case 32: {
                val = new Value(null, DataType.CONTROL);
                break;
            }
            case 35: {
                val = new Value(null, DataType.PAGE);
                break;
            }
            case 36: {
                val = new Value(null, DataType.PAGE_HOLDER);
                break;
            }
            case 37: {
                val = new Value(null, DataType.ATTACHMENT_POOL);
                break;
            }
            case 40: {
                long ulongVal = InputReader.getLong("indent + Ulong Value (0): ", 0L);
                val = new Value(ulongVal, DataType.ULONG);
                break;
            }
            case 41: {
                List<CoordinateInfo> coords = InputReader.getCoordinateInfoList();
                val = new Value(coords);
                break;
            }
            case 11: {
                AttachmentValue attach = InputReader.getAttachmentInfo();
                val = new Value(attach);
                break;
            }
            case 10: {
                String decimalString = InputReader.getString(indent + "Decimal Value ():", "");
                InputReader.checkDecimalFormat(decimalString);
                BigDecimal decimalValue = new BigDecimal(decimalString);
                val = new Value(decimalValue);
                break;
            }
            case 12: {
                String value = InputReader.getString(indent + "Value (0.0):", "");
                InputReader.checkDecimalFormat(value);
                String currencyCode = InputReader.getString(indent + "CurrencyCode (USD):", "USD");
                Timestamp conversionDate = InputReader.getTimestamp(indent + "Conversion Date (0):", new Timestamp(0L));
                CurrencyValue currencyInfo = new CurrencyValue(value, currencyCode, conversionDate, null);
                val = new Value(currencyInfo);
                break;
            }
            case 42: {
                String view = InputReader.getString(indent + "View Value (): ", "");
                val = new Value(view, DataType.VIEW);
                break;
            }
            case 43: {
                String display = InputReader.getString(indent + "Display Value (): ", "");
                val = new Value(display, DataType.DISPLAY);
                break;
            }
            case 13: {
                String date = InputReader.getString(indent + "Date Value ()[YYYY-MM-DD]: ", "");
                val = new Value(new DateInfo(DateInfo.dateToJulianDate("yyyy-MM-dd", date)), DataType.DATE);
                break;
            }
        }
        return val;
    }

    public static List<Value> getValueList() throws IOException, ARException {
        ArrayList<Value> valueList = null;
        int numberOfValues = InputReader.getInt("   Number of values (0): ", 0);
        if (numberOfValues != 0) {
            valueList = new ArrayList<Value>(numberOfValues);
            for (int i = 0; i < numberOfValues; ++i) {
                valueList.add(InputReader.getValue());
            }
        }
        return valueList;
    }

    public static EntryListFieldInfo getEntryListFieldInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Entry list field Info\n");
        if (InputReader.getBoolean("Null EntryListFieldInfo (F): ", false)) {
            return null;
        }
        int fieldId = InputReader.getInt("      Field id (0): ", 0);
        int columnWidth = InputReader.getInt("      Column width (20): ", 20);
        String separator = InputReader.getString("      Separator(  ): ", "  ");
        return new EntryListFieldInfo(fieldId, columnWidth, separator);
    }

    public static List<EntryListFieldInfo> getEntryListFieldInfoList() throws IOException {
        ArrayList<EntryListFieldInfo> entryListFieldList = null;
        int numItems = InputReader.getInt("Number of  query list fields (0): ", 0);
        if (numItems != 0) {
            entryListFieldList = new ArrayList<EntryListFieldInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                entryListFieldList.add(InputReader.getEntryListFieldInfo());
            }
        }
        return entryListFieldList;
    }

    public static StatusHistoryValueIndicator getStatusHistoryValue() throws IOException {
        if (InputReader.getBoolean("Null StatusHistoryValue (F): ", false)) {
            return null;
        }
        int index = InputReader.getInt("Enumerated value index (0): ", 0);
        int userOrTime = InputReader.getInt("User or Time field (1 or 2) (2): ", 2);
        boolean type = true;
        if (userOrTime == 2) {
            type = false;
        }
        return new StatusHistoryValueIndicator(type, index);
    }

    public static CurrencyPartInfo getCurrencyPartInfo() throws IOException {
        int id = InputReader.getInt("Currency Field Id (0): ", 0);
        int partTag = InputReader.getInt("Currency Part - Field,Value,Type,Date,Functional (0-4) (0): ", 0);
        String currencyCode = null;
        if (partTag == 4) {
            currencyCode = InputReader.getString("Functional currency code:", "");
        }
        return new CurrencyPartInfo(id, partTag, currencyCode);
    }

    public static ArithmeticOrRelationalOperand getArithmeticOrRelationalOperand(List<IQuerySource> fieldSources, String indent) throws IOException, ARException {
        if (InputReader.getBoolean("Null ArithmeticOrRelationalOperand (F): ", false)) {
            return null;
        }
        OperandType opType = null;
        boolean promptSources = fieldSources != null && fieldSources.size() > 0;
        int operation = !promptSources ? InputReader.getInt("Fld,Value,Arith,Stat-Hist,Val-Set,Currency,Fld-Tran,Fld-DB,L-Var,\nQuery,Currency-Tran,Currency-DB,Currency-Current,Fld-Current (1-6,50-56,99): ", 0) : InputReader.getInt("Fld,Value,Arith,Stat-Hist,Val-Set,Currency,Val-Set Query,Fld-Tran,Fld-DB,L-Var,Query,Currency-Tran,Currency-DB,Currency-Current,Fld-Current (1-7,50-56,99): ", 0);
        ArithmeticOrRelationalOperand arithOrRlOperand = null;
        opType = OperandType.getOperandType(operation);
        switch (operation) {
            case 1: 
            case 50: 
            case 51: 
            case 99: {
                if (promptSources) {
                    arithOrRlOperand = new ArithmeticOrRelationalOperand(InputReader.getQueryFormField(fieldSources, indent));
                    break;
                }
                int fldId = InputReader.getInt(indent + "Field id (0): ", 0);
                arithOrRlOperand = new ArithmeticOrRelationalOperand(opType, fldId);
                break;
            }
            case 2: {
                Value val = InputReader.getValue(indent);
                arithOrRlOperand = new ArithmeticOrRelationalOperand(val);
                break;
            }
            case 3: {
                ArithmeticOperationInfo aropInfo = InputReader.getArithmeticOperationInfo(indent);
                arithOrRlOperand = new ArithmeticOrRelationalOperand(aropInfo);
                break;
            }
            case 4: {
                StatusHistoryValueIndicator stHistoryVal = InputReader.getStatusHistoryValue();
                arithOrRlOperand = new ArithmeticOrRelationalOperand(stHistoryVal);
                break;
            }
            case 5: {
                List<Value> valList = InputReader.getValueList();
                arithOrRlOperand = new ArithmeticOrRelationalOperand(valList);
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                CurrencyPartInfo currencyPartInfo = InputReader.getCurrencyPartInfo();
                arithOrRlOperand = new ArithmeticOrRelationalOperand(opType, currencyPartInfo);
                break;
            }
            case 52: {
                int variable = InputReader.getInt("Local Variable number (0 to 10) (0): ", 0);
                arithOrRlOperand = new ArithmeticOrRelationalOperand(variable);
                break;
            }
            case 53: {
                QueryInfo qInfo = InputReader.getQueryInfo();
                arithOrRlOperand = new ArithmeticOrRelationalOperand(qInfo);
                break;
            }
            case 7: {
                ValueSetQuery queryValSet = InputReader.getValueSetQuery(indent + "      ");
                arithOrRlOperand = new ArithmeticOrRelationalOperand(queryValSet);
                break;
            }
            default: {
                JavaDriver.outputWriter.driverPrintWarning(indent + "Invalid operation..");
            }
        }
        return arithOrRlOperand;
    }

    public static ArithmeticOperationInfo getArithmeticOperationInfo(String indent) throws IOException, ARException {
        return InputReader.getArithmeticOperationInfo(null, indent);
    }

    public static ArithmeticOperationInfo getArithmeticOperationInfo(List<IQuerySource> fieldSources, String indent) throws IOException, ARException {
        if (InputReader.getBoolean(indent + "Null ArithmeticOperationInfo (F): ", false)) {
            return null;
        }
        ArithmeticOrRelationalOperand leftOperand = null;
        ArithmeticOrRelationalOperand rightOperand = null;
        int operation = InputReader.getInt(indent + "Arithmetic op code -- +, -, *, /, %, unary - (1 - 6): ", 1);
        if (operation != 6) {
            JavaDriver.outputWriter.driverPrintPrompt(indent + "Left Operand - ");
            leftOperand = InputReader.getArithmeticOrRelationalOperand(fieldSources, indent);
        }
        JavaDriver.outputWriter.driverPrintPrompt(indent + "Right Operand - ");
        rightOperand = InputReader.getArithmeticOrRelationalOperand(fieldSources, indent);
        return new ArithmeticOperationInfo(operation, leftOperand, rightOperand);
    }

    public static RelationalOperationInfo getRelationalOperationInfo() throws IOException, ARException {
        return InputReader.getRelationalOperationInfo("");
    }

    public static RelationalOperationInfo getRelationalOperationInfo(String indent) throws IOException, ARException {
        return InputReader.getRelationalOperationInfo(null, indent);
    }

    public static RelationalOperationInfo getRelationalOperationInfo(List<IQuerySource> fieldSources, String indent) throws IOException, ARException {
        if (InputReader.getBoolean(indent + "Null RelationalOperationInfo (F): ", false)) {
            return null;
        }
        int operation = InputReader.getInt(indent + "Relational op code - EQ, GT, GE, LT, LE, NE, LIKE, IN, NOT IN  (1 - 9): ", 1);
        JavaDriver.outputWriter.driverPrintPrompt(indent + "Left operand - ");
        ArithmeticOrRelationalOperand leftOperand = InputReader.getArithmeticOrRelationalOperand(fieldSources, indent);
        JavaDriver.outputWriter.driverPrintPrompt(indent + "Right operand - ");
        ArithmeticOrRelationalOperand rightOperand = InputReader.getArithmeticOrRelationalOperand(fieldSources, indent);
        return new RelationalOperationInfo(operation, leftOperand, rightOperand);
    }

    public static QualifierInfo getQualifierInfo() throws IOException, ARException {
        return InputReader.getQualifierInfo(null, "Qualifier Info", "");
    }

    public static QualifierInfo getQualifierInfo(List<IQuerySource> fieldSources, String label, String indent) throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt(indent + label + ": \n");
        if (InputReader.getBoolean(indent + "Null " + label + " (F): ", false)) {
            return null;
        }
        int operation = InputReader.getInt(indent + "None, And, Or, Not, Relop or FromField (0, 1, 2, 3, 4, 5) (0): ", 0);
        QualifierInfo opLeft = null;
        QualifierInfo opRight = null;
        QualifierInfo qInfo = null;
        switch (operation) {
            case 0: {
                break;
            }
            case 1: {
                opLeft = InputReader.getQualifierInfo(fieldSources, label, indent);
                JavaDriver.outputWriter.driverPrintPrompt(indent + "AND\n");
                opRight = InputReader.getQualifierInfo(fieldSources, label, indent);
                qInfo = new QualifierInfo(1, opLeft, opRight);
                break;
            }
            case 2: {
                opLeft = InputReader.getQualifierInfo(fieldSources, label, indent);
                JavaDriver.outputWriter.driverPrintPrompt(indent + "OR\n");
                opRight = InputReader.getQualifierInfo(fieldSources, label, indent);
                qInfo = new QualifierInfo(2, opLeft, opRight);
                break;
            }
            case 3: {
                opLeft = InputReader.getQualifierInfo(fieldSources, label, indent);
                qInfo = new QualifierInfo(3, opLeft, null);
                break;
            }
            case 4: {
                RelationalOperationInfo rOpInfo = InputReader.getRelationalOperationInfo(fieldSources, indent);
                qInfo = new QualifierInfo(rOpInfo);
                break;
            }
            case 5: {
                int fid = InputReader.getInt("Field id (1):", 1);
                QualifierFromFieldInfo fromFidInfo = new QualifierFromFieldInfo(fid);
                qInfo = new QualifierInfo(fromFidInfo);
                break;
            }
        }
        return qInfo;
    }

    public static QualifierInfo[] getQualifierInfoList() throws IOException, ARException {
        QualifierInfo[] qualifierInfoList = null;
        int numItems = InputReader.getInt("  Number of  qualifierInfo objects(0): ", 0);
        if (numItems != 0) {
            qualifierInfoList = new QualifierInfo[numItems];
            for (int i = 0; i < numItems; ++i) {
                qualifierInfoList[i] = InputReader.getQualifierInfo();
            }
        }
        return qualifierInfoList;
    }

    public static SortInfo getSortInfo() throws IOException {
        return InputReader.getSortInfoWithSources(null);
    }

    public static List<SortInfo> getSortInfoList() throws IOException {
        return InputReader.getSortInfoListWithSources(null);
    }

    public static List<SortInfo> getSortInfoListWithSources(List<IQuerySource> sources) throws IOException {
        ArrayList<SortInfo> sortInfoList = null;
        int numItems = InputReader.getInt("Number of sort fields (0): ", 0);
        if (numItems != 0) {
            sortInfoList = new ArrayList<SortInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                sortInfoList.add(InputReader.getSortInfoWithSources(sources));
            }
        }
        return sortInfoList;
    }

    public static SortInfo getSortInfoWithSources(List<IQuerySource> sources) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Sort list entry\n");
        if (InputReader.getBoolean("Null SortInfo (F): ", false)) {
            return null;
        }
        int id = InputReader.getInt("      Internal id of field to sort on (0): ", 0);
        int order = InputReader.getInt("      Ascending or Descending (1 or 2) (1): ", 1);
        if (sources != null && sources.size() > 0) {
            int idx = InputReader.getInt("      Field source (" + InputReader.getQuerySourcesPrompt(sources) + ") (0): ", 0);
            return new SortInfo(id, sources.get(idx), order);
        }
        return new SortInfo(id, order);
    }

    public static IndexInfo getIndexInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Index list entry\n");
        if (InputReader.getBoolean("Null IndexInfo (F): ", false)) {
            return null;
        }
        List<Integer> fieldIds = InputReader.getIntegerList();
        boolean unique = InputReader.getBooleanForChangingInfo("      Unique index (F): ", false);
        String nameId = InputReader.getString("Name", "");
        return new IndexInfo(fieldIds, unique, nameId);
    }

    public static List<IndexInfo> getIndexInfoList() throws IOException {
        ArrayList<IndexInfo> indexList = null;
        int numItems = InputReader.getInt("Number of indexes (0): ", 0);
        if (numItems != 0) {
            indexList = new ArrayList<IndexInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                indexList.add(InputReader.getIndexInfo());
            }
        }
        return indexList;
    }

    public static ArchiveInfo getArchiveInfo() throws IOException, ARException {
        ArchiveInfo archive = new ArchiveInfo();
        int enable = InputReader.getInt("Enable (0): ", 0);
        int type = InputReader.getInt("Archive Type (0-None, 1-form, 2-delete, 3-form&delete): ", 0);
        String form = null;
        if (type == 1 || type == 3) {
            form = InputReader.getString("Archive Form Name ():", "");
        }
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        archive.setEnable(enable != 0);
        archive.setArchiveType(type);
        archive.setQualifier(qualifierInfo);
        archive.setArchiveDest(form);
        BitSet bsDays = new BitSet(32);
        BitSet bsweekDays = new BitSet(7);
        BitSet bsHours = new BitSet(24);
        int minute = 0;
        if (InputReader.getBooleanForChangingInfo("Do you want to archive now <F>", false)) {
            int secsFromNow = InputReader.getInt("Enter secs from now: (>= 0) (0): ", 0);
            Calendar now = Calendar.getInstance();
            now.add(13, secsFromNow);
            int dayOfMonth = now.get(5);
            int dayOfWeek = now.get(7);
            int hourOfDay = now.get(11);
            bsDays.set(dayOfMonth - 1);
            bsweekDays.set(dayOfWeek - 1);
            if (hourOfDay > 0) {
                --hourOfDay;
            }
            bsHours.set(hourOfDay);
            minute = now.get(12);
        } else {
            int getDate;
            int i;
            int no_days_time = InputReader.getInt("how many days to set in day/month format? (> 0) (1): ", 1);
            for (i = 0; i < no_days_time; ++i) {
                getDate = InputReader.getInt("date of the day, 0 to 30 for month/day (0): ", 0);
                bsDays.set(getDate);
            }
            no_days_time = InputReader.getInt("how many days to set in day/week format? (> 0) (1): ", 1);
            for (i = 0; i < no_days_time; ++i) {
                getDate = InputReader.getInt("date of the day, 0 to 6 for sunday to saturday (0): ", 0);
                bsweekDays.set(getDate);
            }
            no_days_time = InputReader.getInt("how many hour to set in a day? (> 0) (1): ", 1);
            for (i = 0; i < no_days_time; ++i) {
                getDate = InputReader.getInt("hour of the day, 0 to 23 for 24 hours of a day (0): ", 0);
                bsHours.set(getDate);
            }
            minute = InputReader.getInt("set minute of the hour ? (0-59) (0): ", 0);
        }
        EscalationTime timeInfo = new EscalationTime(bsDays, bsweekDays, bsHours, minute);
        archive.setArchiveTmInfo(timeInfo);
        return archive;
    }

    public static AuditInfo getAuditInfo() throws IOException, ARException {
        AuditInfo auditInfo = new AuditInfo();
        int style = InputReader.getInt("Audit Style (0-None, 1-Copy, 2-Log): ", 1);
        if (style == 0) {
            return null;
        }
        if (style == 1 || style == 2) {
            auditInfo.setAuditStyle(style);
            String form = InputReader.getString("Audit Form Name ():", "");
            auditInfo.setAuditForm(form);
        }
        boolean enable = InputReader.getBoolean("Enable Audit (F): ", false);
        auditInfo.setEnable(enable);
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        auditInfo.setQualifier(qualifierInfo);
        return auditInfo;
    }

    public static Form getForm() throws IOException, ARException {
        int type = InputReader.getInt("Form Type (1): ", 1);
        switch (type) {
            case 1: {
                return new RegularForm();
            }
            case 4: {
                return new DisplayOnlyForm();
            }
            case 2: {
                return InputReader.getJoinForm();
            }
            case 3: {
                return InputReader.getViewForm();
            }
            case 5: {
                return InputReader.getVendorForm();
            }
        }
        return new RegularForm();
    }

    public static Container getContainer() throws IOException {
        int type = InputReader.getInt("Container Type (1): ", 1);
        switch (type) {
            case 1: {
                return new ActiveLinkGuide();
            }
            case 3: {
                return new PackingList();
            }
            case 4: {
                return new FilterGuide();
            }
            case 5: {
                return new WebService();
            }
        }
        return new ApplicationContainer();
    }

    public static Field getField() throws IOException {
        int type = InputReader.getInt("Field Datatype (2): ", 2);
        switch (type) {
            case 2: {
                return new IntegerField();
            }
            case 3: {
                return new RealField();
            }
            case 5: {
                return new DiaryField();
            }
            case 6: {
                return new SelectionField();
            }
            case 7: {
                return new DateTimeField();
            }
            case 10: {
                return new DecimalField();
            }
            case 11: {
                return new AttachmentField();
            }
            case 12: {
                return new CurrencyField();
            }
            case 13: {
                return new DateOnlyField();
            }
            case 14: {
                return new TimeOnlyField();
            }
            case 33: {
                return new TableField();
            }
            case 34: {
                return new ColumnField();
            }
            case 42: {
                return new ViewField();
            }
            case 43: {
                return new DisplayField();
            }
        }
        return new CharacterField();
    }

    public static FieldMapping getFieldMappingInfo() throws IOException {
        int fieldType = InputReader.getInt("Field Mapping Type (1): ", 1);
        switch (fieldType) {
            case 0: {
                return null;
            }
            case 1: {
                return new RegularFieldMapping();
            }
            case 2: {
                int index = InputReader.getInt("   form index (0): ", 0);
                int field = InputReader.getInt("   real Id (0): ", 0);
                return new JoinFieldMapping(index, field);
            }
            case 3: {
                return new ViewFieldMapping(InputReader.getString("Field Name", ""));
            }
            case 4: {
                return new VendorFieldMapping(InputReader.getString("Field Name", ""));
            }
        }
        return null;
    }

    public static PropInfo getPropInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null PropInfo (F): ", false)) {
            return null;
        }
        int tag = InputReader.getInt("Prop Tag - ( 0-500 ): ", 0);
        Value val = InputReader.getValue();
        return new PropInfo(tag, val);
    }

    public static PropInfo[] getPropInfoList() throws IOException, ARException {
        PropInfo[] propList = null;
        int numItems = InputReader.getInt("Number of Properties (0): ", 0);
        if (numItems != 0) {
            propList = new PropInfo[numItems];
            for (int i = 0; i < numItems; ++i) {
                propList[i] = InputReader.getPropInfo();
            }
        }
        return propList;
    }

    public static DisplayPropertyMap getDisplayPropertyMap() throws IOException, ARException {
        DisplayPropertyMap propList = null;
        int numItems = InputReader.getInt("Number of Properties (0): ", 0);
        if (numItems != 0) {
            propList = new DisplayPropertyMap();
            for (int i = 0; i < numItems; ++i) {
                PropInfo pi = InputReader.getPropInfo();
                propList.put(pi.getPropertyTag(), pi.getPropertyValue());
            }
        }
        return propList;
    }

    public static ViewDisplayPropertyMap getViewDisplayPropertyMap() throws IOException, ARException {
        ViewDisplayPropertyMap propList = null;
        int numItems = InputReader.getInt("Number of Properties (0): ", 0);
        if (numItems != 0) {
            propList = new ViewDisplayPropertyMap();
            for (int i = 0; i < numItems; ++i) {
                PropInfo pi = InputReader.getPropInfo();
                propList.put(pi.getPropertyTag(), pi.getPropertyValue());
            }
        }
        return propList;
    }

    public static ObjectPropertyMap getObjectPropertyMap() throws IOException, ARException {
        ObjectPropertyMap propList = null;
        int numItems = InputReader.getInt("Number of Properties (0): ", 0);
        if (numItems != 0) {
            propList = new ObjectPropertyMap();
            for (int i = 0; i < numItems; ++i) {
                PropInfo pi = InputReader.getPropInfo();
                propList.put(pi.getPropertyTag(), pi.getPropertyValue());
            }
        }
        return propList;
    }

    public static DisplayInstanceMap getDisplayInstanceMap() throws IOException, ARException {
        DisplayInstanceMap dim = new DisplayInstanceMap();
        JavaDriver.outputWriter.driverPrintPrompt("getting the Common Properties for this field\n");
        int numItems = InputReader.getInt("Number of display Instances (0): ", 0);
        for (int i = 0; i < numItems; ++i) {
            int id = InputReader.getInt(" VUI id ( 0 ): ", 0);
            DisplayPropertyMap propMap = InputReader.getDisplayPropertyMap();
            dim.put(id, propMap);
        }
        return dim;
    }

    public static AssignFieldInfo getAssignFieldInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null AssignFieldInfo (F): ", false)) {
            return null;
        }
        Serializable obj = null;
        String serverName = InputReader.getString("Server name (): ", "");
        String formName = InputReader.getString("Form name (): ", "");
        int tag = InputReader.getInt("Field, status history, currency field (1, 4, 6) (1): ", 1);
        if (tag == 1) {
            obj = new Integer(InputReader.getInt("Field id (0): ", 0));
        } else if (tag == 4) {
            obj = InputReader.getStatusHistoryValue();
        } else if (tag == 6) {
            obj = InputReader.getCurrencyPartInfo();
        }
        QualifierInfo qualifierInfo = InputReader.getQualifierInfo();
        int noMatchOption = InputReader.getInt("No match action -- error, null, no action, submit (1-4) (2): ", 2);
        int multiMatchOption = InputReader.getInt("Multi match action -- error, null, first, picklist, mod all, no action, submit (1-7) (4): ", 4);
        return new AssignFieldInfo(serverName, formName, qualifierInfo, tag, obj, noMatchOption, multiMatchOption);
    }

    public static DDEAction getDDEInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link DDE Info:\n");
        if (InputReader.getBoolean("Null DDEInfo (F): ", false)) {
            return null;
        }
        String serviceName = InputReader.getString("      Service name (): ", "");
        String topic = InputReader.getString("      Topic (): ", "");
        int action = InputReader.getInt("      Action (execute, poke, request) (1-3) (1): ", 1);
        String pathToProgram = InputReader.getString("      Path To Program (): ", "");
        String command = null;
        command = action != 3 ? InputReader.getString("      Command (): ", "") : null;
        String item = null;
        item = InputReader.getBooleanForChangingInfo("      Set an item string? (F): ", false) ? InputReader.getString("      Item text (): ", "") : null;
        return new DDEAction(serviceName, topic, item, action, pathToProgram, command);
    }

    public static OleAutomationAction getAutomationInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Automation Info:\n");
        if (InputReader.getBoolean("Null AutomationInfo (F): ", false)) {
            return null;
        }
        String serverName = InputReader.getString("      Auto Server name (): ", "");
        boolean isVisible = InputReader.getBooleanForChangingInfo("      Showing Automation Server? (T): ", true);
        String classId = InputReader.getString("      Class  Id (): ", "");
        String action = InputReader.getString("      Automation Action (): ", "");
        List<COMMethodInfo> comMethodList = InputReader.getCOMMethodInfoList();
        return new OleAutomationAction(serverName, classId, action, isVisible, comMethodList);
    }

    public static COMValueInfo getCOMValueInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null COMValueInfo (F): ", false)) {
            return null;
        }
        int transId = InputReader.getInt("      Transient Id (1): ", 1);
        String valueId = InputReader.getString("      Value IId (used for method only)(): ", "");
        int valueType = InputReader.getInt("      COM [Method( null -0, fieldId - 1)/Parm( null -0, value - 2)] Type (0): ", 0);
        int fieldId = 0;
        Value val = null;
        switch (valueType) {
            case 1: {
                fieldId = InputReader.getInt("      FieldId (1): ", 1);
                break;
            }
            case 2: {
                val = InputReader.getValue();
                break;
            }
        }
        return new COMValueInfo(valueId, transId, valueType, fieldId, val);
    }

    public static COMMethodParmInfo getCOMMethodParmInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null COMMethodParmInfo (F): ", false)) {
            return null;
        }
        String name = InputReader.getString("      Parameter Name (): ", "");
        int parmType = InputReader.getInt("      COM Parameter Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);
        COMValueInfo val = InputReader.getCOMValueInfo();
        return new COMMethodParmInfo(name, parmType, val);
    }

    public static List<COMMethodParmInfo> getCOMMethodParmInfoList() throws IOException, ARException {
        ArrayList<COMMethodParmInfo> parmList = null;
        int numItems = InputReader.getInt("      Number of Parameters (0): ", 0);
        if (numItems != 0) {
            parmList = new ArrayList<COMMethodParmInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                parmList.add(InputReader.getCOMMethodParmInfo());
            }
        }
        return parmList;
    }

    public static COMMethodInfo getCOMMethodInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null COMMethodInfo (F): ", false)) {
            return null;
        }
        String name = InputReader.getString("      Method Name (): ", "");
        String methodId = InputReader.getString("      Method Interface Id (): ", "");
        int methodType = InputReader.getInt("      COM Method Type (VT_EMPTY/VT_NULL/VT_I2/VT_I4/VT_R4/VT_R8/VT_CY/VT_DATE/VT_BSTR/VT_DISPATCH/VT_ERROR/VT_BOOL/VT_VIANT/VT_UNKNOWN/VT_WBSTR) (0-14) (VT_I1/VT_UI1/VT_UI2/VT_UI4/VT_I8/VT_UI8/VT_INT/VT_UINT/VT_VOID/VT_HRESULT/VT_PTR) (16-26) (VT_LPSTR/VT_LPWSTR) (30-31) (VT_BLOB_OBJECT -- 70) (0): ", 0);
        COMValueInfo value = InputReader.getCOMValueInfo();
        List<COMMethodParmInfo> paramList = InputReader.getCOMMethodParmInfoList();
        return new COMMethodInfo(name, methodId, methodType, value, paramList);
    }

    public static List<COMMethodInfo> getCOMMethodInfoList() throws IOException, ARException {
        ArrayList<COMMethodInfo> methodList = null;
        int numItems = InputReader.getInt("      Number of Methods (1): ", 1);
        if (numItems != 0) {
            methodList = new ArrayList<COMMethodInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                methodList.add(InputReader.getCOMMethodInfo());
            }
        }
        return methodList;
    }

    public static OpenWindowAction getOpenWindowAction() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Open Dialog Info:\n");
        if (InputReader.getBoolean("Null OpenDlgInfo (F): ", false)) {
            return null;
        }
        OpenWindowAction openDlg = new OpenWindowAction();
        String serverName = InputReader.getString("Server Name ():", "");
        openDlg.setServerName(serverName);
        String formName = InputReader.getString("Form name (): ", "");
        openDlg.setFormName(formName);
        String vuiLabel = InputReader.getString("Vui Label (): ", "");
        openDlg.setVuiLabel(vuiLabel);
        boolean closeBox = InputReader.getBooleanForChangingInfo("Close Box? (T): ", true);
        openDlg.setCloseBox(closeBox);
        List<FieldAssignInfo> inputFields = InputReader.getFieldAssignInfoList();
        openDlg.setInputValueFieldPairs(inputFields);
        List<FieldAssignInfo> outputFields = InputReader.getFieldAssignInfoList();
        openDlg.setOutputValueFieldPairs(outputFields);
        int mode = InputReader.getInt("Window Mode( 0-9)(0):", 0);
        openDlg.setWindowMode(mode);
        String targetLocation = InputReader.getString("Target Location ():", "");
        openDlg.setTargetLocation(targetLocation);
        QualifierInfo query = InputReader.getQualifierInfo();
        openDlg.setQuery(query);
        boolean noMatchContinue = InputReader.getBooleanForChangingInfo("   No Match Continue?(F):", false);
        openDlg.setNoMatchContinue(noMatchContinue);
        boolean suppressEmptyLst = InputReader.getBooleanForChangingInfo("Suppress Empty List ? (F):", false);
        openDlg.setSuppressEmptyLst(suppressEmptyLst);
        MessageAction msg = InputReader.getMessageInfo();
        openDlg.setMsg(msg);
        int interval = InputReader.getInt("Polling interval (0):", 0);
        openDlg.setPollinginterval(interval);
        openDlg.setReportInfo(new OpenWindowAction.ReportInfo());
        List<SortInfo> sortOrderList = InputReader.getSortInfoList();
        openDlg.setSortOrderList(sortOrderList);
        return openDlg;
    }

    public static CloseWindowAction getCloseWindowInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Close Window Info :\n");
        if (InputReader.getBoolean("Null CloseWindowInfo (F): ", false)) {
            return null;
        }
        boolean closeAll = InputReader.getBooleanForChangingInfo("Close All? (t): ", true);
        return new CloseWindowAction(closeAll);
    }

    public static CallGuideAction getCallGuideInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Call Guide Info:\n");
        if (InputReader.getBoolean("Null CallGuideInfo (F): ", false)) {
            return null;
        }
        String name = InputReader.getString("      Server Name: ", "");
        String guideName = InputReader.getString("      Guide Name: ", "");
        int guideMode = InputReader.getInt("      Guide Mode: (0): ", 0);
        int guideTableId = InputReader.getInt("      Guide Table Id (0): ", 0);
        List<FieldAssignInfo> inputFields = InputReader.getFieldAssignInfoList();
        List<FieldAssignInfo> outputFields = InputReader.getFieldAssignInfoList();
        String sampleServer = InputReader.getString("      Sample Server Name: ", "");
        String sampleGuide = InputReader.getString("      Sample Guide Name: ", "");
        return new CallGuideAction(name, guideName, guideMode, guideTableId, inputFields, outputFields, sampleServer, sampleGuide);
    }

    public static ExitGuideAction getExitGuideInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Exit Guide Info:\n");
        if (InputReader.getBoolean("Null ExitGuideInfo (F): ", false)) {
            return null;
        }
        boolean closeAll = InputReader.getBooleanForChangingInfo("      Close All? (T): ", true);
        return new ExitGuideAction(closeAll);
    }

    public static GotoGuideLabelAction getGotoGuideLabelInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Goto Guide Label Info:\n");
        if (InputReader.getBoolean("Null GotoGuideLabelInfo (F): ", false)) {
            return null;
        }
        String label = InputReader.getString("      Label (): ", "");
        return new GotoGuideLabelAction(label);
    }

    public static WaitAction getWaitInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("   Active Link Wait Info:");
        if (InputReader.getBoolean("Null WaitInfo (F): ", false)) {
            return null;
        }
        String title = InputReader.getString("      Continue Button Title ( Continue ): ", "Continue");
        return new WaitAction(title);
    }

    public static AssignSQLInfo getAssignSQLInfo() throws IOException {
        if (InputReader.getBoolean("Null AssignSQLInfo (F): ", false)) {
            return null;
        }
        String server = InputReader.getString("Server name (): ", "");
        String command = InputReader.getString("SQL command (): ", "");
        int valueIndex = InputReader.getInt("Index of returned value to select (1): ", 1);
        int noMatchOption = InputReader.getInt("No match action -- error, null (1, 2) (2): ", 2);
        int multiMatchOption = InputReader.getInt("Multi match action -- error, null, first, picklist (1, 2, 3, 4) (4): ", 4);
        return new AssignSQLInfo(server, command, valueIndex, noMatchOption, multiMatchOption);
    }

    public static AssignFilterApiInfo getAssignFilterApiInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null AssignFilterApiInfo (F): ", false)) {
            return null;
        }
        String name = InputReader.getString("      Service Name: ", "");
        JavaDriver.outputWriter.driverPrintPrompt("      Input Value List:\n");
        ArrayList<AssignInfo> list = null;
        int numItems = InputReader.getInt("      Number of Assignments (0): ", 0);
        if (numItems > 0) {
            list = new ArrayList<AssignInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getAssignInfo());
            }
        }
        int index = InputReader.getInt("      Index of the value field (1): ", 1);
        return new AssignFilterApiInfo(name, list, index);
    }

    public static AssignInfo getAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null AssignInfo (F): ", false)) {
            return null;
        }
        AssignInfo asnInfo = new AssignInfo();
        int type = InputReader.getInt("Assign type:  None, Value, Field, Process, Arith, Function, DDE, SQL, Filter API(0 - 8): ", 0);
        asnInfo.setAssignType(type);
        switch (type) {
            case 1: {
                Value val = InputReader.getValue();
                asnInfo.setValue(val);
                break;
            }
            case 2: {
                AssignFieldInfo fldInfo = InputReader.getAssignFieldInfo();
                asnInfo.setField(fldInfo);
                break;
            }
            case 3: {
                String process = InputReader.getString("Process to run (): ", "");
                asnInfo.setProcess(process);
                break;
            }
            case 4: {
                ArithOpAssignInfo arAsnInfo = InputReader.getArithOpAssignInfo();
                asnInfo.setArithOp(arAsnInfo);
                break;
            }
            case 5: {
                FunctionAssignInfo fnInfo = InputReader.getFunctionAssignInfo();
                asnInfo.setFunction(fnInfo);
                break;
            }
            case 6: {
                DDEAction ddeInfo = InputReader.getDDEInfo();
                asnInfo.setDde(ddeInfo);
                break;
            }
            case 7: {
                AssignSQLInfo sqlInfo = InputReader.getAssignSQLInfo();
                asnInfo.setSql(sqlInfo);
                break;
            }
            case 8: {
                asnInfo.setFilterApi(InputReader.getAssignFilterApiInfo());
                break;
            }
        }
        return asnInfo;
    }

    public static ArithOpAssignInfo getArithOpAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null ArithOpAssignInfo (F): ", false)) {
            return null;
        }
        AssignInfo leftOperand = null;
        AssignInfo rightOperand = null;
        int operation = InputReader.getInt("Arithmetic op code(+): +, -, *, /, %, unary - (1 - 6): ", 1);
        if (operation != 6) {
            JavaDriver.outputWriter.driverPrintPrompt("Left Operand - ");
            leftOperand = InputReader.getAssignInfo();
        }
        JavaDriver.outputWriter.driverPrintPrompt("Right Operand - ");
        rightOperand = InputReader.getAssignInfo();
        ArithOpAssignInfo asnInfo = new ArithOpAssignInfo();
        asnInfo.setOperation(operation);
        asnInfo.setOperandLeft(leftOperand);
        asnInfo.setOperandRight(rightOperand);
        return asnInfo;
    }

    public static FunctionAssignInfo getFunctionAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null FunctionAssignInfo (F): ", false)) {
            return null;
        }
        FunctionAssignInfo fnAssignInfo = new FunctionAssignInfo();
        int functionCode = InputReader.getInt("Function code -- (1 - 50): ", 1);
        fnAssignInfo.setFunctionCode(functionCode);
        int numItems = InputReader.getInt("Number of parameters (0): ", 0);
        if (numItems != 0) {
            ArrayList<AssignInfo> paramList = new ArrayList<AssignInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                JavaDriver.outputWriter.driverPrintPrompt("Parameter[" + i + "] - ");
                paramList.add(InputReader.getAssignInfo());
            }
            fnAssignInfo.setParameterList(paramList);
        }
        return fnAssignInfo;
    }

    public static FieldAssignInfo getFieldAssignInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null FieldAssignInfo (F): ", false)) {
            return null;
        }
        FieldAssignInfo fldAsnInfo = new FieldAssignInfo();
        int fieldId = InputReader.getInt("Field id (0): ", 0);
        fldAsnInfo.setFieldId(fieldId);
        AssignInfo asnInfo = InputReader.getAssignInfo();
        fldAsnInfo.setAssignment(asnInfo);
        return fldAsnInfo;
    }

    public static List<FieldAssignInfo> getFieldAssignInfoList() throws IOException, ARException {
        int numItems = InputReader.getInt("   Number of field/assign pairs (0): ", 0);
        ArrayList<FieldAssignInfo> fldAssignInfoList = null;
        if (numItems != 0) {
            fldAssignInfoList = new ArrayList<FieldAssignInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                fldAssignInfoList.add(InputReader.getFieldAssignInfo());
            }
        }
        return fldAssignInfoList;
    }

    public static SetFieldsAction getSetFieldsActionInfo(boolean isActiveLink) throws IOException, ARException {
        List<FieldAssignInfo> setFields = InputReader.getFieldAssignInfoList();
        String sampleServer = new String(InputReader.getString("   Sample Server Name : ", ""));
        String sampleForm = InputReader.getString("   Sample Form Name: ", "");
        SetFieldsAction action = null;
        for (FieldAssignInfo fldAssignInfo : setFields) {
            AssignInfo assignInfo = fldAssignInfo.getAssignment();
            switch (assignInfo.getAssignType()) {
                case 8: {
                    action = new SetFieldsFromFilterAPI("", "", setFields);
                    break;
                }
                case 7: {
                    action = new SetFieldsFromSQL("", "", setFields);
                    break;
                }
            }
            if (action == null) continue;
            action.setSampleServer(sampleServer);
            action.setSampleForm(sampleForm);
            break;
        }
        return action;
    }

    public static PushFieldsAction getPushFieldsAction() throws IOException, ARException {
        String sampleForm = InputReader.getString("   Sample Form Name: ", "");
        String sampleServer = InputReader.getString("   Sample Server Name : ", "");
        List<PushFieldsInfo> fieldList = InputReader.getPushFieldsInfoList();
        return new PushFieldsAction(sampleForm, sampleServer, fieldList);
    }

    public static List<PushFieldsInfo> getPushFieldsInfoList() throws IOException, ARException {
        int numItems = InputReader.getInt("   Number of field/assign pairs (0): ", 0);
        ArrayList<PushFieldsInfo> fieldList = null;
        if (numItems != 0) {
            fieldList = new ArrayList<PushFieldsInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                PushFieldsInfo cur = new PushFieldsInfo();
                cur.setField(InputReader.getAssignFieldInfo());
                cur.setAssignment(InputReader.getAssignInfo());
                fieldList.add(cur);
            }
        }
        return fieldList;
    }

    public static DirectSqlAction getSQLInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Action Direct SQL:\n");
        if (InputReader.getBoolean("Null SQLInfo (F): ", false)) {
            return null;
        }
        String server = InputReader.getString("      Server (): ", "");
        String command = InputReader.getString("      SQL command (): ", "");
        return new DirectSqlAction(server, command);
    }

    public static GotoAction getGotoActionInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Goto Action Info:\n");
        if (InputReader.getBoolean("Null GotoActionInfo (F): ", false)) {
            return null;
        }
        int fieldIdOrValue = 0;
        int tag = InputReader.getInt("      Field, Value, Forward, Backup (1-4): ", 1);
        switch (tag) {
            case 1: {
                fieldIdOrValue = InputReader.getInt("      FieldId (0): ", 0);
                break;
            }
            case 2: {
                fieldIdOrValue = InputReader.getInt("      Execution Order (0): ", 0);
                break;
            }
            case 3: {
                fieldIdOrValue = InputReader.getInt("    Execution Order Advance By(1): ", 1);
                break;
            }
            case 4: {
                fieldIdOrValue = InputReader.getInt("      Execution Order Backup By (0): ", 1);
                break;
            }
        }
        return new GotoAction(tag, fieldIdOrValue);
    }

    public static FilterAction getFilterActionInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintHeader("Filter Action Info:");
        if (InputReader.getBoolean("Null FilterActionInfo (F): ", false)) {
            return null;
        }
        Action filterAction = null;
        int action = InputReader.getInt("   Notify, Message, Log, Fields, Process, Push, SQL, Goto Action, Call Guide, Exit Guide, Goto Guide Label(1-11): ", 0);
        switch (action) {
            case 1: {
                NotifyAction notify = InputReader.getNotifyActionInfo();
                filterAction = notify;
                break;
            }
            case 2: {
                FilterMessageAction message = InputReader.getFilterStatusInfo();
                filterAction = message;
                break;
            }
            case 3: {
                String file = InputReader.getString("  Log File name(): ", "");
                filterAction = new LogAction(file);
                break;
            }
            case 4: {
                SetFieldsAction fields = InputReader.getSetFieldsActionInfo(false);
                filterAction = fields;
                break;
            }
            case 5: {
                String process = InputReader.getString("    Process ():", "");
                filterAction = new RunProcessAction(process);
                break;
            }
            case 6: {
                PushFieldsAction push = InputReader.getPushFieldsAction();
                filterAction = push;
                break;
            }
            case 7: {
                DirectSqlAction sqlCommand = InputReader.getSQLInfo();
                filterAction = sqlCommand;
                break;
            }
            case 8: {
                GotoAction gotoAction = InputReader.getGotoActionInfo();
                filterAction = gotoAction;
                break;
            }
            case 9: {
                filterAction = InputReader.getCallGuideInfo();
                break;
            }
            case 10: {
                filterAction = InputReader.getExitGuideInfo();
                break;
            }
            case 11: {
                filterAction = InputReader.getGotoGuideLabelInfo();
                break;
            }
        }
        return filterAction;
    }

    public static List<FilterAction> getFilterActionInfoList(boolean actionFlag) throws IOException, ARException {
        int numItems = 0;
        numItems = actionFlag ? InputReader.getInt("Number of actions for the filter (1): ", 1) : InputReader.getInt("Number of elses for the filter (0): ", 0);
        ArrayList<FilterAction> list = null;
        if (numItems != 0) {
            list = new ArrayList<FilterAction>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getFilterActionInfo());
            }
        }
        return list;
    }

    public static RunMacroAction getActiveLinkMacroInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Macro Info:\n");
        if (InputReader.getBoolean("Null ActiveLinkMacroInfo (F): ", false)) {
            return null;
        }
        String macroName = InputReader.getString("      Macro name (): ", "");
        String text = InputReader.getString("      Macro text(): ", "");
        TreeMap<String, String> list = null;
        int numItems = InputReader.getInt("      Number of macro parms (0): ", 0);
        if (numItems != 0) {
            list = new TreeMap<String, String>();
            String name = null;
            String val = null;
            for (int i = 0; i < numItems; ++i) {
                name = InputReader.getString("         Parm Name (): ", "");
                val = InputReader.getString("         Parm Value (): ", "");
                list.put(name, val);
            }
        }
        return new RunMacroAction(macroName, text, list);
    }

    public static ChangeFieldAction getFieldCharacteristicsInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("   Active Link Field Characteristics:\n");
        int option = InputReader.getInt("      Option (bitmask - 1 field reference) (0): ", 0);
        if (InputReader.getBoolean("Null ChangeFieldAction (F): ", false)) {
            return null;
        }
        int fieldId = InputReader.getInt("      Field Id (0): ", 0);
        String menu = null;
        if (InputReader.getBooleanForChangingInfo("      Change menu? (F): ", false)) {
            menu = InputReader.getString("      Char menu (): ", "");
        }
        DisplayPropertyMap propList = null;
        if (InputReader.getBooleanForChangingInfo("      Change display Properties? (F): ", false)) {
            propList = InputReader.getDisplayPropertyMap();
        }
        int focus = 0;
        if (InputReader.getBooleanForChangingInfo("      Change focus to this field? (F): ", false)) {
            focus = 1;
        }
        int accessOption = InputReader.getInt("      Access option (unchanged, read-only, read/write, disable) (0-3) (0): ", 0);
        return new ChangeFieldAction(option, fieldId, menu, propList, focus, accessOption);
    }

    public static ActiveLinkAction getActiveLinkActionInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("Active Link Action Info:\n");
        if (InputReader.getBoolean("Null ActiveLinkActionInfo (F): ", false)) {
            return null;
        }
        Action action = null;
        int type = InputReader.getInt(" Macro, Fields, Process, Message, Field Characteristics, DDE, Push, SQL, Automation, Open Dialog, Commit Changes, Close Window, Call Guide, Exit Guide, Goto Guide, Wait, Goto Action(1-17): ", 1);
        switch (type) {
            case 1: {
                RunMacroAction activeLinkMacro;
                action = activeLinkMacro = InputReader.getActiveLinkMacroInfo();
                break;
            }
            case 2: {
                SetFieldsAction fieldList = InputReader.getSetFieldsActionInfo(true);
                action = fieldList;
                break;
            }
            case 3: {
                String process = InputReader.getString("   Command string (): ", "");
                action = new RunProcessAction(process);
                break;
            }
            case 4: {
                MessageAction message = InputReader.getMessageInfo();
                action = message;
                break;
            }
            case 5: {
                ChangeFieldAction field = InputReader.getFieldCharacteristicsInfo();
                action = field;
                break;
            }
            case 6: {
                DDEAction dde = InputReader.getDDEInfo();
                action = dde;
                break;
            }
            case 7: {
                PushFieldsAction push = InputReader.getPushFieldsAction();
                action = push;
                break;
            }
            case 8: {
                DirectSqlAction sql = InputReader.getSQLInfo();
                action = sql;
                break;
            }
            case 9: {
                OleAutomationAction auto = InputReader.getAutomationInfo();
                action = auto;
                break;
            }
            case 10: {
                OpenWindowAction openDlg = InputReader.getOpenWindowAction();
                action = openDlg;
                break;
            }
            case 11: {
                CommitChangesAction commit = InputReader.getCommitChangesInfo();
                action = commit;
                break;
            }
            case 12: {
                CloseWindowAction closeWnd = InputReader.getCloseWindowInfo();
                action = closeWnd;
                break;
            }
            case 13: {
                CallGuideAction callGuide = InputReader.getCallGuideInfo();
                action = callGuide;
                break;
            }
            case 14: {
                ExitGuideAction exitGuide = InputReader.getExitGuideInfo();
                action = exitGuide;
                break;
            }
            case 15: {
                GotoGuideLabelAction guideLabel = InputReader.getGotoGuideLabelInfo();
                action = guideLabel;
                break;
            }
            case 16: {
                WaitAction wait = InputReader.getWaitInfo();
                action = wait;
                break;
            }
            case 17: {
                GotoAction gotoAction = InputReader.getGotoActionInfo();
                action = gotoAction;
                break;
            }
        }
        return action;
    }

    public static List<ActiveLinkAction> getActiveLinkActionInfoList(boolean actionFlag) throws IOException, ARException {
        int numItems = 0;
        numItems = actionFlag ? InputReader.getInt("Number of actions for the active link (1): ", 1) : InputReader.getInt("Number of elses for the active link (0): ", 0);
        ArrayList<ActiveLinkAction> list = null;
        if (numItems != 0) {
            list = new ArrayList<ActiveLinkAction>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(i, InputReader.getActiveLinkActionInfo());
            }
        }
        return list;
    }

    public static PermissionInfo getPermissionInfo(boolean fieldFlag) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Permission Info:\n");
        if (InputReader.getBoolean("Null PermissionInfo (F): ", false)) {
            return null;
        }
        int groupId = InputReader.getInt("      Group id (3): ", 0);
        int permissions = 0;
        permissions = fieldFlag ? InputReader.getInt("      None, View, or Change (0, 1, 2): ", 0) : InputReader.getInt("      None, Visible, or Hidden(0, 1, 2): ", 0);
        return new PermissionInfo(groupId, permissions);
    }

    public static List<PermissionInfo> getPermissionInfoList(boolean fieldFlag) throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Permission List:\n");
        int numItems = InputReader.getInt("   Number of permission defns (0): ", 0);
        ArrayList<PermissionInfo> list = null;
        if (numItems != 0) {
            list = new ArrayList<PermissionInfo>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getPermissionInfo(fieldFlag));
            }
        }
        return list;
    }

    public static IntegerFieldLimit getIntegerLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null Form List Criteria (F): ", false)) {
            return null;
        }
        int low = InputReader.getInt("   Integer range low (0): ", 0);
        int high = InputReader.getInt("   Integer range high (5000): ", 5000);
        return new IntegerFieldLimit(low, high);
    }

    public static RealFieldLimit getRealLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null RealLimitInfo (F): ", false)) {
            return null;
        }
        double rangeLow = InputReader.getDouble("   Real range low (0): ", 0.0);
        double rangeHigh = InputReader.getDouble("   Real range high (5000): ", 5000.0);
        int precision = InputReader.getInt("   Precision (-1 is no precision) (-1): ", -1);
        return new RealFieldLimit(rangeLow, rangeHigh, precision);
    }

    public static CharacterFieldLimit getCharLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null CharLimitInfo (F): ", false)) {
            return null;
        }
        int lengthUnits = InputReader.getInt("   Length Units - Byte or Character (0 or 1) (0): ", 0);
        int storageOptionForCLOB = InputReader.getInt("   Storage Option for CLOB - Default, In-Row or Out-of-Row (0, 1 or 2) (0): ", 0);
        int maxLength = InputReader.getInt("   Maximum length (128): ", 128);
        int menuStyle = InputReader.getInt("   Menu style - Append or Overwrite (1 or 2) (1): ", 1);
        int qbe = InputReader.getInt("   Match operation - Anywhere, Leading match, or Equal (1 - 3) (1): ", 1);
        String charMenu = InputReader.getString("\tCharacter menu(): ", "");
        String pattern = InputReader.getString("   Pattern (): ", "");
        int option = InputReader.getInt("   FullText Options(0): ", 0);
        return new CharacterFieldLimit(maxLength, menuStyle, qbe, charMenu, pattern, option, lengthUnits, storageOptionForCLOB);
    }

    public static DiaryFieldLimit getDiaryLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null DiaryLimitInfo (F): ", false)) {
            return null;
        }
        int fullTextOptions = InputReader.getInt("   FullText Options(0): ", 0);
        return new DiaryFieldLimit(fullTextOptions);
    }

    public static EnumItem getEnumItem() throws IOException {
        if (InputReader.getBoolean("Null EnumItem (F): ", false)) {
            return null;
        }
        String name = InputReader.getString("   Item Name : ", "");
        int number = InputReader.getInt("   Item Number (0): ", 0);
        return new EnumItem(name, number);
    }

    public static List<EnumItem> getEnumItemList() throws IOException {
        ArrayList<EnumItem> enumItems = null;
        int numItems = InputReader.getInt("   Number of enum items (0): ", 0);
        if (numItems != 0) {
            enumItems = new ArrayList<EnumItem>(numItems);
            for (int i = 0; i < numItems; ++i) {
                enumItems.add(InputReader.getEnumItem());
            }
        }
        return enumItems;
    }

    public static SelectionFieldLimit getEnumLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null EnumLimitInfo (F): ", false)) {
            return null;
        }
        int listStyle = InputReader.getInt("Enum List Style (1): ", 1);
        switch (listStyle) {
            case 1: {
                return new SelectionFieldLimit(InputReader.getStringArray("", "Selection Field Enum Item"));
            }
            case 2: {
                return new SelectionFieldLimit(InputReader.getEnumItemList());
            }
        }
        return null;
    }

    public static AttachmentFieldLimit getAttachmentLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null AttachmentLimitInfo (F): ", false)) {
            return null;
        }
        int maxSize = InputReader.getInt("   maxSize(0): ", 0);
        int type = 1;
        int fullTextOptions = InputReader.getInt("   FullText Options(0): ", 0);
        return new AttachmentFieldLimit(maxSize, type, fullTextOptions);
    }

    public static TableFieldLimit getTableLimitInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null TableLimitInfo (F): ", false)) {
            return null;
        }
        String form = InputReader.getString("   form name: ", "");
        String server = InputReader.getString("   server name: ", "");
        QualifierInfo qualifier = InputReader.getQualifierInfo();
        int maxRetrieve = InputReader.getInt("  Max rows to retrieve (10): ", 10);
        int numColumns = 0;
        String sampleForm = InputReader.getString("   sample form name: ", "");
        String sampleServer = InputReader.getString("   sample server name: ", "");
        return new TableFieldLimit(numColumns, qualifier, maxRetrieve, form, server, sampleForm, sampleServer);
    }

    public static ColumnFieldLimit getColumnLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null ColumnLimitInfo (F): ", false)) {
            return null;
        }
        int parentID = InputReader.getInt("   Parent Table field Id (0): ", 0);
        int dataFieldID = InputReader.getInt("   Data field Id (0): ", 0);
        int dataSource = InputReader.getInt("   Data Source(0): ", 0);
        int colLength = InputReader.getInt("   Length to display(10) : ", 10);
        return new ColumnFieldLimit(parentID, dataFieldID, dataSource, colLength);
    }

    public static DecimalFieldLimit getDecimalLimitInfo() throws IOException {
        if (InputReader.getBoolean("Null DecimalLimitInfo (F): ", false)) {
            return null;
        }
        String low = InputReader.getString("   Decimal range low (0.0): ", "0.0");
        String high = InputReader.getString("   Decimal range high (5000.0): ", "5000.0");
        int precision = InputReader.getInt("   Precision (0): ", 0);
        return new DecimalFieldLimit(low, high, precision);
    }

    public static List<CurrencyDetail> getCurrencyDetail(String prompt, int defaultOccurances) throws IOException {
        ArrayList<CurrencyDetail> currencyDetail = null;
        int numCurrencies = InputReader.getInt(prompt + "(" + defaultOccurances + "):", defaultOccurances);
        if (numCurrencies > 0) {
            currencyDetail = new ArrayList<CurrencyDetail>(numCurrencies);
        }
        for (int i = 0; i < numCurrencies; ++i) {
            String currencyCode = InputReader.getString("   Currency Code (USD): ", "USD");
            int precision = InputReader.getInt("   Precision (0): ", 0);
            currencyDetail.add(new CurrencyDetail(currencyCode, precision));
        }
        return currencyDetail;
    }

    public static CurrencyFieldLimit getCurrencyLimitInfo() throws IOException {
        String low = InputReader.getString("   Currency range low (0.0): ", "0.0");
        String high = InputReader.getString("   Currency range high (5000.0): ", "5000.0");
        int precision = InputReader.getInt("   Precision (0): ", 0);
        List<CurrencyDetail> functional = InputReader.getCurrencyDetail("    Number of functional Currencies", 1);
        List<CurrencyDetail> allowable = InputReader.getCurrencyDetail("   Number of Allowable Currencies", 1);
        return new CurrencyFieldLimit(low, high, precision, functional, allowable);
    }

    public static ViewFieldLimit getViewLimits() throws IOException {
        if (InputReader.getBoolean("Null ViewLimits (F): ", false)) {
            return null;
        }
        int maxLength = InputReader.getInt("   Maximum length (128): ", 128);
        return new ViewFieldLimit(maxLength);
    }

    public static DisplayFieldLimit getDisplayLimits() throws IOException {
        if (InputReader.getBoolean("Null DisplayLimits (F): ", false)) {
            return null;
        }
        int lengthUnits = InputReader.getInt("   Length Units - Byte or Character (0 or 1) (0): ", 0);
        int maxLength = InputReader.getInt("   Maximum length (128): ", 128);
        return new DisplayFieldLimit(maxLength, lengthUnits);
    }

    public static MenuItem getCharMenuItemInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Char Menu Item Info:\n");
        if (InputReader.getBoolean("Null CharMenuItemInfo (F): ", false)) {
            return null;
        }
        String menuLabel = InputReader.getString("    Menu Label: ", "");
        int menuType = InputReader.getInt("    Menu type - Value Or Menu (1, 2) (1):", 1);
        MenuItem charMenuItem = null;
        switch (menuType) {
            case 1: {
                String menuItem = InputReader.getString("    Char menu text(): ", "");
                charMenuItem = new MenuItem(menuLabel, menuItem);
                break;
            }
            case 2: {
                List<MenuItem> menuInfo = InputReader.getCharMenuItemInfoList();
                charMenuItem = new MenuItem(menuLabel, menuInfo);
                break;
            }
        }
        return charMenuItem;
    }

    public static ListMenu getCharMenuListInfo() throws IOException {
        if (InputReader.getBoolean("Null CharMenuListInfo (F): ", false)) {
            return null;
        }
        int numItems = InputReader.getInt("   Number of char menu items (0): ", 0);
        ArrayList<MenuItem> list = null;
        if (numItems != 0) {
            list = new ArrayList<MenuItem>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getCharMenuItemInfo());
            }
        }
        return new ListMenu(list);
    }

    public static QueryMenu getCharMenuQueryInfo() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("    Char Menu Query Info:\n");
        if (InputReader.getBoolean("Null CharMenuQueryInfo (F): ", false)) {
            return null;
        }
        String form = InputReader.getString("    Form Name (): ", "");
        String server = InputReader.getString("      Server (): ", "");
        QualifierInfo qualifier = InputReader.getQualifierInfo();
        int labelField = InputReader.getInt("      Id of the label field (0): ", 0);
        int valueField = InputReader.getInt("      Id of the value field (0): ", 0);
        boolean sortOnLabel = InputReader.getBooleanForChangingInfo("      Sort the label field (T): ", true);
        String sampleForm = InputReader.getString("    Sample Form Name (): ", "");
        String sampleServer = InputReader.getString("      Sample Server (): ", "");
        return new QueryMenu(form, server, qualifier, labelField, valueField, sortOnLabel, sampleForm, sampleServer);
    }

    public static FileMenu getCharMenuFileInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("Char Menu FILE INFO:");
        if (InputReader.getBoolean("Null CharMenuFileInfo (F): ", false)) {
            return null;
        }
        int type = InputReader.getInt("       File location  Server or Client (1 or 2) (1): ", 1);
        String name = InputReader.getString("      File Name():", "");
        return new FileMenu(type, name);
    }

    public static SqlMenu getCharMenuSQLInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("Char Menu SQL INFO:\n");
        if (InputReader.getBoolean("Null CharMenuSQLInfo (F): ", false)) {
            return null;
        }
        String server = InputReader.getString("      Server (): ", "");
        String command = InputReader.getString("      SQL command (): ", "");
        int labelIndex = InputReader.getInt("      Index of the label field (1): ", 1);
        int valueIndex = InputReader.getInt("      Index of the value field (1): ", 1);
        return new SqlMenu(server, command, labelIndex, valueIndex);
    }

    public static List<MenuItem> getCharMenuItemInfoList() throws IOException {
        int numItems = InputReader.getInt("   Number of char menu items (0): ", 0);
        ArrayList<MenuItem> list = null;
        if (numItems > 0) {
            list = new ArrayList<MenuItem>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getCharMenuItemInfo());
            }
        }
        return list;
    }

    public static DataDictionaryMenu getCharMenuDDInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Char Menu Data-Dictionary info:\n");
        if (InputReader.getBoolean("Null CharMenuDDInfo (F): ", false)) {
            return null;
        }
        String server = InputReader.getString("      Server name (): ", "");
        int nameType = InputReader.getInt("      Name type (0 - 2) (0): ", 0);
        int valueFormat = InputReader.getInt("      Value format (1 - 11) (2): ", 2);
        int structType = InputReader.getInt("      Struct type ( 1(form) - 2(field) ) (1): ", 1);
        DataDictionaryMenu menu = null;
        switch (structType) {
            case 1: {
                JavaDriver.outputWriter.driverPrintPrompt("      Data-Dictionary Form Info :\n");
                int formType = InputReader.getInt("        Type of form (all,regular,join,view,uplink,downlink,dialog,vendor) (0-6,8) (0): ", 0);
                boolean includeHidden = InputReader.getBooleanForChangingInfo("        Include hidden forms (T): ", true);
                menu = new FormDataDictionaryMenu(server, nameType, valueFormat, formType, includeHidden);
                break;
            }
            case 2: {
                JavaDriver.outputWriter.driverPrintPrompt("        Data-Dictionary Field Info :\n");
                int fieldType = InputReader.getInt("        Field Type - data, trim, control, page, pholder, table,\n  column, attach, attachpool  (1, 2, 4, 8, 16, 32, 64, 128, 256) (129): ", 129);
                String name = InputReader.getString("        Form name (): ", "");
                menu = new FieldDataDictionaryMenu(server, nameType, valueFormat, fieldType, name);
                break;
            }
        }
        return menu;
    }

    public static Menu getCharMenuSSInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("    Char Menu Server-Side info:\n");
        if (InputReader.getBoolean("Null CharMenuSSInfo (F): ", false)) {
            return null;
        }
        String menuName = InputReader.getString("      Menu name (): ", "");
        SqlMenu menu = new SqlMenu(null, null, 0, 0);
        menu.setName(menuName);
        return menu;
    }

    public static Menu getMenu() throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt("Char Menu Info:\n");
        int menuType = InputReader.getInt("    Menu type - None, List, Query, File, SQL, SS, DD (0 - 6) ( 1 ):", 1);
        Menu menu = null;
        switch (menuType) {
            case 1: {
                menu = InputReader.getCharMenuListInfo();
                break;
            }
            case 2: {
                menu = InputReader.getCharMenuQueryInfo();
                break;
            }
            case 3: {
                menu = InputReader.getCharMenuFileInfo();
                break;
            }
            case 4: {
                menu = InputReader.getCharMenuSQLInfo();
                break;
            }
            case 6: {
                menu = InputReader.getCharMenuDDInfo();
            }
            case 5: {
                menu = InputReader.getCharMenuSSInfo();
            }
        }
        return menu;
    }

    public static StructItemInfo getStructItemInfo() throws IOException {
        if (InputReader.getBoolean("Null StructItemInfo (F): ", false)) {
            return null;
        }
        int options = 0;
        InputReader.setNullPromptOption(true);
        int type = InputReader.getInt("   Form(full,defn,view,mail),Filter,ActLink,<7-obsolete>,CharMenu,\n    Escalation,Dist Map, Form(min view), Container, DistPool, VUI,\n   Application, Image, VUI(locale based)(1-8, 9-15, 16-18): ", 0);
        String name = InputReader.getString("Structure name ", "");
        String[] selectedElements = null;
        if (type == 14 || type == 4) {
            JavaDriver.outputWriter.driverPrintPrompt("   VUIs to select (supply VUI's DB name):\n");
            selectedElements = InputReader.getStringArray("", "VUI DB Name");
        } else if (type == 16) {
            if (InputReader.getBoolean("Integration Workflow Only (F): ", false)) {
                options |= 8;
                JavaDriver.outputWriter.driverPrintPrompt("   Applicaiotns to select:\n");
                selectedElements = InputReader.getStringArray("", "Applications");
            } else {
                if (InputReader.getBoolean("Include Shared Workflow (F): ", false)) {
                    options |= 1;
                }
                if (InputReader.getBoolean("Include only Locale VUI and data T/F? (F): ", false)) {
                    options |= 0x14;
                    JavaDriver.outputWriter.driverPrintPrompt("   Locales to select:\n");
                    selectedElements = InputReader.getStringArray("", "Locale");
                } else {
                    int localType = InputReader.getInt("Locales to include: (0-All 1-Default only 2-Selected) (0):", 0);
                    if (localType == 1) {
                        options |= 2;
                    } else if (localType == 2) {
                        options |= 4;
                        JavaDriver.outputWriter.driverPrintPrompt("   Locales to select:\n");
                        selectedElements = InputReader.getStringArray("", "Locale");
                    }
                }
            }
        }
        InputReader.setNullPromptOption(false);
        return new StructItemInfo(type, name, selectedElements, options);
    }

    public static List<StructItemInfo> getStructItemInfoList() throws IOException {
        int expFormat = InputReader.getInt("   Format: AR_DEF, XML (1,2) (1): ", 1);
        JavaDriver.outputWriter.driverPrintPrompt("Struct ItemInfo List:\n");
        int numItems = InputReader.getInt("   Number of structure items (0): ", 0);
        ArrayList<StructItemInfo> list = new ArrayList<StructItemInfo>();
        if (numItems != 0) {
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getStructItemInfo());
            }
        }
        if (expFormat == 2) {
            for (StructItemInfo si : list) {
                si.setType(si.getType() | 0x40000000);
            }
        }
        return list;
    }

    public static ServerInfo getServerInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null ServerInfo (F): ", false)) {
            return null;
        }
        int operation = InputReader.getInt("    Operation (1-341) (1):", 1);
        Value val = InputReader.getValue();
        return new ServerInfo(operation, val);
    }

    public static ServerInfoMap getServerInfoMap() throws IOException, ARException {
        int numItems = InputReader.getInt("   Number of server info operations (0): ", 0);
        ServerInfoMap list = new ServerInfoMap();
        if (numItems != 0) {
            for (int i = 0; i < numItems; ++i) {
                int operation = InputReader.getInt("    Operation (1-341) (1):", 1);
                Value value = InputReader.getValue();
                list.put(operation, value);
            }
        }
        return list;
    }

    public static List<Reference> getReferenceList() throws IOException, ARException {
        int numItems = InputReader.getInt("   Number of References (0): ", 0);
        ArrayList<Reference> list = null;
        if (numItems != 0) {
            list = new ArrayList<Reference>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getReference());
            }
        }
        return list;
    }

    public static Reference getReference() throws IOException, ARException {
        if (InputReader.getBoolean("Null Reference (F): ", false)) {
            return null;
        }
        String label = InputReader.getString("Reference Label ():", "");
        String desc = InputReader.getString("Reference Description ():", "");
        ReferenceType type = InputReader.getReferenceType();
        int dataType = InputReader.getInt("References Data Type AR, EXTERNAL (0, 1) (0):", 0);
        if (dataType == 0) {
            String name = InputReader.getString("ARS reference name", "");
            return new Reference(label, desc, type, name);
        }
        JavaDriver.outputWriter.driverPrintPrompt("   External reference access group ids: \n");
        List<Integer> idList = InputReader.getIntegerList();
        JavaDriver.outputWriter.driverPrintPrompt("External Reference Value :\n");
        Value val = InputReader.getValue();
        return new ExternalReference(label, desc, type, idList, val);
    }

    public static ReferenceType getReferenceType() throws IOException {
        if (InputReader.getBoolean("Null ReferenceType (F): ", false)) {
            return null;
        }
        JavaDriver.outputWriter.driverPrintPrompt("   Reference type none, form, filter, esc,actlink,\n");
        int type = InputReader.getInt("      container,charmenu (0,2-7) (0): ", 0);
        return ReferenceType.toReferenceType(type);
    }

    public static List<ContainerOwner> getContainerOwnerList() throws IOException {
        if (InputReader.getBoolean("Null ContainerOwnerList (F): ", false)) {
            return null;
        }
        int numItems = InputReader.getInt("Number of container owner objects (0): ", 0);
        ArrayList<ContainerOwner> list = null;
        if (numItems != 0) {
            list = new ArrayList<ContainerOwner>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getContainerOwner());
            }
        }
        return list;
    }

    public static ContainerOwner getContainerOwner() throws IOException {
        if (InputReader.getBoolean("Null ContainerOwnerInfo (F): ", false)) {
            return null;
        }
        int type = InputReader.getInt("Container owner type (unowned, all, owned) (0-2) (0): ", 0);
        if (type == 0 || type == 1) {
            return new ContainerOwner(type);
        }
        String ownerName = InputReader.getString("Container Owner Name", "");
        return new ContainerOwner(type, ownerName);
    }

    public static ContainerType getContainerType() throws IOException {
        if (InputReader.getBoolean("Null ContainerType (F): ", false)) {
            return null;
        }
        int type = InputReader.getInt("Active Link Guide, Application, Packing List, Filter Guide, Web Service(1-5) (2): ", 2);
        switch (type) {
            case 1: {
                return ContainerType.GUIDE;
            }
            case 2: {
                return ContainerType.APPLICATION;
            }
            case 3: {
                return ContainerType.PACKINGLIST;
            }
            case 4: {
                return ContainerType.FILTERGUIDE;
            }
        }
        return null;
    }

    public static List<ContainerType> getContainerTypeList() throws IOException {
        int numItems = InputReader.getInt("Number of container types (0): ", 0);
        ArrayList<ContainerType> list = null;
        if (numItems != 0) {
            list = new ArrayList<ContainerType>(numItems);
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getContainerType());
            }
        }
        return list;
    }

    public static LocalizedRequestInfo getLocalizedRequestInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Localized Message Request Info:\n");
        if (InputReader.getBoolean("Null getLocalizedRequest Object? (F):", false)) {
            return null;
        }
        int id = 0;
        int workflowIfElse = 0;
        int workflowAction = 0;
        int messageType = InputReader.getInt(" Message Type:  System, Active Link, Filter, Active Link Help,\n   Form Help, Field Help, Container Desc., List Menu Defn,\n   External Report ,Container Label, Application Help, \n  Application About, Application Help Index   (0 - 13) (0): ", 0);
        String name = InputReader.getString("     name: ", "");
        switch (messageType) {
            case 5: 
            case 8: {
                id = InputReader.getInt("Internal ID (0): ", 0);
                break;
            }
            case 1: 
            case 2: {
                workflowIfElse = InputReader.getInt("If/Else (0): ", 0);
                workflowAction = InputReader.getInt("Action (0): ", 0);
                break;
            }
        }
        return new LocalizedRequestInfo(name, messageType, workflowIfElse, workflowAction, id);
    }

    public static LocalizedRequestInfo[] getLocalizedRequestInfoList() throws IOException {
        int numItems = InputReader.getInt("Number of localized value operations (0): ", 0);
        LocalizedRequestInfo[] list = null;
        if (numItems != 0) {
            list = new LocalizedRequestInfo[numItems];
            for (int i = 0; i < numItems; ++i) {
                list[i] = InputReader.getLocalizedRequestInfo();
            }
        }
        return list;
    }

    public static StatusHistoryItem getStatusHistoryItem() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   Status History Info:\n");
        String user = InputReader.getString("   User: ", "");
        Timestamp timestamp = new Timestamp(InputReader.getLong("   TimeStamp(0): ", 0L));
        return new StatusHistoryItem(user, timestamp);
    }

    public static StatusHistoryValue getStatusHistory() throws IOException {
        StatusHistoryValue value = new StatusHistoryValue();
        int numItems = InputReader.getInt("Number of Status History Info Objects(0): ", 0);
        if (numItems != 0) {
            for (int i = 0; i < numItems; ++i) {
                value.add(InputReader.getStatusHistoryItem());
            }
        }
        return value;
    }

    public static DiaryItem getDiaryInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintPrompt("   DiaryList Info:\n");
        String user = InputReader.getString("   User: ", "");
        Timestamp timestamp = new Timestamp(InputReader.getLong("   TimeStamp: ", 0L));
        String diaryItemString = InputReader.getString("     Text () ", "");
        return new DiaryItem(user, diaryItemString, timestamp);
    }

    public static DiaryListValue getDiaryInfoList() throws IOException {
        DiaryListValue list = new DiaryListValue();
        int numItems = InputReader.getInt("Number of DiaryList Info Objects(0): ", 0);
        if (numItems != 0) {
            for (int i = 0; i < numItems; ++i) {
                list.add(InputReader.getDiaryInfo());
            }
        }
        return list;
    }

    public static EscalationTimeCriteria getEsclationTmInfo() throws IOException {
        if (InputReader.getBoolean("Null EsclationTmInfo (F): ", false)) {
            return null;
        }
        EscalationTimeCriteria timeInfo = null;
        int type = InputReader.getInt("Escalation Time Format (1-interval /2) (1) :", 1);
        if (type == 1) {
            long interval = InputReader.getLong("Escalation Interval ( >0 ) (300):", 300L);
            timeInfo = new EscalationInterval(interval);
        } else {
            DayInfo day = InputReader.getDayInfo();
            timeInfo = new EscalationTime((int)day.getMonthday(), (int)day.getWeekday(), (int)day.getHourmask(), (int)day.getMinute());
        }
        return timeInfo;
    }

    public static DayInfo getDayInfo() throws IOException {
        if (InputReader.getBoolean("Null DayInfo (F): ", false)) {
            return null;
        }
        long day = InputReader.getLong("Day (0):", 0L);
        long hourMask = InputReader.getLong("HourMask (0):", 0L);
        long minutes = InputReader.getLong("Minutes (0):", 0L);
        long weekDay = InputReader.getLong("Week day (0):", 0L);
        return new DayInfo(day, weekDay, hourMask, minutes);
    }

    public static FieldLimit getFieldLimitInfo(int dataType) throws IOException, ARException {
        if (InputReader.getBoolean("Set to NO LIMITS? (F): ", false)) {
            return null;
        }
        switch (dataType) {
            case 2: {
                return InputReader.getIntegerLimitInfo();
            }
            case 3: {
                return InputReader.getRealLimitInfo();
            }
            case 4: {
                return InputReader.getCharLimitInfo();
            }
            case 5: {
                return InputReader.getDiaryLimitInfo();
            }
            case 7: {
                return null;
            }
            case 6: {
                return InputReader.getEnumLimitInfo();
            }
            case 8: {
                return InputReader.getEnumLimitInfo();
            }
            case 11: {
                return InputReader.getAttachmentLimitInfo();
            }
            case 10: {
                return InputReader.getDecimalLimitInfo();
            }
            case 12: {
                return InputReader.getCurrencyLimitInfo();
            }
            case 33: {
                return InputReader.getTableLimitInfo();
            }
            case 34: {
                return InputReader.getColumnLimitInfo();
            }
            case 42: {
                return InputReader.getViewLimits();
            }
            case 43: {
                return InputReader.getDisplayLimits();
            }
        }
        return null;
    }

    public static DataType getDataType() throws IOException {
        if (InputReader.getBoolean("Null Data Type (F): ", false)) {
            return null;
        }
        JavaDriver.outputWriter.driverPrintPrompt("Datatype Null/Key/Int/Real/Char/DiaryList/Enum/Time/Bitmask/Byte/Decimal\n");
        int type = InputReader.getInt("    attach/currency/date/timeofday/join/trim/control/table/column/ulong/coords/view/display (0 - 14, 30-34, 40-43) (2): ", 2);
        return DataType.toDataType(type);
    }

    public static FormType getFormType() throws IOException {
        if (InputReader.getBoolean("Null Form Type (F): ", false)) {
            return null;
        }
        int type = InputReader.getInt("Type of form (all, regular, join, view, uplink, downlink, dialog, all_with_data, vendor) (0-8)(0):", 0);
        switch (type) {
            case 0: {
                return FormType.ALL;
            }
            case 1: {
                return FormType.REGULAR;
            }
            case 2: {
                return FormType.JOIN;
            }
            case 3: {
                return FormType.VIEW;
            }
            case 4: {
                return FormType.UPLINK;
            }
            case 5: {
                return FormType.DOWNLINK;
            }
            case 6: {
                return FormType.DIALOG;
            }
            case 8: {
                return FormType.VENDOR;
            }
            case 7: {
                return FormType.ALL_WITH_DATA;
            }
        }
        return null;
    }

    public static EntryKey getEntryKey() throws IOException {
        if (InputReader.getBoolean("Null Entry key (F): ", false)) {
            return null;
        }
        String formName = InputReader.getString("Form Name (): ", "");
        int numItems = InputReader.getInt("Number of Items in EntryId ? (1): ", 1);
        if (numItems <= 0) {
            return null;
        }
        String[] entryIDList = new String[numItems];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numItems; ++i) {
            entryIDList[i] = InputReader.getString("String: ", "");
            sb.append(entryIDList[i]);
            sb.append("|");
        }
        if (numItems == 1) {
            return new EntryKey(formName, entryIDList[0]);
        }
        String joinEntryID = sb.toString();
        joinEntryID = joinEntryID.substring(0, joinEntryID.length() - 1);
        return new EntryKey(formName, joinEntryID);
    }

    public static ByteListValue[] getByteListInfoList() throws IOException {
        ByteListValue[] byteList = null;
        int numberOfValues = InputReader.getInt("   Number of items (0): ", 0);
        if (numberOfValues != 0) {
            byteList = new ByteListValue[numberOfValues];
            for (int i = 0; i < numberOfValues; ++i) {
                byteList[i] = InputReader.getByteListInfo();
            }
        }
        return byteList;
    }

    public static Entry getEntry() throws IOException, ARException {
        Entry entry = new Entry();
        int numItems = InputReader.getInt("  Number of Field/value pairs (0): ", 0);
        if (numItems != 0) {
            for (int i = 0; i < numItems; ++i) {
                int fieldId = InputReader.getInt("Field id (0): ", 0);
                Value val = InputReader.getValue();
                entry.put(fieldId, val);
            }
        }
        return entry;
    }

    public static ViewKey getViewKey() throws IOException {
        if (InputReader.getBoolean("Null ViewKey (F): ", false)) {
            return null;
        }
        String formName = InputReader.getString("Form Name (): ", "");
        int vuiId = InputReader.getInt("VUI id (1): ", 1);
        return new ViewKey(formName, vuiId);
    }

    public static int[] getIntArray() throws IOException {
        int[] fieldIdList = null;
        int numItems = InputReader.getInt("   Number of field IDs (0): ", 0);
        if (numItems != 0) {
            fieldIdList = new int[numItems];
            for (int i = 0; i < numItems; ++i) {
                fieldIdList[i] = InputReader.getInt("Field id (0): ", 0);
            }
        }
        return fieldIdList;
    }

    public static QueryInfo getQueryInfo() throws IOException, ARException {
        if (InputReader.getBoolean("Null QueryInfo (F): ", false)) {
            return null;
        }
        String form = InputReader.getString("Form (): ", "");
        String server = InputReader.getString("Server (): ", "");
        QualifierInfo qualifier = InputReader.getQualifierInfo();
        int fieldId = InputReader.getInt("Field id (0): ", 0);
        int multiMatchCode = InputReader.getInt("Multi-Match code (error, first, set) (1, 2, 3) (1): ", 1);
        return new QueryInfo(form, server, qualifier, fieldId, multiMatchCode);
    }

    public static NotifyAction getNotifyActionInfo() throws IOException {
        if (InputReader.getBoolean("Null NotifyActionInfo (F): ", false)) {
            return null;
        }
        NotifyAction info = new NotifyAction();
        JavaDriver.outputWriter.driverPrintHeader("Filter Action Notify (): ");
        int notifyMechanism = InputReader.getInt("   Notifier, Email, Default, other, or XRef (1, 2, 3, 4-98, 99): ", 0);
        info.setNotifyMechanism(notifyMechanism);
        if (notifyMechanism == 99) {
            int ref = InputReader.getInt("   Cross-reference field id: ", 0);
            info.setNotifyMechanismXRef(ref);
        }
        String user = InputReader.getString("   User name: ", "");
        info.setUser(user);
        String text = InputReader.getString("   Notify text (): ", "");
        info.setNotifyText(text);
        int notifyPriority = InputReader.getInt("   Notify priority (1 to 10) (1): ", 1);
        info.setNotifyPriority(notifyPriority);
        String subject = InputReader.getString("   Notify subject (): ", "");
        info.setSubjectText(subject);
        boolean isAdvanced = InputReader.getBoolean("Is Advanced Notify Action (F): ", false);
        if (isAdvanced) {
            info.setFrom(InputReader.getString("   From user: ", ""));
            info.setReplyTo(InputReader.getString("   Reply To: ", ""));
            info.setCc(InputReader.getString("   Cc user: ", ""));
            info.setBcc(InputReader.getString("   Bcc user: ", ""));
            info.setOrganization(InputReader.getString("   Organization: ", ""));
            info.setMailboxName(InputReader.getString("   Mailbox name: ", ""));
            info.setHeaderTemplate(InputReader.getString("   Header template: ", ""));
            info.setFooterTemplate(InputReader.getString("   Footer template: ", ""));
            info.setContentTemplate(InputReader.getString("   Content template: ", ""));
        }
        int fieldIdListType = InputReader.getInt("   None, All, specific list, or changed (0, 1, 2, 3) (0): ", 0);
        info.setFieldIdListType(fieldIdListType);
        if (fieldIdListType == 2) {
            List<Integer> idList = InputReader.getIntegerList();
            info.setFieldIdList(idList);
        }
        return info;
    }

    public static StatusInfo getStatusInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("Status Info:");
        if (InputReader.getBoolean("Null StatusInfo (F): ", false)) {
            return null;
        }
        int messageType = InputReader.getInt("   Note, Warning, or Error (0, 1, 2) (2) : ", 2);
        long messageNum = InputReader.getLong("   Message number (0): ", 0L);
        String text = InputReader.getString("   Message text (): ", "");
        String appendedText = InputReader.getString("Appended Text():", "");
        return new StatusInfo(messageType, messageNum, text, appendedText);
    }

    public static CommitChangesAction getCommitChangesInfo() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("   Active Link Commit Changes Info :");
        if (InputReader.getBoolean("Null CommitChangesInfo (F): ", false)) {
            return null;
        }
        String formName = InputReader.getString("      Form Name (): ", "");
        return new CommitChangesAction(formName);
    }

    public static String getFileContents(String fileName) throws IOException, FileNotFoundException {
        File file = new File(fileName);
        FileReader fileReader = new FileReader(file);
        long length = file.length();
        char[] buffer = new char[(int)length + 1];
        String contents = null;
        if ((long)fileReader.read(buffer, 0, (int)length) != length) {
            fileReader.close();
            JavaDriver.outputWriter.driverPrintWarning("Not able to read the entire file..\n");
            throw new IOException("Not able to read the entire file..\n");
        }
        contents = new String(buffer);
        fileReader.close();
        return contents;
    }

    public static String getFileContent(String promt, String defaultFilePath, int numberOfAttempts, OutputWriter outputWriter) {
        String fileName = null;
        String content = null;
        for (int i = 0; i < numberOfAttempts; ++i) {
            try {
                fileName = InputReader.getString(promt, defaultFilePath);
                content = InputReader.getFileContents(fileName);
                continue;
            }
            catch (Throwable e2) {
                outputWriter.printString(String.format("Could not read from given input file;%s\n", i + 1 < numberOfAttempts ? String.format("Retry (%d)...", i + 1) : ""));
            }
        }
        return content;
    }

    public static ReferenceType[] getReferenceTypeList() throws IOException {
        int numItems = InputReader.getInt("   Number of reference types (0): ", 0);
        ReferenceType[] list = null;
        if (numItems != 0) {
            list = new ReferenceType[numItems];
            for (int i = 0; i < numItems; ++i) {
                list[i] = InputReader.getReferenceType();
            }
        }
        return list;
    }

    public static SupportFileKey getSupportFileKey() throws IOException {
        if (InputReader.getBoolean("Null SupportFileKey? (F): ", false)) {
            return null;
        }
        int fileType = InputReader.getInt("File type -- external report (1) (1):", 1);
        String name = InputReader.getString("Name of associated object: ", "");
        int fieldID = InputReader.getInt("Supporting ID for object (0):", 0);
        int fileID = InputReader.getInt("ID for the file (1): ", 1);
        return new SupportFileKey(fileType, name, fieldID, fileID);
    }

    public static LocalizedValueCriteria getLocalizedValueCriteria() throws IOException {
        if (InputReader.getBoolean("Null LocalizedValueCriteria? (F):", false)) {
            return null;
        }
        LocalizedValueCriteria criteria = new LocalizedValueCriteria();
        criteria.setRetrieveAll(false);
        if (InputReader.getBooleanForChangingInfo("get Localized Values? (T): ", true)) {
            criteria.setPropertiesToRetrieve(1 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBooleanForChangingInfo("get Timestamps? (T): ", true)) {
            criteria.setPropertiesToRetrieve(2 | criteria.getPropertiesToRetrieve());
        }
        return criteria;
    }

    public static AlertMessageCriteria getAlertMessageCriteria() throws IOException {
        AlertMessageCriteria criteria = new AlertMessageCriteria();
        criteria.setRetrieveAll(false);
        if (InputReader.getBoolean("get Timestamp? (T): ", true)) {
            criteria.setPropertiesToRetrieve(1 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get sourceType? (T): ", true)) {
            criteria.setPropertiesToRetrieve(2 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get priority? (T): ", true)) {
            criteria.setPropertiesToRetrieve(4 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get alertText? (T): ", true)) {
            criteria.setPropertiesToRetrieve(8 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get sourceTag? (T): ", true)) {
            criteria.setPropertiesToRetrieve(0x10 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get serverName? (T): ", true)) {
            criteria.setPropertiesToRetrieve(0x20 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get serverAddress? (T): ", true)) {
            criteria.setPropertiesToRetrieve(0x100 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get formName? (T): ", true)) {
            criteria.setPropertiesToRetrieve(0x40 | criteria.getPropertiesToRetrieve());
        }
        if (InputReader.getBoolean("get objectId? (T): ", true)) {
            criteria.setPropertiesToRetrieve(0x80 | criteria.getPropertiesToRetrieve());
        }
        return criteria;
    }

    public static String getString(String prompt) throws IOException {
        return InputReader.getString(prompt, "");
    }

    public static JoinForm getJoinForm() throws IOException, ARException {
        if (InputReader.getBoolean("Null JoinForm (F): ", false)) {
            return null;
        }
        String memberA = InputReader.getString("Join member A name");
        String memberB = InputReader.getString("Join member B name");
        QualifierInfo joinQual = InputReader.getQualifierInfo();
        int option = InputReader.getInt("   Join option(0): ", 0);
        return new JoinForm(memberA, memberB, joinQual, option);
    }

    public static ViewForm getViewForm() throws IOException {
        if (InputReader.getBoolean("Null ViewForm (F): ", false)) {
            return null;
        }
        String tableName = InputReader.getString("   View table name : ", "");
        String keyField = InputReader.getString("   Key Field ");
        return new ViewForm(tableName, keyField);
    }

    public static VendorForm getVendorForm() throws IOException {
        if (InputReader.getBoolean("Null VendorForm (F): ", false)) {
            return null;
        }
        String vendorName = InputReader.getString("   Vendor name ");
        String vtableName = InputReader.getString("   Vendor table name : ", "");
        return new VendorForm(vendorName, vtableName);
    }

    public static void openInputFile(String inputFileName) throws IOException {
        String fileName = null;
        fileName = inputFileName == null ? InputReader.getString("File name of input file ()", "") : inputFileName;
        if (fileName == null || fileName.length() == 0) {
            JavaDriver.outputWriter.driverPrintWarning("****No filename specified so no change to input file\n");
        } else {
            ThreadControlBlock threadControlBlockPtr = JavaDriver.getThreadControlBlockPtr();
            try {
                threadControlBlockPtr.setCurrentInputFile(fileName);
            }
            catch (FileNotFoundException e2) {
                JavaDriver.outputWriter.printString("**** File error during open; no change to input file: " + fileName + "\n");
            }
        }
    }

    public static String[] getStringList() throws IOException {
        if (InputReader.getBoolean("Null String List (F): ", false)) {
            return null;
        }
        String[] joinEntryList = null;
        int numEntries = InputReader.getInt("Number Of Entries (1):", 1);
        if (numEntries > 0) {
            joinEntryList = new String[numEntries];
            for (int i = 0; i < numEntries; ++i) {
                joinEntryList[i] = InputReader.getString("", "");
            }
        }
        return joinEntryList;
    }

    public static WorkflowLockInfo getWorkflowLockInfo() throws IOException {
        if (InputReader.getBoolean("Null WorkflowLockInfo (F): ", false)) {
            return null;
        }
        int lockType = InputReader.getInt("   Lock type (0-None, 1-Read, 2-Hidden) (0): ", 0);
        String lockKey = null;
        if (lockType > 0) {
            lockKey = InputReader.getString("   Lock Key: ");
        }
        return new WorkflowLockInfo(lockType, lockKey);
    }

    public static WfdBreakpoint WFDFillBreakPt(boolean local) throws IOException {
        WfdBreakpoint bp = new WfdBreakpoint();
        if (!local) {
            bp.id = InputReader.getInt("  BP location -\n  ID ? (0): ", 0);
        }
        bp.filter = InputReader.getString("  Filter: ", "FilterName");
        bp.schema = InputReader.getString("  Schema (*): ", "*");
        bp.stage = 3 + InputReader.getInt("  Stage PreAPI/PreQual/Phase1/Phase2/Phase3/Escl/CMDB (0-5) (4): ", 1);
        bp.elsePath = InputReader.getBoolean("  Else path? (F): ", false);
        bp.actionNo = InputReader.getInt("  Action number (0): ", 0);
        bp.disable = InputReader.getBoolean("  Disabled (F): ", false);
        bp.passcount = InputReader.getInt("  Passcount ? (0): ", 0);
        bp.bpQualifier = null;
        return bp;
    }

    public static RegularQuery getRegularQuery() throws IOException, ARException {
        RegularQuery query = new RegularQuery();
        query.setFromSources(InputReader.getQuerySourceList(""));
        query.setFromFields(InputReader.getQueryFormFieldList(query.getFromSources(), ""));
        query.setQualifier(InputReader.getQualifierInfo(query.getFromSources(), "Qualifier Info", ""));
        query.setSortBy(InputReader.getSortInfoList());
        return query;
    }

    public static RecursiveQuery getRecursiveQuery() throws IOException, ARException {
        RecursiveQuery recQuery = new RecursiveQuery();
        recQuery.setFromSources(InputReader.getQuerySourceList(recQuery, "      "));
        recQuery.setFromFields(InputReader.getQueryFormFieldList(recQuery.getFromSources(), "      "));
        recQuery.setQualifier(InputReader.getQualifierInfo(recQuery.getFromSources(), "Start qualifier", "      "));
        ArrayList<IQuerySource> recQualSources = new ArrayList<IQuerySource>(recQuery.getFromSources().size() + 1);
        recQualSources.addAll(recQuery.getFromSources());
        recQualSources.add(recQuery);
        recQuery.setRecursionQualifier(InputReader.getQualifierInfo(recQualSources, "Recursion qualifier", "      "));
        recQuery.setLevelsToRetrieve(InputReader.getInt("      Levels to retrieve (0): ", 0));
        return recQuery;
    }

    public static List<IQuerySource> getQuerySourceList(String indent) throws IOException, ARException {
        return InputReader.getQuerySourceList(null, indent);
    }

    public static List<IQuerySource> getQuerySourceList(RecursiveQuery recQuery, String indent) throws IOException, ARException {
        ArrayList<IQuerySource> querySourceList = null;
        IQuerySource source = null;
        int numItems = InputReader.getInt(indent + "Number of query sources (0): ", 0);
        if (numItems > 0) {
            querySourceList = new ArrayList<IQuerySource>(numItems);
            int i = 0;
            while (i < numItems) {
                source = InputReader.getQuerySource(indent, recQuery, i == 0 ? null : querySourceList);
                if (source == null) continue;
                querySourceList.add(source);
                ++i;
            }
        }
        return querySourceList;
    }

    public static IQuerySource getQuerySource(String indent, RecursiveQuery recQuery, List<IQuerySource> joinableSources) throws IOException, ARException {
        JavaDriver.outputWriter.driverPrintPrompt(indent + "    Query source: \n");
        IQuerySource querySource = null;
        boolean recurseOn = false;
        int sourceType = recQuery == null ? InputReader.getInt(indent + "      Type: Form name, Nested, Recursive (0 - 2) (0): ", 0) : 0;
        if (sourceType == 0) {
            querySource = new QuerySourceForm(InputReader.getString(indent + "      Form: ", ""));
            if (recQuery != null && !recurseOn && (recurseOn = InputReader.getBoolean(indent + "      Recurse on this form (T): ", true))) {
                recQuery.setRecursiveForm((QuerySourceForm)querySource);
            }
        } else if (sourceType == 2) {
            querySource = InputReader.getRecursiveQuery();
        } else {
            JavaDriver.outputWriter.driverPrintWarning("****This query type is not supported\n");
            return null;
        }
        if (querySource != null && joinableSources != null && joinableSources.size() > 0) {
            ArrayList<IQuerySource> qualifierSources = new ArrayList<IQuerySource>(joinableSources.size() + 1);
            qualifierSources.addAll(joinableSources);
            qualifierSources.add(querySource);
            querySource.setJoinType(InputReader.getInt(indent + "      Join type: Inner, Left, Right (0 - 2) (0): ", 0));
            querySource.setJoinQualifier(InputReader.getQualifierInfo(qualifierSources, "Join qualifier", indent + "      "));
            querySource.setJoinedWith(InputReader.getSourceJoinedWith(joinableSources, indent + "      "));
        }
        return querySource;
    }

    public static IQuerySource getSourceJoinedWith(List<IQuerySource> sources, String indent) throws IOException {
        int idx = InputReader.getInt(indent + "Joined with (" + InputReader.getQuerySourcesPrompt(sources) + ") (0): ", 0);
        return sources.get(idx);
    }

    public static List<QueryFormField> getQueryFormFieldList(List<IQuerySource> sources, String indent) throws IOException {
        ArrayList<QueryFormField> queryFromFieldList = null;
        int numItems = InputReader.getInt(indent + "Number of query fields (0): ", 0);
        if (numItems > 0) {
            queryFromFieldList = new ArrayList<QueryFormField>(numItems);
            for (int i = 0; i < numItems; ++i) {
                queryFromFieldList.add(InputReader.getQueryFormField(sources, indent));
            }
        }
        return queryFromFieldList;
    }

    public static QueryFormField getQueryFormField(List<IQuerySource> sources, String indent) throws IOException {
        QueryFormField queryFromField = new QueryFormField();
        JavaDriver.outputWriter.driverPrintPrompt(indent + "    Query field: \n");
        queryFromField.setFieldId(InputReader.getInt(indent + "      Field id (0): ", 0));
        int idx = InputReader.getInt(indent + "      Field source (" + InputReader.getQuerySourcesPrompt(sources) + ") (0): ", 0);
        queryFromField.setSource(sources.get(idx));
        return queryFromField;
    }

    public static ValueSetQuery getValueSetQuery(String indent) throws IOException, ARException {
        ArrayList<QueryFormField> queryFromFieldList = new ArrayList<QueryFormField>(1);
        ValueSetQuery query = new ValueSetQuery();
        query.setFromSources(InputReader.getQuerySourceList(indent));
        queryFromFieldList.add(InputReader.getQueryFormField(query.getFromSources(), indent));
        query.setFromFields(queryFromFieldList);
        query.setQualifier(InputReader.getQualifierInfo(query.getFromSources(), "Qualifier Info", indent));
        return query;
    }

    private static String getQuerySourcesPrompt(List<IQuerySource> sources) throws IOException {
        String sourceList = "";
        for (int i = 0; i < sources.size(); ++i) {
            if (sources.get(i) instanceof RecursiveQuery) {
                sourceList = sourceList + "Recursive query - " + i + ", ";
                continue;
            }
            if (!(sources.get(i) instanceof QuerySourceForm)) continue;
            sourceList = sourceList + ((QuerySourceForm)sources.get(i)).getName() + "(" + i + "), ";
        }
        if (sourceList.endsWith(", ")) {
            sourceList = sourceList.substring(0, sourceList.length() - 2);
        }
        return sourceList;
    }

    private static void checkDecimalFormat(String value) throws ARException {
        CurrencyValue.checkDecimalFormat(value);
    }

    public static ImageData getImageData() throws IOException {
        int option = InputReader.getInt("Choose:\n   1 - prompt for filename \n   2 - prompt for string\n default (1): ", 1);
        ImageData data = null;
        switch (option) {
            case 1: {
                String filename = InputReader.getString("Image File name (): ", "");
                data = new ImageData(filename);
                break;
            }
            case 2: {
                int length = InputReader.getInt("Number of Items in the List (0): ", 0);
                byte[] byteBuffer = new byte[1024];
                char[] charBuffer = new char[length];
                for (int i = 0; i < length; ++i) {
                    charBuffer[i] = InputReader.getChar("Byte[" + i + "]", ' ');
                }
                byteBuffer = charBuffer.toString().getBytes();
                data = new ImageData(byteBuffer);
            }
        }
        return data;
    }

    public static String[] getObjectModificationLogLabelAndTaskName() throws IOException {
        String[] rst = new String[]{InputReader.getString("Object Modification Log Label (): ", "")};
        if (rst[0].length() == 0) {
            rst[0] = null;
        }
        return rst;
    }
}

