/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.struts;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeanUtils;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.context.ApplicationContextException;
import com.bmc.thirdparty.org.springframework.context.ConfigurableApplicationContext;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.context.ConfigurableWebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.support.WebApplicationContextUtils;
import com.bmc.thirdparty.org.springframework.web.struts.ActionServletAwareProcessor;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;

public class ContextLoaderPlugIn
implements PlugIn {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$springframework$web$context$support$XmlWebApplicationContext == null ? (class$org$springframework$web$context$support$XmlWebApplicationContext = ContextLoaderPlugIn.class$("com.bmc.thirdparty.org.springframework.web.context.support.XmlWebApplicationContext")) : class$org$springframework$web$context$support$XmlWebApplicationContext;
    public static final String SERVLET_CONTEXT_PREFIX = (class$org$springframework$web$struts$ContextLoaderPlugIn == null ? (class$org$springframework$web$struts$ContextLoaderPlugIn = ContextLoaderPlugIn.class$("com.bmc.thirdparty.org.springframework.web.struts.ContextLoaderPlugIn")) : class$org$springframework$web$struts$ContextLoaderPlugIn).getName() + ".CONTEXT.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private ActionServlet actionServlet;
    private ModuleConfig moduleConfig;
    private WebApplicationContext webApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$support$XmlWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$struts$ContextLoaderPlugIn;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;
    static /* synthetic */ Class class$org$apache$struts$action$ActionServlet;

    public void setContextClassName(String contextClassName) throws ClassNotFoundException {
        this.contextClass = ClassUtils.forName(contextClassName);
    }

    public void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        if (this.actionServlet != null) {
            return this.actionServlet.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
        }
        return null;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public final void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        long startTime = System.currentTimeMillis();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ContextLoaderPlugIn for Struts ActionServlet '" + actionServlet.getServletName() + ", module '" + moduleConfig.getPrefix() + "': initialization started");
        }
        this.actionServlet = actionServlet;
        this.moduleConfig = moduleConfig;
        try {
            this.webApplicationContext = this.initWebApplicationContext();
            this.onInit();
        }
        catch (RuntimeException ex) {
            this.logger.error("Context initialization failed", ex);
            throw ex;
        }
        if (this.logger.isInfoEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info("ContextLoaderPlugIn for Struts ActionServlet '" + actionServlet.getServletName() + "', module '" + moduleConfig.getPrefix() + "': initialization completed in " + elapsedTime + " ms");
        }
    }

    public final ActionServlet getActionServlet() {
        return this.actionServlet;
    }

    public final String getServletName() {
        return this.actionServlet.getServletName();
    }

    public final ServletContext getServletContext() {
        return this.actionServlet.getServletContext();
    }

    public final ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public final String getModulePrefix() {
        return this.moduleConfig.getPrefix();
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException, IllegalStateException {
        this.getServletContext().log("Initializing WebApplicationContext for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "'");
        WebApplicationContext parent = WebApplicationContextUtils.getWebApplicationContext(this.getServletContext());
        WebApplicationContext wac = this.createWebApplicationContext(parent);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Using context class '" + wac.getClass().getName() + "' for servlet '" + this.getServletName() + "'");
        }
        String attrName = this.getServletContextAttributeName();
        this.getServletContext().setAttribute(attrName, (Object)wac);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Published WebApplicationContext of Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "' as ServletContext attribute with name [" + attrName + "]");
        }
        return wac;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext parent) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ContextLoaderPlugIn for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "' will try to create custom WebApplicationContext " + "context of class '" + this.getContextClass().getName() + "', using parent context [" + parent + "]");
        }
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoaderPlugIn.class$("com.bmc.thirdparty.org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in ContextLoaderPlugIn for Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "': custom WebApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(this.getContextClass());
        wac.setParent(parent);
        wac.setServletContext(this.getServletContext());
        wac.setNamespace(this.getNamespace());
        if (this.getContextConfigLocation() != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray(this.getContextConfigLocation(), ",; \t\n"));
        }
        wac.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
                beanFactory.addBeanPostProcessor(new ActionServletAwareProcessor(ContextLoaderPlugIn.this.getActionServlet()));
                beanFactory.ignoreDependencyType(class$org$apache$struts$action$ActionServlet == null ? (class$org$apache$struts$action$ActionServlet = ContextLoaderPlugIn.class$("org.apache.struts.action.ActionServlet")) : class$org$apache$struts$action$ActionServlet);
            }
        });
        wac.refresh();
        return wac;
    }

    public String getServletContextAttributeName() {
        return SERVLET_CONTEXT_PREFIX + this.getModulePrefix();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void onInit() throws ServletException {
    }

    public void destroy() {
        this.getServletContext().log("Closing WebApplicationContext of Struts ActionServlet '" + this.getServletName() + "', module '" + this.getModulePrefix() + "'");
        if (this.getWebApplicationContext() instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)((Object)this.getWebApplicationContext())).close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

