/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.util;

import com.bmc.thirdparty.org.springframework.util.PropertiesPersister;
import com.bmc.thirdparty.org.springframework.util.ReflectionUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class DefaultPropertiesPersister
implements PropertiesPersister {
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    public void load(Properties props, InputStream is) throws IOException {
        props.load(is);
    }

    public void load(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + StringUtils.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace(key);
            value = StringUtils.trimLeadingWhitespace(value);
            props.put(this.unescape(key), this.unescape(value));
        }
        return;
    }

    protected boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    protected String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index = 0;
        while (index < str.length()) {
            int c2;
            if ((c2 = str.charAt(index++)) == 92) {
                if ((c2 = str.charAt(index++)) == 116) {
                    c2 = 9;
                } else if (c2 == 114) {
                    c2 = 13;
                } else if (c2 == 110) {
                    c2 = 10;
                } else if (c2 == 102) {
                    c2 = 12;
                }
            }
            outBuffer.append((char)c2);
        }
        return outBuffer.toString();
    }

    public void store(Properties props, OutputStream os, String header) throws IOException {
        props.store(os, header);
    }

    public void store(Properties props, Writer writer, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            out.write(this.escape(key, true) + "=" + this.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    protected String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int index = 0; index < len; ++index) {
            char c2 = str.charAt(index);
            switch (c2) {
                case ' ': {
                    if (index == 0 || isKey) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    outBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block8;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block8;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c2) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c2);
                }
            }
        }
        return outBuffer.toString();
    }

    public void loadFromXml(Properties props, InputStream is) throws IOException {
        try {
            Method loadMethod = props.getClass().getMethod("loadFromXML", class$java$io$InputStream == null ? (class$java$io$InputStream = DefaultPropertiesPersister.class$("java.io.InputStream")) : class$java$io$InputStream);
            loadMethod.invoke((Object)props, is);
        }
        catch (NoSuchMethodException ex) {
            throw new IOException("Cannot load properties XML file - not running on JDK 1.5+: " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof IOException) {
                throw (IOException)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    public void storeToXml(Properties props, OutputStream os, String header) throws IOException {
        try {
            Method storeMethod = props.getClass().getMethod("storeToXML", class$java$io$OutputStream == null ? (class$java$io$OutputStream = DefaultPropertiesPersister.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = DefaultPropertiesPersister.class$("java.lang.String")) : class$java$lang$String);
            storeMethod.invoke((Object)props, os, header);
        }
        catch (NoSuchMethodException ex) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof IOException) {
                throw (IOException)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    public void storeToXml(Properties props, OutputStream os, String header, String encoding) throws IOException {
        try {
            Method storeMethod = props.getClass().getMethod("storeToXML", class$java$io$OutputStream == null ? (class$java$io$OutputStream = DefaultPropertiesPersister.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = DefaultPropertiesPersister.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DefaultPropertiesPersister.class$("java.lang.String")) : class$java$lang$String);
            storeMethod.invoke((Object)props, os, header, encoding);
        }
        catch (NoSuchMethodException ex) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof IOException) {
                throw (IOException)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

