/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import com.bmc.thirdparty.org.springframework.core.io.ClassPathResource;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.jdbc.support.JdbcUtils;
import com.bmc.thirdparty.org.springframework.jdbc.support.MetaDataAccessException;
import com.bmc.thirdparty.org.springframework.jdbc.support.SQLErrorCodes;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.PatternMatchUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;

public class SQLErrorCodesFactory {
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "com/bmc/thirdparty/org/springframework/jdbc/support/sql-error-codes.xml";
    private static final Log logger = LogFactory.getLog(class$org$springframework$jdbc$support$SQLErrorCodesFactory == null ? (class$org$springframework$jdbc$support$SQLErrorCodesFactory = SQLErrorCodesFactory.class$("com.bmc.thirdparty.org.springframework.jdbc.support.SQLErrorCodesFactory")) : class$org$springframework$jdbc$support$SQLErrorCodesFactory);
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map errorCodesMap;
    private final Map dataSourceCache = new HashMap(16);
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodesFactory;
    static /* synthetic */ Class class$org$springframework$jdbc$support$SQLErrorCodes;

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        Map errorCodes = null;
        try {
            DefaultListableBeanFactory lbf = new DefaultListableBeanFactory();
            XmlBeanDefinitionReader bdr = new XmlBeanDefinitionReader(lbf);
            Resource resource = this.loadResource(SQL_ERROR_CODE_DEFAULT_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
            } else {
                logger.warn("Default sql-error-codes.xml not found (should be included in spring.jar)");
            }
            resource = this.loadResource(SQL_ERROR_CODE_OVERRIDE_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
                logger.info("Found custom sql-error-codes.xml file at the root of the classpath");
            }
            errorCodes = lbf.getBeansOfType(class$org$springframework$jdbc$support$SQLErrorCodes == null ? (class$org$springframework$jdbc$support$SQLErrorCodes = SQLErrorCodesFactory.class$("com.bmc.thirdparty.org.springframework.jdbc.support.SQLErrorCodes")) : class$org$springframework$jdbc$support$SQLErrorCodes, true, false);
            if (logger.isInfoEnabled()) {
                logger.info("SQLErrorCodes loaded: " + errorCodes.keySet());
            }
        }
        catch (BeansException ex) {
            logger.warn("Error loading SQL error codes from config file", ex);
            errorCodes = Collections.EMPTY_MAP;
        }
        this.errorCodesMap = errorCodes;
    }

    protected Resource loadResource(String path) {
        return new ClassPathResource(path);
    }

    public SQLErrorCodes getErrorCodes(String dbName) {
        Assert.notNull(dbName, "Database product name must not be null");
        SQLErrorCodes sec = (SQLErrorCodes)this.errorCodesMap.get(dbName);
        if (sec == null) {
            Iterator it = this.errorCodesMap.values().iterator();
            while (it.hasNext()) {
                SQLErrorCodes candidate = (SQLErrorCodes)it.next();
                if (!PatternMatchUtils.simpleMatch(candidate.getDatabaseProductNames(), dbName)) continue;
                sec = candidate;
                break;
            }
        }
        if (sec != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("SQL error codes for '" + dbName + "' found");
            }
            return sec;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SQL error codes for '" + dbName + "' not found");
        }
        return new SQLErrorCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes getErrorCodes(DataSource dataSource) {
        Assert.notNull(dataSource, "DataSource must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug("Looking up default SQLErrorCodes for DataSource [" + dataSource + "]");
        }
        Map map = this.dataSourceCache;
        synchronized (map) {
            SQLErrorCodes sec = (SQLErrorCodes)this.dataSourceCache.get(dataSource);
            if (sec != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SQLErrorCodes found in cache for DataSource [" + dataSource + "]");
                }
                return sec;
            }
            try {
                String dbName = (String)JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductName");
                if (dbName != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Database product name cached for DataSource [" + dataSource + "]: name is '" + dbName + "'");
                    }
                    sec = this.getErrorCodes(dbName);
                    this.dataSourceCache.put(dataSource, sec);
                    return sec;
                }
            }
            catch (MetaDataAccessException ex) {
                logger.warn("Error while extracting database product name - falling back to empty error codes", ex);
            }
        }
        return new SQLErrorCodes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

