/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.arsys.apitransport.ApiValueBase;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

class ProxyPool
implements Serializable {
    private static final long serialVersionUID = 4709098968089221055L;
    private int maxProxies;
    private int numberOfProxies;
    private Stack<ApiProxyI> pool;
    protected final ReentrantLock lock = new ReentrantLock();
    private static Logger a = Logger.getLogger(ProxyPool.class);

    ProxyPool(int n2) {
        this.maxProxies = n2;
        this.numberOfProxies = 0;
        this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized ApiProxyI get(ApiUserContextI apiUserContextI) throws ARException {
        if (!this.pool.empty()) {
            return this.pool.pop();
        }
        String string = "Tid_" + Thread.currentThread().getId() + " for server " + apiUserContextI.getServer() + (apiUserContextI.getPort() > 0 ? ":" + apiUserContextI.getPort() : "");
        if (this.numberOfProxies < this.maxProxies) {
            ApiProxyI apiProxyI = null;
            this.lock.lock();
            try {
                if (this.numberOfProxies < this.maxProxies) {
                    apiProxyI = ProxyManager.getProxyManager().createProxy(apiUserContextI);
                    ++this.numberOfProxies;
                    ApiValueBase apiValueBase = new ApiValueBase(1);
                    apiProxyI.ARSetSessionConfiguration(apiUserContextI, 6, apiValueBase);
                    a.debug("Created proxy.  numberOfProxies = " + this.numberOfProxies + ", pool size = " + this.pool.size() + ", max = " + this.maxProxies + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount() + " by " + string);
                }
            }
            finally {
                this.lock.unlock();
            }
            return apiProxyI;
        }
        do {
            try {
                a.info("We have reached the max number proxies in the pool; wait for one to become available for thread " + string);
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.pool.empty());
        a.info("The thread " + string + ", which was waiting for the available proxy, got one proxy");
        return this.pool.pop();
    }

    synchronized void put(ApiProxyI apiProxyI) {
        if (this.pool.size() < this.maxProxies) {
            this.pool.push(apiProxyI);
            this.notifyAll();
        } else {
            System.err.println("Proxy pool overflow! Size = " + this.pool.size() + ", max = " + this.maxProxies + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        this.lock.lock();
        try {
            Enumeration enumeration = this.pool.elements();
            while (enumeration.hasMoreElements()) {
                ApiProxyI apiProxyI = (ApiProxyI)enumeration.nextElement();
                try {
                    apiProxyI.ARTermination(null);
                }
                catch (ARException aRException) {
                    aRException.toString();
                }
            }
            this.pool.removeAllElements();
        }
        finally {
            this.lock.unlock();
        }
    }

    synchronized ProxyManager.PoolInfo getInfo(String string) {
        return new ProxyManager.PoolInfo(string, this.numberOfProxies - this.pool.size(), this.pool.size(), this.maxProxies - this.numberOfProxies);
    }

    private void a() {
        this.pool = new Stack();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Max Proxies", this.maxProxies).append("Number Of Proxies", this.numberOfProxies).append("Pool", this.pool).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.maxProxies).append(this.numberOfProxies).append(this.pool).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProxyPool)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ProxyPool proxyPool = (ProxyPool)object;
        return new EqualsBuilder().append(this.maxProxies, proxyPool.maxProxies).append(this.numberOfProxies, proxyPool.numberOfProxies).append(this.pool, proxyPool.pool).isEquals();
    }
}

