/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcException;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrEncodingStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class XdrUdpEncodingStream
extends XdrEncodingStream {
    private DatagramSocket socket;
    private InetAddress receiverAddress = null;
    private int receiverPort = 0;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public XdrUdpEncodingStream(DatagramSocket datagramSocket, int n2) {
        this.socket = datagramSocket;
        if (n2 < 1024) {
            n2 = 1024;
        }
        if ((n2 & 3) != 0) {
            n2 = n2 + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[n2];
        this.bufferIndex = 0;
        this.bufferHighmark = n2 - 4;
    }

    public void beginEncoding(InetAddress inetAddress, int n2) throws OncRpcException, IOException {
        this.receiverAddress = inetAddress;
        this.receiverPort = n2;
        this.bufferIndex = 0;
    }

    public void endEncoding() throws OncRpcException, IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.buffer, this.bufferIndex, this.receiverAddress, this.receiverPort);
        this.socket.send(datagramPacket);
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    public void xdrEncodeInt(int n2) throws OncRpcException, IOException {
        if (this.bufferIndex > this.bufferHighmark) {
            throw new OncRpcException(42);
        }
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 24);
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 16);
        this.buffer[this.bufferIndex++] = (byte)(n2 >>> 8);
        this.buffer[this.bufferIndex++] = (byte)n2;
    }

    public void xdrEncodeOpaque(byte[] byArray, int n2, int n3) throws OncRpcException, IOException {
        int n4 = 4 - (n3 & 3) & 3;
        if (this.bufferIndex <= this.bufferHighmark - (n3 + n4)) {
            System.arraycopy(byArray, n2, this.buffer, this.bufferIndex, n3);
            this.bufferIndex += n3;
            if (n4 != 0) {
                System.arraycopy(paddingZeros, 0, this.buffer, this.bufferIndex, n4);
                this.bufferIndex += n4;
            }
        } else {
            throw new OncRpcException(42);
        }
    }
}

