/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;

public class OncRpcTcpSocketHelper {
    private Socket socket;
    private Method methodSetSendBufferSize;
    private Method methodSetReceiveBufferSize;
    private Method methodGetSendBufferSize;
    private Method methodGetReceiveBufferSize;
    private Method methodConnect;
    private Constructor ctor;

    public OncRpcTcpSocketHelper(Socket socket) {
        this();
        this.socket = socket;
    }

    public OncRpcTcpSocketHelper() {
        this.inspectSocketClassMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket connect(InetAddress inetAddress, int n2, int n3) throws IOException {
        if (n3 < 0) {
            this.socket = new Socket(inetAddress, n2);
            return this.socket;
        }
        if (this.methodConnect != null) {
            try {
                this.socket = (Socket)this.ctor.newInstance(new Object[0]);
                this.methodConnect.invoke((Object)this.socket, inetAddress, new Integer(n3));
                return this.socket;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                if (!(throwable instanceof IllegalArgumentException)) return this.socket;
                throw (IllegalArgumentException)throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new SocketException(instantiationException.getMessage());
            }
        }
        Connectiator connectiator = new Connectiator(inetAddress, n2);
        connectiator.start();
        Connectiator connectiator2 = connectiator;
        synchronized (connectiator2) {
            try {
                connectiator.wait(n3);
            }
            catch (InterruptedException interruptedException) {
                connectiator.notRequiredAnyMore();
                throw new IOException("connect interrupted");
            }
            IOException iOException = connectiator.getIOException();
            if (iOException != null) {
                throw iOException;
            }
            this.socket = connectiator.getSocket();
            if (this.socket != null) return this.socket;
            throw new NoRouteToHostException("Operation timed out: connect");
        }
    }

    public void setSendBufferSize(int n2) throws SocketException {
        if (this.methodSetSendBufferSize != null) {
            try {
                this.methodSetSendBufferSize.invoke((Object)this.socket, new Integer(n2));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                if (throwable instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)throwable;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.methodGetSendBufferSize != null) {
            try {
                Object object = this.methodGetSendBufferSize.invoke((Object)this.socket, (Object[])null);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                throw new SocketException(throwable.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
        return 65536;
    }

    public void setReceiveBufferSize(int n2) throws SocketException {
        if (this.methodSetSendBufferSize != null) {
            try {
                this.methodSetReceiveBufferSize.invoke((Object)this.socket, new Integer(n2));
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                if (throwable instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)throwable;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.methodGetReceiveBufferSize != null) {
            try {
                Object object = this.methodGetReceiveBufferSize.invoke((Object)this.socket, (Object[])null);
                if (object instanceof Integer) {
                    return (Integer)object;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SocketException) {
                    throw (SocketException)throwable;
                }
                throw new SocketException(throwable.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SocketException(illegalAccessException.getMessage());
            }
        }
        return 65536;
    }

    protected void inspectSocketClassMethods() {
        Class<Socket> clazz = Socket.class;
        try {
            this.methodSetSendBufferSize = clazz.getMethod("setSendBufferSize", Integer.TYPE);
            this.methodGetSendBufferSize = clazz.getMethod("getSendBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.methodSetReceiveBufferSize = clazz.getMethod("setReceiveBufferSize", Integer.TYPE);
            this.methodGetReceiveBufferSize = clazz.getMethod("getReceiveBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ctor = clazz.getConstructor(new Class[0]);
            this.methodConnect = clazz.getMethod("connect", InetAddress.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Connectiator
    extends Thread {
        private InetAddress address;
        private int port;
        private IOException ioexception;
        private Socket socket;
        private boolean hitTheBucket = false;

        public Connectiator(InetAddress inetAddress, int n2) {
            this.address = inetAddress;
            this.port = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket socket = null;
            IOException iOException = null;
            try {
                socket = new Socket(this.address, this.port);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            Connectiator connectiator = this;
            synchronized (connectiator) {
                this.socket = socket;
                this.ioexception = iOException;
                this.notify();
                if (this.hitTheBucket && this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
            }
        }

        public IOException getIOException() {
            return this.ioexception;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void notRequiredAnyMore() {
            this.hitTheBucket = true;
            try {
                this.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

