/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcClient;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcDumpResult;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcException;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcGetPortResult;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcServerIdent;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcTcpClient;
import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcUdpClient;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrBoolean;
import com.bmc.thirdparty.org.acplt.oncrpc.XdrVoid;
import java.io.IOException;
import java.net.InetAddress;

public class OncRpcPortmapClient {
    public static final int PMAP_PORT = 111;
    public static final int PMAP_PROGRAM = 100000;
    public static final int PMAP_VERSION = 2;
    protected OncRpcClient portmapClient;

    public OncRpcPortmapClient(InetAddress inetAddress) throws OncRpcException, IOException {
        this(inetAddress, 17, 0);
    }

    public OncRpcPortmapClient(InetAddress inetAddress, int n2) throws OncRpcException, IOException {
        this(inetAddress, n2, -1);
    }

    public OncRpcPortmapClient(InetAddress inetAddress, int n2, int n3) throws OncRpcException, IOException {
        switch (n2) {
            case 17: {
                this.portmapClient = new OncRpcUdpClient(inetAddress, 100000, 2, 111);
                break;
            }
            case 6: {
                this.portmapClient = new OncRpcTcpClient(inetAddress, 100000, 2, 111, 0, n3);
                break;
            }
            default: {
                throw new OncRpcException(17);
            }
        }
    }

    public void close() throws OncRpcException {
        this.portmapClient.close();
    }

    public OncRpcClient getOncRpcClient() {
        return this.portmapClient;
    }

    public int getPort(int n2, int n3, int n4) throws OncRpcException {
        OncRpcServerIdent oncRpcServerIdent = new OncRpcServerIdent(n2, n3, n4, 0);
        OncRpcGetPortResult oncRpcGetPortResult = new OncRpcGetPortResult();
        try {
            this.portmapClient.call(3, oncRpcServerIdent, oncRpcGetPortResult);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        if (oncRpcGetPortResult.port == 0) {
            throw new OncRpcProgramNotRegisteredException();
        }
        return oncRpcGetPortResult.port;
    }

    public boolean setPort(int n2, int n3, int n4, int n5) throws OncRpcException {
        OncRpcServerIdent oncRpcServerIdent = new OncRpcServerIdent(n2, n3, n4, n5);
        XdrBoolean xdrBoolean = new XdrBoolean(false);
        try {
            this.portmapClient.call(1, oncRpcServerIdent, xdrBoolean);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        return xdrBoolean.booleanValue();
    }

    public boolean unsetPort(int n2, int n3) throws OncRpcException {
        OncRpcServerIdent oncRpcServerIdent = new OncRpcServerIdent(n2, n3, 0, 0);
        XdrBoolean xdrBoolean = new XdrBoolean(false);
        try {
            this.portmapClient.call(2, oncRpcServerIdent, xdrBoolean);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        return xdrBoolean.booleanValue();
    }

    public OncRpcServerIdent[] listServers() throws OncRpcException {
        OncRpcDumpResult oncRpcDumpResult = new OncRpcDumpResult();
        try {
            this.portmapClient.call(4, XdrVoid.XDR_VOID, oncRpcDumpResult);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
        Object[] objectArray = new OncRpcServerIdent[oncRpcDumpResult.servers.size()];
        oncRpcDumpResult.servers.copyInto(objectArray);
        return objectArray;
    }

    public void ping() throws OncRpcException {
        try {
            this.portmapClient.call(0, XdrVoid.XDR_VOID, XdrVoid.XDR_VOID);
        }
        catch (OncRpcException oncRpcException) {
            throw new OncRpcException(14);
        }
    }
}

