/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.BeanUtils;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BeanFactoryLocator;
import com.bmc.thirdparty.org.springframework.beans.factory.access.BeanFactoryReference;
import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.ApplicationContextException;
import com.bmc.thirdparty.org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import com.bmc.thirdparty.org.springframework.core.io.ClassPathResource;
import com.bmc.thirdparty.org.springframework.core.io.support.PropertiesLoaderUtils;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.context.ConfigurableWebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContext;

public class ContextLoader {
    public static final String CONTEXT_CLASS_PARAM = "contextClass";
    public static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";
    public static final String LOCATOR_FACTORY_SELECTOR_PARAM = "locatorFactorySelector";
    public static final String LOCATOR_FACTORY_KEY_PARAM = "parentContextKey";
    private static final String DEFAULT_STRATEGIES_PATH = "ContextLoader.properties";
    private static final Properties defaultStrategies;
    private final Log logger = LogFactory.getLog(class$org$springframework$web$context$ContextLoader == null ? (class$org$springframework$web$context$ContextLoader = ContextLoader.class$("com.bmc.thirdparty.org.springframework.web.context.ContextLoader")) : class$org$springframework$web$context$ContextLoader);
    private WebApplicationContext context;
    private BeanFactoryReference parentContextRef;
    static /* synthetic */ Class class$org$springframework$web$context$ContextLoader;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$WebApplicationContext;

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws IllegalStateException, BeansException {
        if (servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null) {
            throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ContextLoader* definitions in your web.xml!");
        }
        long startTime = System.currentTimeMillis();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Root WebApplicationContext: initialization started");
        }
        servletContext.log("Loading Spring root WebApplicationContext");
        try {
            ApplicationContext parent = this.loadParentContext(servletContext);
            this.context = this.createWebApplicationContext(servletContext, parent);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.context);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using context class [" + this.context.getClass().getName() + "] for root WebApplicationContext");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Published root WebApplicationContext [" + this.context + "] as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]");
            }
            if (this.logger.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                this.logger.info("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms");
            }
            return this.context;
        }
        catch (RuntimeException ex) {
            this.logger.error("Context initialization failed", ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            this.logger.error("Context initialization failed", err);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)err);
            throw err;
        }
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext parent) throws BeansException {
        Class contextClass;
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = ContextLoader.class$("com.bmc.thirdparty.org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(contextClass = this.determineContextClass(servletContext))) {
            throw new ApplicationContextException("Custom context class [" + contextClass.getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(contextClass);
        wac.setParent(parent);
        wac.setServletContext(servletContext);
        String configLocation = servletContext.getInitParameter(CONFIG_LOCATION_PARAM);
        if (configLocation != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray(configLocation, ",; \t\n"));
        }
        wac.refresh();
        return wac;
    }

    protected Class determineContextClass(ServletContext servletContext) throws ApplicationContextException {
        String contextClassName = servletContext.getInitParameter(CONTEXT_CLASS_PARAM);
        if (contextClassName != null) {
            try {
                return ClassUtils.forName(contextClassName);
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", ex);
            }
        }
        contextClassName = defaultStrategies.getProperty((class$org$springframework$web$context$WebApplicationContext == null ? (class$org$springframework$web$context$WebApplicationContext = ContextLoader.class$("com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext")) : class$org$springframework$web$context$WebApplicationContext).getName());
        try {
            return ClassUtils.forName(contextClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new ApplicationContextException("Failed to load default context class [" + contextClassName + "]", ex);
        }
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ApplicationContext parentContext = null;
        String locatorFactorySelector = servletContext.getInitParameter(LOCATOR_FACTORY_SELECTOR_PARAM);
        String parentContextKey = servletContext.getInitParameter(LOCATOR_FACTORY_KEY_PARAM);
        if (locatorFactorySelector != null) {
            BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance(locatorFactorySelector);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Getting parent context definition: using parent context key of '" + parentContextKey + "' with BeanFactoryLocator");
            }
            this.parentContextRef = locator.useBeanFactory(parentContextKey);
            parentContext = (ApplicationContext)this.parentContextRef.getFactory();
        }
        return parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWebApplicationContext(ServletContext servletContext) {
        servletContext.log("Closing Spring root WebApplicationContext");
        try {
            if (this.context instanceof ConfigurableWebApplicationContext) {
                ((ConfigurableWebApplicationContext)this.context).close();
            }
        }
        finally {
            if (this.parentContextRef != null) {
                this.parentContextRef.release();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, class$org$springframework$web$context$ContextLoader == null ? (class$org$springframework$web$context$ContextLoader = ContextLoader.class$("com.bmc.thirdparty.org.springframework.web.context.ContextLoader")) : class$org$springframework$web$context$ContextLoader);
            defaultStrategies = PropertiesLoaderUtils.loadProperties(resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'ContextLoader.properties': " + ex.getMessage());
        }
    }
}

