/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.ejb.access;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.ejb.access.AbstractRemoteSlsbInvokerInterceptor;
import com.bmc.thirdparty.org.springframework.remoting.RemoteLookupFailureException;
import com.bmc.thirdparty.org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.naming.NamingException;

public class SimpleRemoteSlsbInvokerInterceptor
extends AbstractRemoteSlsbInvokerInterceptor {
    protected Object doInvoke(MethodInvocation invocation) throws Throwable {
        EJBObject ejb = null;
        try {
            ejb = this.getSessionBeanInstance();
            Object object = RmiClientInterceptorUtils.doInvoke(invocation, (Remote)ejb);
            return object;
        }
        catch (NamingException ex) {
            throw new RemoteLookupFailureException("Failed to locate remote EJB [" + this.getJndiName() + "]", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof RemoteException) {
                RemoteException rex = (RemoteException)targetEx;
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), rex, this.isConnectFailure(rex), this.getJndiName());
            }
            if (targetEx instanceof CreateException) {
                throw RmiClientInterceptorUtils.convertRmiAccessException(invocation.getMethod(), targetEx, "Could not create remote EJB [" + this.getJndiName() + "]");
            }
            throw targetEx;
        }
        finally {
            if (ejb != null) {
                this.releaseSessionBeanInstance(ejb);
            }
        }
    }

    protected EJBObject getSessionBeanInstance() throws NamingException, InvocationTargetException {
        return this.newSessionBeanInstance();
    }

    protected void releaseSessionBeanInstance(EJBObject ejb) {
        this.removeSessionBeanInstance(ejb);
    }
}

