/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.acplt.oncrpc;

import com.bmc.thirdparty.org.acplt.oncrpc.OncRpcException;
import java.io.IOException;
import java.net.InetAddress;

public abstract class XdrEncodingStream {
    private String characterEncoding = null;

    public void beginEncoding(InetAddress inetAddress, int n2) throws OncRpcException, IOException {
    }

    public void endEncoding() throws OncRpcException, IOException {
    }

    public void close() throws OncRpcException, IOException {
    }

    public abstract void xdrEncodeInt(int var1) throws OncRpcException, IOException;

    public abstract void xdrEncodeOpaque(byte[] var1, int var2, int var3) throws OncRpcException, IOException;

    public final void xdrEncodeDynamicOpaque(byte[] byArray) throws OncRpcException, IOException {
        this.xdrEncodeInt(byArray.length);
        this.xdrEncodeOpaque(byArray);
    }

    public final void xdrEncodeOpaque(byte[] byArray) throws OncRpcException, IOException {
        this.xdrEncodeOpaque(byArray, 0, byArray.length);
    }

    public final void xdrEncodeOpaque(byte[] byArray, int n2) throws OncRpcException, IOException {
        if (byArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        this.xdrEncodeOpaque(byArray, 0, byArray.length);
    }

    public final void xdrEncodeByteVector(byte[] byArray) throws OncRpcException, IOException {
        int n2 = byArray.length;
        this.xdrEncodeInt(n2);
        if (n2 != 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.xdrEncodeInt(byArray[i2]);
            }
        }
    }

    public final void xdrEncodeByteFixedVector(byte[] byArray, int n2) throws OncRpcException, IOException {
        if (byArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        if (n2 != 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.xdrEncodeInt(byArray[i2]);
            }
        }
    }

    public final void xdrEncodeByte(byte by) throws OncRpcException, IOException {
        this.xdrEncodeInt(by);
    }

    public final void xdrEncodeShort(short s) throws OncRpcException, IOException {
        this.xdrEncodeInt(s);
    }

    public final void xdrEncodeLong(long l2) throws OncRpcException, IOException {
        this.xdrEncodeInt((int)(l2 >>> 32));
        this.xdrEncodeInt((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    public final void xdrEncodeFloat(float f2) throws OncRpcException, IOException {
        this.xdrEncodeInt(Float.floatToIntBits(f2));
    }

    public final void xdrEncodeDouble(double d2) throws OncRpcException, IOException {
        this.xdrEncodeLong(Double.doubleToLongBits(d2));
    }

    public final void xdrEncodeBoolean(boolean bl) throws OncRpcException, IOException {
        this.xdrEncodeInt(bl ? 1 : 0);
    }

    public void xdrEncodeString(String string) throws OncRpcException, IOException {
        if (this.characterEncoding != null) {
            this.xdrEncodeDynamicOpaque(string.getBytes(this.characterEncoding));
        } else {
            this.xdrEncodeDynamicOpaque(string.getBytes());
        }
    }

    public final void xdrEncodeShortVector(short[] sArray) throws OncRpcException, IOException {
        int n2 = sArray.length;
        this.xdrEncodeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeShort(sArray[i2]);
        }
    }

    public final void xdrEncodeShortFixedVector(short[] sArray, int n2) throws OncRpcException, IOException {
        if (sArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeShort(sArray[i2]);
        }
    }

    public final void xdrEncodeIntVector(int[] nArray) throws OncRpcException, IOException {
        int n2 = nArray.length;
        this.xdrEncodeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeInt(nArray[i2]);
        }
    }

    public final void xdrEncodeIntFixedVector(int[] nArray, int n2) throws OncRpcException, IOException {
        if (nArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeInt(nArray[i2]);
        }
    }

    public final void xdrEncodeLongVector(long[] lArray) throws OncRpcException, IOException {
        int n2 = lArray.length;
        this.xdrEncodeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeLong(lArray[i2]);
        }
    }

    public final void xdrEncodeLongFixedVector(long[] lArray, int n2) throws OncRpcException, IOException {
        if (lArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeLong(lArray[i2]);
        }
    }

    public final void xdrEncodeFloatVector(float[] fArray) throws OncRpcException, IOException {
        int n2 = fArray.length;
        this.xdrEncodeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeFloat(fArray[i2]);
        }
    }

    public final void xdrEncodeFloatFixedVector(float[] fArray, int n2) throws OncRpcException, IOException {
        if (fArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeFloat(fArray[i2]);
        }
    }

    public final void xdrEncodeDoubleVector(double[] dArray) throws OncRpcException, IOException {
        int n2 = dArray.length;
        this.xdrEncodeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeDouble(dArray[i2]);
        }
    }

    public final void xdrEncodeDoubleFixedVector(double[] dArray, int n2) throws OncRpcException, IOException {
        if (dArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeDouble(dArray[i2]);
        }
    }

    public final void xdrEncodeBooleanVector(boolean[] blArray) throws OncRpcException, IOException {
        int n2 = blArray.length;
        this.xdrEncodeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeBoolean(blArray[i2]);
        }
    }

    public final void xdrEncodeBooleanFixedVector(boolean[] blArray, int n2) throws OncRpcException, IOException {
        if (blArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeBoolean(blArray[i2]);
        }
    }

    public final void xdrEncodeStringVector(String[] stringArray) throws OncRpcException, IOException {
        int n2 = stringArray.length;
        this.xdrEncodeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeString(stringArray[i2]);
        }
    }

    public final void xdrEncodeStringFixedVector(String[] stringArray, int n2) throws OncRpcException, IOException {
        if (stringArray.length != n2) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.xdrEncodeString(stringArray[i2]);
        }
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

