/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api.internal;

import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.Timestamp;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.regex.Pattern;

public final class ConversionUtil {
    static Method decimalToPlainStringMethod;

    public static boolean getBooleanValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = ConversionUtil.getStringValue(object);
        if (string.compareToIgnoreCase("true") == 0) {
            return true;
        }
        if (string.compareToIgnoreCase("false") == 0) {
            return false;
        }
        return ConversionUtil.getIntValue(object) != 0;
    }

    public static char getCharValue(Object object) {
        if (object == null) {
            return '\u0000';
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Number) {
            return (char)((Number)object).intValue();
        }
        String string = ConversionUtil.getStringValue(object);
        if (string != null && string.length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public static byte getByteValue(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        return (byte)ConversionUtil.getIntValue(object);
    }

    public static short getShortValue(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Short) {
            return (short)((Short)object).intValue();
        }
        return (short)ConversionUtil.getIntValue(object);
    }

    public static int getIntValue(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Character) {
            return Character.getNumericValue(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return ((Byte)object).intValue();
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        if (object instanceof Float) {
            return ((Float)object).intValue();
        }
        if (object instanceof Double) {
            return ((Double)object).intValue();
        }
        if (object instanceof Time) {
            return (int)((Time)object).getValue();
        }
        if (object instanceof DateInfo) {
            return ((DateInfo)object).getValue();
        }
        if (object instanceof Timestamp) {
            return (int)((Timestamp)object).getValue();
        }
        String string = null;
        int n2 = 0;
        if (object instanceof Array) {
            string = ConversionUtil.getStringValue(object);
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return n2;
        }
        if (object instanceof Void) {
            return 0;
        }
        return 0;
    }

    public static long getLongValue(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        String string = null;
        long l2 = 0L;
        if (object instanceof Array) {
            string = ConversionUtil.getStringValue(object);
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null) {
            try {
                l2 = Long.parseLong(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return l2;
        }
        return ConversionUtil.getIntValue(object);
    }

    public static float getFloatValue(Object object) {
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        String string = null;
        float f2 = 0.0f;
        if (object instanceof Array) {
            string = ConversionUtil.getStringValue(object);
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null) {
            try {
                f2 = Float.parseFloat(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return f2;
        }
        return ConversionUtil.getIntValue(object);
    }

    private static boolean a(String string) {
        return Pattern.matches("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*", string);
    }

    public static double getDoubleValue(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string = null;
        double d2 = 0.0;
        if (object instanceof Array) {
            string = ConversionUtil.getStringValue(object);
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null && ConversionUtil.a(string)) {
            d2 = Double.parseDouble(string);
            return d2;
        }
        return ConversionUtil.getIntValue(object);
    }

    public static BigDecimal getBigDecimalValue(Object object) {
        if (object == null) {
            return new BigDecimal(0);
        }
        if (object instanceof Double) {
            return new BigDecimal(ConversionUtil.getDoubleValue(object));
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        String string = null;
        if (object instanceof Array) {
            string = ConversionUtil.getStringValue(object);
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null && string.length() > 0) {
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bigDecimal;
    }

    private static String a(BigDecimal bigDecimal) {
        if (decimalToPlainStringMethod != null) {
            try {
                return (String)decimalToPlainStringMethod.invoke((Object)bigDecimal, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bigDecimal.toString();
    }

    public static String getStringValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Array) {
            Object object2 = Array.get(object, 0);
            if (object2 instanceof Character) {
                return new String((char[])object);
            }
            if (object2 instanceof Byte) {
                return new String((byte[])object);
            }
        } else if (object instanceof BigDecimal) {
            return ConversionUtil.a((BigDecimal)object);
        }
        return object.toString();
    }

    public static int getARTimestamp(Timestamp timestamp) {
        int n2 = 0;
        if (timestamp != null) {
            n2 = (int)timestamp.getValue();
        }
        return n2;
    }

    public static int getARTimestamp(Date date) {
        int n2 = 0;
        if (date != null) {
            n2 = (int)(date.getTime() / 1000L);
        }
        return n2;
    }

    public static Date getSqlDateValue(long l2) {
        if (l2 > 0L) {
            return new Date(l2 * 1000L);
        }
        return new Date(0L);
    }

    public static Date getSqlDateValue(Object object) {
        return ConversionUtil.getSqlDateValue(ConversionUtil.getIntValue(object));
    }

    public static Date getSqlDateValue(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n4 <= 0) {
            return ConversionUtil.getSqlDateValue(0L);
        }
        return new Date(n2, n3, n4);
    }

    static {
        try {
            decimalToPlainStringMethod = BigDecimal.class.getMethod("toPlainString", null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

