/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Proxy;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.Value;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import org.apache.log4j.Logger;

class ProxyPool
implements Serializable {
    private static final long serialVersionUID = 4709098968089221055L;
    private int maxProxies;
    private int numberOfProxies;
    private Stack<Proxy> pool;
    private static Logger a = Logger.getLogger(ProxyPool.class);

    ProxyPool(int n2) {
        this.maxProxies = n2;
        this.numberOfProxies = 0;
        this.a();
    }

    synchronized Proxy get(ARServerUser aRServerUser) throws ARException {
        if (!this.pool.empty()) {
            return this.pool.pop();
        }
        String string = "Tid_" + Thread.currentThread().getId() + " for server " + aRServerUser.getServer() + (aRServerUser.getPort() > 0 ? ":" + aRServerUser.getPort() : "");
        if (this.numberOfProxies < this.maxProxies) {
            Proxy proxy = ProxyManager.getProxyManager().createProxy(aRServerUser);
            Value value = new Value(1);
            proxy.ARSetSessionConfiguration(aRServerUser, 6, value);
            ++this.numberOfProxies;
            a.info("Created proxy " + this.numberOfProxies + " by " + string);
            return proxy;
        }
        do {
            try {
                a.info("We have reached the max number proxies in the pool; wait for one to become available for thread " + string);
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.pool.empty());
        a.info("The thread " + string + ", which was waiting for the available proxy, got one proxy");
        return this.pool.pop();
    }

    synchronized void put(Proxy proxy) {
        if (this.pool.size() < this.maxProxies) {
            this.pool.push(proxy);
            this.notifyAll();
        } else {
            System.err.println("Proxy pool overflow! Size = " + this.pool.size() + ", max = " + this.maxProxies + "; current thread = " + Thread.currentThread() + "; total activeThread = " + Thread.activeCount());
        }
    }

    public synchronized void clear() {
        Enumeration enumeration = this.pool.elements();
        while (enumeration.hasMoreElements()) {
            Proxy proxy = (Proxy)enumeration.nextElement();
            try {
                proxy.ARTermination(null);
            }
            catch (ARException aRException) {
                aRException.toString();
            }
        }
        this.pool.removeAllElements();
    }

    synchronized ProxyManager.PoolInfo getInfo(String string) {
        return new ProxyManager.PoolInfo(string, this.numberOfProxies - this.pool.size(), this.pool.size(), this.maxProxies - this.numberOfProxies);
    }

    private void a() {
        this.pool = new Stack();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Max Proxies", this.maxProxies).append("Number Of Proxies", this.numberOfProxies).append("Pool", this.pool).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.maxProxies).append(this.numberOfProxies).append(this.pool).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProxyPool)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ProxyPool proxyPool = (ProxyPool)object;
        return new EqualsBuilder().append(this.maxProxies, proxyPool.maxProxies).append(this.numberOfProxies, proxyPool.numberOfProxies).append(this.pool, proxyPool.pool).isEquals();
    }
}

