/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList
extends ArrayList {
    protected ArrayList list = null;
    protected boolean fast = false;

    public FastArrayList() {
        this.list = new ArrayList();
    }

    public FastArrayList(int capacity) {
        this.list = new ArrayList(capacity);
    }

    public FastArrayList(Collection collection) {
        this.list = new ArrayList(collection);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
    }

    public boolean add(Object element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.add(element);
                this.list = temp;
                boolean bl = result;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.add(element);
            return bl;
        }
    }

    public void add(int index, Object element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.add(index, element);
                this.list = temp;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(index, element);
        }
    }

    public boolean addAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.addAll(collection);
                this.list = temp;
                boolean bl = result;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.addAll(collection);
            return bl;
        }
    }

    public boolean addAll(int index, Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = temp.addAll(index, collection);
                this.list = temp;
                boolean bl = result;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.addAll(index, collection);
            return bl;
        }
    }

    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.clear();
                this.list = temp;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    public Object clone() {
        FastArrayList results = null;
        if (this.fast) {
            results = new FastArrayList((Collection)this.list);
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                results = new FastArrayList((Collection)this.list);
            }
        }
        results.setFast(this.getFast());
        return results;
    }

    public boolean contains(Object element) {
        if (this.fast) {
            return this.list.contains(element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.contains(element);
            return bl;
        }
    }

    public boolean containsAll(Collection collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.containsAll(collection);
            return bl;
        }
    }

    public void ensureCapacity(int capacity) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.ensureCapacity(capacity);
                this.list = temp;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.ensureCapacity(capacity);
        }
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        List lo = (List)o2;
        if (this.fast) {
            ListIterator li1 = ((AbstractList)this.list).listIterator();
            ListIterator li2 = lo.listIterator();
            while (li1.hasNext() && li2.hasNext()) {
                Object o1 = li1.next();
                Object o22 = li2.next();
                if (o1 == null ? o22 == null : o1.equals(o22)) continue;
                return false;
            }
            return !li1.hasNext() && !li2.hasNext();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator li1 = ((AbstractList)this.list).listIterator();
            ListIterator li2 = lo.listIterator();
            while (li1.hasNext() && li2.hasNext()) {
                Object o1 = li1.next();
                Object o23 = li2.next();
                if (o1 == null ? o23 == null : o1.equals(o23)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !li1.hasNext() && !li2.hasNext();
            return bl;
        }
    }

    public Object get(int index) {
        if (this.fast) {
            return this.list.get(index);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e2 = this.list.get(index);
            return e2;
        }
    }

    public int hashCode() {
        if (this.fast) {
            int hashCode = 1;
            Iterator i2 = ((AbstractList)this.list).iterator();
            while (i2.hasNext()) {
                Object o2 = i2.next();
                hashCode = 31 * hashCode + (o2 == null ? 0 : o2.hashCode());
            }
            return hashCode;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int hashCode = 1;
            Iterator i3 = ((AbstractList)this.list).iterator();
            while (i3.hasNext()) {
                Object o3 = i3.next();
                hashCode = 31 * hashCode + (o3 == null ? 0 : o3.hashCode());
            }
            int n2 = hashCode;
            return n2;
        }
    }

    public int indexOf(Object element) {
        if (this.fast) {
            return this.list.indexOf(element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.indexOf(element);
            return n2;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.isEmpty();
            return bl;
        }
    }

    public Iterator iterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return ((AbstractList)this.list).iterator();
    }

    public int lastIndexOf(Object element) {
        if (this.fast) {
            return this.list.lastIndexOf(element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.lastIndexOf(element);
            return n2;
        }
    }

    public ListIterator listIterator() {
        if (this.fast) {
            return new ListIter(0);
        }
        return ((AbstractList)this.list).listIterator();
    }

    public ListIterator listIterator(int index) {
        if (this.fast) {
            return new ListIter(index);
        }
        return ((AbstractList)this.list).listIterator(index);
    }

    public Object remove(int index) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                Object result = temp.remove(index);
                this.list = temp;
                Object e2 = result;
                return e2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e3 = this.list.remove(index);
            return e3;
        }
    }

    public boolean remove(Object element) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = ((AbstractCollection)temp).remove(element);
                this.list = temp;
                boolean bl = result;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = ((AbstractCollection)this.list).remove(element);
            return bl;
        }
    }

    public boolean removeAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = ((AbstractCollection)temp).removeAll(collection);
                this.list = temp;
                boolean bl = result;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = ((AbstractCollection)this.list).removeAll(collection);
            return bl;
        }
    }

    public boolean retainAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                boolean result = ((AbstractCollection)temp).retainAll(collection);
                this.list = temp;
                boolean bl = result;
                return bl;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = ((AbstractCollection)this.list).retainAll(collection);
            return bl;
        }
    }

    public Object set(int index, Object element) {
        if (this.fast) {
            return this.list.set(index, element);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object = this.list.set(index, element);
            return object;
        }
    }

    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n2 = this.list.size();
            return n2;
        }
    }

    public List subList(int fromIndex, int toIndex) {
        if (this.fast) {
            return new SubList(fromIndex, toIndex);
        }
        return ((AbstractList)this.list).subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
    }

    public Object[] toArray(Object[] array) {
        if (this.fast) {
            return this.list.toArray(array);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray = this.list.toArray(array);
            return objectArray;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FastArrayList[");
        sb.append(this.list.toString());
        sb.append("]");
        return sb.toString();
    }

    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList temp = (ArrayList)this.list.clone();
                temp.trimToSize();
                this.list = temp;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.trimToSize();
        }
    }

    private class ListIter
    implements ListIterator {
        private List expected;
        private ListIterator iter;
        private int lastReturnedIndex = -1;

        public ListIter(int i2) {
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(i2);
        }

        private void checkMod() {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
        }

        List get() {
            return this.expected;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            this.lastReturnedIndex = this.iter.nextIndex();
            return this.iter.next();
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object previous() {
            this.lastReturnedIndex = this.iter.previousIndex();
            return this.iter.previous();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public void remove() {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().remove(this.lastReturnedIndex);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.lastReturnedIndex);
            this.lastReturnedIndex = -1;
        }

        public void set(Object o2) {
            this.checkMod();
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
            this.get().set(this.lastReturnedIndex, o2);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(this.previousIndex() + 1);
        }

        public void add(Object o2) {
            this.checkMod();
            int i2 = this.nextIndex();
            this.get().add(i2, o2);
            this.expected = FastArrayList.this.list;
            this.iter = this.get().listIterator(i2 + 1);
            this.lastReturnedIndex = -1;
        }
    }

    private class SubList
    implements List {
        private int first;
        private int last;
        private List expected;

        public SubList(int first, int last) {
            this.first = first;
            this.last = last;
            this.expected = FastArrayList.this.list;
        }

        private List get(List l2) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return l2.subList(this.first, this.last);
        }

        public void clear() {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    this.get(temp).clear();
                    this.last = this.first;
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).clear();
            }
        }

        public boolean remove(Object o2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r2 = this.get(temp).remove(o2);
                    if (r2) {
                        --this.last;
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).remove(o2);
                return bl;
            }
        }

        public boolean removeAll(Collection o2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    List sub = this.get(temp);
                    boolean r2 = sub.removeAll(o2);
                    if (r2) {
                        this.last = this.first + sub.size();
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).removeAll(o2);
                return bl;
            }
        }

        public boolean retainAll(Collection o2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    List sub = this.get(temp);
                    boolean r2 = sub.retainAll(o2);
                    if (r2) {
                        this.last = this.first + sub.size();
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).retainAll(o2);
                return bl;
            }
        }

        public int size() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).size();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).size();
                return n2;
            }
        }

        public boolean isEmpty() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).isEmpty();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).isEmpty();
                return bl;
            }
        }

        public boolean contains(Object o2) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).contains(o2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).contains(o2);
                return bl;
            }
        }

        public boolean containsAll(Collection o2) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).containsAll(o2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).containsAll(o2);
                return bl;
            }
        }

        public Object[] toArray(Object[] o2) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray(o2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object[] objectArray = this.get(this.expected).toArray(o2);
                return objectArray;
            }
        }

        public Object[] toArray() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).toArray();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object[] objectArray = this.get(this.expected).toArray();
                return objectArray;
            }
        }

        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (FastArrayList.this.fast) {
                return this.get(this.expected).equals(o2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).equals(o2);
                return bl;
            }
        }

        public int hashCode() {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).hashCode();
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).hashCode();
                return n2;
            }
        }

        public boolean add(Object o2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r2 = this.get(temp).add(o2);
                    if (r2) {
                        ++this.last;
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).add(o2);
                return bl;
            }
        }

        public boolean addAll(Collection o2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r2 = this.get(temp).addAll(o2);
                    if (r2) {
                        this.last += o2.size();
                    }
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).addAll(o2);
                return bl;
            }
        }

        public void add(int i2, Object o2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    this.get(temp).add(i2, o2);
                    ++this.last;
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                this.get(this.expected).add(i2, o2);
            }
        }

        public boolean addAll(int i2, Collection o2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    boolean r2 = this.get(temp).addAll(i2, o2);
                    FastArrayList.this.list = temp;
                    if (r2) {
                        this.last += o2.size();
                    }
                    this.expected = temp;
                    boolean bl = r2;
                    return bl;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                boolean bl = this.get(this.expected).addAll(i2, o2);
                return bl;
            }
        }

        public Object remove(int i2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    Object o2 = this.get(temp).remove(i2);
                    --this.last;
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    Object e2 = o2;
                    return e2;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object e3 = this.get(this.expected).remove(i2);
                return e3;
            }
        }

        public Object set(int i2, Object a2) {
            if (FastArrayList.this.fast) {
                FastArrayList fastArrayList = FastArrayList.this;
                synchronized (fastArrayList) {
                    ArrayList temp = (ArrayList)FastArrayList.this.list.clone();
                    Object o2 = this.get(temp).set(i2, a2);
                    FastArrayList.this.list = temp;
                    this.expected = temp;
                    Object object = o2;
                    return object;
                }
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object object = this.get(this.expected).set(i2, a2);
                return object;
            }
        }

        public Iterator iterator() {
            return new SubListIter(0);
        }

        public ListIterator listIterator() {
            return new SubListIter(0);
        }

        public ListIterator listIterator(int i2) {
            return new SubListIter(i2);
        }

        public Object get(int i2) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).get(i2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                Object e2 = this.get(this.expected).get(i2);
                return e2;
            }
        }

        public int indexOf(Object o2) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).indexOf(o2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).indexOf(o2);
                return n2;
            }
        }

        public int lastIndexOf(Object o2) {
            if (FastArrayList.this.fast) {
                return this.get(this.expected).lastIndexOf(o2);
            }
            ArrayList arrayList = FastArrayList.this.list;
            synchronized (arrayList) {
                int n2 = this.get(this.expected).lastIndexOf(o2);
                return n2;
            }
        }

        public List subList(int f2, int l2) {
            if (FastArrayList.this.list != this.expected) {
                throw new ConcurrentModificationException();
            }
            return new SubList(this.first + f2, f2 + l2);
        }

        private class SubListIter
        implements ListIterator {
            private List expected;
            private ListIterator iter;
            private int lastReturnedIndex = -1;

            public SubListIter(int i2) {
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = SubList.this.get(this.expected).listIterator(i2);
            }

            private void checkMod() {
                if (((SubList)SubList.this).FastArrayList.this.list != this.expected) {
                    throw new ConcurrentModificationException();
                }
            }

            List get() {
                return SubList.this.get(this.expected);
            }

            public boolean hasNext() {
                this.checkMod();
                return this.iter.hasNext();
            }

            public Object next() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.nextIndex();
                return this.iter.next();
            }

            public boolean hasPrevious() {
                this.checkMod();
                return this.iter.hasPrevious();
            }

            public Object previous() {
                this.checkMod();
                this.lastReturnedIndex = this.iter.previousIndex();
                return this.iter.previous();
            }

            public int previousIndex() {
                this.checkMod();
                return this.iter.previousIndex();
            }

            public int nextIndex() {
                this.checkMod();
                return this.iter.nextIndex();
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().remove(this.lastReturnedIndex);
                SubList.this.last--;
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = this.get().listIterator(this.lastReturnedIndex);
                this.lastReturnedIndex = -1;
            }

            public void set(Object o2) {
                this.checkMod();
                if (this.lastReturnedIndex < 0) {
                    throw new IllegalStateException();
                }
                this.get().set(this.lastReturnedIndex, o2);
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = this.get().listIterator(this.previousIndex() + 1);
            }

            public void add(Object o2) {
                this.checkMod();
                int i2 = this.nextIndex();
                this.get().add(i2, o2);
                SubList.this.last++;
                this.expected = ((SubList)SubList.this).FastArrayList.this.list;
                this.iter = this.get().listIterator(i2 + 1);
                this.lastReturnedIndex = -1;
            }
        }
    }
}

