/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.Converter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.KeywordExpander;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.RecordResult;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryFactory
extends BaseObject {
    private static Logger bv = Logger.getLogger(EntryFactory.class);
    private ImportOptions bu = null;
    private FormInformation bx = null;
    private FormInformation by = null;
    private Converter bw = null;
    private KeywordExpander bA = null;
    private IParser bz = null;

    public EntryFactory(IParser iParser, ImportOptions importOptions, String string, String string2) throws ARImportException {
        this.bz = iParser;
        this.bu = importOptions;
        this.bx = importOptions.getFileForms().get(string);
        this.by = importOptions.getServerForms().get(string2);
        if (this.bx == null || this.by == null) {
            throw new ARImportException("Both a source and target form must be supplied");
        }
        this.bw = new Converter(importOptions);
        this.bA = new KeywordExpander(importOptions);
    }

    public EntryFactory(IParser iParser, ImportOptions importOptions, FormInformation formInformation, FormInformation formInformation2) throws ARImportException {
        this.bz = iParser;
        this.bu = importOptions;
        this.bx = formInformation;
        this.by = formInformation2;
        if (formInformation == null || formInformation2 == null) {
            throw new ARImportException("Both a source and target form must be supplied");
        }
        this.bw = new Converter(importOptions);
        this.bA = new KeywordExpander(importOptions);
    }

    public ImportOptions getOptions() {
        return this.bu;
    }

    public void setOptions(ImportOptions importOptions) {
        this.bu = importOptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry createEntry(List<String> list, String string) throws ARImportException, ARException, Exception {
        Entry entry;
        block44: {
            Object object;
            Object object2;
            entry = new Entry();
            MappingOptions mappingOptions = this.bu.getMappingOptions(this.bx.getName(), this.by.getName());
            if (mappingOptions == null) {
                mappingOptions = this.bu.getMappingOptions("ARImport_Data_Holder", this.by.getName());
            }
            if (bv.isTraceEnabled()) {
                bv.trace(MessageFormat.format("Creating entry from : {0}", list));
            }
            this.applyMappings(mappingOptions, this.bx, this.by, list);
            for (Integer n : mappingOptions.getMappings().keySet()) {
                String string2;
                try {
                    object2 = mappingOptions.getMappings().get(n);
                    FieldInformation fieldInformation = this.by.getFields().get(n);
                    if (fieldInformation == null || fieldInformation.getDataType() == null) continue;
                    if (((Mapping)object2).getType() == Mapping.Type.CONSTANT) {
                        if (bv.isTraceEnabled()) {
                            bv.trace(MessageFormat.format("Setting value for {0} to constant based on mapping {1}", String.valueOf(fieldInformation.getFieldId()), object2));
                        }
                        entry.put(Integer.valueOf(fieldInformation.getFieldId()), new Value(((Mapping)object2).getConstant()));
                        continue;
                    }
                    if (((Mapping)object2).getType() == Mapping.Type.COMPOUND) {
                        Value value = this.bw.convertToARValue(fieldInformation, ((Mapping)object2).getCompoundValue());
                        if (bv.isTraceEnabled()) {
                            bv.trace(MessageFormat.format("Setting value for {0} to {1} based on mapping {2}", String.valueOf(fieldInformation.getFieldId()), value, object2));
                        }
                        entry.put(Integer.valueOf(fieldInformation.getFieldId()), value);
                        continue;
                    }
                    if (((Mapping)object2).getType() == Mapping.Type.KEYWORD) {
                        Value value = this.bw.getKeywordValue(fieldInformation, (Mapping)object2);
                        if (bv.isTraceEnabled()) {
                            bv.trace(MessageFormat.format("Setting value for {0} to {1} based on mapping {2}", String.valueOf(fieldInformation.getFieldId()), value, object2));
                        }
                        entry.put(Integer.valueOf(fieldInformation.getFieldId()), value);
                        continue;
                    }
                    int n2 = ((Mapping)object2).getTokenIndex();
                    if (n2 <= -1 || n2 > list.size() - 1) continue;
                    string2 = list.get(n2);
                    Value value = this.bw.convertToARValue(fieldInformation, string2);
                    if (bv.isTraceEnabled()) {
                        bv.trace(MessageFormat.format("Setting value for {0} to {1} based on mapping {2}", String.valueOf(fieldInformation.getFieldId()), value, object2));
                    }
                    entry.put(Integer.valueOf(fieldInformation.getFieldId()), value);
                }
                catch (Exception exception) {
                    if (!mappingOptions.getFallbacks().keySet().contains(this.by.getFields().get(n).getFieldId())) {
                        throw exception;
                    }
                    int n3 = this.applyFallbackMappings(mappingOptions, this.bx, this.by, list, this.by.getFields().get(n).getFieldId());
                    String string3 = list.get(n3);
                    string2 = this.bw.convertToARValue(this.by.getFields().get(n), string3);
                    entry.put(Integer.valueOf(this.by.getFields().get(n).getFieldId()), (Value)string2);
                }
            }
            if (entry.isEmpty()) {
                if (this.bu.getDataOptions().getBadRecordHandling().equals((Object)DataOptions.BadRecords.SKIP) && bv.isInfoEnabled()) {
                    bv.info(MessageFormat.format("Unable to determine any field values for record. No mappings might be defined or the source file might be corrupt.", list.size(), this.by.getFields().size(), System.getProperty("line.separator"), string));
                }
            } else if (this.by.getFormType() == 1 && this.bu.getDataOptions().isDisableRequired()) {
                for (Integer n : this.getTargetForm().getFields().keySet()) {
                    if (n <= 8 || entry.containsKey((Object)n) || (object2 = this.getTargetForm().getFields().get(n)) == null || ((FieldInformation)object2).getFieldOption() != 1 || this.bu.getDataOptions().getDuplicateIdHandling().getMergeOption() == 4 || ((FieldInformation)object2).getDefaultValue().getValue() != null) continue;
                    entry.put(n, new Value());
                }
            }
            if (this.bu.getFileForms().get(this.bx.getName()).getFields().size() > list.size()) {
                if (!this.bu.getDataOptions().isAllowTooFew()) {
                    object = MessageFormat.format("Not enough fields found. Found {0}, expected {1}.", list.size(), this.bu.getFileForms().get(this.bx.getName()).getFields().size());
                    if (this.bu.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER) {
                        if (this.bu.getUserAlertListener() != null) {
                            int n = this.bu.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, (String)object);
                            switch (n) {
                                case 0: {
                                    bv.warn("Stopping import on first failure as instructed by user");
                                    bv.warn(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                    if (this.a() != null) {
                                        this.a().setAbort(true);
                                        this.a().fireEvent(new ParseEvent(2));
                                    }
                                    return null;
                                }
                            }
                            if (bv.isInfoEnabled()) {
                                bv.info("Skipping import of record as instructed by user");
                                bv.info(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                            }
                            this.getOptions().getResults().addError(this.by.getName(), new RecordResult(this.bx.getName(), this.by.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.by.getName()), (String)object, null));
                            return null;
                        }
                        break block44;
                    } else {
                        if (bv.isEnabledFor(Level.WARN)) {
                            bv.warn(MessageFormat.format("Skipping record {0} : {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.by.getName()), object, System.getProperty("line.separator"), string));
                        }
                        this.getOptions().getResults().addError(this.by.getName(), new RecordResult(this.bx.getName(), this.by.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.by.getName()), (String)object, null));
                        return null;
                    }
                }
                object = MessageFormat.format("Not enough fields found. Found {0}, expected {1}.{2}{3}", list.size(), this.bu.getFileForms().get(this.bx.getName()).getFields().size(), System.getProperty("line.separator"), string);
                if (bv.isTraceEnabled()) {
                    bv.trace(object);
                }
                this.getOptions().getResults().addWarning(this.by.getName(), new RecordResult(this.bx.getName(), this.by.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.by.getName()), (String)object, null));
            } else if (this.bu.getFileForms().get(this.bx.getName()).getFields().size() < list.size()) {
                if (!this.bu.getDataOptions().isAllowTooMany()) {
                    object = MessageFormat.format("Too many fields found. Found {0}, expected {1}.", list.size(), this.bu.getFileForms().get(this.bx.getName()).getFields().size());
                    if (this.bu.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER) {
                        if (this.bu.getUserAlertListener() != null) {
                            int n = this.bu.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, (String)object);
                            switch (n) {
                                case 0: {
                                    bv.warn("Stopping import on first failure as instructed by user");
                                    bv.warn(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                                    if (this.a() != null) {
                                        this.a().setAbort(true);
                                        this.a().fireEvent(new ParseEvent(2));
                                    }
                                    return null;
                                }
                            }
                            if (bv.isInfoEnabled()) {
                                bv.info("Skipping import of record as instructed by user");
                                bv.info(MessageFormat.format("Error importing record {0}: {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), object, System.getProperty("line.separator"), string));
                            }
                            this.getOptions().getResults().addError(this.by.getName(), new RecordResult(this.bx.getName(), this.by.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.by.getName()), (String)object, null));
                            return null;
                        }
                        break block44;
                    } else {
                        if (bv.isEnabledFor(Level.WARN)) {
                            bv.warn(MessageFormat.format("Skipping record {0} : {1}{2}{3}", this.getOptions().getResults().getRecordCount(this.by.getName()), object, System.getProperty("line.separator"), string));
                        }
                        this.getOptions().getResults().addError(this.by.getName(), new RecordResult(this.bx.getName(), this.by.getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.by.getName()), (String)object, null));
                        return null;
                    }
                }
                object = MessageFormat.format("Too many fields found. Found {0}, expected {1}.{2}{3}", list.size(), this.bu.getFileForms().get(this.bx.getName()).getFields().size(), System.getProperty("line.separator"), string);
                if (bv.isTraceEnabled()) {
                    bv.trace(object);
                }
                this.getOptions().getResults().addWarning(this.by.getName(), new RecordResult(this.bx.getName(), this.by.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.by.getName()), (String)object, null));
            }
        }
        if (bv.isTraceEnabled()) {
            bv.trace(MessageFormat.format("New entry : {0}", entry));
        }
        return entry;
    }

    public void applyMappings(MappingOptions mappingOptions, FormInformation formInformation, FormInformation formInformation2, List<String> list) throws ARException {
        boolean bl = this.bu.getDataOptions().isSuppressDefaults();
        for (Integer n : mappingOptions.getMappings().keySet()) {
            Mapping mapping = mappingOptions.getMappings().get(n);
            FieldInformation fieldInformation = formInformation2.getFields().get(n);
            if (mapping.getType() == Mapping.Type.COMPOUND) {
                String string = this.bA.expandAllKeywords(mapping.getCompound(), formInformation2, fieldInformation);
                if (string != null) {
                    string = this.a(string, formInformation, formInformation2, list);
                }
                mapping.setCompoundValue(string);
                continue;
            }
            int n2 = mapping.getTokenIndex();
            if (n2 <= -1 || n2 > list.size() - 1) continue;
            String string = list.get(n2);
            if (bl || string != null && string.length() != 0 || fieldInformation == null || fieldInformation.getDefaultValue() == null || fieldInformation.getDefaultValue().getDataType().equals((Object)DataType.NULL)) continue;
            string = fieldInformation.getDataType() == DataType.CURRENCY ? this.a(fieldInformation.getDefaultValue()) : fieldInformation.getDefaultValue().getValue().toString();
            string = this.bA.expandAllKeywords(string, formInformation2, fieldInformation);
            list.set(n2, string);
        }
    }

    private String a(Value value) {
        CurrencyValue currencyValue = (CurrencyValue)value.getValue();
        String string = currencyValue.getValueString() + Character.toString('\u0004') + currencyValue.getCurrencyCode() + Character.toString('\u0004') + currencyValue.getConversionDate().getValue() + Character.toString('\u0004');
        return string;
    }

    private String a(FormInformation formInformation, String string, List<String> list) {
        int n = -1;
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            if (!fieldInformation.getName().equals(string)) continue;
            n = fieldInformation.getFieldId();
            break;
        }
        return this.a(formInformation, n, list);
    }

    private String a(FormInformation formInformation, int n, List<String> list) {
        int n2 = -1;
        n2 = formInformation.getFields().get(n).getTokenIndex();
        return list.get(n2);
    }

    private String a(String string, FormInformation formInformation, FormInformation formInformation2, List<String> list) {
        for (FieldInformation fieldInformation : formInformation.getFields().values()) {
            String string2 = "$" + fieldInformation.getFieldId() + "$";
            String string3 = list.get(fieldInformation.getTokenIndex());
            string = string.replace(string2, string3);
        }
        return string;
    }

    public FormInformation getSourceForm() {
        return this.bx;
    }

    public void setSourceForm(FormInformation formInformation) {
        this.bx = formInformation;
    }

    public FormInformation getTargetForm() {
        return this.by;
    }

    public void setTargetForm(FormInformation formInformation) {
        this.by = formInformation;
    }

    private IParser a() {
        return this.bz;
    }

    protected void setLastId(String string) {
        if (this.bA != null) {
            this.bA.setLastId(string);
        }
    }

    public int applyFallbackMappings(MappingOptions mappingOptions, FormInformation formInformation, FormInformation formInformation2, List<String> list, Integer n) throws ARException {
        Mapping mapping = mappingOptions.getFallbacks().get(n);
        Mapping mapping2 = mappingOptions.getMappings().get(n);
        int n2 = mapping2.getTokenIndex();
        if (n2 > -1 && n2 <= list.size() - 1) {
            String string = list.get(n2);
            if (mapping.getType() == Mapping.Type.FIELDID) {
                string = this.bu.getFileOptions().getType().equals("CSV") || this.bu.getFileOptions().getType().equals("ASC") ? list.get(mapping.getFieldId()) : this.a(formInformation, mapping.getFieldId(), list);
                list.set(n2, string);
            } else if (mapping.getType() == Mapping.Type.FIELDNAME) {
                string = this.bu.getFileOptions().getType().equals("CSV") || this.bu.getFileOptions().getType().equals("ASC") ? this.a(formInformation, mapping.getFieldName(), list) : this.a(formInformation, mapping.getFieldName(), list);
                list.set(n2, string);
            } else if (mapping.getType() == Mapping.Type.CONSTANT) {
                string = mapping.getConstant();
                list.set(n2, string);
            } else if ((mapping.getType() == Mapping.Type.COMPOUND || mapping.getType() == Mapping.Type.KEYWORD) && n2 > -1 && n2 <= list.size() - 1) {
                FieldInformation fieldInformation = formInformation2.getFields().get(n);
                if (Mapping.Type.COMPOUND == mapping.getType()) {
                    string = this.bA.expandAllKeywords(mapping.getCompound(), formInformation2, fieldInformation);
                } else if (Mapping.Type.KEYWORD == mapping.getType()) {
                    string = this.bA.expandKeyword(mapping.getKeyword(), formInformation2, fieldInformation);
                }
                if (string != null) {
                    string = this.a(string, formInformation, formInformation2, list);
                }
                list.set(n2, string);
            }
        }
        return n2;
    }
}

