/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.arrpc.ArByteList;
import com.bmc.arsys.arrpc.ArEncryptRPCCntToSvr;
import com.bmc.arsys.arrpc.ArEncryptRPCSvrToCnt;
import com.bmc.arsys.arrpc.ArEsControlStruct4;
import com.bmc.arsys.arrpc.ArEsGetEncryptInfo4In;
import com.bmc.arsys.arrpc.ArEsGetEncryptInfo4Out;
import com.bmc.arsys.arrpc.ArEsKeyExchangeBegin4In;
import com.bmc.arsys.arrpc.ArEsKeyExchangeBegin4Out;
import com.bmc.arsys.arrpc.ArEsKeyExchangeFinal4In;
import com.bmc.arsys.arrpc.ArEsKeyExchangeFinal4Out;
import com.bmc.arsys.arrpc.ArEsRequest4In;
import com.bmc.arsys.arrpc.ArEsRequest4Out;
import com.bmc.arsys.arrpc.ArEsSignal4In;
import com.bmc.arsys.arrpc.ArEsSignal4Out;
import com.bmc.arsys.arrpc.ArServerInfoList;
import com.bmc.arsys.arrpc.ArServerInfoRequestList;
import com.bmc.arsys.arrpc.ArServerInfoStruct;
import com.bmc.arsys.arrpc.ArStatusList6;
import com.bmc.arsys.arrpc.ArStatusStruct6;
import com.bmc.arsys.arrpc.ArValueStruct;
import com.bmc.arsys.artranscode.ARCharSet;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARPluginSvrRemoteHostInfo;
import com.bmc.arsys.pluginsvr.binding.ARPluginOnEventHandler;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.mapping.ApiToRpcMapping;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.arsys.utils.StringByteUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ARGenericCallRouter {
    private static Logger log = Logger.getLogger(ARGenericCallRouter.class);
    ARPluginServerEncryptionInfo mEncryptInfo = ARPluginServerEncryptionInfo.getInstance();

    static void getRemoteHostLanguageStr(ArEsControlStruct4 arEsControlStruct4) {
        String string = null;
        try {
            string = StringByteUtil.createNullTerminatedString((byte[])arEsControlStruct4.getLanguage(), (String)"utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.debug((Object)unsupportedEncodingException.getLocalizedMessage());
        }
        String string2 = ARCharSet.getServerCharSetName((String)string);
        log.info((Object)("RemoteHostLanguage " + string + ", CharSet " + string2));
        if (!ARPluginSvrRemoteHostInfo.isRemoteHostCodeSetExist()) {
            ARPluginSvrRemoteHostInfo.setRemoteHostCharSet((String)string2);
        }
    }

    public ArEsRequest4Out ArExternalServerRequest(ArEsRequest4In arEsRequest4In) {
        return null;
    }

    public ArEsSignal4Out ArEsSignal(ArEsSignal4In arEsSignal4In) {
        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
        ARPluginContext aRPluginContext = ApiToRpcMapping.getInstance().getContextFromControl((ArEsControlStruct4)arEsSignal4In.control, null);
        if (arEsSignal4In.signalList != null) {
            int n = 10005;
            Thread thread = new Thread(new ARPluginOnEventHandler(aRPluginContext, n));
            thread.start();
        }
        ArEsSignal4Out arEsSignal4Out = new ArEsSignal4Out(arEsSignal4In.getControl(), ApiToRpcMapping.getInstance().getRpcStatusFromStatusInfo(arrayList));
        return arEsSignal4Out;
    }

    public ArEsGetEncryptInfo4Out ArEsGetEncryptInfo(ArEsGetEncryptInfo4In arEsGetEncryptInfo4In) {
        ArEsGetEncryptInfo4Out arEsGetEncryptInfo4Out;
        block15: {
            arEsGetEncryptInfo4Out = new ArEsGetEncryptInfo4Out();
            try {
                ARGenericCallRouter.getRemoteHostLanguageStr((ArEsControlStruct4)arEsGetEncryptInfo4In.getControl());
                ArServerInfoRequestList arServerInfoRequestList = arEsGetEncryptInfo4In.requestList;
                if (arServerInfoRequestList == null || arServerInfoRequestList.value == null) break block15;
                ArServerInfoStruct[] arServerInfoStructArray = new ArServerInfoStruct[arServerInfoRequestList.value.length];
                block13: for (int i = 0; i < arServerInfoRequestList.value.length; ++i) {
                    arServerInfoStructArray[i] = new ArServerInfoStruct();
                    arServerInfoStructArray[i].setOperation(arServerInfoRequestList.value[i]);
                    ArValueStruct arValueStruct = new ArValueStruct();
                    switch (arServerInfoRequestList.value[i]) {
                        case 131: {
                            arValueStruct.dataType = 2;
                            arValueStruct.intVal = ARPluginServerConfiguration.getInstance().getDataEncryptionKeyExpiry();
                            arServerInfoStructArray[i].setValue(arValueStruct);
                            continue block13;
                        }
                        case 130: {
                            arValueStruct.dataType = 2;
                            arValueStruct.intVal = ARPluginServerConfiguration.getInstance().getPublicKeyExpiry();
                            arServerInfoStructArray[i].setValue(arValueStruct);
                            continue block13;
                        }
                        case 133: {
                            arValueStruct.dataType = 2;
                            arValueStruct.intVal = ARPluginServerConfiguration.getInstance().getEncryptionSecurityPolicy();
                            arServerInfoStructArray[i].setValue(arValueStruct);
                            continue block13;
                        }
                        case 132: {
                            arValueStruct.dataType = 2;
                            arValueStruct.intVal = ARPluginServerConfiguration.getInstance().getDataEncryptionAlgorithm();
                            arServerInfoStructArray[i].setValue(arValueStruct);
                            continue block13;
                        }
                        case 168: {
                            arValueStruct.dataType = 2;
                            arValueStruct.intVal = ARPluginServerConfiguration.getInstance().getPublicKeyAlgorithm();
                            arServerInfoStructArray[i].setValue(arValueStruct);
                            continue block13;
                        }
                        case 129: {
                            arValueStruct.dataType = 9;
                            ArByteList arByteList = new ArByteList();
                            if (ARPluginServerConfiguration.getInstance().getEncryptionSecurityPolicy() < 2) {
                                try {
                                    arByteList.bytes = this.mEncryptInfo.getPublicKeyBytes();
                                }
                                catch (Exception exception) {
                                    log.debug((Object)exception.getLocalizedMessage());
                                }
                            }
                            arValueStruct.byteListVal = arByteList;
                            arServerInfoStructArray[i].setValue(arValueStruct);
                            continue block13;
                        }
                        case 134: {
                            arValueStruct.dataType = 2;
                            arValueStruct.intVal = ARPluginServerConfiguration.getInstance().getNumEncSessionHashentries();
                            arServerInfoStructArray[i].setValue(arValueStruct);
                            continue block13;
                        }
                        default: {
                            arValueStruct.dataType = 0;
                            arServerInfoStructArray[i].setValue(arValueStruct);
                        }
                    }
                }
                ArServerInfoList arServerInfoList = new ArServerInfoList(arServerInfoStructArray);
                arEsGetEncryptInfo4Out.setServerInfoList(arServerInfoList);
            }
            catch (Throwable throwable) {
                log.error((Object)"getEncryptInfo() FAIL: ", throwable);
                ArStatusList6 arStatusList6 = new ArStatusList6();
                arStatusList6.value = new ArStatusStruct6[1];
                arStatusList6.value[0] = new ArStatusStruct6(2, 8790, CatalogReader.getInstance().getMessage(8790), throwable.getLocalizedMessage());
                arEsGetEncryptInfo4Out.setStatus(arStatusList6);
            }
        }
        return arEsGetEncryptInfo4Out;
    }

    public ArEsKeyExchangeBegin4Out ArEsKeyExchangeBegin(ArEsKeyExchangeBegin4In arEsKeyExchangeBegin4In) {
        int n;
        ArEsKeyExchangeBegin4Out arEsKeyExchangeBegin4Out = new ArEsKeyExchangeBegin4Out();
        byte[] byArray = ARPluginServerEncryptionInfo.generateRandomBytes();
        arEsKeyExchangeBegin4Out.sessionId = n = this.mEncryptInfo.createAndInsertSessionNode(byArray, arEsKeyExchangeBegin4In.clientRandBytes.value);
        arEsKeyExchangeBegin4Out.serverRandBytes.value = byArray;
        return arEsKeyExchangeBegin4Out;
    }

    public ArEsKeyExchangeFinal4Out ArEsKeyExchangeFinal(ArEsKeyExchangeFinal4In arEsKeyExchangeFinal4In) {
        ArEsKeyExchangeFinal4Out arEsKeyExchangeFinal4Out = new ArEsKeyExchangeFinal4Out();
        try {
            byte[] byArray = arEsKeyExchangeFinal4In.encPreMasterKey;
            int n = arEsKeyExchangeFinal4In.getSessionId();
            byte[] byArray2 = this.mEncryptInfo.unxdrAndDecryptPreMasterkey(n, byArray);
            this.mEncryptInfo.generateServerAndClientDataKey(n, byArray2);
            byte[] byArray3 = this.mEncryptInfo.XdrAndEncryptSessionId(n);
            arEsKeyExchangeFinal4Out.setEncSessionId(byArray3);
        }
        catch (ARException aRException) {
            log.error((Object)CatalogReader.getInstance().getMessage(9002), (Throwable)aRException);
            ArStatusList6 arStatusList6 = new ArStatusList6();
            arEsKeyExchangeFinal4Out.setStatus(arStatusList6);
        }
        return arEsKeyExchangeFinal4Out;
    }

    public ArEncryptRPCSvrToCnt ArEsEncryptRPC(ArEncryptRPCCntToSvr arEncryptRPCCntToSvr) {
        return null;
    }
}

