/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scripting.jruby;

import com.bmc.thirdparty.org.springframework.scripting.ScriptCompilationException;
import com.bmc.thirdparty.org.springframework.scripting.ScriptFactory;
import com.bmc.thirdparty.org.springframework.scripting.ScriptSource;
import com.bmc.thirdparty.org.springframework.scripting.jruby.JRubyScriptUtils;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.IOException;
import org.jruby.exceptions.JumpException;

public class JRubyScriptFactory
implements ScriptFactory {
    private final String scriptSourceLocator;
    private final Class[] scriptInterfaces;

    public JRubyScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        Assert.hasText(scriptSourceLocator);
        Assert.notEmpty(scriptInterfaces);
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    public Object getScriptedObject(ScriptSource actualScriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            return JRubyScriptUtils.createJRubyObject(actualScriptSource.getScriptAsString(), actualInterfaces);
        }
        catch (JumpException ex) {
            throw new ScriptCompilationException("Could not compile JRuby script: " + actualScriptSource, ex);
        }
    }
}

