/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.jdo;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.orm.jdo.JdoAccessor;
import com.bmc.thirdparty.org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import com.bmc.thirdparty.org.springframework.orm.jdo.PersistenceManagerHolder;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;

public class JdoInterceptor
extends JdoAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true);
        if (TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory())) {
            this.logger.debug("Found thread-bound PersistenceManager for JDO interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug("Using new PersistenceManager for JDO interceptor");
            TransactionSynchronizationManager.bindResource(this.getPersistenceManagerFactory(), new PersistenceManagerHolder(pm));
        }
        try {
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(pm, existingTransaction);
            Object object = retVal;
            return object;
        }
        catch (JDOException ex) {
            if (this.exceptionConversionEnabled) {
                throw this.convertJdoAccessException(ex);
            }
            throw ex;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug("Not closing pre-bound JDO PersistenceManager after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource(this.getPersistenceManagerFactory());
                PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
            }
        }
    }
}

