/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.object;

import com.bmc.thirdparty.org.springframework.dao.DataAccessException;
import com.bmc.thirdparty.org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import com.bmc.thirdparty.org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import com.bmc.thirdparty.org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import com.bmc.thirdparty.org.springframework.jdbc.object.SqlOperation;
import com.bmc.thirdparty.org.springframework.jdbc.support.KeyHolder;
import java.util.Map;
import javax.sql.DataSource;

public class SqlUpdate
extends SqlOperation {
    private int maxRowsAffected = 0;
    private int requiredRowsAffected = 0;

    public SqlUpdate() {
    }

    public SqlUpdate(DataSource ds, String sql) {
        this.setDataSource(ds);
        this.setSql(sql);
    }

    public SqlUpdate(DataSource ds, String sql, int[] types) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
    }

    public SqlUpdate(DataSource ds, String sql, int[] types, int maxRowsAffected) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setTypes(types);
        this.maxRowsAffected = maxRowsAffected;
    }

    public void setMaxRowsAffected(int maxRowsAffected) {
        this.maxRowsAffected = maxRowsAffected;
    }

    public void setRequiredRowsAffected(int requiredRowsAffected) {
        this.requiredRowsAffected = requiredRowsAffected;
    }

    protected void checkRowsAffected(int rowsAffected) throws JdbcUpdateAffectedIncorrectNumberOfRowsException {
        if (this.maxRowsAffected > 0 && rowsAffected > this.maxRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.maxRowsAffected, rowsAffected);
        }
        if (this.requiredRowsAffected > 0 && rowsAffected != this.requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(this.getSql(), this.requiredRowsAffected, rowsAffected);
        }
    }

    public int update(Object[] params) throws DataAccessException {
        this.validateParameters(params);
        int rowsAffected = this.getJdbcTemplate().update(this.newPreparedStatementCreator(params));
        this.checkRowsAffected(rowsAffected);
        return rowsAffected;
    }

    public int update(Object[] params, KeyHolder generatedKeyHolder) throws DataAccessException {
        this.validateParameters(params);
        int rowsAffected = this.getJdbcTemplate().update(this.newPreparedStatementCreator(params), generatedKeyHolder);
        this.checkRowsAffected(rowsAffected);
        return rowsAffected;
    }

    public int update() throws DataAccessException {
        return this.update((Object[])null);
    }

    public int update(int p1) throws DataAccessException {
        return this.update(new Object[]{new Integer(p1)});
    }

    public int update(int p1, int p2) throws DataAccessException {
        return this.update(new Object[]{new Integer(p1), new Integer(p2)});
    }

    public int update(long p1) throws DataAccessException {
        return this.update(new Object[]{new Long(p1)});
    }

    public int update(long p1, long p2) throws DataAccessException {
        return this.update(new Object[]{new Long(p1), new Long(p2)});
    }

    public int update(String p2) throws DataAccessException {
        return this.update(new Object[]{p2});
    }

    public int update(String p1, String p2) throws DataAccessException {
        return this.update(new Object[]{p1, p2});
    }

    public int updateByNamedParam(Map paramMap) throws DataAccessException {
        this.validateNamedParameters(paramMap);
        Object[] params = NamedParameterUtils.buildValueArray(this.getSql(), paramMap);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(this.getSql(), new MapSqlParameterSource(paramMap));
        int rowsAffected = this.getJdbcTemplate().update(this.newPreparedStatementCreator(sqlToUse, params));
        this.checkRowsAffected(rowsAffected);
        return rowsAffected;
    }

    public int updateByNamedParam(Map paramMap, KeyHolder generatedKeyHolder) throws DataAccessException {
        this.validateNamedParameters(paramMap);
        Object[] params = NamedParameterUtils.buildValueArray(this.getSql(), paramMap);
        int rowsAffected = this.getJdbcTemplate().update(this.newPreparedStatementCreator(params), generatedKeyHolder);
        this.checkRowsAffected(rowsAffected);
        return rowsAffected;
    }
}

