/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.context.support;

import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.context.support.StaticApplicationContext;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.core.io.support.ResourcePatternResolver;
import com.bmc.thirdparty.org.springframework.ui.context.Theme;
import com.bmc.thirdparty.org.springframework.ui.context.ThemeSource;
import com.bmc.thirdparty.org.springframework.ui.context.support.UiApplicationContextUtils;
import com.bmc.thirdparty.org.springframework.web.context.ConfigurableWebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.request.RequestScope;
import com.bmc.thirdparty.org.springframework.web.context.request.SessionScope;
import com.bmc.thirdparty.org.springframework.web.context.support.ServletContextAwareProcessor;
import com.bmc.thirdparty.org.springframework.web.context.support.ServletContextResource;
import com.bmc.thirdparty.org.springframework.web.context.support.ServletContextResourcePatternResolver;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class StaticWebApplicationContext
extends StaticApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    private ServletContext servletContext;
    private ServletConfig servletConfig;
    private String namespace;
    private ThemeSource themeSource;
    static /* synthetic */ Class class$org$springframework$web$context$ServletContextAware;
    static /* synthetic */ Class class$org$springframework$web$context$ServletConfigAware;

    public StaticWebApplicationContext() {
        this.setDisplayName("Root WebApplicationContext");
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null && this.servletContext == null) {
            this.servletContext = servletConfig.getServletContext();
        }
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] configLocations) {
        throw new UnsupportedOperationException("StaticWebApplicationContext does not support configLocations");
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.registerScope("request", new RequestScope());
        beanFactory.registerScope("session", new SessionScope(false));
        beanFactory.registerScope("globalSession", new SessionScope(true));
        beanFactory.addBeanPostProcessor(new ServletContextAwareProcessor(this.servletContext, this.servletConfig));
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletContextAware == null ? (class$org$springframework$web$context$ServletContextAware = StaticWebApplicationContext.class$("com.bmc.thirdparty.org.springframework.web.context.ServletContextAware")) : class$org$springframework$web$context$ServletContextAware);
        beanFactory.ignoreDependencyInterface(class$org$springframework$web$context$ServletConfigAware == null ? (class$org$springframework$web$context$ServletConfigAware = StaticWebApplicationContext.class$("com.bmc.thirdparty.org.springframework.web.context.ServletConfigAware")) : class$org$springframework$web$context$ServletConfigAware);
    }

    protected Resource getResourceByPath(String path) {
        return new ServletContextResource(this.servletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver(this);
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource(this);
    }

    public Theme getTheme(String themeName) {
        return this.themeSource.getTheme(themeName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

