/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.validation;

import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.validation.ObjectError;

public class FieldError
extends ObjectError {
    private final String field;
    private final Object rejectedValue;
    private final boolean bindingFailure;

    public FieldError(String objectName, String field, Object rejectedValue, boolean bindingFailure, String[] codes, Object[] arguments, String defaultMessage) {
        super(objectName, codes, arguments, defaultMessage);
        Assert.notNull(field, "Field must not be null");
        this.field = field;
        this.rejectedValue = rejectedValue;
        this.bindingFailure = bindingFailure;
    }

    public String getField() {
        return this.field;
    }

    public Object getRejectedValue() {
        return this.rejectedValue;
    }

    public boolean isBindingFailure() {
        return this.bindingFailure;
    }

    public String toString() {
        return "Field error in object '" + this.getObjectName() + "' on field '" + this.field + "': rejected value [" + this.rejectedValue + "]; " + this.resolvableToString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        FieldError otherError = (FieldError)other;
        return this.getField().equals(otherError.getField());
    }

    public int hashCode() {
        return super.hashCode() * 29 + this.getField().hashCode();
    }
}

