/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.xerces.dom.ASModelImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DOMInputSourceImpl;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.as.ASModel;
import org.apache.xerces.dom3.as.DOMASBuilder;
import org.apache.xerces.dom3.as.DOMASException;
import org.apache.xerces.dom3.as.DOMImplementationAS;
import org.apache.xerces.dom3.ls.DOMEntityResolver;
import org.apache.xerces.dom3.ls.DOMInputSource;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dv.XSAtomicSimpleType;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.xni.parser.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSchemaParser
implements DOMErrorHandler,
DOMEntityResolver {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected XSGrammarBucket grammarBucket = new XSGrammarBucket();
    protected Document mapDom = null;
    protected String currentTargetNamespace = null;
    protected StringBuffer warnings = new StringBuffer();
    protected String tempDir = null;
    protected HashMap schemaLocationMap = new HashMap();
    public static final int SEVERITY_NONE = -1;
    public static final int SEVERITY_WARNING = 0;
    public static final int SEVERITY_ERROR = 1;
    public static final int SEVERITY_FATAL_ERROR = 2;
    private Stack<String> complexNameStack;
    private HashMap<String, String> attrFormDefaultMap;
    private HashMap<String, String> eleFormDefaultMap;
    public String baseUri = null;

    public XMLSchemaParser(String string, StringBuffer stringBuffer) {
        this.warnings = stringBuffer;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.parseXMLSchema(string);
    }

    public XMLSchemaParser(String string, String string2, String string3, StringBuffer stringBuffer) {
        this.warnings = stringBuffer;
        this.complexNameStack = new Stack();
        this.attrFormDefaultMap = new HashMap();
        this.eleFormDefaultMap = new HashMap();
        this.tempDir = string2 + System.getProperty("file.separator");
        this.setBaseUri(string);
        this.parseXMLSchema(string3);
    }

    public void setBaseUri(String string) {
        this.baseUri = string;
    }

    public String getElementFormDefault(String string) {
        String string2 = this.eleFormDefaultMap.get(string);
        if (string2 == null || string2.equals("")) {
            string2 = "unqualified";
        }
        return string2;
    }

    public String getAttributeFormDefault(String string) {
        String string2 = this.attrFormDefaultMap.get(string);
        if (string2 == null || string2.equals("")) {
            string2 = "unqualified";
        }
        return string2;
    }

    public boolean handleError(DOMError dOMError) {
        if (dOMError.getSeverity() >= 2 && dOMError.getException() instanceof RuntimeException) {
            throw (RuntimeException)dOMError.getException();
        }
        this.warnings.append("WARNING:");
        if (dOMError.getException() instanceof XMLParseException) {
            XMLParseException xMLParseException = (XMLParseException)dOMError.getException();
            String string = xMLParseException.getExpandedSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                this.warnings.append(string);
            }
            this.warnings.append(":" + xMLParseException.getLineNumber() + ":" + xMLParseException.getColumnNumber() + ": " + xMLParseException.getMessage());
        } else {
            this.warnings.append(dOMError.getMessage());
        }
        this.warnings.append(System.getProperty("line.separator"));
        return true;
    }

    public DOMInputSource resolveEntity(String string, String string2, String string3) {
        DOMInputSourceImpl dOMInputSourceImpl = null;
        if (string2 == null) {
            return null;
        }
        dOMInputSourceImpl = this.baseUri != null ? (Pattern.matches("ns[\\d++].xsd", string2) ? new DOMInputSourceImpl(string, string2, string3) : new DOMInputSourceImpl(string, string2, this.baseUri)) : new DOMInputSourceImpl(string, string2, string3);
        return dOMInputSourceImpl;
    }

    private boolean checkIfFilename(String string) {
        int n = 0;
        int n2 = 0;
        try {
            String[] stringArray = string.split("http:");
            String[] stringArray2 = string.split("\\\\");
            n = stringArray.length;
            n2 = stringArray2.length;
        }
        catch (Exception exception) {
            throw new ARWSException("OTHER_ERROR", "Error in checking for filename " + exception);
        }
        return n <= 1 && n2 <= 1;
    }

    private void extractFormDefaultValues(String string) {
        if (string != null) {
            NodeList nodeList;
            if (string.equals(Constants.URI_DEFAULT_SOAP_ENC)) {
                return;
            }
            this.schemaLocationMap.put(string, string);
            Document document = WsdlUtil.newDocument(string, false);
            Element element = document.getDocumentElement();
            String string2 = "unqualified";
            String string3 = "unqualified";
            if (!element.getLocalName().equals("schema")) {
                throw new ARWSException("INVALID_XSD", "Schema " + string + " does not have root element as schema");
            }
            String string4 = element.getAttribute("elementFormDefault");
            string2 = string4 != null && string4.equals("qualified") ? "qualified" : "unqualified";
            string4 = element.getAttribute("attributeFormDefault");
            string3 = string4 != null && string4.equals("qualified") ? "qualified" : "unqualified";
            string4 = element.getAttribute("targetNamespace");
            if (string4 != null) {
                this.attrFormDefaultMap.put(string4, string3);
                this.eleFormDefaultMap.put(string4, string2);
            }
            if ((nodeList = element.getChildNodes()) != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Object v;
                    String string5;
                    Element element2;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || !(element2 = (Element)node).getLocalName().equals("import") || (string5 = element2.getAttribute("schemaLocation")) == null || string5.length() <= 0) continue;
                    if (this.checkIfFilename(string5)) {
                        string5 = this.tempDir + string5;
                    }
                    if ((v = this.schemaLocationMap.get(string5)) != null) continue;
                    this.extractFormDefaultValues(string5);
                }
            }
        }
    }

    protected void parseXMLSchema(String string) {
        this.extractFormDefaultValues(string);
        DOMImplementationAS dOMImplementationAS = (DOMImplementationAS)DOMImplementationImpl.getDOMImplementation();
        DOMASBuilder dOMASBuilder = dOMImplementationAS.createDOMASBuilder();
        dOMASBuilder.setErrorHandler((DOMErrorHandler)this);
        dOMASBuilder.setEntityResolver((DOMEntityResolver)this);
        dOMASBuilder.setFeature(NAMESPACES_FEATURE_ID, true);
        dOMASBuilder.setFeature(VALIDATION_FEATURE_ID, true);
        dOMASBuilder.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        dOMASBuilder.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, false);
        ASModel aSModel = null;
        try {
            aSModel = dOMASBuilder.parseASURI(string);
        }
        catch (DOMASException dOMASException) {
            throw new ARWSException("INVALID_XSD", "The schema " + string + " is invalid", dOMASException, string);
        }
        catch (Exception exception) {
            throw new ARWSException("INVALID_XSD", "The schema " + string + " is invalid", exception, string);
        }
        if (aSModel == null) {
            throw new ARWSException("INVALID_XSD", "The schema " + string + " cannot be parsed");
        }
        dOMASBuilder.setAbstractSchema(aSModel);
        this.parseASModel(aSModel);
    }

    public void parseASModel(ASModel aSModel) {
        if (!(aSModel instanceof ASModelImpl)) {
            return;
        }
        ASModelImpl aSModelImpl = (ASModelImpl)aSModel;
        SchemaGrammar schemaGrammar = aSModelImpl.getGrammar();
        if (schemaGrammar != null) {
            this.grammarBucket.putGrammar(schemaGrammar);
        }
        Vector vector = aSModelImpl.getInternalASModels();
        for (int i = 0; i < vector.size(); ++i) {
            this.parseASModel((ASModel)vector.elementAt(i));
        }
    }

    public Element parseSchemaForElement(Document document, QName qName) {
        SchemaGrammar schemaGrammar = this.grammarBucket.getGrammar(qName.getNamespaceURI());
        if (schemaGrammar == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find namespace " + qName.getNamespaceURI());
        }
        XSElementDecl xSElementDecl = schemaGrammar.getGlobalElementDecl(qName.getLocalPart());
        if (xSElementDecl == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find element " + qName.getLocalPart());
        }
        this.currentTargetNamespace = qName.getNamespaceURI();
        this.mapDom = document;
        DocumentFragment documentFragment = this.mapDom.createDocumentFragment();
        this.parseElement(documentFragment, xSElementDecl);
        return (Element)documentFragment.getFirstChild();
    }

    public void parseSchemaForType(Element element, QName qName) {
        SchemaGrammar schemaGrammar = this.grammarBucket.getGrammar(qName.getNamespaceURI());
        if (schemaGrammar == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find namespace " + qName.getNamespaceURI());
        }
        XSTypeDecl xSTypeDecl = schemaGrammar.getGlobalTypeDecl(qName.getLocalPart());
        if (xSTypeDecl == null) {
            throw new ARWSException("INVALID_XSD", "Cannot find type " + qName.getLocalPart());
        }
        this.currentTargetNamespace = qName.getNamespaceURI();
        this.mapDom = element.getOwnerDocument();
        if (xSTypeDecl.getXSType() == 2) {
            this.parseSimpleType(element, (XSSimpleType)xSTypeDecl);
        } else if (xSTypeDecl.getXSType() == 1) {
            this.parseComplexType(element, (XSComplexTypeDecl)xSTypeDecl);
        }
    }

    public Element parseElement(Node node, XSElementDecl xSElementDecl) {
        Element element = this.mapDom.createElementNS(null, "element");
        element.setAttributeNS(null, "name", xSElementDecl.fName);
        if (xSElementDecl.fTargetNamespace != null) {
            this.currentTargetNamespace = xSElementDecl.fTargetNamespace;
        }
        element.setAttributeNS(null, "targetNamespace", this.currentTargetNamespace);
        element.setAttributeNS(null, "form", this.getElementFormDefault(this.currentTargetNamespace));
        node.appendChild(element);
        XSTypeDecl xSTypeDecl = xSElementDecl.fType;
        if (xSTypeDecl != null) {
            short s = xSTypeDecl.getXSType();
            String string = xSTypeDecl.getTypeName();
            String string2 = xSTypeDecl.getTargetNamespace();
            if (string != null && string.equals("anyType") && string2 != null && string2.equals("http://www.w3.org/2001/XMLSchema")) {
                this.parseAnyType(element, xSTypeDecl);
            } else if (s == 1) {
                this.parseComplexType(element, (XSComplexTypeDecl)xSTypeDecl);
            } else if (s == 2) {
                this.parseSimpleType(element, (XSSimpleType)xSTypeDecl);
                if (xSElementDecl.getConstraintType() == 1) {
                    element.setAttributeNS(null, "default", xSElementDecl.fDefault.normalizedValue);
                }
            } else {
                element.setAttributeNS(null, "xmlType", "true");
                element.setAttributeNS(null, "dataType", "string");
                this.warnings.append("WARNING: Unsupported type in parseElement, treating as xmlType" + xSElementDecl + System.getProperty("line.separator"));
            }
        }
        return element;
    }

    public Element parseAttribute(Element element, XSComplexTypeDecl xSComplexTypeDecl) {
        Element element2 = null;
        XSAttributeGroupDecl xSAttributeGroupDecl = xSComplexTypeDecl.fAttrGrp;
        if (xSAttributeGroupDecl != null) {
            XSAttributeUse[] xSAttributeUseArray = xSAttributeGroupDecl.getAttributeUses();
            for (int i = 0; i < xSAttributeUseArray.length; ++i) {
                String string;
                XSAttributeDecl xSAttributeDecl;
                XSAttributeUse xSAttributeUse = xSAttributeUseArray[i];
                if (xSAttributeUse == null || (xSAttributeDecl = xSAttributeUse.fAttrDecl) == null || (string = xSAttributeDecl.fName) == null) continue;
                element2 = this.mapDom.createElementNS(null, "attribute");
                element2.setAttributeNS(null, "name", string);
                if (xSAttributeDecl.fTargetNamespace != null) {
                    this.currentTargetNamespace = xSAttributeDecl.fTargetNamespace;
                }
                element2.setAttributeNS(null, "targetNamespace", this.currentTargetNamespace);
                element2.setAttributeNS(null, "form", this.getAttributeFormDefault(this.currentTargetNamespace));
                if (xSAttributeDecl.getConstraintType() == 1) {
                    element2.setAttributeNS(null, "default", xSAttributeDecl.fDefault.normalizedValue);
                }
                XSSimpleType xSSimpleType = xSAttributeDecl.fType;
                this.parseSimpleType(element2, xSSimpleType);
                short s = xSAttributeUse.fUse;
                if (s == 0) {
                    element2.setAttributeNS(null, "use", "optional");
                } else if (s == 1) {
                    element2.setAttributeNS(null, "use", "required");
                } else if (s == 2) {
                    element2.setAttributeNS(null, "use", "prohibited");
                }
                element.appendChild(element2);
            }
        }
        return element2;
    }

    public void parseChoice(Element element, XSParticleDecl xSParticleDecl) {
        XSParticleDecl xSParticleDecl2 = (XSParticleDecl)xSParticleDecl.fValue;
        XSParticleDecl xSParticleDecl3 = (XSParticleDecl)xSParticleDecl.fOtherValue;
        if (xSParticleDecl2 != null) {
            if (xSParticleDecl2.fType == 3) {
                this.parseChoice(element, xSParticleDecl2);
            } else {
                this.parseParticle(element, xSParticleDecl2);
            }
        }
        if (xSParticleDecl3 != null) {
            if (xSParticleDecl3.fType == 3) {
                this.parseChoice(element, xSParticleDecl3);
            } else {
                this.parseParticle(element, xSParticleDecl3);
            }
        }
    }

    public void parseAll(Element element, XSParticleDecl xSParticleDecl) {
        XSParticleDecl xSParticleDecl2;
        XSParticleDecl xSParticleDecl3;
        element.setAttributeNS(null, "all", "true");
        XSParticleDecl xSParticleDecl4 = (XSParticleDecl)xSParticleDecl.fValue;
        XSParticleDecl xSParticleDecl5 = (XSParticleDecl)xSParticleDecl.fOtherValue;
        if (xSParticleDecl4 != null) {
            if (xSParticleDecl4.fType == 5) {
                xSParticleDecl3 = (XSParticleDecl)xSParticleDecl4.fValue;
                this.parseParticle(element, xSParticleDecl3);
                xSParticleDecl2 = (XSParticleDecl)xSParticleDecl4.fOtherValue;
                this.parseParticle(element, xSParticleDecl2);
            } else {
                this.parseParticle(element, xSParticleDecl4);
            }
        }
        if (xSParticleDecl5 != null) {
            if (xSParticleDecl5.fType == 5) {
                xSParticleDecl3 = (XSParticleDecl)xSParticleDecl5.fValue;
                this.parseParticle(element, xSParticleDecl3);
                xSParticleDecl2 = (XSParticleDecl)xSParticleDecl5.fOtherValue;
                this.parseParticle(element, xSParticleDecl2);
            } else {
                this.parseParticle(element, xSParticleDecl5);
            }
        }
    }

    public void parseAnyType(Element element, XSTypeDecl xSTypeDecl) {
        element.setAttributeNS(null, "dataType", "string");
    }

    public void parseSimpleType(Element element, XSSimpleType xSSimpleType) {
        if (xSSimpleType == null) {
            return;
        }
        if (xSSimpleType.getVariety() == 1) {
            Object object;
            XSAtomicSimpleType xSAtomicSimpleType = (XSAtomicSimpleType)xSSimpleType;
            XSSimpleType xSSimpleType2 = xSSimpleType;
            while (!xSSimpleType2.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema") && (object = xSSimpleType2.getBaseType()) != xSSimpleType2) {
                xSSimpleType2 = object;
            }
            object = xSSimpleType2.getTypeName();
            if (xSAtomicSimpleType.getPrimitiveKind() == 2 && ((String)object).equals("string")) {
                object = "boolean";
            }
            element.setAttributeNS(null, "dataType", (String)object);
        } else {
            element.setAttributeNS(null, "xmlType", "true");
            element.setAttributeNS(null, "dataType", "string");
            this.warnings.append("WARNING: Unsupported simple element variety in parseSimpleType. Treating as xmlType" + xSSimpleType + System.getProperty("line.separator"));
        }
    }

    public void parseComplexType(Element element, XSComplexTypeDecl xSComplexTypeDecl) {
        if (xSComplexTypeDecl != null && xSComplexTypeDecl.fContentType != 0) {
            String string = xSComplexTypeDecl.fTargetNamespace + ":" + xSComplexTypeDecl.fName;
            try {
                if (this.complexNameStack.search(string) != -1) {
                    element.setAttributeNS(null, "xmlType", "true");
                    this.warnings.append("WARNING: Unsupported recursive reference in parseComplexType. Treating as xmlType" + System.getProperty("line.separator"));
                    return;
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            this.complexNameStack.push(string);
            if (xSComplexTypeDecl.fContentType == 2) {
                element.setAttributeNS(null, "xmlType", "true");
                element.setAttributeNS(null, "dataType", "string");
                this.warnings.append("WARNING: Unsupported Mixed content type in parseComplexType. Treating as xmlType" + System.getProperty("line.separator"));
            } else if (xSComplexTypeDecl.fContentType == 1) {
                this.parseSimpleType(element, xSComplexTypeDecl.fXSSimpleType);
            } else if (xSComplexTypeDecl.fContentType == 3) {
                if (xSComplexTypeDecl.getTypeName().indexOf("#Anon") == -1) {
                    element.setAttributeNS(null, "complexType", xSComplexTypeDecl.getTypeName());
                }
                this.parseParticle(element, xSComplexTypeDecl.fParticle);
            }
            this.complexNameStack.pop();
        }
        this.parseAttribute(element, xSComplexTypeDecl);
    }

    public void parseParticle(Element element, XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl == null) {
            return;
        }
        int n = xSParticleDecl.fMinOccurs;
        int n2 = xSParticleDecl.fMaxOccurs;
        if (xSParticleDecl.fType == 4) {
            this.parseParticle(element, (XSParticleDecl)xSParticleDecl.fValue);
            this.parseParticle(element, (XSParticleDecl)xSParticleDecl.fOtherValue);
        } else if (xSParticleDecl.fType == 1) {
            XSElementDecl xSElementDecl = (XSElementDecl)xSParticleDecl.fValue;
            Element element2 = this.parseElement(element, xSElementDecl);
            if (xSElementDecl.isNillable()) {
                element2.setAttributeNS(null, "nillable", "true");
            }
            if (n > 0) {
                element2.setAttributeNS(null, "minOccurs", Integer.toString(n));
            } else {
                element2.setAttributeNS(null, "minOccurs", Integer.toString(0));
            }
            if (n2 == -1) {
                element2.setAttributeNS(null, "maxOccurs", "unbounded");
            } else if (n2 > 1) {
                element2.setAttributeNS(null, "maxOccurs", Integer.toString(n2));
            } else {
                element2.setAttributeNS(null, "maxOccurs", Integer.toString(1));
            }
        } else if (xSParticleDecl.fType == 3) {
            Element element3 = this.mapDom.createElementNS(null, "choice");
            element3.setAttributeNS(null, "name", "choiceNode");
            element3.setAttributeNS(null, "form", this.getElementFormDefault(this.currentTargetNamespace));
            element.appendChild(element3);
            this.parseChoice(element3, xSParticleDecl);
        } else if (xSParticleDecl.fType == 5) {
            this.parseAll(element, xSParticleDecl);
        } else {
            element.setAttributeNS(null, "xmlType", "true");
            element.setAttributeNS(null, "dataType", "string");
            this.warnings.append("WARNING: Unsupported Particle type in parseParticle. Treating as xmlType" + xSParticleDecl + System.getProperty("line.separator"));
        }
    }

    public static String expandSystemId(String string, String string2) {
        return XMLEntityManager.expandSystemId((String)string, (String)string2);
    }
}

