/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrXdrTcpEncodingStream;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrTcpDecodingStream;
import org.acplt.oncrpc.XdrTcpEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.acplt.oncrpc.server.OncRpcTcpConnectionServerTransport;
import org.acplt.oncrpc.server.OncRpcTcpServerTransport;
import org.apache.log4j.Logger;

public class ARTcpConnectionServerTransport
extends OncRpcTcpConnectionServerTransport {
    private static Logger log = Logger.getLogger(ARTcpConnectionServerTransport.class);
    private boolean mbEncryptedCall = false;
    private int mCurrentSessionId = 0;

    public ARTcpConnectionServerTransport(OncRpcDispatchable oncRpcDispatchable, Socket socket, int n, int n2, int n3, OncRpcTcpServerTransport oncRpcTcpServerTransport, int n4) throws OncRpcException, IOException {
        super(oncRpcDispatchable, socket, n, n2, n3, oncRpcTcpServerTransport, n4);
        this.changeToArXdrStream();
    }

    public ARTcpConnectionServerTransport(OncRpcDispatchable oncRpcDispatchable, Socket socket, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n, OncRpcTcpServerTransport oncRpcTcpServerTransport, int n2) throws OncRpcException, IOException {
        super(oncRpcDispatchable, socket, oncRpcServerTransportRegistrationInfoArray, n, oncRpcTcpServerTransport, n2);
        this.changeToArXdrStream();
    }

    public void changeToArXdrStream() throws IOException, OncRpcException {
        int n = ((XdrTcpEncodingStream)super.getXdrEncodingStream()).getBuffer().length;
        int n2 = ((XdrTcpDecodingStream)super.getXdrDecodingStream()).getBuffer().length;
        super.getXdrEncodingStream().close();
        super.getXdrDecodingStream().close();
        super.setXdrTcpEncodingStream((XdrTcpEncodingStream)new ARPluginSvrXdrTcpEncodingStream(this, super.getSocket(), n));
        super.setXdrTcpDecodingStream((XdrTcpDecodingStream)new ARPluginSvrXdrTcpDecodingStream(this, super.getSocket(), n2));
    }

    protected void dispatchCall(OncRpcCallInformation oncRpcCallInformation) throws IOException, OncRpcException {
        log.info((Object)"dispatchCall");
        if ((oncRpcCallInformation.callMessage.procedure & 0x8000) != 0) {
            oncRpcCallInformation.callMessage.procedure &= 0xFFFF7FFF;
            log.info((Object)"RPC call is encrypted");
            this.mbEncryptedCall = true;
        } else {
            log.info((Object)"RPC call is not encrypted");
            this.mbEncryptedCall = false;
        }
        log.info((Object)("Procedure No. " + oncRpcCallInformation.callMessage.procedure));
        ((ArXdrTcpEncodingStream)super.getXdrEncodingStream()).setArRrocessOn(this.mbEncryptedCall);
        ((ArXdrTcpDecodingStream)super.getXdrDecodingStream()).setArRrocessOn(this.mbEncryptedCall);
        int n = this.isEncryptionPolicyValid(this.mbEncryptedCall, oncRpcCallInformation.callMessage.procedure);
        if (n != 0) {
            log.error((Object)"Invalid call for the given encryption policy");
            this.mbEncryptedCall = false;
            oncRpcCallInformation.reply(new OncRpcServerReplyMessage(oncRpcCallInformation.callMessage, 1, 0, 1, 0, 0, n), null);
            return;
        }
        super.dispatchCall(oncRpcCallInformation);
    }

    protected boolean isCurrentCallEncrypted() {
        return this.mbEncryptedCall;
    }

    protected void setCurrentCallEncryption(boolean bl) {
        this.mbEncryptedCall = bl;
    }

    protected int getCurrentSessionId() throws ARException {
        if (this.mCurrentSessionId == 0) {
            log.error((Object)"Failed to fetch sessionId for the current call");
            throw new ARException(2, 8784);
        }
        return this.mCurrentSessionId;
    }

    public void setCurrentSessionId(int n) {
        this.mCurrentSessionId = n;
    }

    private int isEncryptionPolicyValid(boolean bl, int n) {
        int n2 = 0;
        if (n != 16) {
            try {
                ARPluginServerEncryptionInfo aRPluginServerEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
                switch (aRPluginServerEncryptionInfo.getEncryptionSecurityPolicy()) {
                    case 2: {
                        if (!bl && n != 17 && n != 18) break;
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        if (bl || n == 17 || n == 18) break;
                        n2 = 5;
                    }
                }
            }
            catch (ARException aRException) {
                // empty catch block
            }
        }
        return n2;
    }

    protected void beginEncoding(OncRpcCallInformation oncRpcCallInformation, OncRpcServerReplyMessage oncRpcServerReplyMessage) throws OncRpcException, IOException {
        super.beginEncoding(oncRpcCallInformation, oncRpcServerReplyMessage);
        ArXdrTcpEncodingStream arXdrTcpEncodingStream = (ArXdrTcpEncodingStream)this.getXdrEncodingStream();
        if (arXdrTcpEncodingStream instanceof ArXdrTcpEncodingStream) {
            int n = arXdrTcpEncodingStream.getBufferIndex();
            arXdrTcpEncodingStream.setOrgBufferBeginIndex(n);
        }
    }

    public void retrieveCall(XdrAble xdrAble) throws OncRpcException, IOException {
        if (this.getXdrDecodingStream() instanceof ARPluginSvrXdrTcpDecodingStream) {
            ARPluginSvrXdrTcpDecodingStream aRPluginSvrXdrTcpDecodingStream = (ARPluginSvrXdrTcpDecodingStream)this.getXdrDecodingStream();
            aRPluginSvrXdrTcpDecodingStream.resetArFlags();
            aRPluginSvrXdrTcpDecodingStream.arExcBeforeUnXdrDecodeParams(xdrAble);
            if (!aRPluginSvrXdrTcpDecodingStream.isXdrDecodeDone()) {
                super.retrieveCall(xdrAble);
            }
        } else {
            super.retrieveCall(xdrAble);
        }
    }

    protected void initializeThreadData() {
        try {
            ARPluginLoaderRouter.addPluginRouter(new ARPluginLoaderRouter());
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)exception);
        }
        try {
            PluginProxy.getInstance().createInstancesForThread();
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)exception);
        }
    }

    protected void cleanUp() {
        try {
            ARPluginLoaderRouter.removePluginRouter();
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)exception);
        }
        try {
            PluginProxy.getInstance().deleteInstancesForThread();
        }
        catch (Exception exception) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), (Throwable)exception);
        }
    }
}

