/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.oncrpcext.ARTcpConnectionServerTransport;
import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpEncodingStream
extends ArXdrTcpEncodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpEncodingStream.class);
    private ARTcpConnectionServerTransport mConnection;
    private ARPluginServerEncryptionInfo mEncryptionInfo;

    public ARPluginSvrXdrTcpEncodingStream(ARTcpConnectionServerTransport aRTcpConnectionServerTransport, Socket socket, int n) throws IOException {
        super(socket, n);
        this.mConnection = aRTcpConnectionServerTransport;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException aRException) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncAfterXdrEncoding(byte[] byArray) throws OncRpcException, IOException {
        byte[] byArray2 = null;
        if (this.isDataEncrypted()) {
            this.setArRrocessOn(true);
            try {
                int n = this.mConnection.getCurrentSessionId();
                XdrAble xdrAble = this.mEncryptionInfo.encryptAndXdrData(n, byArray);
                this.arEncodeEncryptedData(xdrAble, this);
            }
            catch (ARException aRException) {
                log.error((Object)"Encryption of output failed", (Throwable)aRException);
                throw new OncRpcException("Rpc encryption error");
            }
        } else {
            this.setArRrocessOn(false);
            byArray2 = byArray;
        }
        return byArray2;
    }

    protected boolean isDataEncrypted() {
        boolean bl = false;
        if (this.mConnection != null && this.mConnection.isCurrentCallEncrypted()) {
            bl = true;
        }
        return bl;
    }
}

