/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509CRL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CRLObject;
import org.bouncycastle.x509.X509Util;

public class X509V2CRLGenerator {
    private SimpleDateFormat dateF = new SimpleDateFormat("yyMMddHHmmss");
    private SimpleTimeZone tz = new SimpleTimeZone(0, "Z");
    private V2TBSCertListGenerator tbsGen;
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private Hashtable extensions = null;
    private Vector extOrdering = null;

    public X509V2CRLGenerator() {
        this.dateF.setTimeZone(this.tz);
        this.tbsGen = new V2TBSCertListGenerator();
    }

    public void reset() {
        this.tbsGen = new V2TBSCertListGenerator();
    }

    public void setIssuerDN(X500Principal x500Principal) {
        try {
            this.tbsGen.setIssuer(new X509Principal(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't process principal: " + iOException);
        }
    }

    public void setIssuerDN(X509Name x509Name) {
        this.tbsGen.setIssuer(x509Name);
    }

    public void setThisUpdate(Date date) {
        this.tbsGen.setThisUpdate(new Time(date));
    }

    public void setNextUpdate(Date date) {
        this.tbsGen.setNextUpdate(new Time(date));
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, int n) {
        this.tbsGen.addCRLEntry(new DERInteger(bigInteger), new Time(date), n);
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, int n, Date date2) {
        this.tbsGen.addCRLEntry(new DERInteger(bigInteger), new Time(date), n, new DERGeneralizedTime(date2));
    }

    public void addCRLEntry(BigInteger bigInteger, Date date, X509Extensions x509Extensions) {
        this.tbsGen.addCRLEntry(new DERInteger(bigInteger), new Time(date), x509Extensions);
    }

    public void setSignatureAlgorithm(String string) {
        this.signatureAlgorithm = string;
        try {
            this.sigOID = X509Util.getAlgorithmOID(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = new AlgorithmIdentifier(this.sigOID, null);
        this.tbsGen.setSignature(this.sigAlgId);
    }

    public void addExtension(String string, boolean bl, DEREncodable dEREncodable) {
        this.addExtension(new DERObjectIdentifier(string), bl, dEREncodable);
    }

    public void addExtension(DERObjectIdentifier dERObjectIdentifier, boolean bl, DEREncodable dEREncodable) {
        if (this.extensions == null) {
            this.extensions = new Hashtable();
            this.extOrdering = new Vector();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        try {
            dEROutputStream.writeObject(dEREncodable);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding value: " + iOException);
        }
        this.addExtension(dERObjectIdentifier, bl, byteArrayOutputStream.toByteArray());
    }

    public void addExtension(String string, boolean bl, byte[] byArray) {
        this.addExtension(new DERObjectIdentifier(string), bl, byArray);
    }

    public void addExtension(DERObjectIdentifier dERObjectIdentifier, boolean bl, byte[] byArray) {
        if (this.extensions == null) {
            this.extensions = new Hashtable();
            this.extOrdering = new Vector();
        }
        this.extensions.put(dERObjectIdentifier, new X509Extension(bl, (ASN1OctetString)new DEROctetString(byArray)));
        this.extOrdering.addElement(dERObjectIdentifier);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(privateKey, "BC", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, SecureRandom secureRandom) throws SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generateX509CRL(privateKey, "BC", secureRandom);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SecurityException("BC provider not installed!");
        }
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateX509CRL(privateKey, string, null);
    }

    public X509CRL generateX509CRL(PrivateKey privateKey, String string, SecureRandom secureRandom) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        Object object;
        Signature signature = null;
        try {
            signature = Signature.getInstance(this.sigOID.getId(), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                signature = Signature.getInstance(this.signatureAlgorithm, string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new SecurityException("exception creating signature: " + noSuchAlgorithmException2.toString());
            }
        }
        if (secureRandom != null) {
            signature.initSign(privateKey, secureRandom);
        } else {
            signature.initSign(privateKey);
        }
        if (this.extensions != null) {
            this.tbsGen.setExtensions(new X509Extensions(this.extOrdering, this.extensions));
        }
        TBSCertList tBSCertList = this.tbsGen.generateTBSCertList();
        try {
            object = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)object);
            dEROutputStream.writeObject(tBSCertList);
            signature.update(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (Exception exception) {
            throw new SecurityException("exception encoding TBS cert - " + exception);
        }
        object = new ASN1EncodableVector();
        ((DEREncodableVector)object).add(tBSCertList);
        ((DEREncodableVector)object).add(this.sigAlgId);
        ((DEREncodableVector)object).add(new DERBitString(signature.sign()));
        return new X509CRLObject(new CertificateList(new DERSequence((DEREncodableVector)object)));
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

