/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.plugin;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.CharDataEncryption;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.utils.StringByteUtil;
import com.bmc.arsys.ws.client.WebServiceSoapClient;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.DecoderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPlugin
implements ARFilterAPIPluggable {
    public static final String PLUGIN_NAME = "ARSYS.ARF.WEBSERVICE";
    private static final int WS_SERVER_CODESET = 14;
    private static final int WS_MAX_PARAMS = 15;
    private static final int AR_MAX_NAME_SIZE_30_BYTES = 30;
    private static final int AR_ENCRYPTION_VERSION_1 = 0;
    private static final int AR_ENCRYPTION_VERSION_2 = 1;
    private static final int AR_ENCRYPTION_VERSION_3 = 2;
    private ARPluginInfo mInfo = null;

    @Override
    public List<Value> filterAPICall(ARPluginContext aRPluginContext, List<Value> list) throws ARException {
        if (list.size() < 12 || list.size() > 15) {
            this.ThrowException("Invalid number of parameters for Web Service call");
        }
        Integer n = null;
        try {
            Object object;
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < 11; ++i) {
                stringArray[i] = list.get(i).toString();
            }
            String string = list.get(11).toString();
            stringArray[11] = this.DecryptStringForImport(101, string);
            if (list.size() > 12 && (object = list.get(12)).getDataType() == DataType.CHAR && object.getValue() != null) {
                stringArray[12] = object.toString();
            }
            if (list.size() > 13 && (object = list.get(13)).getDataType() == DataType.CHAR && object.getValue() != null) {
                stringArray[13] = object.toString();
            }
            if (list.size() > 14) {
                object = list.get(14);
                if (object.getDataType() == DataType.INTEGER) {
                    n = (Integer)object.getValue();
                }
                stringArray[14] = n.toString();
            }
            object = WebServiceSoapClient.call(aRPluginContext, this.mInfo, stringArray);
            Vector<Value> vector = new Vector<Value>();
            Value value = new Value((String)object);
            vector.add(value);
            return vector;
        }
        catch (Exception exception) {
            this.ThrowException(exception.getMessage());
            return null;
        }
    }

    private void ThrowException(String string) throws ARException {
        throw new ARException(2, 9130, string);
    }

    private String DecryptStringForImport(int n, String string) throws AREncryptionException, UnsupportedEncodingException, DecoderException {
        Object object;
        if (string == null || string.length() == 0) {
            return null;
        }
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        String string2 = string.substring(0, n2);
        int n3 = Integer.parseInt(string2);
        int n4 = string.indexOf(92, n2 + 1);
        if (n4 == -1) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        String string3 = string.substring(n2 + 1, n4);
        int n5 = Integer.parseInt(string3);
        int n6 = string.indexOf(92, n4 + 1);
        if (n6 == -1) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        String string4 = string.substring(n4 + 1, n6);
        int n7 = Integer.parseInt(string4);
        int n8 = n3 % 30;
        if (n7 < 2 && n8 != 0) {
            throw new IllegalArgumentException("String is not in the correct format.");
        }
        int n9 = n6 + n3 + 1;
        String string5 = string.substring(n6 + 1, n9);
        switch (n7) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                object = StringByteUtil.hexStrToBytes((String)string5);
                string5 = new String((byte[])object);
                break;
            }
        }
        object = null;
        switch (n7) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                CharDataEncryption charDataEncryption = new CharDataEncryption(false);
                byte[] byArray = charDataEncryption.decryptWebServiceBody(string5.getBytes());
                object = new String(byArray);
                break;
            }
        }
        if (n5 > 0) {
            int n10 = object.length() - n5;
            object = object.substring(0, n10);
        }
        return object;
    }

    @Override
    public void initialize(ARPluginContext aRPluginContext) throws ARException {
    }

    @Override
    public void onEvent(ARPluginContext aRPluginContext, int n) throws ARException {
    }

    @Override
    public void terminate(ARPluginContext aRPluginContext) throws ARException {
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "826\\0\\02\\4336326a594a655552473556747a47524667396163656b3573734a7a344f563574454a6d615854792f694b736b50335557434d7938414961776d5832673548326c736746464e4853742b75780a54427a45657765656e467052453772785734713353656f726138444a537832334b56704e55775530375646684a7a383369346a2f6948314f30497a63557446543361525977374445437350390a6f5664687641325850464e6d635857594c4a59623034555349632f52724e4742434f6433784e764a6d4c694d5876552b56755938522b7065356a71636e32347a3252394b7a3262556e714a780a624230456f4a6a492f4671757239654f4f52707956384d546a53396c68537178687a6b4c696861775373354d71524565625856695533333861314c554436517145477a6a636157657272556b0a2f7a594d685258476e5a2b494c39364a495934546f35734b594e62393138513048386b3976485241564a3968784c4d4753303171304e6b7776714370686d526d4561536e46736232527655530a3635794e6531776433596b70436e5650716563306347554d6f513d3d";
        String string2 = new WSPlugin().DecryptStringForImport(101, string);
        System.out.println(string2);
    }
}

