/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdlgen;

import com.bmc.arsys.ws.mapping.ARSMapping;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdlgen.WsdlGenerator;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiteralTypesGenerator {
    protected HashMap<String, Element> complexTypesHash = new HashMap();
    protected HashMap<String, Element> enumHash = new HashMap();
    protected Document typesDocumentHolder = null;
    protected Element wsdlTypesElem = null;
    protected Element schemaElem = null;
    protected String targetNamespace = null;
    protected String prefix = null;

    public LiteralTypesGenerator(String string, String string2) {
        this.targetNamespace = string;
        this.prefix = string2;
        this.typesDocumentHolder = WsdlUtil.newDocument();
        this.wsdlTypesElem = this.typesDocumentHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "wsdl:types");
        this.schemaElem = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
        this.wsdlTypesElem.appendChild(this.schemaElem);
        this.schemaElem.setAttributeNS(null, "targetNamespace", string);
        this.schemaElem.setAttributeNS(null, "elementFormDefault", "qualified");
    }

    public Element getTypesElement() {
        return this.wsdlTypesElem;
    }

    public void writeTopLevelElement(String string, ARSMapping aRSMapping) {
        Element element = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        this.schemaElem.appendChild(element);
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", string);
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + aRSMapping.getName());
        this.writeMappingGlobalComplexType(aRSMapping.getMappingElement(), aRSMapping.getName());
    }

    protected Element writeLinkedTopLevelElement(String string, ARSMapping aRSMapping, HashMap hashMap) {
        Element element = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        this.schemaElem.appendChild(element);
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", string);
        if (aRSMapping.getMappingMode() == 3) {
            String string2 = (String)hashMap.get(aRSMapping.getExternalNamespace());
            element.setAttributeNS(aRSMapping.getExternalNamespace(), "type", string2 + ":" + aRSMapping.getExternalGlobalName());
            return null;
        }
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + aRSMapping.getName());
        Element element2 = this.complexTypesHash.get(aRSMapping.getName());
        if (element2 != null) {
            return element2;
        }
        element2 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
        element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", aRSMapping.getName());
        this.schemaElem.appendChild(element2);
        this.complexTypesHash.put(aRSMapping.getName(), element2);
        Element element3 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:sequence");
        element2.appendChild(element3);
        for (Node node = ARSMapping.skipToFirstMappingElement(aRSMapping.getMappingElement(), true); node != null; node = node.getNextSibling()) {
            Element element4;
            if (node.getNodeType() != 1 || !(element4 = node).getLocalName().equals("element")) continue;
            String string3 = element4.getAttribute("targetNamespace");
            String string4 = (String)hashMap.get(string3);
            Element element5 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
            element5.setAttributeNS("http://www.w3.org/2001/XMLSchema", "ref", string4 + ":" + element4.getAttribute("name"));
            element3.appendChild(element5);
        }
        return element2;
    }

    protected Element writeMappingGlobalComplexType(Element element, String string) {
        Element element2 = this.complexTypesHash.get(string);
        if (element2 == null) {
            element2 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
            element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", string);
            this.schemaElem.appendChild(element2);
            this.complexTypesHash.put(string, element2);
            this.addChildrenToComplexElem(element2, null, element);
        }
        return element2;
    }

    protected Element writeMappingComplexType(Element element) {
        Element element2 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
        Element element3 = this.writeParentElem(element2, element);
        this.addChildrenToComplexElem(element2, element3, element);
        return element2;
    }

    protected Element writeAuthenticationElem() {
        Element element = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        this.schemaElem.appendChild(element);
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", WsdlGenerator.AUTH_ELEMENT_NAME);
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + WsdlGenerator.AUTH_TYPE_NAME);
        this.writeAuthenticationType();
        return element;
    }

    protected Element writeAuthenticationType() {
        Element element = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:complexType");
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", WsdlGenerator.AUTH_ELEMENT_NAME);
        this.schemaElem.appendChild(element);
        Element element2 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:sequence");
        element.appendChild(element2);
        this.addAuthenticationElement(element2, "userName", true);
        this.addAuthenticationElement(element2, "password", true);
        this.addAuthenticationElement(element2, "authentication", false);
        this.addAuthenticationElement(element2, "locale", false);
        this.addAuthenticationElement(element2, "timeZone", false);
        this.complexTypesHash.put(WsdlGenerator.AUTH_ELEMENT_NAME, element);
        return element;
    }

    protected void addAuthenticationElement(Element element, String string, boolean bl) {
        String string2 = "string";
        Element element2 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
        element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", string);
        element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", "xsd:" + string2);
        if (!bl) {
            element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "minOccurs", "0");
        }
        element.appendChild(element2);
    }

    protected void addOtherAttributes(Element element, Element element2) {
        if (element.getLocalName().equals("element")) {
            String string;
            String string2;
            String string3;
            String string4 = element.getAttribute("minOccurs");
            if (string4 != null && !string4.equals("") && !string4.equals("1")) {
                element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "minOccurs", string4);
            }
            if ((string3 = element.getAttribute("maxOccurs")) != null && !string3.equals("") && !string3.equals("1")) {
                element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "maxOccurs", string3);
            }
            if ((string2 = element.getAttribute("nillable")) != null && (string2.equals("1") || string2.equals("true") || string2.equals("True"))) {
                element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "nillable", "true");
            }
            if ((string = element.getAttribute("default")) != null && !string.equals("") && string4.equals("0")) {
                element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "default", string);
            }
        } else if (element.getLocalName().equals("attribute")) {
            String string;
            String string5 = element.getAttribute("use");
            if (string5 != null && !string5.equals("") && !string5.equals("1")) {
                element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "use", string5);
            }
            if ((string = element.getAttribute("default")) != null && !string.equals("") && !string5.equals("required")) {
                element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "default", string);
            }
        }
    }

    protected Element writeMappingGlobalEnumType(Element element) {
        String string = element.getAttribute("enumValues");
        Element element2 = this.enumHash.get(string);
        if (element2 == null) {
            Element element3 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:restriction");
            element3.setAttributeNS("http://www.w3.org/2001/XMLSchema", "base", "xsd:string");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            while (stringTokenizer.hasMoreTokens()) {
                Element element4 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:enumeration");
                element4.setAttributeNS("http://www.w3.org/2001/XMLSchema", "value", stringTokenizer.nextToken());
                element3.appendChild(element4);
            }
            element2 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:simpleType");
            element2.appendChild(element3);
            element2.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", element.getAttribute("name") + "Type");
            this.schemaElem.appendChild(element2);
            this.enumHash.put(string, element2);
        }
        return element2;
    }

    protected Element writeParentElem(Element element, Element element2) {
        Element element3 = null;
        String string = element2.getAttribute("all");
        element3 = string != null && string.equals("true") ? this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:all") : this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:sequence");
        element.appendChild(element3);
        return element3;
    }

    protected void addChildrenToComplexElem(Element element, Element element2, Element element3) {
        if (element2 == null) {
            element2 = this.writeParentElem(element, element3);
        }
        NodeList nodeList = element3.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element4 = null;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element5 = (Element)node;
            if (!element5.getAttribute("name").equals("ROOT")) {
                if (element5.getLocalName().equals("element")) {
                    element4 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:element");
                    element4.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", element5.getAttribute("name"));
                    this.addOtherAttributes(element5, element4);
                    element2.appendChild(element4);
                    this.writeMappingElement(element4, element5);
                    continue;
                }
                if (element5.getLocalName().equals("attribute")) {
                    element4 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:attribute");
                    element4.setAttributeNS("http://www.w3.org/2001/XMLSchema", "name", element5.getAttribute("name"));
                    this.addOtherAttributes(element5, element4);
                    element.appendChild(element4);
                    this.writeMappingElement(element4, element5);
                    continue;
                }
                if (element5.getLocalName().equals("choice")) {
                    element4 = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:choice");
                    element2.appendChild(element4);
                    this.addChildrenToComplexElem(element, element4, element5);
                    continue;
                }
            }
            this.addChildrenToComplexElem(element, element2, element5);
        }
    }

    protected void writeMappingElement(Element element, Element element2) {
        String string = element2.getAttribute("dataType");
        String string2 = element2.getAttribute("complexType");
        if (string2 != null && !string2.equals("")) {
            this.writeMappingGlobalComplexType(element2, string2);
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + string2);
        } else if (string == null || string.equals("")) {
            element.appendChild(this.writeMappingComplexType(element2));
        } else if (element2.getAttribute("enumValues") != null && !element2.getAttribute("enumValues").equals("")) {
            Element element3 = this.writeMappingGlobalEnumType(element2);
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", this.prefix + ":" + element3.getAttribute("name"));
        } else {
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "type", "xsd:" + string);
        }
    }

    public void createImports(HashMap hashMap, boolean bl) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String string : hashMap.keySet()) {
            String string2 = (String)hashMap.get(string);
            if (string2.equals(this.targetNamespace) || !bl && hashMap2.get(string2) != null) continue;
            hashMap2.put(string2, "");
            Element element = this.typesDocumentHolder.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:import");
            element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "namespace", string2);
            if (bl) {
                element.setAttributeNS("http://www.w3.org/2001/XMLSchema", "schemaLocation", string);
            }
            this.schemaElem.insertBefore(element, this.schemaElem.getFirstChild());
        }
    }
}

