/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.FuncCurrencyInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ARStructTypeInfo(Name="ARCurrencyStruct", NumberOfMembers=4)
public class CurrencyValue
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8546908808563168015L;
    @ARStructMemTypeInfo(Name="value", Offset=0)
    private BigDecimal m_value;
    @ARStructMemTypeInfo(Name="currencyCode", Offset=1)
    private String m_currencyCode;
    @ARStructMemTypeInfo(Name="conversionDate", Offset=2)
    private Timestamp m_conversionDate;
    @ARStructMemTypeInfo(Name="funcCurrencyList", Offset=3)
    private List<FuncCurrencyInfo> m_funcCurrencyList;

    public CurrencyValue() {
        this.m_value = null;
        this.m_currencyCode = null;
        this.m_conversionDate = null;
    }

    public CurrencyValue(String string, String string2, Timestamp timestamp, List<FuncCurrencyInfo> list) {
        if (".".equals(string)) {
            string = "0";
        }
        this.m_value = new BigDecimal(string);
        this.m_currencyCode = string2;
        this.m_conversionDate = timestamp;
        this.m_funcCurrencyList = list;
    }

    public CurrencyValue(BigDecimal bigDecimal, String string, Timestamp timestamp, List<FuncCurrencyInfo> list) {
        this.m_value = bigDecimal;
        this.m_currencyCode = string;
        this.m_conversionDate = timestamp;
        this.m_funcCurrencyList = list;
    }

    public CurrencyValue(String string) {
        int n2 = 0;
        this.m_value = null;
        this.m_currencyCode = null;
        this.m_conversionDate = new Timestamp(0L);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            switch (n2++) {
                case 0: {
                    this.m_value = new BigDecimal(stringTokenizer.nextToken());
                    break;
                }
                case 1: {
                    this.m_currencyCode = stringTokenizer.nextToken();
                    break;
                }
                case 2: {
                    String string2 = stringTokenizer.nextToken();
                    Long l2 = new Long(string2);
                    long l3 = l2;
                    this.m_conversionDate = new Timestamp(l3);
                    break;
                }
            }
            if (n2 != 3) continue;
            break;
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, Config.getInstance().getToStringStyle()).append("Value", (Object)this.m_value).append("Currency Code", (Object)this.m_currencyCode).append("Conversion Date", (Object)this.m_conversionDate).append("Func Currency List", this.m_funcCurrencyList).toString();
    }

    public BigDecimal getValue() {
        return this.m_value;
    }

    public String getValueString() {
        return this.m_value.toString();
    }

    public void setValue(BigDecimal bigDecimal) {
        this.m_value = bigDecimal;
    }

    public String getCurrencyCode() {
        return this.m_currencyCode;
    }

    public void setCurrencyCode(String string) {
        this.m_currencyCode = string;
    }

    public Timestamp getConversionDate() {
        return this.m_conversionDate;
    }

    public void setConversionDate(long l2) {
        this.m_conversionDate = new Timestamp(l2);
    }

    public List<FuncCurrencyInfo> getFuncCurrencyList() {
        return this.m_funcCurrencyList;
    }

    public void setFuncCurrencyList(List<FuncCurrencyInfo> list) {
        this.m_funcCurrencyList = list;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CurrencyValue)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        CurrencyValue currencyValue = (CurrencyValue)object;
        return new EqualsBuilder().append((Object)this.m_value, (Object)currencyValue.m_value).append((Object)this.m_currencyCode, (Object)currencyValue.m_currencyCode).append((Object)this.m_conversionDate, (Object)currencyValue.m_conversionDate).append(this.m_funcCurrencyList, currencyValue.m_funcCurrencyList).isEquals();
    }

    public Object clone() throws CloneNotSupportedException {
        CurrencyValue currencyValue = (CurrencyValue)super.clone();
        if (this.m_conversionDate != null) {
            currencyValue.m_conversionDate = (Timestamp)this.m_conversionDate.clone();
        }
        if (this.m_funcCurrencyList != null) {
            int n2 = this.m_funcCurrencyList.size();
            currencyValue.m_funcCurrencyList = new ArrayList<FuncCurrencyInfo>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                currencyValue.m_funcCurrencyList.add((FuncCurrencyInfo)this.m_funcCurrencyList.get(i2).clone());
            }
        }
        return currencyValue;
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        this.m_value = ConversionUtil.getBigDecimalValue(ARTypeMgr.GetAt((Object)objectArray, 0));
        this.m_currencyCode = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 1));
        this.m_conversionDate = new Timestamp(ConversionUtil.getLongValue(ARTypeMgr.GetAt((Object)objectArray, 2)));
        this.m_funcCurrencyList = ARTypeMgr.getInstance().ObjectListFromVariant(FuncCurrencyInfo.class, ARTypeMgr.GetAt((Object)objectArray, 3), aRServerUser);
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[]{ConversionUtil.getStringValue(this.m_value), this.m_currencyCode, ConversionUtil.getARTimestamp(this.m_conversionDate), ARTypeMgr.getInstance().ObjectListToVariant(this.m_funcCurrencyList, aRServerUser)};
        return objectArray;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.m_value).append((Object)this.m_currencyCode).append((Object)this.m_conversionDate).append(this.m_funcCurrencyList).toHashCode();
    }

    static CurrencyValue deserializeFromObjectStr(String string) {
        int n2;
        BigDecimal bigDecimal = null;
        String string2 = null;
        Timestamp timestamp = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        if (stringTokenizer.hasMoreTokens() && (n2 = new Integer(stringTokenizer.nextToken()).intValue()) > 0 && stringTokenizer.hasMoreTokens()) {
            bigDecimal = new BigDecimal(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens() && (n2 = new Integer(stringTokenizer.nextToken()).intValue()) > 0 && stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            timestamp = new Timestamp(new Long(stringTokenizer.nextToken()));
        }
        ArrayList<FuncCurrencyInfo> arrayList = new ArrayList<FuncCurrencyInfo>();
        if (stringTokenizer.hasMoreTokens()) {
            int n3 = new Integer(stringTokenizer.nextToken());
            int n4 = 0;
            String string3 = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                BigDecimal bigDecimal2 = null;
                String string4 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    n4 = new Integer(stringTokenizer.nextToken());
                }
                if (n4 > 0 && stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3 == null) {
                        string3 = "";
                    }
                    bigDecimal2 = new BigDecimal(string3);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    n4 = new Integer(stringTokenizer.nextToken());
                }
                if (n4 > 0 && stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    if (string3 == null) {
                        string3 = "";
                    }
                    string4 = string3;
                }
                arrayList.add(new FuncCurrencyInfo(bigDecimal2, string4));
            }
        }
        return new CurrencyValue(bigDecimal, string2, timestamp, arrayList);
    }

    public static String checkDecimalFormat(String string) throws ARException {
        String string2 = string;
        if (".".equals(string) || "".equals(string) || string == null) {
            string2 = "0";
        }
        try {
            new BigDecimal(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ARException(2, 8735, string);
        }
        return string2;
    }
}

