/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.ContainerType;
import com.bmc.arsys.api.internal.ConversionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerListInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2265754968285667059L;
    String m_containerKey;
    ContainerType m_containerType;
    List<ContainerOwner> m_containerOwner;

    public ContainerListInfo(String string, int n2, List<ContainerOwner> list) {
        this.m_containerKey = string;
        this.m_containerType = ContainerType.toContainerType(n2);
        this.m_containerOwner = list;
    }

    private ContainerListInfo() {
    }

    public String getKey() {
        return this.m_containerKey;
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        this.m_containerKey = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)objectArray, 0));
        this.m_containerType = ContainerType.toContainerType(ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 1)));
        this.m_containerOwner = ARTypeMgr.getInstance().ObjectListFromVariant(ContainerOwner.class, ARTypeMgr.GetAt((Object)objectArray, 2), aRServerUser);
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[]{this.m_containerKey, new Integer(this.m_containerType.toInt()), ARTypeMgr.getInstance().ObjectToVariant(this.m_containerOwner, aRServerUser)};
        return objectArray;
    }

    static ContainerListInfo createInstance(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return null;
        }
        ContainerListInfo containerListInfo = new ContainerListInfo();
        if (objectArray.length == 3) {
            containerListInfo.fromVariant(objectArray, aRServerUser);
        }
        return containerListInfo;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, Config.getInstance().getToStringStyle()).append("Container Key", (Object)this.m_containerKey).append("Container Type", (Object)this.m_containerType).append("Container Owner", this.m_containerOwner).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.m_containerKey).append((Object)this.m_containerType).append(this.m_containerOwner).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContainerListInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ContainerListInfo containerListInfo = (ContainerListInfo)object;
        return new EqualsBuilder().append((Object)this.m_containerKey, (Object)containerListInfo.m_containerKey).append((Object)this.m_containerType, (Object)containerListInfo.m_containerType).append(this.m_containerOwner, containerListInfo.m_containerOwner).isEquals();
    }

    public Object clone() throws CloneNotSupportedException {
        ContainerListInfo containerListInfo = (ContainerListInfo)super.clone();
        if (this.m_containerOwner != null) {
            int n2 = this.m_containerOwner.size();
            containerListInfo.m_containerOwner = new ArrayList<ContainerOwner>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                containerListInfo.m_containerOwner.add(i2, (ContainerOwner)this.m_containerOwner.get(i2).clone());
            }
        }
        return containerListInfo;
    }
}

