/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ConversionUtil;
import java.io.Serializable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ArithmeticOperationInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8565634548350997817L;
    private int m_operation;
    private ArithmeticOrRelationalOperand m_operandLeft;
    private ArithmeticOrRelationalOperand m_operandRight;
    public static final int AR_ARITH_OP_ADD = 1;
    public static final int AR_ARITH_OP_SUBTRACT = 2;
    public static final int AR_ARITH_OP_MULTIPLY = 3;
    public static final int AR_ARITH_OP_DIVIDE = 4;
    public static final int AR_ARITH_OP_MODULO = 5;
    public static final int AR_ARITH_OP_NEGATE = 6;

    public ArithmeticOperationInfo() {
        this.m_operation = 0;
        this.m_operandLeft = null;
        this.m_operandRight = null;
    }

    public ArithmeticOperationInfo(int n2, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand2) throws IllegalArgumentException {
        if (!this.a(n2)) {
            throw new IllegalArgumentException("invalid operation in ArithmeticOperationInfo constructor");
        }
        this.m_operation = n2;
        this.m_operandLeft = arithmeticOrRelationalOperand;
        this.m_operandRight = arithmeticOrRelationalOperand2;
    }

    public ArithmeticOrRelationalOperand getLeftOperand() {
        return this.m_operandLeft;
    }

    public ArithmeticOrRelationalOperand getRightOperand() {
        return this.m_operandRight;
    }

    public int getOperation() {
        return this.m_operation;
    }

    private boolean a(int n2) {
        return n2 >= 1 && n2 <= 6;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOperationInfo arithmeticOperationInfo = (ArithmeticOperationInfo)super.clone();
        if (this.m_operandLeft != null) {
            arithmeticOperationInfo.m_operandLeft = (ArithmeticOrRelationalOperand)this.m_operandLeft.clone();
        }
        if (this.m_operandRight != null) {
            arithmeticOperationInfo.m_operandRight = (ArithmeticOrRelationalOperand)this.m_operandRight.clone();
        }
        return arithmeticOperationInfo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArithmeticOperationInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ArithmeticOperationInfo arithmeticOperationInfo = (ArithmeticOperationInfo)object;
        return new EqualsBuilder().append(this.m_operation, arithmeticOperationInfo.m_operation).append((Object)this.m_operandLeft, (Object)arithmeticOperationInfo.m_operandLeft).append((Object)this.m_operandRight, (Object)arithmeticOperationInfo.m_operandRight).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_operation).append((Object)this.m_operandLeft).append((Object)this.m_operandRight).toHashCode();
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        this.m_operation = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 0));
        if (this.m_operation != 6) {
            this.m_operandLeft = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOrRelationalOperand.class, ARTypeMgr.GetAt((Object)objectArray, 1), aRServerUser);
        }
        this.m_operandRight = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOrRelationalOperand.class, ARTypeMgr.GetAt((Object)objectArray, 2), aRServerUser);
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[]{this.getOperation(), ARTypeMgr.getInstance().ObjectToVariant(this.m_operandLeft, aRServerUser), ARTypeMgr.getInstance().ObjectToVariant(this.m_operandRight, aRServerUser)};
        return objectArray;
    }

    static ArithmeticOperationInfo createInstance(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return null;
        }
        ArithmeticOperationInfo arithmeticOperationInfo = new ArithmeticOperationInfo();
        if (objectArray.length == 3) {
            arithmeticOperationInfo.fromVariant(objectArray, aRServerUser);
        }
        return arithmeticOperationInfo;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, Config.getInstance().getToStringStyle()).append("Operation", this.m_operation).append("Operand Left", (Object)this.m_operandLeft).append("Operand Right", (Object)this.m_operandRight).toString();
    }

    public void setOperandLeft(ArithmeticOrRelationalOperand arithmeticOrRelationalOperand) {
        this.m_operandLeft = arithmeticOrRelationalOperand;
    }

    public void setOperandRight(ArithmeticOrRelationalOperand arithmeticOrRelationalOperand) {
        this.m_operandRight = arithmeticOrRelationalOperand;
    }

    public void setOperation(int n2) {
        this.m_operation = n2;
    }
}

