/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.oncrpcext.ARTcpConnectionServerTransport;
import java.io.IOException;
import java.net.Socket;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpDecodingStream
extends ArXdrTcpDecodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpDecodingStream.class);
    private ARTcpConnectionServerTransport mConnection;
    private ARPluginServerEncryptionInfo mEncryptionInfo;

    public ARPluginSvrXdrTcpDecodingStream(ARTcpConnectionServerTransport aRTcpConnectionServerTransport, Socket socket, int n) throws IOException {
        super(socket, n);
        this.mConnection = aRTcpConnectionServerTransport;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException aRException) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncBeforeUnXdrDecoding(byte[] byArray) throws OncRpcException, IOException {
        byte[] byArray2 = null;
        if (this.isArRrocessOn()) {
            try {
                byArray2 = this.mEncryptionInfo.unXdrAndDecryptData(byArray, this.mConnection);
            }
            catch (ARException aRException) {
                super.endDecoding();
                log.error((Object)"Decrypting of the input arguments failed", (Throwable)aRException);
                throw new OncRpcException("Rpc decryption error");
            }
            catch (OncRpcException oncRpcException) {
                log.error((Object)"Decoding of the input arguments failed", (Throwable)oncRpcException);
                this.mConnection.setCurrentCallEncryption(false);
                throw oncRpcException;
            }
        } else {
            byArray2 = byArray;
        }
        return byArray2;
    }

    protected void resetArFlags() {
        this.setXdrDecodeDone(false);
        this.setDataNotInXdrBuffer(false);
    }

    protected boolean isXdrDecodeDone() {
        return super.isXdrDecodeDone();
    }
}

