/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.utils.LogBytes;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;

public class ARPublicKey
extends ARPPKey {
    protected Key getRsaKey() throws AREncryptionException {
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.getBigModulus(), this.getBigExponent());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.new());
            this.encKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            if (this.debug) {
                LogBytes.printByteArrayAsHex(((RSAPublicKey)this.encKey).getModulus().toByteArray(), "RSA public Modulus: \n");
                LogBytes.printByteArrayAsHex(((RSAPublicKey)this.encKey).getPublicExponent().toByteArray(), "RSA public Exponent: \n");
            }
        }
        catch (Exception exception) {
            throw new AREncryptionException(exception, 9006);
        }
        return this.encKey;
    }
}

