/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.servlet.tags.form.ValueFormatter;

final class OptionWriter {
    private final ValueFormatter valueFormatter = new ValueFormatter();
    private final Object optionSource;
    private final BindStatus bindStatus;
    private final String valueProperty;
    private final String labelProperty;
    private final boolean htmlEscape;

    public OptionWriter(Object optionSource, BindStatus bindStatus, String valueProperty, String labelProperty, boolean htmlEscape) {
        Assert.notNull(optionSource, "'optionSource' cannot be null.");
        Assert.notNull(bindStatus, "'bindStatus' cannot be null.");
        this.optionSource = optionSource;
        this.bindStatus = bindStatus;
        this.valueProperty = valueProperty;
        this.labelProperty = labelProperty;
        this.htmlEscape = htmlEscape;
    }

    public void writeOptions(TagWriter tagWriter) throws JspException {
        if (this.optionSource.getClass().isArray()) {
            this.renderFromArray(tagWriter);
        } else if (this.optionSource instanceof Collection) {
            this.renderFromCollection(tagWriter);
        } else if (this.optionSource instanceof Map) {
            this.renderFromMap(tagWriter);
        } else {
            throw new JspException("Type '" + this.optionSource.getClass().getName() + "' is not valid for property 'items'.");
        }
    }

    private void renderFromArray(TagWriter tagWriter) throws JspException {
        this.doRenderFromCollection(CollectionUtils.arrayToList(this.optionSource), tagWriter);
    }

    private void renderFromMap(TagWriter tagWriter) throws JspException {
        Map optionMap = (Map)this.optionSource;
        Iterator iterator = optionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.renderOption(tagWriter, entry, entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private void renderFromCollection(TagWriter tagWriter) throws JspException {
        this.doRenderFromCollection((Collection)this.optionSource, tagWriter);
    }

    private void doRenderFromCollection(Collection optionCollection, TagWriter tagWriter) throws JspException {
        Iterator iterator = optionCollection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            BeanWrapperImpl wrapper = new BeanWrapperImpl(item);
            Object value = this.valueProperty == null ? item : wrapper.getPropertyValue(this.valueProperty);
            Object label = this.labelProperty == null ? item : wrapper.getPropertyValue(this.labelProperty);
            this.renderOption(tagWriter, item, value, label);
        }
    }

    private void renderOption(TagWriter tagWriter, Object item, Object value, Object label) throws JspException {
        tagWriter.startTag("option");
        String valueDisplayString = this.getDisplayString(value);
        String labelDisplayString = this.getDisplayString(label);
        tagWriter.writeAttribute("value", valueDisplayString);
        if (this.isSelected(value) || this.isSelected(item)) {
            tagWriter.writeAttribute("selected", "selected");
        }
        tagWriter.appendValue(labelDisplayString);
        tagWriter.endTag();
    }

    private boolean isSelected(Object resolvedValue) {
        return SelectedValueComparator.isSelected(this.bindStatus, resolvedValue);
    }

    private String getDisplayString(Object value) {
        return this.valueFormatter.getDisplayString(value, this.bindStatus.getEditor(), this.htmlEscape);
    }
}

